<!-- header.php -->
<?php
// This file contains the common header and sidebar for admin pages
// Make sure the user is logged in and has admin privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header("Location: ../login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' | Color Access System' : 'Admin Panel | Color Access System'; ?></title>
    <link rel="icon" href="../images/logo.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                    backgroundImage: {
                        'gradient-primary': 'linear-gradient(135deg, #2C5364 0%, #203A43 50%, #0F2027 100%)',
                        'gradient-side': 'linear-gradient(225deg, #2C5364 0%, #203A43 50%, #0F2027 100%)',
                    },
                    colors: {
                        primary: '#203A43',
                        secondary: '#2C5364',
                        tertiary: '#0F2027',
                    }
                }
            }
        }
    </script>
</head>
<body class="font-poppins bg-gray-100 flex h-screen">
    <!-- Sidebar -->
    <div id="sidebar" class="bg-gradient-side text-white w-64 py-4 px-6 flex flex-col transition-all duration-300 h-full shadow-lg fixed lg:relative z-20">
        <div class="flex flex-col items-center mb-6">
            <!-- Logo above borrower Panel text -->
<div class="relative flex justify-center">
    <div class="rounded-full p-1 bg-white ring-4 ring-white">
        <img src="../images/logo.png" alt="Logo" class="h-20 w-20 rounded-full object-cover">
    </div>
</div>
<h2 class="text-2xl font-bold mt-3">Admin Panel</h2>
        </div>
        <div class="flex items-center justify-end lg:hidden">
            <button id="closeSidebar" class="text-white">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="flex-1 flex flex-col">
            <!-- Main Menu -->
            <div class="mb-4">
                <div class="text-xs uppercase font-semibold text-white/70 mb-2 pl-2">Main Menu</div>
                <ul>
                    <li class="mb-1">
                        <a href="dashboard_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                            <i class="fas fa-tachometer-alt w-5"></i>
                            <span class="ml-2">Dashboard</span>
                        </a>
                    </li>
                    <li class="mb-1">
    <!-- Manajement Color Submenu -->
    <div class="submenu">
        <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
            <div class="flex items-center">
                <i class="fas fa-fill-drip w-5"></i>
                <span class="ml-2">Manajement Color</span>
            </div>
            <i class="fas fa-chevron-down text-xs"></i>
        </div>
        <ul class="pl-6 mt-1 hidden">
            <li class="mb-1">
                <a href="data_color_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                    <i class="fas fa-palette w-5"></i>
                    <span class="ml-2">Data Color</span>
                </a>
            </li>
            <li class="mb-1">
                <a href="stok_color_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                    <i class="fas fa-cube w-5"></i>
                    <span class="ml-2">Stok Color</span>
                </a>
            </li>
        </ul>
    </div>
</li>
                    <li class="mb-1">
                        <!-- Manajemen peminjaman Submenu -->
                        <div class="submenu">
                            <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                <div class="flex items-center">
                                    <i class="fas fa-hand-holding w-5"></i>
                                    <span class="ml-2">Manajemen peminjaman</span>
                                </div>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </div>
                            <ul class="pl-6 mt-1 hidden">
                                <li class="mb-1">
                                    <a href="persetujuan_formulir_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                                        <i class="fas fa-clipboard-list w-5"></i>
                                        <span class="ml-2">Cek Formulir peminjaman</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="cek_lokasi_admin.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200">
                                        <i class="fas fa-map-marker-alt w-5"></i>
                                        <span class="ml-2">Cek Lokasi peminjaman</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col min-h-screen">
        <!-- Top Navigation Bar -->
        <header class="bg-white shadow-sm z-10">
            <div class="flex items-center justify-between px-6 py-3">
                <div class="flex items-center">
                    <button id="toggleSidebar" class="text-gray-600 hover:text-primary lg:hidden">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-semibold ml-4 text-gray-800"><?php echo $page_title ?? 'Dashboard'; ?></h1>
                </div>
                
                <!-- User Profile Dropdown -->
                <div class="relative">
                    <button id="profileDropdown" class="flex items-center px-3 py-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors duration-200">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-primary flex items-center justify-center text-white">
                                <?php echo isset($_SESSION['username']) ? strtoupper(substr($_SESSION['username'], 0, 1)) : 'A'; ?>
                            </div>
                            <span class="ml-2 font-medium text-sm text-gray-700 hidden md:block">
                                <?php echo htmlspecialchars($_SESSION['username'] ?? 'Admin User'); ?>
                            </span>
                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-500"></i>
                        </div>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-20 hidden">
                        <div class="px-4 py-2 text-sm text-gray-500 border-b border-gray-200">
                            Color Room
                        </div>
                        <a href="profile_admin.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-user mr-2 text-primary"></i> Profile
                        </a>
                        <div class="border-t border-gray-200 my-1"></div>
                        <a href="../logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
        </header>