<?php

namespace App\Helpers;

class CasegoodHelper
{
    /**
     * Calculate M2 from width and length
     */
    public static function calculateM2($width, $length)
    {
        return ($width * $length) / 1000000;
    }

    /**
     * Calculate Top Panel - Patching Panel 1
     */
    public static function calculatePatchingPanel1($m2, $qty, $panelPrice)
    {
        return $m2 * $qty * $panelPrice;
    }

    /**
     * Calculate Top Panel - Patching Solid 2 (PANJANG)
     */
    public static function calculatePatchingSolid2($widthChoice, $lengthOriginal, $qty, $solidPrice)
    {
        $m2 = self::calculateM2($widthChoice, $lengthOriginal);
        return $m2 * $qty * $solidPrice;
    }

    /**
     * Calculate Top Panel - Patching Solid 3 (LEBAR)
     */
    public static function calculatePatchingSolid3($widthChoice, $widthOriginal, $qty, $solidPrice)
    {
        $m2 = self::calculateM2($widthChoice, $widthOriginal);
        return $m2 * $qty * $solidPrice;
    }

    /**
     * Calculate Crossgrain (MDF)
     */
    public static function calculateCrossgrain($m2, $qty, $mdfPrice)
    {
        return $m2 * $qty * $mdfPrice;
    }

    /**
     * Calculate Veneer Face
     */
    public static function calculateVeneerFace($m2, $qty, $veneerPrice)
    {
        return $m2 * $qty * $veneerPrice;
    }

    /**
     * Calculate Veneer Back
     */
    public static function calculateVeneerBack($m2, $qty, $veneerPrice)
    {
        return $m2 * $qty * $veneerPrice;
    }

    /**
     * Calculate Cleat
     */
    public static function calculateCleat($qty, $cleatPrice = 1000)
    {
        return $qty * $cleatPrice;
    }

    /**
     * Calculate Bottom Panel - E.Band
     */
    public static function calculateEBand($thickness, $length, $veneerFacePrice)
    {
        $m2 = self::calculateM2($thickness, $length);
        return $m2 * $veneerFacePrice;
    }

    /**
     * Calculate Core Solid (Front/Back Frame)
     */
    public static function calculateCoreSolid($m2, $qty, $solidPrice)
    {
        return $m2 * $qty * $solidPrice;
    }

    /**
     * Calculate Box Drawer
     */
    public static function calculateBoxDrawer($drawerPrice, $qtyDefault, $qtyFaceDrawer)
    {
        return $drawerPrice * ($qtyDefault * $qtyFaceDrawer);
    }

    /**
     * Calculate Support Drawer
     */
    public static function calculateSupportDrawer($qty, $supportPrice = 2200)
    {
        return $qty * $supportPrice;
    }

    /**
     * Calculate Cleat Drawer
     */
    public static function calculateCleatDrawer($qty, $cleatDrawerPrice = 400)
    {
        return $qty * $cleatDrawerPrice;
    }

    /**
     * Get Bottom Panel Core Thickness based on selection
     */
    public static function getBottomPanelCoreThickness($selectedThickness)
    {
        $thicknessMap = [
            16 => 15,
            19 => 18,
            26 => 25
        ];
        return $thicknessMap[$selectedThickness] ?? 15;
    }

    /**
     * Format currency to Rupiah
     */
    public static function formatRupiah($amount)
    {
        return 'Rp ' . number_format($amount, 0, ',', '.');
    }

    /**
     * Calculate Qty with parent multiplier
     */
    public static function calculateQtyWithParent($defaultQty, $parentQty)
    {
        return $defaultQty * $parentQty;
    }
}