<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hardware extends Model
{
    use HasFactory;

    protected $table = 'hardware';

    protected $fillable = [
        'material_code',
        'hardware_type',
        'material_description',
        'price'
    ];

    protected $casts = [
        'price' => 'decimal:2'
    ];

    /**
     * Scope: Filter by hardware type
     */
    public function scopeByType($query, $type)
    {
        return $query->where('hardware_type', $type);
    }

    /**
     * Scope: Search by material code or description
     */
    public function scopeSearch($query, $search)
    {
        return $query->where(function($q) use ($search) {
            $q->where('material_code', 'LIKE', "%{$search}%")
              ->orWhere('material_description', 'LIKE', "%{$search}%");
        });
    }

    /**
     * Get all unique hardware types
     */
    public static function getTypes()
    {
        return self::select('hardware_type')
            ->distinct()
            ->orderBy('hardware_type')
            ->pluck('hardware_type');
    }
}