<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceBomComponent extends Model
{
    use HasFactory;

    protected $fillable = [
        'component_name',
        'component_structure'
    ];

    protected $casts = [
        'component_structure' => 'array'
    ];

    /**
     * Scope untuk filter berdasarkan component name
     */
    public function scopeByName($query, $name)
    {
        return $query->where('component_name', $name);
    }
}