<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceHardware extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'hardware_data',
        'grand_total',
    ];

    protected $casts = [
        'hardware_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    // Relationship
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * ✅ Get Hardware Groups from JSON
     */
    public function getHardwareGroups()
    {
        if (!$this->hardware_data) {
            return [];
        }

        // Parse JSON jika masih string
        $data = is_string($this->hardware_data) 
            ? json_decode($this->hardware_data, true) 
            : $this->hardware_data;

        return $data['groups'] ?? [];
    }

    /**
     * Calculate Grand Total from Groups
     */
    public function calculateGrandTotal()
    {
        $groups = $this->getHardwareGroups();
        
        return collect($groups)->sum('subtotal');
    }
}