<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaterialSolid extends Model
{
    use HasFactory;

    protected $fillable = [
        'material_name',
        'price'
    ];

    protected $casts = [
        'price' => 'decimal:2'
    ];

    /**
     * Scope untuk filter berdasarkan material name
     */
    public function scopeByName($query, $name)
    {
        return $query->where('material_name', $name);
    }
}