<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductSolid extends Model
{
    use HasFactory;

    protected $fillable = [
        'solid_type',
        'thickness',
        'price'
    ];

    protected $casts = [
        'thickness' => 'decimal:2',
        'price' => 'decimal:2'
    ];

    /**
     * Scope untuk filter berdasarkan solid type
     */
    public function scopeByType($query, $type)
    {
        return $query->where('solid_type', $type);
    }

    /**
     * Scope untuk filter berdasarkan thickness
     */
    public function scopeByThickness($query, $thickness)
    {
        return $query->where('thickness', $thickness);
    }
}