<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_panels', function (Blueprint $table) {
            $table->id();
            $table->string('panel_type'); // PB, MDF, PLYWOOD
            $table->decimal('thickness', 8, 2); // Tebal
            $table->decimal('price', 15, 2); // Harga per M2
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_panels');
    }
};