<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_boms', function (Blueprint $table) {
            $table->id();
            $table->string('product_name'); // Ethan Allen, Uttermost, etc.
            $table->string('product_category'); // Casegoods, Occasional Table, etc.
            $table->string('product_type'); // Montclaire 2 Drawer Nightstand
            $table->string('product_code'); // 14-5466
            $table->string('size'); // 620mm x 486mm x 669mm
            $table->date('invoice_date');
            $table->integer('order_qty');
            $table->string('panel_type')->nullable(); // PB/PLYWOOD
            $table->string('solid_type')->nullable(); // Jenis Solid
            $table->string('veneer_face_type')->nullable(); // Jenis Veneer Face
            $table->string('veneer_back_type')->nullable(); // Jenis Veneer Back
            $table->string('box_drawer_type')->nullable(); // Mahoni/White Oak
            $table->string('image_path')->nullable(); // Upload gambar
            $table->json('calculation_data'); // Data perhitungan JSON
            $table->decimal('grand_total', 15, 2);
            $table->boolean('is_fixed')->default(false); // Status fix atau masih bisa edit
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_boms');
    }
};