<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('hardware', function (Blueprint $table) {
            $table->id();
            $table->string('material_code')->unique(); // RHALOC00001
            $table->string('hardware_type'); // Lock & Tipping, Glider, Pull, etc.
            $table->string('material_description'); // LOCK CYL STD 1-1/8" #14A BRS KW DMT
            $table->decimal('price', 15, 2); // Harga per unit
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('hardware');
    }
};