<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class HardwareSeeder extends Seeder
{
    public function run(): void
    {
        $hardwareData = [
            // ============================================
            // NAME PLATE
            // ============================================
            ['material_code' => '', 'hardware_type' => 'Name Plate', 'material_description' => 'NAME PLATE', 'price' => 41250],

            // ============================================
            // HARDWARE LOCK & TIPPING
            // ============================================
            ['material_code' => 'RHALOC00047', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'DRAWER INTERLOCK S1039 BLACK OVS', 'price' => 74663],
            ['material_code' => 'RHALOC00037', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'NYLON PLSTC STRP CLR WHT Y1220 7.5X300MM', 'price' => 4125],
            ['material_code' => 'RHALOC00036', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'RIGHT ANGLE HEX WRENCH 45-1371 HWK', 'price' => 3919],
            ['material_code' => 'RHALOC00035', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'KUNCI PAS 10-11MM DMT ZINC', 'price' => 3713],
            ['material_code' => 'RHALOC00021', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'FURNITURE TIPPING Y1220 XH 100 LB', 'price' => 12375],
            ['material_code' => 'RHALOC00017', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'WRENCH E1008 13X87X2MM ZINC OVS', 'price' => 3300],
            ['material_code' => 'RHALOC00016', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'TABLE LOCK TYPE V0288 BRWN OVS', 'price' => 12375],
            ['material_code' => 'RHALOC00014', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'RIGHT ANGLE HEX WRENCH E1016 ZINC OVS', 'price' => 4538],
            ['material_code' => 'RHALOC00012', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'KUNCI PAS 14-15MM DMT', 'price' => 4125],
            ['material_code' => 'RHALOC00011', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'KUNCI PAS 12-13MM DMT', 'price' => 3919],
            ['material_code' => 'RHALOC00008', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'FURNITURE TIPPING 98-2286 OVS', 'price' => 9075],
            ['material_code' => 'RHALOC00007', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'FURNITURE TIPPING (STANLEY)', 'price' => 2681],
            ['material_code' => 'RHALOC00002', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'ALLEN KEY 5X83X32MM ZINC DMT', 'price' => 11138],
            ['material_code' => 'RHALOC00001', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'ALLEN KEY H1007 4X70X32MM NKL OVS', 'price' => 2475],
            ['material_code' => '40001155', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'FURNITURE TIPPING W/HEAVY ABS PLSTC 60LB', 'price' => 12581],
            ['material_code' => '40001023', 'hardware_type' => 'Hardware Lock & Tipping', 'material_description' => 'FURNITURE TIPPING (VANGUARD)', 'price' => 4744],

            // ============================================
            // HARDWARE GLIDER, NAIL, STOPPER
            // ============================================
            ['material_code' => 'RHSGLD00010', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER M1008 5/16"X7/8"X40MM BLK', 'price' => 9900],
            ['material_code' => 'RHSGLD00008', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER LEV 2-1/4" EXT 31-1371300', 'price' => 21656],
            ['material_code' => 'RHSGLD00013', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER RM0338 1/4X7/8"X19MM BRWN', 'price' => 825],
            ['material_code' => 'RHSGLD00005', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER 1/4X7/8"X20MM BLK DMT', 'price' => 759],
            ['material_code' => 'RHSGLD00016', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER 1/4X7/8"X20MM WHITE DMT', 'price' => 749],
            ['material_code' => 'RHSGLD00015', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER RM0338 1/4X7/8"X24MM BRWN', 'price' => 749],
            ['material_code' => 'RHSGLD00001', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER 1/4X6X16MM BLK DMT', 'price' => 619],
            ['material_code' => 'RHSGLD00006', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER M6X25MM BLK DMT', 'price' => 535],
            ['material_code' => 'RHSGLD00014', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER RM0338 1/4X7/8"X24MM BLK', 'price' => 747],
            ['material_code' => 'RHSGLD00057', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER M6X15XØ13MM BRWN DMT', 'price' => 619],
            ['material_code' => 'RHSGLD00019', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER M4X13X5 BLK DMT', 'price' => 318],
            ['material_code' => '40000719', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER M6X15XØ13MM BLK DMT', 'price' => 413],
            ['material_code' => 'RHSGLD00002', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJ GLIDER 1/4X6X16MM BRWN DMT', 'price' => 723],
            ['material_code' => 'RHSGLD00020', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'GLIDER BULAT Ø16X6MM BRWN DMT', 'price' => 208],
            ['material_code' => 'RHSGLD00021', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'GLIDER BULAT Ø20X6MM DMT BRWN', 'price' => 252],
            ['material_code' => 'RHSGLD00037', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LEVELING FEET FIXED 12644/12 OVS', 'price' => 55275],
            ['material_code' => 'RHSGLD00036', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LEVELING FEET FIXED NON ADJ 466159 OVS', 'price' => 18150],
            ['material_code' => 'RHSGLD00028', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL BRNZERNAISSANCE 670REF#3 Ø11X13MM', 'price' => 413],
            ['material_code' => 'RHSGLD00058', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL 40-472-500 MARMOREIT #35', 'price' => 413],
            ['material_code' => 'RHSGLD00026', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL 5/8" ANT BRASS OVS', 'price' => 413],
            ['material_code' => 'RHSGLD00025', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL 2.5X10MM YELLW DMT', 'price' => 147],
            ['material_code' => 'RHSGLD00039', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL OVS BLK', 'price' => 239],
            ['material_code' => 'RHSGLD00024', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL 1.2X11MM NICKEL', 'price' => 631],
            ['material_code' => 'RHSGLD00029', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL IMPORT GOLD UK. 5/8 INCH', 'price' => 410],
            ['material_code' => 'RHSGLD00033', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'NAIL SQUARE 16.64X16.64MM BLK', 'price' => 4950],
            ['material_code' => 'RHSGLD00034', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'RECT GLIDE TACK 32X12X6MM BRWN DMT', 'price' => 346],
            ['material_code' => 'RHSSTO00002', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'GLS RETAINER PVC RY1141A BLK OVS', 'price' => 9900],
            ['material_code' => 'RHSSTO00003', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'GLS RETAINER PVC RY1141A BRWN OVS', 'price' => 8250],
            ['material_code' => 'RHSSTO00004', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LARGE RECT BLK PAD 94X44.45X3.2MM', 'price' => 4538],
            ['material_code' => 'RHSSTO00017', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'PAD ANTI SLIP 30-40030-83 BLK', 'price' => 15469],
            ['material_code' => 'RHSSTO00011', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'RUBBER STRIPE NEOPRENE 31.75X320.67MM DM', 'price' => 11756],
            ['material_code' => 'RHSCON00017', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BUFFERS 356.21.420 Ø8X1.6MM OVS TRANSP', 'price' => 361],
            ['material_code' => 'RHSSTO00006', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'PLAT DRAWER PLASTIC BLK DMT', 'price' => 475],
            ['material_code' => 'RHSSTO00018', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'FELT Ø25 X 3 MM BLK', 'price' => 683],
            ['material_code' => 'RHSSTO00028', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'RUBBER FOOD PAD UK.3X82X127MM', 'price' => 26400],
            ['material_code' => 'RHSCON00035', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BUFFERS 3M SJ5312 Ø10X3MM OVS TRANSP', 'price' => 1187],
            ['material_code' => 'RHSSTO00005', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LARGE RECT BLK PAD 94X44.45X5MM', 'price' => 7425],
            ['material_code' => '40000720', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'PIN DRAWER Ø20X20MM WHT DMT', 'price' => 7219],
            ['material_code' => 'RHSSTO00012', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SELANG BENING 5/16"', 'price' => 1603],
            ['material_code' => 'RHSSTO00014', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SMALL SQUARE BLK PAD 60.5X44.45X5MM', 'price' => 5363],
            ['material_code' => 'RHSCAT00005', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MAGNETIC CATCH #900 S RT1028 BLK OVS', 'price' => 3713],
            ['material_code' => 'RHSCAT00009', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MAGNETIC CATCH PUSH TO OPEN 956.1002', 'price' => 25781],
            ['material_code' => 'RHSCAT00003', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'EARTH MAGNET Ø10MMX12MM T1023 OVS', 'price' => 19800],
            ['material_code' => 'RHSCAT00008', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'TIP ON CATH PLATE NCKL PLTD 955.1008S', 'price' => 1057],
            ['material_code' => 'RHSCAT00002', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'DOOR CATHCHES (SES) BRWN DMT', 'price' => 3300],
            ['material_code' => 'RHSCAT00004', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MAGNETIC CATCH 58X34MM T0533 BLK DMT', 'price' => 5775],
            ['material_code' => 'RHSCAT00010', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MAGNETIC CATCH PUSH TO OPEN 956A.1002', 'price' => 47850],
            ['material_code' => 'RHSCON00009', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'STEEL SHELF PIN V1027 BRASS OVS', 'price' => 1238],
            ['material_code' => 'RHSCON00036', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'TUBE END BRACKET 12,4X17XT2,5MM BLK OVS', 'price' => 3300],
            ['material_code' => 'RHSCON00029', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'CONECTOR CENTRAL RAIL V1724', 'price' => 10313],
            ['material_code' => 'RHSCON00007', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LOWER RAIL SUP V1744 60X33X2MM ANT BRAS', 'price' => 3300],
            ['material_code' => 'RHSCON00031', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SOCKET V0226 8X15MM BRWN OVS', 'price' => 2055],
            ['material_code' => 'RHSCON00024', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'PLASTIC COVER V1295 BRWN OVS', 'price' => 875],
            ['material_code' => 'RHSCON00060', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'WIRELESS ADJUSTABLE HANGER 3010B', 'price' => 21244],
            ['material_code' => 'RHSCON00006', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SHELF PIN BRASS V1027 1/4X8X19MM', 'price' => 1650],
            ['material_code' => 'RHSCON00019', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MOUNTING PLATE V1662 30X16X2MM ANT BRWN', 'price' => 1526],
            ['material_code' => 'RHSCON00044', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'METAL LEV V0566M 19X50X2MM ANT BRWN OVS', 'price' => 2063],
            ['material_code' => 'RHSCON00082', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR BLK UK.127 ØM10', 'price' => 20625],
            ['material_code' => 'RHSCON00071', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BRACKET SOHO&SANIBEL 3X28.5X114MM BLK', 'price' => 9488],
            ['material_code' => 'RHSCON00021', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SHELF HOLDER W/HOLE V1006 BRWN OVS', 'price' => 1444],
            ['material_code' => 'RHSCON00028', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'HANGER MIRROR 3 HOLE BLK DMT', 'price' => 5569],
            ['material_code' => 'RHSCON00032', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'TABLE PIN V0225 8X24MM BRWN OVS', 'price' => 3300],
            ['material_code' => 'RHSCON00037', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'TUBE END BRACKET 16,4X22XT2,5MM ZINC OVS', 'price' => 3300],
            ['material_code' => 'RHSCON00039', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR BLK UK.102 ØM12', 'price' => 30938],
            ['material_code' => 'RHSCON00002', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'METAL BRACKET 1.5X63.5X63.5MM WHITE DMT', 'price' => 5775],
            ['material_code' => 'RHSCON00012', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'STEEL SHELF PIN 1/4" 7,5X25,5 MM BRASS', 'price' => 4744],
            ['material_code' => 'RHSCON00042', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MANDING PLATE 5X50X150MM BLK', 'price' => 18150],
            ['material_code' => 'RHSCON00010', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'STEEL SOCKET FOR SHELF PIN V1026 BRS OVS', 'price' => 619],
            ['material_code' => 'RHSCON00005', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MTL BRACKET UK 1.5X48.2X76.2 BLK', 'price' => 5775],
            ['material_code' => 'RHSCON00020', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'PLAT SIKU 25X25MM BLK DMT', 'price' => 2475],
            ['material_code' => 'RHSCON00075', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR BLK UK.102 ØM16', 'price' => 31144],
            ['material_code' => 'RHSCON00072', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BRACKT SOHO & SANIBEL 3X28.5X114MM UNF', 'price' => 7631],
            ['material_code' => 'RHSCON00054', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'LONG ALUMINIUM 1/4X5/8" DMT WHTE', 'price' => 4331],
            ['material_code' => 'RHSCON00026', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR UNF UK.102 ØM16', 'price' => 29081],
            ['material_code' => 'RHSCON00041', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'TIPPING BRACKET', 'price' => 11756],
            ['material_code' => '40001124', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'SPRING CLIPS NO-SAG 1.2X22X23MM', 'price' => 1238],
            ['material_code' => 'RHSCON00023', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MANDING PLATE 0.6X15X30MM BLK DMT', 'price' => 1444],
            ['material_code' => 'RHSCON00043', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MANDING PLATE KAKI 3 1.5X108X108MM BLK', 'price' => 19388],
            ['material_code' => 'RHSCON00050', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR UNF UK.102 ØM12', 'price' => 29288],
            ['material_code' => 'RHSCON00056', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'MANDING PLATE ZINC UK.1,5X19X50MM', 'price' => 1650],
            ['material_code' => 'RHSCON00067', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'ADJUSTING BAR UNF UK.127 ØM10', 'price' => 19181],
            ['material_code' => 'RHSCON00070', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BRACKET SOHO&SANIBEL 3X117X114MM BLK', 'price' => 34238],
            ['material_code' => 'RHSCON00073', 'hardware_type' => 'Hardware Glider, Nail, Stopper', 'material_description' => 'BRACKET SOHO&SANIBEL 3X117X114MM UNF', 'price' => 31350],
            // ============================================
            // HARDWARE SCREW
            // ============================================
            ['material_code' => 'RHSSCR00103', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX1/2" BLK OVS', 'price' => 126],
            ['material_code' => 'RHSSCR00065', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (SQ) B1044 6MMX3/4" BLK OVS', 'price' => 105],
            ['material_code' => 'RHSSCR00007', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 1/4X1-1/2" Ø10MM ZINC DMT', 'price' => 672],
            ['material_code' => 'RHSSCR00108', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX2-1/4" BLK OVS', 'price' => 309],
            ['material_code' => 'RHSSCR00100', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 6MMX3/4" BLK OVS', 'price' => 104],
            ['material_code' => 'RHSSCR00066', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (SQ) B1044 6MMX5/8" BLK OVS', 'price' => 92],
            ['material_code' => 'RHSSCR00093', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX5/8" BLK DMT', 'price' => 119],
            ['material_code' => 'RHSSCR00110', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX5/8" BLK OVS', 'price' => 128],
            ['material_code' => 'RHSSCR00058', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX3/4" BLK DMT', 'price' => 132],
            ['material_code' => 'RHSSCR00084', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX5/8" BLK DMT', 'price' => 82],
            ['material_code' => 'RHSSCR00045', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 7MMX5/8" BRWN OVS', 'price' => 133],
            ['material_code' => 'RHSSCR00064', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (SQ) B1044 6MMX1/2" BLK OVS', 'price' => 78],
            ['material_code' => 'RHSSCR00099', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 6MMX1/2" BLK OVS', 'price' => 78],
            ['material_code' => 'RHSSCR00107', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX2-1/2" BLK OVS', 'price' => 340],
            ['material_code' => 'RHSSCR00025', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 5MMX5/8" BRWN OVS', 'price' => 87],
            ['material_code' => 'RHSSCR00140', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 9X2-3/4" BLK OVS', 'price' => 413],
            ['material_code' => 'RHSSCR00028', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1/2" BLK DMT', 'price' => 78],
            ['material_code' => 'RHSSCR00086', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX1-1/2" SS DMT', 'price' => 588],
            ['material_code' => 'RHSSCR00032', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1-1/2" ZINC DMT', 'price' => 106],
            ['material_code' => 'RHSSCR00038', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX5/8" BLK DMT', 'price' => 77],
            ['material_code' => 'RHSSCR00106', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX2" BLK OVS', 'price' => 206],
            ['material_code' => '40000623', 'hardware_type' => 'Hardware Screw', 'material_description' => 'STUD INT THRD SS 304 6X10 M4', 'price' => 5981],
            ['material_code' => 'RHSSCR00101', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 6MMX5/8" BLK OVS', 'price' => 85],
            ['material_code' => 'RHSSCR00109', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX3/4" BLK OVS', 'price' => 206],
            ['material_code' => 'RHSSCR00102', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX1" BLK OVS', 'price' => 169],
            ['material_code' => 'RHSSCR00056', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX2" BLK DMT', 'price' => 297],
            ['material_code' => 'RHSSCR00105', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX1-1/4" BLK OVS', 'price' => 206],
            ['material_code' => 'RHSSCR00031', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1-1/2" BLK DMT', 'price' => 153],
            ['material_code' => 'RHSSCR00052', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1-1/4" BLK DMT', 'price' => 191],
            ['material_code' => 'RHSSCR00082', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX3/8" BLK DMT', 'price' => 67],
            ['material_code' => 'RHSSCR00085', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX5/8" ZINC DMT', 'price' => 74],
            ['material_code' => 'RHSSCR00043', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX5/8" SS DMT', 'price' => 183],
            ['material_code' => 'RHSSCR00104', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (SQ) B1025 8MMX1-1/2" BLK OVS', 'price' => 223],
            ['material_code' => 'RHSSCR00057', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX2" ZINC DMT', 'price' => 201],
            ['material_code' => 'RHSSCR00023', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 5MMX1/2" BRS DMT', 'price' => 2150],
            ['material_code' => 'RHSSCR00022', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 4MMX5/8" SS DMT', 'price' => 151],
            ['material_code' => 'RHSSCR00092', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX3/4" ZINC DMT', 'price' => 98],
            ['material_code' => 'RHSSCR00074', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 4MMX1/2" BLK DMT', 'price' => 62],
            ['material_code' => 'RHSSCR00051', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1-1/2" ZINC DMT', 'price' => 149],
            ['material_code' => 'RHSSCR00006', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 1/4"X3" Ø10MM ZINC DMT', 'price' => 511],
            ['material_code' => 'RHSSCR00019', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 4MMX1/2" ZINC DMT', 'price' => 44],
            ['material_code' => 'RHSSCR00026', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1" ZINC DMT', 'price' => 72],
            ['material_code' => 'RHSSCR00077', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 4MMX3/8" ZINC DMT', 'price' => 45],
            ['material_code' => 'RHSSCR00029', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1/2" ZINC DMT', 'price' => 78],
            ['material_code' => 'RHSSCR00020', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 4MMX5/8" BLK DMT', 'price' => 65],
            ['material_code' => 'RHSSCR00009', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 5/16"X1" BLK DMT', 'price' => 892],
            ['material_code' => '40000335', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF SS 6 X 3/4"', 'price' => 206],
            ['material_code' => 'RHSSCR00067', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (SQ) B1044 8MMX1" BLK OVS', 'price' => 176],
            ['material_code' => 'RHSSCR00040', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX5/8" ZINC DMT', 'price' => 52],
            ['material_code' => 'RHSSCR00111', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 3/8"X1-1/2" ZINC DMT', 'price' => 724],
            ['material_code' => 'RHSSCR00004', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 1/4"X2" Ø10MM ZINC DMT', 'price' => 394],
            ['material_code' => 'RHSSCR00005', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 1/4"X2-1/2" Ø10MM ZINC DMT', 'price' => 455],
            ['material_code' => 'RHSSCR00087', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX1-1/4" ZINC DMT', 'price' => 139],
            ['material_code' => 'RHSSCR00021', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 4MMX5/8" ZINC DMT', 'price' => 47],
            ['material_code' => 'RHSSCR00008', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 3/8"X1-1/2" BLK DMT', 'price' => 1231],
            ['material_code' => 'RHSSCR00035', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX3/4" ZINC DMT', 'price' => 58],
            ['material_code' => 'RHSSCR00047', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1" ZINC DMT', 'price' => 107],
            ['material_code' => 'RHSSCR00027', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX1" SS DMT', 'price' => 251],
            ['material_code' => 'RHSSCR00072', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 10MMX3/4" ZINC DMT', 'price' => 148],
            ['material_code' => 'RHSSCR00126', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX1-1/2" YLLW DMT', 'price' => 206],
            ['material_code' => 'RHSSCR00034', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX3/4" BLK DMT', 'price' => 83],
            ['material_code' => 'RHSSCR00039', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 6MMX5/8" YELLW DMT', 'price' => 58],
            ['material_code' => 'RHSSCR00044', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 7MMX5/8" NKL PLATED', 'price' => 164],
            ['material_code' => 'RHSSCR00046', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1" BLK DMT', 'price' => 156],
            ['material_code' => 'RHSSCR00048', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1/2" BLK DMT', 'price' => 104],
            ['material_code' => 'RHSSCR00050', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1-1/2" BLK DMT', 'price' => 206],
            ['material_code' => 'RHSSCR00053', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JF (+) 8MMX1-1/4" ZINC DMT', 'price' => 130],
            ['material_code' => 'RHSSCR00076', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 4MMX3/8" BLK DMT', 'price' => 56],
            ['material_code' => 'RHSSCR00080', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX1/2" BLK DMT', 'price' => 97],
            ['material_code' => 'RHSSCR00081', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX1/2" ZINC DMT', 'price' => 55],
            ['material_code' => 'RHSSCR00083', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 6MMX3/8" ZINC DMT', 'price' => 46],
            ['material_code' => 'RHSSCR00091', 'hardware_type' => 'Hardware Screw', 'material_description' => 'SCREW JP (+) 8MMX3/4" BLK DMT', 'price' => 91],
            ['material_code' => 'RHSSCR00112', 'hardware_type' => 'Hardware Screw', 'material_description' => 'HEX SCREW 5/16"X1" ZINC DMT', 'price' => 612],
            // ============================================
            // HARDWARE BOLT
            // ============================================
            ['material_code' => 'RHSBOL00025', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 1/4X1 1/4" ZINC', 'price' => 446],
            ['material_code' => 'RHSBOL00039', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 5/32X1-1/2" ZINC OVS', 'price' => 203],
            ['material_code' => 'RHSBOL00030', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JF A0380 NW LIGHT UK.1/4X5/8 INCH', 'price' => 368],
            ['material_code' => 'RHSBOL00028', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 UK.1/4X5/8 INCH ZINC', 'price' => 307],
            ['material_code' => 'RHSBOL00236', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 1/4X1-1/4" ZINC DMT', 'price' => 413],
            ['material_code' => 'RHSBOL00022', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) B1002 BLK 1/4X1"', 'price' => 569],
            ['material_code' => 'RHSBOL00044', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1" BRWN OVS', 'price' => 206],
            ['material_code' => 'RHSSCR00122', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BIG WALL ANCHOR HHD-S M5X65 MM ZINC DMT', 'price' => 19388],
            ['material_code' => '40000801', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 5/16X1" BLK', 'price' => 619],
            ['material_code' => 'RHSBOL00257', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 UK.1/4X5/8 INCH BLACK', 'price' => 413],
            ['material_code' => 'RHSBOL00195', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX BOLT SS M6X15MM', 'price' => 619],
            ['material_code' => 'RHSBOL00171', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X7/8" OVS ZINC', 'price' => 413],
            ['material_code' => 'RHSBOL00018', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 5/16X3" BLK DMT', 'price' => 1171],
            ['material_code' => 'RHSBOL00026', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 1/4X1" BLK', 'price' => 324],
            ['material_code' => '40000651', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1-1/4" BROWN', 'price' => 413],
            ['material_code' => 'RHSBOL00045', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1" ZINC OVS', 'price' => 413],
            ['material_code' => 'RHSBOL00100', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1-3/4\'\'ø12MM ZINC DMT', 'price' => 742],
            ['material_code' => 'RHSBOL00046', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1-1/4" ZINC OVS', 'price' => 413],
            ['material_code' => 'RHSBOL00187', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1-1/2" ZINC OVS', 'price' => 413],
            ['material_code' => 'RHSBOL00189', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1-1/2" BROWN OVS', 'price' => 413],
            ['material_code' => '40000986', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) M6 X 80 MM ZINC DMT', 'price' => 413],
            ['material_code' => 'RHSBOL00031', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JF A0380 UK.1/4X1 INCH BLK', 'price' => 321],
            ['material_code' => '40001122', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X1-3/8" ZINC OVS', 'price' => 413],
            ['material_code' => 'RHSBOL00066', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HANGER BOLT 5/16X2-1/2" ZINC DMT', 'price' => 1163],
            ['material_code' => 'RHSBOL00069', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HANGER BOLT 5/16X4" ZINC DMT', 'price' => 1872],
            ['material_code' => 'RHSBOL00027', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 1/4X1" ZINC', 'price' => 318],
            ['material_code' => 'RHSBOL00035', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+) 4X30 ZINC DMT', 'price' => 103],
            ['material_code' => 'RHSBOL00056', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'CB BOLT 1/4"X3/4"', 'price' => 252],
            ['material_code' => 'RHSBOL00253', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC A0379 1/4X1 1/4" YLLW', 'price' => 493],
            ['material_code' => 'RHSBOL00096', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1-1/2" ZINC DMT', 'price' => 700],
            ['material_code' => 'RHSBOL00215', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JF SS M4X35MM', 'price' => 619],
            ['material_code' => 'RHSBOL00080', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 1/4X1" ZINC DMT', 'price' => 360],
            ['material_code' => 'RHSBOL00013', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 5/16X1" YELLW', 'price' => 923],
            ['material_code' => 'RHSBOL00047', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 8/32"X3/4" ZINC OVS', 'price' => 60],
            ['material_code' => 'RHSBOL00118', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'THROUGH BOLT A1038 5/16X3-1/2" ZINC DMT', 'price' => 2063],
            ['material_code' => 'RHSBOL00020', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) B1002 1/4"X1-1/2" BLK', 'price' => 572],
            ['material_code' => '40000643', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JF (L) SS 304 M6X15MM', 'price' => 825],
            ['material_code' => 'RHSBOL00032', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+) 4X15MM ZINC DMT', 'price' => 57],
            ['material_code' => 'RHSBOL00063', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HANGER BOLT 3/8X3" ZINC DMT', 'price' => 2269],
            ['material_code' => 'RHSBOL00065', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HANGER BOLT 5/16X2" ZINC DMT', 'price' => 916],
            ['material_code' => 'RHSBOL00207', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX BOLT SS 304 1/4"X1/2"', 'price' => 1031],
            ['material_code' => 'RHSBOL00012', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 1/4X2" ZINC OVS', 'price' => 885],
            ['material_code' => 'RHSBOL00088', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 3/8 X 4 INCH WHITE', 'price' => 1650],
            ['material_code' => 'RHSBOL00131', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+-) 5/32X1/2" ZINC OVS', 'price' => 1031],
            ['material_code' => 'RHSBOL00094', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1" ZINC DMT', 'price' => 166],
            ['material_code' => 'RHSBOL00238', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX BOLT SS M8 X 25MM', 'price' => 1444],
            ['material_code' => 'RHSBOL00019', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) B1002 1/4"X1-1/2" ANT BRWN', 'price' => 892],
            ['material_code' => 'RHSBOL00153', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 BLK 5/16X2" DMT', 'price' => 1444],
            ['material_code' => 'RHSBOL00036', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+) 4X35MM ZINC DMT', 'price' => 102],
            ['material_code' => 'RHSBOL00174', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JFL SS M6X25MM', 'price' => 1444],
            ['material_code' => '40000606', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JF (+) M6X40 ZINC', 'price' => 206],
            ['material_code' => 'RHSBOL00014', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 5/16X1-1/2" BLK', 'price' => 1242],
            ['material_code' => '40000042', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX NUT SS 304 M8', 'price' => 619],
            ['material_code' => 'RHSBOL00081', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 1/4X1-1/2" BLK DMT', 'price' => 324],
            ['material_code' => 'RHSBOL00016', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC (L) A0379 5/16X1-1/2" ZINC', 'price' => 835],
            ['material_code' => 'RHSBOL00102', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X2" ZINC DMT', 'price' => 796],
            ['material_code' => '40000607', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT BUTTON SS 304 M4X10MM', 'price' => 619],
            ['material_code' => 'RHSBOL00199', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1" DMT BLK', 'price' => 409],
            ['material_code' => 'RHSBOL00079', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 1/4X1" BLK DMT', 'price' => 274],
            ['material_code' => 'RHSBOL00176', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX BOLT BLK 3/8X1"', 'price' => 623],
            ['material_code' => '40000743', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'STUD BOLT M16X394MM ZINC', 'price' => 17119],
            ['material_code' => '40000674', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX BOLT SS 304 5/16"X1"', 'price' => 1444],
            ['material_code' => 'RHSBOL00033', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+) 4X20 ZINC DMT', 'price' => 63],
            ['material_code' => 'RHSBOL00034', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JP (+) 4X25MM ZINC DMT', 'price' => 87],
            ['material_code' => 'RHSBOL00091', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT A0354 5/16"X3" HD1/2" ZINC', 'price' => 1112],
            ['material_code' => 'RHSBOL00098', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1-1/4\'\' ø13 MM ZINC', 'price' => 644],
            ['material_code' => 'RHSBOL00092', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16"X3-1/2" BLK DMT', 'price' => 916],
            ['material_code' => 'RHSBOL00237', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT SS JFL M6X30MM', 'price' => 1444],
            ['material_code' => 'RHSBOL00103', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X2-1/2" ZINC DMT', 'price' => 880],
            ['material_code' => 'RHSBOL00101', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16X1-3/4\'\'ø13MM ZINC DMT', 'price' => 743],
            ['material_code' => 'RHSBOL00067', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HANGER BOLT 5/16X3" ZINC DMT', 'price' => 1412],
            ['material_code' => '40001233', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'STUD BOLT 3/8" X 292 MM ZINC', 'price' => 4125],
            ['material_code' => '40001910', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'STUD BOLT M12X291MM ZINC', 'price' => 6394],
            ['material_code' => '40000038', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEXBOLT M10 X 25 MM ZINC', 'price' => 1006],
            ['material_code' => '40000821', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JFL SS M6X20MM', 'price' => 1031],
            ['material_code' => 'RHSBOL00004', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT FLAT HEAD M4X15MM BLK DMT', 'price' => 93],
            ['material_code' => 'RHSBOL00023', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'BOLT JCBC 6 M X 80 M YELLW DMT', 'price' => 735],
            ['material_code' => 'RHSBOL00093', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16"X3-1/2" ZINC DMT', 'price' => 1263],
            ['material_code' => 'RHSBOL00106', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT RA1060 3/8X2-1/2" ZINC OVS', 'price' => 28624],
            ['material_code' => 'RHSBOL00107', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT ZINC 3/8 X 2 1/2', 'price' => 825],
            ['material_code' => 'RHSBOL00119', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'THROUGH BOLT 5/16X 1 1/2INC ZINC', 'price' => 455],
            ['material_code' => 'RHSBOL00190', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'STUD INT THRD SS TYPE IT 8X20 M6', 'price' => 14025],
            ['material_code' => 'RHSBOL00219', 'hardware_type' => 'Hardware Bolt', 'material_description' => 'HEX HEAD BOLT 5/16"X3" Ø13MM BLK DMT', 'price' => 822],
            // ============================================
            // HARDWARE NUT
            // ============================================
            ['material_code' => 'RHSNUT00037', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 5/32"X10MM ZINC OVS', 'price' => 724],
            ['material_code' => 'RHSNUT00033', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 3/8"X25MM ZINC OVS', 'price' => 1671],
            ['material_code' => 'RHSNUT00002', 'hardware_type' => 'Hardware Nut', 'material_description' => 'ADJ T NUT D0297 5/16"X37X15MM YELLW OVS', 'price' => 3300],
            ['material_code' => 'RHSNUT00036', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 5/16"X12.7X25MM STEEL', 'price' => 1070],
            ['material_code' => 'RHSNUT00032', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 1/4"X25MM ZINC OVS', 'price' => 1234],
            ['material_code' => 'RHSNUT00085', 'hardware_type' => 'Hardware Nut', 'material_description' => 'RIVET NUT STEEL D1009 1/4"X8.9X15 MM YLW', 'price' => 1238],
            ['material_code' => 'RHSNUT00031', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 1/4"X13MM ZINC OVS', 'price' => 585],
            ['material_code' => '40000841', 'hardware_type' => 'Hardware Nut', 'material_description' => 'BUDGET NUT M6 30 SERIES', 'price' => 1031],
            ['material_code' => 'RHSNUT00011', 'hardware_type' => 'Hardware Nut', 'material_description' => 'CYLINDR NUT RD1015 5/16"X12.5X12MM ZINC', 'price' => 4125],
            ['material_code' => 'RHSNUT00008', 'hardware_type' => 'Hardware Nut', 'material_description' => 'BUSHING 3/4 INCH-16  51-2036931 ZINC', 'price' => 40219],
            ['material_code' => 'RHSNUT00048', 'hardware_type' => 'Hardware Nut', 'material_description' => 'ROUND WELD NUT M10 WHITE ZINC OVS', 'price' => 1650],
            ['material_code' => 'RHSNUT00007', 'hardware_type' => 'Hardware Nut', 'material_description' => 'ALUMUNIUM BLIND RIVET DIA.4,8MM', 'price' => 315],
            ['material_code' => 'RHSNUT00030', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 1/4"X10X20MM STEEL', 'price' => 872],
            ['material_code' => 'RHSNUT00020', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX NUT D0329 5/16" ZINC OVS', 'price' => 392],
            ['material_code' => 'RHSNUT00054', 'hardware_type' => 'Hardware Nut', 'material_description' => 'T NUT 3/8" ZINC DMT', 'price' => 1014],
            ['material_code' => 'RHSNUT00035', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT D0306 5/16"X12.7X22MM STEEL', 'price' => 2063],
            ['material_code' => 'RHSNUT00041', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT E-29 YELLW DMT', 'price' => 481],
            ['material_code' => 'RHSNUT00068', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT E-40 DMT YELLW', 'price' => 1031],
            ['material_code' => 'RHSNUT00001', 'hardware_type' => 'Hardware Nut', 'material_description' => 'ADJ NUT D0297 3/8X37X15MM YLLW', 'price' => 6188],
            ['material_code' => '40000913', 'hardware_type' => 'Hardware Nut', 'material_description' => 'RIVET NUT M6 YELLOW', 'price' => 1349],
            ['material_code' => '40001566', 'hardware_type' => 'Hardware Nut', 'material_description' => 'PINAPLE NUT SS M6X10X20MM', 'price' => 10725],
            ['material_code' => 'RHSNUT00018', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX NUT 3/8 ZINC DMT', 'price' => 341],
            ['material_code' => 'RHSNUT00024', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX RIVET NUT SS M6', 'price' => 5981],
            ['material_code' => 'RHSNUT00092', 'hardware_type' => 'Hardware Nut', 'material_description' => 'RIVET NUT SS M6', 'price' => 5775],
            ['material_code' => '40000780', 'hardware_type' => 'Hardware Nut', 'material_description' => 'SLAB BASE NUT 11-240617-001', 'price' => 27844],
            ['material_code' => 'RHSNUT00014', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HARDWARE FISHER S6', 'price' => 100],
            ['material_code' => 'RHSNUT00075', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX RIVET NUT M6', 'price' => 1650],
            ['material_code' => 'RHSNUT00056', 'hardware_type' => 'Hardware Nut', 'material_description' => 'T NUT WHITE ZINC 5/16" DMT', 'price' => 487],
            ['material_code' => 'RHSNUT00053', 'hardware_type' => 'Hardware Nut', 'material_description' => 'T NUT 1/4" ZINC DMT', 'price' => 433],
            ['material_code' => 'RHSNUT00079', 'hardware_type' => 'Hardware Nut', 'material_description' => 'NUT 1/4 SS', 'price' => 414],
            ['material_code' => 'RHSNUT00027', 'hardware_type' => 'Hardware Nut', 'material_description' => 'NUT 1/4', 'price' => 142],
            ['material_code' => 'RHSNUT00025', 'hardware_type' => 'Hardware Nut', 'material_description' => 'INSERT LOCK NUT E-06 (M6)', 'price' => 477],
            ['material_code' => 'RHSNUT00080', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX RIVET NUT SS M4', 'price' => 5981],
            ['material_code' => 'RHSNUT00013', 'hardware_type' => 'Hardware Nut', 'material_description' => 'FISHER Y1077 S8', 'price' => 188],
            ['material_code' => 'RHSNUT00010', 'hardware_type' => 'Hardware Nut', 'material_description' => 'CROSS DOWEL NUT D0325 5/16" ZINC', 'price' => 2475],
            ['material_code' => 'RHSNUT00073', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX RIVET NUT SS M8', 'price' => 6394],
            ['material_code' => '40000684', 'hardware_type' => 'Hardware Nut', 'material_description' => 'ALUMUNIUM BLIND RIVET DIA. 4,8X16 MM', 'price' => 413],
            ['material_code' => '40001911', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX NUT M12 ZINC', 'price' => 825],
            ['material_code' => 'RHSNUT00016', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX NUT 10MM ZINC DMT', 'price' => 494],
            ['material_code' => 'RHSNUT00021', 'hardware_type' => 'Hardware Nut', 'material_description' => 'HEX NUT M12 BLK DMT', 'price' => 737],
            ['material_code' => 'RHSNUT00069', 'hardware_type' => 'Hardware Nut', 'material_description' => 'NUT M6 SS', 'price' => 206],

            // ============================================
            // HARDWARE WASHER
            // ============================================
            ['material_code' => 'RHSWAS0006', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 5/16"X23X2MM ZINC OVS', 'price' => 416],
            ['material_code' => 'RHSWAS0012', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER RC0330 3/8X 25,4X2 BLK', 'price' => 520],
            ['material_code' => 'RHSWAS0001', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 1/4 INCHX19X2MM BLK DMT', 'price' => 392],
            ['material_code' => 'RHSWAS0036', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER SS M6X12MM', 'price' => 172],
            ['material_code' => 'RHSWAS0017', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER RC0330 5/16"X19X1.5MM ZINC', 'price' => 206],
            ['material_code' => 'RHSWAS0032', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER SS UK. 3/8 INCH', 'price' => 440],
            ['material_code' => 'RHSWAS0027', 'hardware_type' => 'Hardware Washer', 'material_description' => 'RECT WASHER C1023 17X35X3MM ZINC OVS', 'price' => 1361],
            ['material_code' => 'RHSWAS0010', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 6X16MM BLK DMT', 'price' => 106],
            ['material_code' => 'RHSWAS0003', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 4X10X1MM ZINC DMT', 'price' => 40],
            ['material_code' => 'RHSWAS0016', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER RC0330 5/16"X19X1.5MM BLK', 'price' => 236],
            ['material_code' => 'RHSWAS0022', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER 8MM BLK DMT', 'price' => 64],
            ['material_code' => 'RHSWAS0026', 'hardware_type' => 'Hardware Washer', 'material_description' => 'RECT WASHER 3/8" C1023 38.5X22.5X6MM', 'price' => 4331],
            ['material_code' => '40001678', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER M4 ZINC', 'price' => 29],
            ['material_code' => 'RHSWAS0020', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER 6MM BLK DMT', 'price' => 34],
            ['material_code' => 'RHSWAS0023', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER 8MM ZINC DMT', 'price' => 62],
            ['material_code' => 'RHSWAS0030', 'hardware_type' => 'Hardware Washer', 'material_description' => 'HALF MOON WASHER UK.8X14.5X41MM', 'price' => 9694],
            ['material_code' => 'RHSWAS0021', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER 6MM ZINC DMT', 'price' => 34],
            ['material_code' => 'RHSWAS0009', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 6X16 X1MM ZINC DMT', 'price' => 84],
            ['material_code' => 'RHSWAS0019', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER 10MM ZINC DMT', 'price' => 104],
            ['material_code' => 'RHSWAS0015', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER RC0330 3/8"X25.4X2MM ZINC', 'price' => 73],
            ['material_code' => 'RHSWAS0008', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 6X13X1MM ZINC DMT', 'price' => 52],
            ['material_code' => 'RHSWAS0053', 'hardware_type' => 'Hardware Washer', 'material_description' => 'LOCK WASHER SS M8', 'price' => 206],
            ['material_code' => '40000045', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER SS 304 M8', 'price' => 206],
            ['material_code' => 'RHSWAS0007', 'hardware_type' => 'Hardware Washer', 'material_description' => 'FLAT WASHER 6X13MM BLK DMT', 'price' => 106],
        ];

        DB::table('hardware')->insert($hardwareData);
        
        $this->command->info('✅ Hardware data seeded successfully! Total: ' . count($hardwareData) . ' items');
    }
}