<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ProductDrawer;

class ProductDrawerSeeder extends Seeder
{
    public function run(): void
    {
        $drawers = [
            // MAHONI - FRONT/BACK DRAWER
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 450, 'm2' => 0.0405, 'price' => 10000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 600, 'm2' => 0.054, 'price' => 14000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 850, 'm2' => 0.0765, 'price' => 19000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 1000, 'm2' => 0.09, 'price' => 22000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 450, 'm2' => 0.0495, 'price' => 13000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 600, 'm2' => 0.066, 'price' => 17000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 850, 'm2' => 0.0935, 'price' => 23000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 1000, 'm2' => 0.11, 'price' => 27000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 450, 'm2' => 0.063, 'price' => 16000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 600, 'm2' => 0.084, 'price' => 21000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 850, 'm2' => 0.119, 'price' => 29000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 1000, 'm2' => 0.14, 'price' => 35000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 450, 'm2' => 0.09, 'price' => 22000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 600, 'm2' => 0.12, 'price' => 30000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 850, 'm2' => 0.17, 'price' => 42000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 1000, 'm2' => 0.2, 'price' => 49000],

            // MAHONI - SIDE DRAWER
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 260, 'm2' => 0.0234, 'price' => 6000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 360, 'm2' => 0.0324, 'price' => 8000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 410, 'm2' => 0.0369, 'price' => 9000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 460, 'm2' => 0.0414, 'price' => 11000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 260, 'm2' => 0.0286, 'price' => 7000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 360, 'm2' => 0.0396, 'price' => 10000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 410, 'm2' => 0.0451, 'price' => 11000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 460, 'm2' => 0.0506, 'price' => 13000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 260, 'm2' => 0.0364, 'price' => 9000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 360, 'm2' => 0.0504, 'price' => 13000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 410, 'm2' => 0.0574, 'price' => 14000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 460, 'm2' => 0.0644, 'price' => 16000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 260, 'm2' => 0.052, 'price' => 13000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 360, 'm2' => 0.072, 'price' => 18000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 410, 'm2' => 0.082, 'price' => 20000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 460, 'm2' => 0.092, 'price' => 23000],

            // MAHONI - BASE DRAWER
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 450, 'm2' => 0.117, 'price' => 16000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 600, 'm2' => 0.156, 'price' => 21000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 850, 'm2' => 0.211, 'price' => 30000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 1000, 'm2' => 0.26, 'price' => 35000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 450, 'm2' => 0.162, 'price' => 22000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 600, 'm2' => 0.216, 'price' => 29000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 850, 'm2' => 0.306, 'price' => 41000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 1000, 'm2' => 0.36, 'price' => 48000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 450, 'm2' => 0.1845, 'price' => 25000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 600, 'm2' => 0.246, 'price' => 33000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 850, 'm2' => 0.3485, 'price' => 47000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 1000, 'm2' => 0.41, 'price' => 55000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 450, 'm2' => 0.207, 'price' => 28000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 600, 'm2' => 0.276, 'price' => 37000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 850, 'm2' => 0.391, 'price' => 52000],
            ['material_type' => 'Mahoni', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 1000, 'm2' => 0.46, 'price' => 61000],

            // WHITE OAK - FRONT/BACK DRAWER (sama seperti di atas tapi ganti Mahoni jadi White Oak)
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 450, 'm2' => 0.0405, 'price' => 20000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 600, 'm2' => 0.054, 'price' => 26000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 850, 'm2' => 0.0765, 'price' => 37000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 90, 'length' => 1000, 'm2' => 0.09, 'price' => 43000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 450, 'm2' => 0.0495, 'price' => 24000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 600, 'm2' => 0.066, 'price' => 32000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 850, 'm2' => 0.0935, 'price' => 45000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 110, 'length' => 1000, 'm2' => 0.11, 'price' => 52000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 450, 'm2' => 0.063, 'price' => 30000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 600, 'm2' => 0.084, 'price' => 40000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 850, 'm2' => 0.119, 'price' => 56000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 140, 'length' => 1000, 'm2' => 0.14, 'price' => 66000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 450, 'm2' => 0.09, 'price' => 42000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 600, 'm2' => 0.12, 'price' => 56000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 850, 'm2' => 0.17, 'price' => 80000],
            ['material_type' => 'White Oak', 'drawer_type' => 'front drawer', 'width' => 200, 'length' => 1000, 'm2' => 0.2, 'price' => 94000],

            // WHITE OAK - SIDE DRAWER
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 260, 'm2' => 0.0234, 'price' => 12000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 360, 'm2' => 0.0324, 'price' => 16000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 410, 'm2' => 0.0369, 'price' => 18000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 90, 'length' => 460, 'm2' => 0.0414, 'price' => 20000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 260, 'm2' => 0.0286, 'price' => 14000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 360, 'm2' => 0.0396, 'price' => 19000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 410, 'm2' => 0.0451, 'price' => 22000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 110, 'length' => 460, 'm2' => 0.0506, 'price' => 24000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 260, 'm2' => 0.0364, 'price' => 18000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 360, 'm2' => 0.0504, 'price' => 24000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 410, 'm2' => 0.0574, 'price' => 27000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 140, 'length' => 460, 'm2' => 0.0644, 'price' => 31000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 260, 'm2' => 0.052, 'price' => 25000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 360, 'm2' => 0.072, 'price' => 34000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 410, 'm2' => 0.082, 'price' => 39000],
            ['material_type' => 'White Oak', 'drawer_type' => 'side drawer', 'width' => 200, 'length' => 460, 'm2' => 0.092, 'price' => 43000],

            // WHITE OAK - BASE DRAWER
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 450, 'm2' => 0.117, 'price' => 54000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 600, 'm2' => 0.156, 'price' => 72000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 850, 'm2' => 0.211, 'price' => 102000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 260, 'length' => 1000, 'm2' => 0.26, 'price' => 120000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 450, 'm2' => 0.162, 'price' => 75000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 600, 'm2' => 0.216, 'price' => 100000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 850, 'm2' => 0.306, 'price' => 141000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 360, 'length' => 1000, 'm2' => 0.36, 'price' => 166000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 450, 'm2' => 0.1845, 'price' => 85000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 600, 'm2' => 0.246, 'price' => 114000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 850, 'm2' => 0.3485, 'price' => 161000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 410, 'length' => 1000, 'm2' => 0.41, 'price' => 189000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 450, 'm2' => 0.207, 'price' => 96000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 600, 'm2' => 0.276, 'price' => 127000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 850, 'm2' => 0.391, 'price' => 180000],
            ['material_type' => 'White Oak', 'drawer_type' => 'base drawer', 'width' => 460, 'length' => 1000, 'm2' => 0.46, 'price' => 212000],
        ];

        foreach ($drawers as $drawer) {
            ProductDrawer::create($drawer);
        }
    }
}