<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ProductPanel;

class ProductPanelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $panels = [
            // PB (Particle Board)
            ['panel_type' => 'PB', 'thickness' => 5, 'price' => 50000],
            ['panel_type' => 'PB', 'thickness' => 6, 'price' => 60000],
            ['panel_type' => 'PB', 'thickness' => 15, 'price' => 88000],   // ✅ UNTUK 18mm
            ['panel_type' => 'PB', 'thickness' => 18, 'price' => 106000],  // ✅ UNTUK 21mm
            ['panel_type' => 'PB', 'thickness' => 25, 'price' => 152000],  // ✅ UNTUK 28mm
            // HAPUS: 17, 20, 27
            
            // MDF
            ['panel_type' => 'MDF', 'thickness' => 1, 'price' => 13000],
            ['panel_type' => 'MDF', 'thickness' => 2.5, 'price' => 25000],
            ['panel_type' => 'MDF', 'thickness' => 4.75, 'price' => 42000],
            ['panel_type' => 'MDF', 'thickness' => 5, 'price' => 48000],
            ['panel_type' => 'MDF', 'thickness' => 6, 'price' => 55000],
            ['panel_type' => 'MDF', 'thickness' => 15, 'price' => 118000],  // ✅ UNTUK 18mm
            ['panel_type' => 'MDF', 'thickness' => 18, 'price' => 141000],  // ✅ UNTUK 21mm
            ['panel_type' => 'MDF', 'thickness' => 25, 'price' => 231000],  // ✅ UNTUK 28mm
            // HAPUS: 17, 20, 27
            
            // PLYWOOD
            ['panel_type' => 'PLYWOOD', 'thickness' => 4.75, 'price' => 68000],
            ['panel_type' => 'PLYWOOD', 'thickness' => 5, 'price' => 75000],
            ['panel_type' => 'PLYWOOD', 'thickness' => 6, 'price' => 85000],
            ['panel_type' => 'PLYWOOD', 'thickness' => 15, 'price' => 194000],  // ✅ UNTUK 18mm
            ['panel_type' => 'PLYWOOD', 'thickness' => 18, 'price' => 233000],  // ✅ UNTUK 21mm
            ['panel_type' => 'PLYWOOD', 'thickness' => 25, 'price' => 323000],  // ✅ UNTUK 28mm
            // HAPUS: 17, 20, 27
        ];
        
        // ✅ INSERT OR UPDATE (Avoid duplicates)
        foreach ($panels as $panel) {
            ProductPanel::updateOrCreate(
                [
                    'panel_type' => $panel['panel_type'],
                    'thickness' => $panel['thickness']
                ],
                [
                    'price' => $panel['price']
                ]
            );
        }
        
        $this->command->info('✅ Product Panel Seeder completed!');
        $this->command->info('Total panels: ' . count($panels));
    }
}