<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ProductVeneer;

class ProductVeneerSeeder extends Seeder
{
    public function run(): void
    {
        $veneers = [
            ['veneer_type' => 'MAHONI', 'thickness' => 0.5, 'price_lurus' => 61000, 'price_motif' => 149000],
            ['veneer_type' => 'WHITE BEECH', 'thickness' => 0.5, 'price_lurus' => 88000, 'price_motif' => 176000],
            ['veneer_type' => 'MAPLE', 'thickness' => 0.5, 'price_lurus' => 110000, 'price_motif' => 198000],
            ['veneer_type' => 'WHITE ASH', 'thickness' => 0.5, 'price_lurus' => 116000, 'price_motif' => 204000],
            ['veneer_type' => 'WHITE OAK', 'thickness' => 0.5, 'price_lurus' => 121000, 'price_motif' => 209000],
            ['veneer_type' => 'MAPLE BURL', 'thickness' => 0.5, 'price_lurus' => 139000, 'price_motif' => 227000],
            ['veneer_type' => 'WALNUT', 'thickness' => 0.5, 'price_lurus' => 206000, 'price_motif' => 294000],
            ['veneer_type' => 'JATI', 'thickness' => 0.5, 'price_lurus' => 244000, 'price_motif' => 332000],
            ['veneer_type' => 'WHITE ASH BURL', 'thickness' => 0.5, 'price_lurus' => 297000, 'price_motif' => 385000],
            ['veneer_type' => 'OLIVE ASH BURL', 'thickness' => 0.5, 'price_lurus' => 528000, 'price_motif' => 616000],
            ['veneer_type' => 'OAK BURL', 'thickness' => 0.5, 'price_lurus' => 589000, 'price_motif' => 677000],
            ['veneer_type' => 'WALNUT BURL', 'thickness' => 0.5, 'price_lurus' => 636000, 'price_motif' => 724000],
            ['veneer_type' => 'KHAYA CROTCH', 'thickness' => 0.5, 'price_lurus' => 792000, 'price_motif' => 880000],
        ];

        foreach ($veneers as $veneer) {
            ProductVeneer::create($veneer);
        }
    }
}