<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Invoice - {{ $invoice->product_code }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            padding: 20px;
            background: white;
        }

        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
            z-index: 1000;
        }

        .print-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
        }

        /* Header Section */
        .header-section {
            border: 2px solid #000;
            display: flex;
            margin-bottom: 20px;
        }

        .header-left {
            width: 70%;
            padding: 15px;
            border-right: 2px solid #000;
        }

        .header-right {
            width: 30%;
            padding: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .header-title {
            text-align: center;
            margin-bottom: 5px;
        }

        .header-title h1 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .header-subtitle {
            text-align: center;
            color: #0066cc;
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .header-penawaran {
            text-align: center;
            color: #cc0000;
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 15px;
            text-decoration: underline;
        }

        .product-info-table {
            width: 100%;
            border-collapse: collapse;
        }

        .product-info-table td {
            padding: 4px 8px;
            font-size: 11px;
        }

        .product-info-table td:first-child {
            width: 120px;
            font-weight: bold;
        }

        .product-image {
            max-width: 200px;
            max-height: 150px;
            border: 1px solid #ccc;
            object-fit: contain;
        }

        /* BOM Table */
        .bom-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .bom-table th,
        .bom-table td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
            font-size: 11px;
        }

        .bom-table th {
            background-color: #d0e0f0;
            font-weight: bold;
        }

        /* Column widths */
        .col-inc { width: 30px; }
        .col-partname { width: 150px; text-align: left; }
        .col-t { width: 40px; }
        .col-w { width: 50px; }
        .col-l { width: 50px; }
        .col-qty { width: 50px; }
        .col-m2 { width: 80px; }
        .col-material { width: 120px; text-align: left; }
        .col-note { width: 150px; text-align: left; }
        .col-price { width: 100px; text-align: right; }
        .col-total { width: 100px; text-align: right; }

        /* Row types */
        .row-pf {
            background-color: #e8f4ff;
            font-weight: bold;
        }

        .row-sf {
            background-color: white;
        }

        .row-sf .col-partname {
            padding-left: 20px;
        }

        .row-sub {
            background-color: #f9f9f9;
        }

        .row-sub .col-partname {
            padding-left: 30px;
        }

        .row-grandtotal {
            background-color: #ffffcc;
            font-weight: bold;
            font-size: 12px;
        }

        .row-m3 {
            background-color: #fff3cd;
            font-weight: bold;
        }

        .row-biaya {
            background-color: #d4edda;
            font-weight: bold;
        }

        .row-final {
            background-color: #28a745;
            color: white;
            font-weight: bold;
            font-size: 13px;
        }

        /* Footer Section */
        .footer-section {
            margin-top: 30px;
        }

        .footer-location {
            text-align: center;
            margin-bottom: 50px;
            font-size: 12px;
        }

        .signature-section {
            display: flex;
            justify-content: space-around;
            text-align: center;
        }

        .signature-box {
            width: 30%;
        }

        .signature-box h4 {
            font-size: 12px;
            margin-bottom: 60px;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin-top: 10px;
            padding-top: 5px;
            font-size: 11px;
        }

        /* Print styles */
        @media print {
            body {
                padding: 0;
            }

            .print-button {
                display: none;
            }

            .no-print {
                display: none;
            }

            .container {
                max-width: 100%;
            }
        }
    </style>
</head>
<body>
    <button class="print-button no-print" onclick="window.print()">
        🖨️ Print Invoice
    </button>

    <div class="container">
        <!-- Header Section -->
        <div class="header-section">
            <div class="header-left">
                <div class="header-title">
                    <h1>Bill of Material</h1>
                </div>
                <div class="header-subtitle">
                    ({{ $invoice->product_category }})
                </div>
                <div class="header-penawaran">
                    Penawaran
                </div>
                
                <table class="product-info-table">
                    <tr>
                        <td>Product Name</td>
                        <td>: {{ $invoice->product_name }}</td>
                    </tr>
                    <tr>
                        <td>Product Type</td>
                        <td>: {{ $invoice->product_type }}</td>
                    </tr>
                    <tr>
                        <td>Product code</td>
                        <td>: {{ $invoice->product_code }}</td>
                    </tr>
                    <tr>
                        <td>Size</td>
                        <td>: {{ $invoice->size }}</td>
                    </tr>
                    <tr>
                        <td>Date</td>
                        <td>: {{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d F Y') }}</td>
                    </tr>
                    <tr>
                        <td>Order</td>
                        <td>: {{ $invoice->order_qty }} Pcs</td>
                    </tr>
                </table>
            </div>
            <div class="header-right">
                @if($invoice->image_path)
                    <img src="{{ asset($invoice->image_path) }}" alt="Product Image" class="product-image">
                @else
                    <div style="width: 200px; height: 150px; border: 1px solid #ccc; display: flex; align-items: center; justify-content: center; background: #f5f5f5;">
                        <span style="color: #999;">No Image</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- BOM Table -->
        <table class="bom-table">
            <thead>
                <tr>
                    <th class="col-inc">Inc/<br>Number</th>
                    <th class="col-partname">Part Name</th>
                    <th colspan="3">FINISH SIZE</th>
                    <th class="col-qty">QTY<br>ITEM</th>
                    <th class="col-m2">M2</th>
                    <th class="col-material">Material</th>
                    <th class="col-note">Note</th>
                    <th class="col-price">Harga</th>
                    <th class="col-total">Total</th>
                </tr>
                <tr>
                    <th class="col-inc"></th>
                    <th class="col-partname"></th>
                    <th class="col-t">T</th>
                    <th class="col-w">W</th>
                    <th class="col-l">L</th>
                    <th class="col-qty"></th>
                    <th class="col-m2"></th>
                    <th class="col-material"></th>
                    <th class="col-note"></th>
                    <th class="col-price"></th>
                    <th class="col-total"></th>
                </tr>
            </thead>
            <tbody>
                @php
                    $calculationData = json_decode($invoice->calculation_data, true);
                    $rowNumber = 1;
                @endphp

                @if($calculationData)
                    @foreach($calculationData as $key => $component)
                        @if(isset($component['componentTotal']) && $component['componentTotal'] > 0)
                            @php
                                $componentName = $component['componentName'] ?? strtoupper(str_replace('-', ' ', $key));
                                $details = $component['details'] ?? [];
                                $subComponents = $component['subComponents'] ?? [];
                                $componentTotal = $component['componentTotal'];
                            @endphp

                            <!-- Main Component Row (PF) -->
                            <tr class="row-pf">
                                <td class="col-inc">{{ $rowNumber++ }}</td>
                                <td class="col-partname"><strong>{{ $componentName }}</strong></td>
                                <td class="col-t">
                                    @if(isset($details['thicknessTotal']))
                                        {{ $details['thicknessTotal'] }}
                                    @elseif(isset($details['solidThickness']))
                                        {{ $details['solidThickness'] }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="col-w">{{ $details['width'] ?? '-' }}</td>
                                <td class="col-l">{{ $details['length'] ?? '-' }}</td>
                                <td class="col-qty">{{ $details['qty'] ?? 1 }}</td>
                                <td class="col-m2">
                                    @if(isset($details['m2']))
                                        {{ number_format($details['m2'], 4) }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="col-material">
                                    @if(strpos($key, 'panel') !== false)
                                        {{ $invoice->panel_type }}
                                    @elseif(strpos($key, 'frame') !== false)
                                        SL.{{ $invoice->solid_type }}
                                    @elseif(strpos($key, 'drawer') !== false && !in_array($key, ['support-drawer-13', 'cleat-drawer-14']))
                                        {{ $invoice->box_drawer_type }}
                                    @else
                                        Mix
                                    @endif
                                </td>
                                <td class="col-note">
                                    @if(strpos($key, 'panel') !== false && strpos($key, 'back') === false)
                                        TV=F,V.{{ $invoice->veneer_face_type }} + B,V.{{ $invoice->veneer_back_type }}
                                    @elseif(strpos($key, 'back-panel') !== false)
                                        TV=F/B,V.{{ $invoice->veneer_face_type }}
                                    @elseif(strpos($key, 'facedrawer') !== false)
                                        TV=F,V.{{ $invoice->veneer_face_type }} + B,V.{{ $invoice->veneer_back_type }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="col-price">-</td>
                                <td class="col-total">Rp {{ number_format($componentTotal, 0, ',', '.') }}</td>
                            </tr>

                            <!-- Sub Components (SF) -->
                            @foreach($subComponents as $subKey => $subComp)
                                <tr class="row-sub">
                                    <td class="col-inc"></td>
                                    <td class="col-partname">{{ $subComp['name'] ?? $subKey }}</td>
                                    <td class="col-t">
                                        @if(isset($subComp['thickness']))
                                            {{ $subComp['thickness'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-w">
                                        @if(isset($subComp['width']))
                                            {{ $subComp['width'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-l">
                                        @if(isset($subComp['length']))
                                            {{ $subComp['length'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-qty">
                                        @if(isset($subComp['qty']))
                                            {{ $subComp['qty'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-m2">
                                        @if(isset($subComp['m2']))
                                            {{ number_format($subComp['m2'], 4) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-material">
                                        @if(isset($subComp['material']))
                                            {{ $subComp['material'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-note">
                                        @if(isset($subComp['pattern']))
                                            {{ $subComp['pattern'] }}
                                        @elseif(isset($subComp['note']))
                                            {{ $subComp['note'] }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-price">
                                        @if(isset($subComp['price']))
                                            Rp {{ number_format($subComp['price'], 0, ',', '.') }}
                                        @elseif(isset($subComp['pricePerUnit']))
                                            Rp {{ number_format($subComp['pricePerUnit'], 0, ',', '.') }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="col-total">
                                        @if(isset($subComp['total']))
                                            Rp {{ number_format($subComp['total'], 0, ',', '.') }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    @endforeach

                    <!-- Grand Total Components Row -->
                    <tr class="row-grandtotal">
                        <td colspan="10" style="text-align: right; padding-right: 20px;">GRAND TOTAL (Material Components)</td>
                        <td class="col-total">Rp {{ number_format($invoice->grand_total, 0, ',', '.') }}</td>
                    </tr>

                    <!-- ✅ M³ Section -->
                    <tr class="row-m3">
                        <td colspan="10" style="text-align: right; padding-right: 20px;">
                            Total M³
                        </td>
                        <td class="col-total">
                            {{ number_format($invoice->total_m3 ?? 0, 6) }} m³
                        </td>
                    </tr>

                    <tr class="row-m3">
                        <td colspan="10" style="text-align: right; padding-right: 20px;">
                            Harga per M³
                        </td>
                        <td class="col-total">
                            Rp {{ number_format($invoice->harga_per_m3 ?? 6000000, 0, ',', '.') }}
                        </td>
                    </tr>

                    <!-- ✅ Biaya Produksi Row -->
                    <tr class="row-biaya">
                        <td colspan="10" style="text-align: right; padding-right: 20px;">
                            Biaya Produksi (M³)
                        </td>
                        <td class="col-total">
                            Rp {{ number_format($invoice->biaya_produksi ?? 0, 0, ',', '.') }}
                        </td>
                    </tr>

                    <!-- ✅ Final Grand Total Row -->
                    <tr class="row-final">
                        <td colspan="10" style="text-align: right; padding-right: 20px;">
                            FINAL GRAND TOTAL (Components + Biaya Produksi)
                        </td>
                        <td class="col-total">
                            Rp {{ number_format($invoice->final_grand_total ?? $invoice->grand_total, 0, ',', '.') }}
                        </td>
                    </tr>
                @else
                    <tr>
                        <td colspan="11" class="text-center">No calculation data available</td>
                    </tr>
                @endif
            </tbody>
        </table>

        <!-- Footer Section -->
        <div class="footer-section">
            <div class="footer-location">
                Sidoarjo, {{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d F Y') }}
            </div>

            <div class="signature-section">
                <div class="signature-box">
                    <h4>Disetujui</h4>
                    <div class="signature-line">
                        ( _________________ )
                    </div>
                </div>
                <div class="signature-box">
                    <h4>Diperiksa</h4>
                    <div class="signature-line">
                        ( _________________ )
                    </div>
                </div>
                <div class="signature-box">
                    <h4>Dibuat</h4>
                    <div class="signature-line">
                        ( _________________ )
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Invoice Print Page Loaded');
            console.log('Total M³:', '{{ $invoice->total_m3 ?? 0 }}');
            console.log('Harga per M³:', '{{ $invoice->harga_per_m3 ?? 6000000 }}');
            console.log('Biaya Produksi:', '{{ $invoice->biaya_produksi ?? 0 }}');
            console.log('Final Grand Total:', '{{ $invoice->final_grand_total ?? $invoice->grand_total }}');
        });
    </script>
</body>
</html>