@extends('layouts.app')

@section('title', 'Buat Invoice Box - Cost Furniture')

@section('page-title', 'Buat Invoice Box')

@section('content')

<!-- Alert jika tidak ada Invoice BOM -->
@if($invoiceBoms->isEmpty())
<div class="alert alert-warning">
    <i class="fas fa-exclamation-triangle me-2"></i>
    <strong>Tidak ada Invoice BOM yang tersedia!</strong> 
    Pastikan ada Invoice BOM yang sudah di-fix dan belum memiliki data box.
    <a href="{{ route('invoice.bom.index') }}" class="alert-link">Lihat Invoice BOM</a>
</div>
@endif

<div class="card modern-card">
    <div class="card-header">
        <h5><i class="fas fa-box me-2"></i>Form Buat Invoice Box - PACKING PENAWARAN</h5>
    </div>
    <div class="card-body">
        <form id="boxForm">
            @csrf
            
            <!-- Step 1: Pilih Invoice BOM -->
            <div class="section-card mb-4">
                <h6 class="section-title"><i class="fas fa-file-invoice me-2"></i>PILIH INVOICE BOM</h6>
                
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label">Invoice BOM <span class="text-danger">*</span></label>
                        <select name="invoice_bom_id" id="invoice_bom_id" class="form-select" required>
                            <option value="">-- Pilih Invoice BOM --</option>
                            @foreach($invoiceBoms as $bom)
                            <option value="{{ $bom->id }}" 
                                    data-product-name="{{ $bom->product_name }}"
                                    data-product-code="{{ $bom->product_code }}"
                                    data-product-type="{{ $bom->product_type }}"
                                    data-product-category="{{ $bom->product_category }}"
                                    data-size="{{ $bom->size }}"
                                    data-grand-total="{{ $bom->grand_total }}">
                                BOM #{{ $bom->id }} - {{ $bom->product_name }} ({{ $bom->product_code }}) - {{ $bom->size }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <!-- BOM Info Display -->
                <div id="bom-info" style="display: none;" class="mt-3">
                    <div class="info-box">
                        <div class="row">
                            <div class="col-md-3">
                                <strong>Product Name:</strong>
                                <div id="bom-product-name">-</div>
                            </div>
                            <div class="col-md-3">
                                <strong>Product Code:</strong>
                                <div id="bom-product-code">-</div>
                            </div>
                            <div class="col-md-3">
                                <strong>Dimensi (P×L×T):</strong>
                                <div id="bom-size">-</div>
                            </div>
                            <div class="col-md-3">
                                <strong>BOM Grand Total:</strong>
                                <div id="bom-grand-total" class="text-success fw-bold">-</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Dimensi Produk (Auto dari BOM) -->
            <div class="section-card mb-4" id="dimensi-section" style="display: none;">
                <h6 class="section-title"><i class="fas fa-ruler me-2"></i>DIMENSI PRODUK (Auto dari BOM)</h6>
                
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">P (Panjang) - mm</label>
                        <input type="number" class="form-control" id="p_value" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">L (Lebar) - mm</label>
                        <input type="number" class="form-control" id="l_value" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">T (Tinggi) - mm</label>
                        <input type="number" class="form-control" id="t_value" readonly>
                    </div>
                </div>
            </div>
            
            <!-- KOMPONEN BOX (CARD STYLE) + TOMBOL TAMBAH FILLER -->
            <div id="components-section" style="display: none;">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="section-title mb-0"><i class="fas fa-boxes me-2"></i>KOMPONEN BOX (Pilih yang dibutuhkan)</h6>
                    <button type="button" class="btn btn-sm btn-info" onclick="openTambahFillerModal()">
                        <i class="fas fa-plus-circle me-2"></i>Tambah Filler
                    </button>
                </div>
                
                <div class="row" id="box-cards-container">
                    <!-- Cards will be generated here by JavaScript -->
                </div>
            </div>
            <!-- SECTION KOMPONEN PENDUKUNG -->
            <div class="section-card" id="komponen-pendukung-section" style="display: none;">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-boxes me-2"></i>KOMPONEN PENDUKUNG (Optional)
                    </h6>
                    <button type="button" class="btn btn-sm btn-success" onclick="openKomponenPendukungModal()">
                        <i class="fas fa-plus-circle me-2"></i>Tambah Komponen Pendukung
                    </button>
                </div>
                
                <div id="komponen-pendukung-container">
                    <!-- Komponen pendukung items will be added here -->
                </div>
                
                <div id="no-komponen-pendukung-message" class="text-center py-4">
                    <i class="fas fa-info-circle fa-2x text-muted mb-2"></i>
                    <p class="text-muted">Belum ada komponen pendukung. Klik "Tambah Komponen Pendukung" untuk menambahkan.</p>
                </div>
                
                <!-- ============================================ -->
                <!-- ✅ SKID SECTION -->
                <!-- ============================================ -->
                <hr class="my-4">
                <h6 class="section-title"><i class="fas fa-layer-group me-2"></i>SKID PLYWOOD POPLAR (Optional)</h6>
                
                <!-- SKID BOX REGULER -->
                <div id="skid-box-reguler-section" style="display: none;">
                    <div class="biaya-tambahan-card mb-3">
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   id="skid-box-reguler-checkbox" 
                                   onchange="toggleSkidBoxReguler()">
                            <label class="form-check-label fw-bold" for="skid-box-reguler-checkbox">
                                <i class="fas fa-layer-group me-2 text-info"></i>
                                SKID untuk Box Reguler
                            </label>
                        </div>
                        
                        <div id="skid-box-reguler-detail" class="mt-3" style="display: none;">
                            <!-- SKID PJG -->
                            <div class="row align-items-center mb-3">
                                <div class="col-md-2">
                                    <strong>SKID PJG:</strong>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">PJG:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-pjg-pjg" 
                                           readonly>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">LBR:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="120" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">TBL:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="12" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">M²:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-pjg-m2" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">Qty:</label>
                                    <input type="number" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-pjg-qty" 
                                           value="2" 
                                           min="1"
                                           oninput="calculateSkidBoxRegulerPjg()">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small mb-1">Total:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control fw-bold text-success" 
                                               id="skid-reguler-pjg-total" 
                                               readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- SKID LBR -->
                            <div class="row align-items-center">
                                <div class="col-md-2">
                                    <strong>SKID LBR:</strong>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">PJG:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-lbr-pjg" 
                                           readonly>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">LBR:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="120" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">TBL:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="12" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">M²:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-lbr-m2" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">Qty:</label>
                                    <input type="number" 
                                           class="form-control form-control-sm" 
                                           id="skid-reguler-lbr-qty" 
                                           value="6" 
                                           min="1"
                                           oninput="calculateSkidBoxRegulerLbr()">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small mb-1">Total:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control fw-bold text-success" 
                                               id="skid-reguler-lbr-total" 
                                               readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- SKID BOX TUMBU -->
                <div id="skid-box-tumbu-section" style="display: none;">
                    <div class="biaya-tambahan-card mb-3">
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   id="skid-box-tumbu-checkbox" 
                                   onchange="toggleSkidBoxTumbu()">
                            <label class="form-check-label fw-bold" for="skid-box-tumbu-checkbox">
                                <i class="fas fa-layer-group me-2 text-primary"></i>
                                SKID untuk Box Tumbu
                            </label>
                        </div>
                        
                        <div id="skid-box-tumbu-detail" class="mt-3" style="display: none;">
                            <!-- SKID PJG -->
                            <div class="row align-items-center mb-3">
                                <div class="col-md-2">
                                    <strong>SKID PJG:</strong>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">PJG:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-pjg-pjg" 
                                           readonly>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">LBR:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-pjg-lbr" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">TBL:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="2.4" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">M²:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-pjg-m2" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">Qty:</label>
                                    <input type="number" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-pjg-qty" 
                                           value="2" 
                                           min="1"
                                           oninput="calculateSkidBoxTumbuPjg()">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small mb-1">Total:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control fw-bold text-success" 
                                               id="skid-tumbu-pjg-total" 
                                               readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- SKID LBR -->
                            <div class="row align-items-center">
                                <div class="col-md-2">
                                    <strong>SKID LBR:</strong>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">PJG:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-lbr-pjg" 
                                           readonly>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label small mb-1">LBR:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-lbr-lbr" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">TBL:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           value="2.4" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">M²:</label>
                                    <input type="text" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-lbr-m2" 
                                           readonly>
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label small mb-1">Qty:</label>
                                    <input type="number" 
                                           class="form-control form-control-sm" 
                                           id="skid-tumbu-lbr-qty" 
                                           value="2" 
                                           min="1"
                                           oninput="calculateSkidBoxTumbuLbr()">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label small mb-1">Total:</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-text">Rp</span>
                                        <input type="text" 
                                               class="form-control fw-bold text-success" 
                                               id="skid-tumbu-lbr-total" 
                                               readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- ============================================ -->
                <!-- ✅ PENUNJANG AUTO-ENABLED (NO CHECKBOX) -->
                <!-- ============================================ -->
                <hr class="my-4">
                <h6 class="section-title"><i class="fas fa-plus-square me-2"></i>TAMBAHAN BIAYA PACKING</h6>
                <!-- ✅ PENUNJANG AUTO-ENABLED (NEW) -->
                <div class="biaya-tambahan-card mb-3" id="penunjang-section" style="display: none;">
                    <div class="alert alert-success mb-0">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-grow-1">
                                <h6 class="mb-0">
                                    <i class="fas fa-check-circle me-2"></i>
                                    <strong>Penunjang Otomatis</strong>
                                </h6>
                                <small class="text-muted">Penunjang otomatis ditambahkan berdasarkan Product Category</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-success" style="font-size: 14px;">
                                    <i class="fas fa-star me-1"></i>AUTO-ENABLED
                                </span>
                            </div>
                        </div>
                        
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <label class="form-label small mb-1">Product Category:</label>
                                <input type="text" 
                                       class="form-control form-control-sm bg-light" 
                                       id="penunjang-category" 
                                       readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small mb-1">Harga:</label>
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" 
                                           class="form-control bg-light" 
                                           id="penunjang-harga-display" 
                                           readonly>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small mb-1">Qty:</label>
                                <input type="number" 
                                       class="form-control form-control-sm" 
                                       id="penunjang-qty" 
                                       value="1" 
                                       min="1"
                                       oninput="calculatePenunjangTotal()">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label small mb-1">Total:</label>
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" 
                                           class="form-control fw-bold text-success" 
                                           id="penunjang-total-display" 
                                           readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- PALLET (WITH CHECKBOX) -->
                <div class="biaya-tambahan-card">
                    <div class="form-check">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="pallet-checkbox" 
                               onchange="togglePallet()">
                        <label class="form-check-label fw-bold" for="pallet-checkbox">
                            <i class="fas fa-pallet me-2 text-primary"></i>
                            Pallet
                        </label>
                    </div>
                    
                    <div id="pallet-detail" class="mt-3" style="display: none;">
                        <div class="row align-items-center">
                            <div class="col-md-3 offset-md-3">
                                <label class="form-label small mb-1">Harga:</label>
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" 
                                           class="form-control" 
                                           id="pallet-harga-display" 
                                           value="150.000" 
                                           readonly>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small mb-1">Qty:</label>
                                <input type="number" 
                                       class="form-control form-control-sm" 
                                       id="pallet-qty" 
                                       value="1" 
                                       min="1"
                                       oninput="calculatePalletTotal()">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label small mb-1">Total:</label>
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" 
                                           class="form-control fw-bold text-success" 
                                           id="pallet-total-display" 
                                           readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Grand Total -->
            <div class="section-card bg-gradient">
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <h5 class="mb-0"><i class="fas fa-calculator me-2"></i>GRAND TOTAL BOX</h5>
                        <small class="text-white">Komponen Box</small>
                    </div>
                    <div class="col-md-4 text-center">
                        <h5 class="mb-0 text-white">KOMPONEN PENDUKUNG</h5>
                        <h4 class="mb-0 text-white" id="komponen-pendukung-total-display">Rp 0</h4>
                    </div>
                    <div class="col-md-4 text-end">
                        <h5 class="mb-0 text-white">GRAND TOTAL</h5>
                        <h3 class="mb-0 text-white" id="grand-total-display">Rp 0</h3>
                        <input type="hidden" name="grand_total" id="grand_total" value="0">
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="d-flex gap-2 justify-content-end mt-4">
                <button type="button" class="btn btn-warning" onclick="saveDraft()">
                    <i class="fas fa-save me-2"></i>Simpan Draft
                </button>
                <a href="{{ route('invoice.box.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Batal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-check me-2"></i>Simpan Invoice Box
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay" style="display: none;">
    <div class="spinner-border text-light" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
    <p class="text-light mt-3">Menyimpan invoice box...</p>
</div>

<!-- Modal Edit Komponen Box -->
<div class="modal fade" id="editComponentModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="fas fa-edit me-2"></i>Edit <span id="modal-component-name"></span></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="modal-component-id">
                
                <div id="modal-component-content">
                    <!-- Content will be loaded dynamically -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" onclick="saveComponentFromModal()">
                    <i class="fas fa-save me-2"></i>Simpan
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Filler -->
<div class="modal fade" id="tambahFillerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title"><i class="fas fa-plus-circle me-2"></i>Tambah Filler</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">Pilih jenis Filler yang ingin ditambahkan:</p>
                
                <div class="d-grid gap-3">
                    <button type="button" class="btn btn-lg btn-outline-primary" onclick="addFillerBox()">
                        <i class="fas fa-box fa-2x mb-2 d-block"></i>
                        <strong>FILLER BOX</strong>
                        <small class="d-block text-muted">Otomatis membuat Layer Honeycomb 1 & 2</small>
                    </button>
                    
                    <button type="button" class="btn btn-lg btn-outline-success" onclick="addFillerSegitiga()">
                        <i class="fas fa-shapes fa-2x mb-2 d-block"></i>
                        <strong>FILLER SEGITIGA</strong>
                        <small class="d-block text-muted">Independent, tidak ada Layer Honeycomb</small>
                    </button>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Komponen Pendukung -->
<div class="modal fade" id="komponenPendukungModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="fas fa-plus-circle me-2"></i>Tambah Komponen Pendukung</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="komponen-pendukung-edit-index">
                
                <!-- TOGGLE MODE: Pilihan vs Manual -->
                <div class="mb-4">
                    <label class="form-label fw-bold">Mode Input <span class="text-danger">*</span></label>
                    <div class="btn-group w-100" role="group">
                        <input type="radio" 
                               class="btn-check" 
                               name="komponen_input_mode" 
                               id="komponen_mode_pilihan" 
                               value="pilihan" 
                               checked
                               onchange="toggleKomponenInputMode()">
                        <label class="btn btn-outline-primary" for="komponen_mode_pilihan">
                            <i class="fas fa-list me-2"></i>Pilih dari Data Master
                        </label>
                        
                        <input type="radio" 
                               class="btn-check" 
                               name="komponen_input_mode" 
                               id="komponen_mode_manual" 
                               value="manual"
                               onchange="toggleKomponenInputMode()">
                        <label class="btn btn-outline-warning" for="komponen_mode_manual">
                            <i class="fas fa-keyboard me-2"></i>Input Manual
                        </label>
                    </div>
                </div>
                
                <hr>
                
                <!-- MODE PILIHAN: Search Product Pendukung Box -->
                <div id="komponen-mode-pilihan-section">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Mode Pilihan:</strong> Pilih product dari data master. Harga/M² dan Harga Finished akan otomatis terisi dan tidak bisa diubah.
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Pilih Product Pendukung Box <span class="text-danger">*</span></label>
                        <select class="form-select" id="komponen-pendukung-product-select" onchange="selectProductPendukung()">
                            <option value="">-- Pilih Product --</option>
                            @foreach($products as $product)
                            <option value="{{ $product->id }}" 
                                    data-material-code="{{ $product->material_code }}"
                                    data-description="{{ $product->description }}"
                                    data-pricing-type="{{ $product->pricing_type }}"
                                    data-harga-asli="{{ $product->harga_asli }}"
                                    data-lebar="{{ $product->lebar }}"
                                    data-panjang="{{ $product->panjang }}"
                                    data-m2="{{ $product->m2 }}"
                                    data-harga-m2="{{ $product->harga_m2 }}"
                                    data-harga-finished="{{ $product->harga_finished }}">
                                {{ $product->material_code }} - {{ $product->description }} 
                                @if($product->pricing_type === 'pcs')
                                    (PCS: {{ \App\Helpers\CasegoodHelper::formatRupiah($product->harga_finished) }})
                                @else
                                    (M2: {{ \App\Helpers\CasegoodHelper::formatRupiah($product->harga_finished) }})
                                @endif
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <!-- MODE MANUAL: Input Manual -->
                <div id="komponen-mode-manual-section" style="display: none;">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Mode Manual:</strong> Input data komponen baru yang tidak ada di data master. Data ini hanya untuk invoice ini saja.
                    </div>
                </div>
                
                <hr>
                
                <!-- Common Fields (Kode & Nama) -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Kode Barang <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control" 
                               id="komponen-pendukung-kode" 
                               placeholder="VSRFOM00007" 
                               required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Nama <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control" 
                               id="komponen-pendukung-nama" 
                               placeholder="STF BLOCK D17 KW1..." 
                               required>
                    </div>
                </div>
                
                <!-- Pricing Type Selection -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">Tipe Harga <span class="text-danger">*</span></label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" 
                                   class="btn-check" 
                                   name="komponen_pricing_type" 
                                   id="komponen_pricing_type_pcs" 
                                   value="pcs" 
                                   checked
                                   onchange="toggleKomponenPricingFields()">
                            <label class="btn btn-outline-success" for="komponen_pricing_type_pcs">
                                <i class="fas fa-box me-2"></i>Harga PCS
                            </label>
                            
                            <input type="radio" 
                                   class="btn-check" 
                                   name="komponen_pricing_type" 
                                   id="komponen_pricing_type_m2" 
                                   value="m2"
                                   onchange="toggleKomponenPricingFields()">
                            <label class="btn btn-outline-info" for="komponen_pricing_type_m2">
                                <i class="fas fa-ruler-combined me-2"></i>Harga M2
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Harga Asli (untuk calculate) -->
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">
                            Harga Asli <span class="text-danger">*</span>
                            <small class="text-muted">(Digunakan untuk kalkulasi Harga Finished)</small>
                        </label>
                        <input type="number" 
                               class="form-control" 
                               id="komponen-pendukung-harga-asli" 
                               placeholder="3712" 
                               step="0.01"
                               oninput="calculateKomponenPendukung()"
                               required>
                    </div>
                </div>
                
                <!-- Dimensi (PJG, LBR, TGI, M2) - CONDITIONAL -->
                <div class="row mb-3" id="komponen-dimensi-row">
                    <div class="col-md-3">
                        <label class="form-label">
                            PJG (mm)
                            <span class="text-danger" id="komponen-pjg-required" style="display: none;">*</span>
                            <small class="text-muted" id="komponen-pjg-optional">(Optional)</small>
                        </label>
                        <input type="number" 
                               class="form-control" 
                               id="komponen-pendukung-pjg" 
                               placeholder="120" 
                               oninput="calculateKomponenPendukung()">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">
                            LBR (mm)
                            <span class="text-danger" id="komponen-lbr-required" style="display: none;">*</span>
                            <small class="text-muted" id="komponen-lbr-optional">(Optional)</small>
                        </label>
                        <input type="number" 
                               class="form-control" 
                               id="komponen-pendukung-lbr" 
                               placeholder="120" 
                               oninput="calculateKomponenPendukung()">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">
                            TGI (mm) 
                            <small class="text-muted" id="komponen-tgi-label">(Auto dari Product)</small>
                        </label>
                        <input type="number" 
                               class="form-control" 
                               id="komponen-pendukung-tgi" 
                               placeholder="20"
                               readonly>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">M² (Auto)</label>
                        <input type="text" class="form-control" id="komponen-pendukung-m2" readonly placeholder="0.0000">
                    </div>
                </div>
                
                <!-- Harga M2 (only for M2 pricing type) -->
                <div class="row mb-3" id="komponen-harga-m2-field" style="display: none;">
                    <div class="col-md-12">
                        <label class="form-label">
                            Harga / M² (Auto)
                            <small class="text-muted" id="komponen-harga-m2-info">(Paten dari Master)</small>
                        </label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" 
                                   class="form-control" 
                                   id="komponen-pendukung-harga-m2-display" 
                                   readonly 
                                   placeholder="0">
                        </div>
                    </div>
                </div>
                
                <!-- Qty & Harga Finished -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Qty <span class="text-danger">*</span></label>
                        <input type="number" 
                               class="form-control" 
                               id="komponen-pendukung-qty" 
                               value="1" 
                               min="1" 
                               oninput="calculateKomponenPendukungTotal()" 
                               required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">
                            Harga Finished (Auto)
                            <small class="text-muted" id="komponen-harga-finished-info">(Paten dari Master)</small>
                        </label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" 
                                   class="form-control fw-bold text-success" 
                                   id="komponen-pendukung-harga-finished-display" 
                                   readonly 
                                   placeholder="0">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Total (Auto)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="text" 
                                   class="form-control fw-bold text-success" 
                                   id="komponen-pendukung-total" 
                                   readonly 
                                   placeholder="0">
                        </div>
                    </div>
                </div>
                
                <!-- Hidden field to store mode and master data -->
                <input type="hidden" id="komponen-pendukung-mode" value="pilihan">
                <input type="hidden" id="komponen-pendukung-harga-m2-master" value="0">
                <input type="hidden" id="komponen-pendukung-harga-finished-master" value="0">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-success" onclick="saveKomponenPendukung()">
                    <i class="fas fa-save me-2"></i>Simpan
                </button>
            </div>
        </div>
    </div>
</div>
<style>
/* Modern Card */
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: white;
}

.modern-card .card-body {
    padding: 30px;
}

/* Section Card */
.section-card {
    background: #fff;
    border: 2px solid #f0f0f0;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 25px;
}

.section-title {
    font-weight: 700;
    color: #f39c12;
    font-size: 16px;
    margin-bottom: 20px;
}

/* Info Box */
.info-box {
    background: linear-gradient(135deg, rgba(243, 156, 18, 0.1) 0%, rgba(230, 126, 34, 0.1) 100%);
    border: 2px solid rgba(243, 156, 18, 0.2);
    border-radius: 10px;
    padding: 20px;
}

.info-box strong {
    color: #666;
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-box div:not(strong) {
    color: #2c3e50;
    font-size: 16px;
    font-weight: 600;
    margin-top: 5px;
}

/* Box Component Card */
.box-component-card {
    background: #fff;
    border: 3px solid #e9ecef;
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    min-height: 200px;
}

.box-component-card:hover {
    border-color: #f39c12;
    box-shadow: 0 5px 15px rgba(243, 156, 18, 0.2);
    transform: translateY(-3px);
}

.box-component-card.active {
    border-color: #28a745;
    background: linear-gradient(135deg, rgba(40, 167, 69, 0.05) 0%, rgba(32, 201, 151, 0.05) 100%);
}

.box-component-card.active .card-badge {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
}
/* ✅ Cancel Button Styling */
.box-component-card .btn-danger {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    border: none;
    font-size: 11px;
    padding: 5px 10px;
    box-shadow: 0 2px 5px rgba(220, 53, 69, 0.3);
    transition: all 0.3s ease;
}

.box-component-card .btn-danger:hover {
    background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
    transform: scale(1.05);
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.5);
}

.box-component-card .btn-danger:active {
    transform: scale(0.95);
}

/* Layer Honeycomb Auto-Generated */
.box-component-card.layer-auto {
    border-color: #17a2b8 !important;
    background: linear-gradient(135deg, rgba(23, 162, 184, 0.05) 0%, rgba(19, 132, 150, 0.05) 100%);
}

/* Layer Honeycomb Disabled */
.box-component-card.layer-disabled {
    opacity: 0.5;
    border-color: #6c757d !important;
    background: linear-gradient(135deg, rgba(108, 117, 125, 0.05) 0%, rgba(90, 98, 104, 0.05) 100%);
}

.box-component-card.layer-disabled .card-icon {
    color: #6c757d;
}

.box-component-card.layer-disabled .card-total {
    color: #6c757d !important;
}

.box-component-card.layer-auto .card-badge {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
}

/* ✅ NEW: DISABLED CARD (Cannot be clicked or activated) */
.box-component-card.disabled-card {
    opacity: 0.4;
    pointer-events: none;
    cursor: not-allowed !important;
    border-color: #dc3545 !important;
    background: linear-gradient(135deg, rgba(220, 53, 69, 0.05) 0%, rgba(200, 35, 51, 0.05) 100%);
    position: relative;
}

.box-component-card.disabled-card::before {
    content: "DISABLED";
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) rotate(-15deg);
    font-size: 32px;
    font-weight: 900;
    color: rgba(220, 53, 69, 0.3);
    letter-spacing: 4px;
    z-index: 1;
    pointer-events: none;
}

.box-component-card.disabled-card .card-icon {
    color: #dc3545;
}

.box-component-card.disabled-card .card-badge {
    background: #dc3545 !important;
}

.box-component-card.disabled-card:hover {
    transform: none;
    box-shadow: none;
    border-color: #dc3545 !important;
}

.card-badge {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #6c757d;
    color: white;
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
}

.card-icon {
    font-size: 40px;
    color: #f39c12;
    margin-bottom: 15px;
}

.box-component-card.active .card-icon {
    color: #28a745;
}

.box-component-card.layer-auto .card-icon {
    color: #17a2b8;
}

/* Biaya Tambahan Card */
.biaya-tambahan-card {
    background: #fff;
    border: 2px solid #e9ecef;
    border-left: 4px solid #17a2b8;
    border-radius: 8px;
    padding: 15px;
    transition: all 0.3s ease;
}

.biaya-tambahan-card:hover {
    box-shadow: 0 2px 8px rgba(23, 162, 184, 0.2);
}

.biaya-tambahan-card .form-check-input {
    width: 1.5rem;
    height: 1.5rem;
    margin-top: 0;
    cursor: pointer;
}

.biaya-tambahan-card .form-check-label {
    font-size: 16px;
    margin-left: 10px;
    cursor: pointer;
}

.biaya-tambahan-card .form-check-input:checked ~ .form-check-label {
    color: #28a745;
}

.card-title {
    font-size: 16px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 10px;
}

.card-formula {
    font-size: 11px;
    color: #6c757d;
    background: #f8f9fa;
    padding: 8px;
    border-radius: 6px;
    margin-bottom: 10px;
}

.card-total {
    font-size: 18px;
    font-weight: 700;
    color: #28a745;
    margin-top: 10px;
}

/* Komponen Pendukung Card */
.komponen-pendukung-card {
    background: #fff;
    border: 2px solid #28a745;
    border-left: 4px solid #28a745;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 10px;
    transition: all 0.2s ease;
}

.komponen-pendukung-card:hover {
    box-shadow: 0 2px 8px rgba(40, 167, 69, 0.2);
    transform: translateY(-1px);
}

.komponen-kode {
    font-size: 11px;
    color: #666;
    font-weight: 600;
    background: #d4edda;
    padding: 2px 6px;
    border-radius: 3px;
    display: inline-block;
    margin-bottom: 5px;
}

.komponen-nama {
    font-size: 13px;
    color: #2c3e50;
    font-weight: 500;
    margin-bottom: 8px;
}

.komponen-dimensi {
    font-size: 11px;
    color: #6c757d;
    background: #f8f9fa;
    padding: 4px 8px;
    border-radius: 4px;
    display: inline-block;
}

/* Grand Total */
.bg-gradient {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
}

/* Form Controls */
.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #f39c12;
    box-shadow: 0 0 0 0.2rem rgba(243, 156, 18, 0.1);
    outline: none;
}

.form-control:read-only {
    background-color: #f8f9fa;
}

/* Buttons */
.btn {
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.btn-primary {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    border: none;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #e67e22 0%, #f39c12 100%);
}

/* Loading Overlay */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

/* Alert */
.alert {
    border-radius: 10px;
    border: none;
    margin-bottom: 20px;
}

.alert-warning {
    background: linear-gradient(135deg, rgba(241, 196, 15, 0.1) 0%, rgba(243, 156, 18, 0.1) 100%);
    border-left: 4px solid #f39c12;
    color: #d68910;
}

.modal-header.bg-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
}
</style>
<script>
// ============================================
// GLOBAL VARIABLES - UPDATED FOR SKID & DISABLE
// ============================================

let componentsData = {};
let komponenPendukungItems = [];
let P = 0, L = 0, T = 0;

// Box Reguler dimensions (for dependencies)
let boxRegulerPjg = 0;
let boxRegulerLbr = 0;
let boxRegulerTgi = 0;

// Box Tumbu dimensions (for dependencies)
let boxTumbuPjg = 0;
let boxTumbuLbr = 0;
let boxTumbuTgi = 0;

// MULTIPLE FILLER BOX - Store all filler box instances
let fillerBoxInstances = {};
let fillerBoxCounter = 0;

// MULTIPLE FILLER SEGITIGA
let fillerSegitigaCounter = 0;

// Draft key for localStorage
const DRAFT_KEY = 'invoice_box_draft';

// ============================================
// ✅ SKID DATA
// ============================================

// SKID Box Reguler State
let skidBoxRegulerData = {
    enabled: false,
    pjg: {
        pjg_dimensi: 0,
        lbr_dimensi: 120,
        tbl_dimensi: 12,
        m2: 0,
        qty: 2,
        harga: 125000,
        total: 0
    },
    lbr: {
        pjg_dimensi: 0,
        lbr_dimensi: 120,
        tbl_dimensi: 12,
        m2: 0,
        qty: 6,
        harga: 125000,
        total: 0
    },
    total: 0
};

// SKID Box Tumbu State
let skidBoxTumbuData = {
    enabled: false,
    pjg: {
        pjg_dimensi: 0,
        lbr_dimensi: 0,
        tbl_dimensi: 2.4,
        m2: 0,
        qty: 2,
        harga: 75000,
        total: 0
    },
    lbr: {
        pjg_dimensi: 0,
        lbr_dimensi: 0,
        tbl_dimensi: 2.4,
        m2: 0,
        qty: 2,
        harga: 75000,
        total: 0
    },
    total: 0
};

// ============================================
// PENUNJANG & PALLET DATA
// ============================================

const PENUNJANG_PRICES = {
    'Casegoods': 20000,
    'Occasional Table': 20000,
    'Dining Table': 20000,
    'Bed': 20000,
    'Chair': 20000
};

// Harga Pallet (fixed)
const PALLET_PRICE = 150000;

// ✅ Penunjang AUTO-ENABLED (no checkbox)
let penunjangData = {
    enabled: false,
    category: '',
    harga: 0,
    qty: 1,
    total: 0
};

let palletData = {
    enabled: false,
    harga: PALLET_PRICE,
    qty: 1,
    total: 0
};

// ============================================
// BOX COMPONENT DEFINITIONS
// ============================================

const boxComponents = [
    {
        id: 'box-reguler',
        name: 'BOX REGULER',
        icon: '📦',
        formula: 'PJG = P + 122 | LBR = L + 122 | TGI = T + 146',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'box-tumbu',
        name: 'BOX TUMBU',
        icon: '📦',
        formula: 'PJG = P + 90 | LBR = L + 90 | TGI = T + 90',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'box-tutup',
        name: 'BOX TUTUP',
        icon: '📦',
        formula: 'Dari BOX TUMBU + 20',
        defaultPrice: 15100,
        type: 'auto',
        allowMultiple: false
    },
    {
        id: 'filler-box',
        name: 'FILLER BOX',
        icon: '📦',
        formula: 'Manual Input (PJG, LBR, TGI)',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: true,
        hidden: false
    },
    {
        id: 'layer-honeycomb-1',
        name: 'LAYER HONEYCOMB 1',
        icon: '🔷',
        formula: 'Auto dari Filler Box | TGI = 6',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false,
        hidden: false
    },
    {
        id: 'layer-honeycomb-2',
        name: 'LAYER HONEYCOMB 2',
        icon: '🔷',
        formula: 'Auto dari Filler Box | TGI = 6',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false,
        hidden: false
    },
    {
        id: 'filler-segitiga',
        name: 'FILLER SEGITIGA',
        icon: '🔺',
        formula: 'Manual PJG & LBR | TGI = 6',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: true,
        hidden: false
    },
    {
        id: 'support-box',
        name: 'SUPPORT BOX',
        icon: '⬜',
        formula: 'Dari Box Reguler | TGI = 50',
        defaultPrice: 10600,
        type: 'dependent',
        allowMultiple: false
    },
    {
        id: 'top-pad',
        name: 'TOP PAD',
        icon: '⬛',
        formula: 'Manual Input (PJG, LBR, TGI)',
        defaultPrice: 10600,
        type: 'manual',
        allowMultiple: false
    }
];

// ============================================
// PAGE LOAD - CHECK FOR DRAFT
// ============================================

document.addEventListener('DOMContentLoaded', function() {
    console.log('Invoice Box Create Page Loaded');
    
    checkForDraft();
    
    window.addEventListener('beforeunload', function(e) {
        const invoiceBomId = document.getElementById('invoice_bom_id').value;
        
        if (invoiceBomId && (Object.keys(componentsData).length > 0 || komponenPendukungItems.length > 0)) {
            e.preventDefault();
            e.returnValue = '';
            return '';
        }
    });
});

// ============================================
// CHECK FOR DRAFT
// ============================================

function checkForDraft() {
    const draft = localStorage.getItem(DRAFT_KEY);
    
    if (draft) {
        const draftData = JSON.parse(draft);
        
        if (confirm('⚠️ Ditemukan Draft Invoice Box yang belum selesai!\n\nApakah Anda ingin melanjutkan draft tersebut?')) {
            loadDraft(draftData);
        } else {
            localStorage.removeItem(DRAFT_KEY);
        }
    }
}

// ============================================
// LOAD DRAFT - UPDATED WITH SKID
// ============================================

function loadDraft(draftData) {
    console.log('Loading draft:', draftData);
    
    if (draftData.invoice_bom_id) {
        document.getElementById('invoice_bom_id').value = draftData.invoice_bom_id;
        
        const event = new Event('change');
        document.getElementById('invoice_bom_id').dispatchEvent(event);
        
        setTimeout(() => {
            if (draftData.componentsData) {
                componentsData = draftData.componentsData;
                
                Object.entries(componentsData).forEach(([key, comp]) => {
                    if (comp.jenis_box === 'BOX REGULER') {
                        boxRegulerPjg = comp.dimensi_box.pjg;
                        boxRegulerLbr = comp.dimensi_box.lbr;
                        boxRegulerTgi = comp.dimensi_box.tgi;
                    } else if (comp.jenis_box === 'BOX TUMBU') {
                        boxTumbuPjg = comp.dimensi_box.pjg;
                        boxTumbuLbr = comp.dimensi_box.lbr;
                        boxTumbuTgi = comp.dimensi_box.tgi;
                    } else if (comp.jenis_box && comp.jenis_box.startsWith('FILLER BOX')) {
                        fillerBoxInstances[key] = {
                            pjg: comp.dimensi_box.pjg,
                            lbr: comp.dimensi_box.lbr,
                            tgi: comp.dimensi_box.tgi
                        };
                    }
                });
                
                fillerBoxCounter = Object.keys(componentsData).filter(k => k.startsWith('filler-box-')).length;
                fillerSegitigaCounter = Object.keys(componentsData).filter(k => k.startsWith('filler-segitiga-')).length;
                
                renderBoxCards();
            }
            
            if (draftData.komponenPendukung) {
                komponenPendukungItems = draftData.komponenPendukung.map(item => {
                    return {
                        material_code: item.material_code,
                        nama: item.nama,
                        pricing_type: item.pricing_type || 'pcs',
                        harga_asli: item.harga_asli || item.harga || 0,
                        pjg: item.pjg || 0,
                        lbr: item.lbr || 0,
                        tgi: item.tgi || 0,
                        m2: item.m2 || 0,
                        qty: item.qty,
                        harga_finished: item.harga_finished || item.harga || 0,
                        total: item.total,
                        from_master: item.from_master || false
                    };
                });
                
                renderKomponenPendukung();
            }
            
            // ✅ RESTORE SKID DATA
            if (draftData.skidBoxReguler) {
                skidBoxRegulerData = draftData.skidBoxReguler;
                
                if (skidBoxRegulerData.enabled) {
                    document.getElementById('skid-box-reguler-checkbox').checked = true;
                    document.getElementById('skid-reguler-pjg-qty').value = skidBoxRegulerData.pjg.qty;
                    document.getElementById('skid-reguler-lbr-qty').value = skidBoxRegulerData.lbr.qty;
                    toggleSkidBoxReguler();
                }
            }
            
            if (draftData.skidBoxTumbu) {
                skidBoxTumbuData = draftData.skidBoxTumbu;
                
                if (skidBoxTumbuData.enabled) {
                    document.getElementById('skid-box-tumbu-checkbox').checked = true;
                    document.getElementById('skid-tumbu-pjg-qty').value = skidBoxTumbuData.pjg.qty;
                    document.getElementById('skid-tumbu-lbr-qty').value = skidBoxTumbuData.lbr.qty;
                    toggleSkidBoxTumbu();
                }
            }
            
            // ✅ RESTORE PENUNJANG (AUTO-ENABLED)
            if (draftData.penunjang) {
                penunjangData = draftData.penunjang;
                
                if (penunjangData.enabled) {
                    document.getElementById('penunjang-qty').value = penunjangData.qty;
                    calculatePenunjangTotal();
                }
            }
            
            if (draftData.pallet) {
                palletData = draftData.pallet;
                
                if (palletData.enabled) {
                    document.getElementById('pallet-checkbox').checked = true;
                    document.getElementById('pallet-qty').value = palletData.qty;
                    togglePallet();
                }
            }
            
            updateGrandTotal();
            
            alert('✅ Draft berhasil dimuat!');
        }, 500);
    }
}

// ============================================
// SAVE DRAFT - UPDATED WITH SKID
// ============================================

function saveDraft() {
    const invoiceBomId = document.getElementById('invoice_bom_id').value;
    
    if (!invoiceBomId) {
        alert('❌ Pilih Invoice BOM terlebih dahulu!');
        return;
    }
    
    const draftData = {
        invoice_bom_id: invoiceBomId,
        componentsData: componentsData,
        komponenPendukung: komponenPendukungItems,
        fillerBoxCounter: fillerBoxCounter,
        fillerSegitigaCounter: fillerSegitigaCounter,
        skidBoxReguler: skidBoxRegulerData,
        skidBoxTumbu: skidBoxTumbuData,
        penunjang: penunjangData,
        pallet: palletData,
        timestamp: new Date().toISOString()
    };
    
    localStorage.setItem(DRAFT_KEY, JSON.stringify(draftData));
    
    alert('✅ Draft berhasil disimpan!');
    console.log('Draft saved:', draftData);
}

// ============================================
// FORMAT RUPIAH
// ============================================

function formatRupiah(amount) {
    return 'Rp ' + Math.round(amount).toLocaleString('id-ID');
}

// ============================================
// INVOICE BOM SELECTION
// ============================================

document.getElementById('invoice_bom_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    
    if (this.value) {
        const size = selectedOption.dataset.size;
        
        document.getElementById('bom-product-name').textContent = selectedOption.dataset.productName;
        document.getElementById('bom-product-code').textContent = selectedOption.dataset.productCode;
        document.getElementById('bom-size').textContent = size;
        document.getElementById('bom-grand-total').textContent = formatRupiah(parseFloat(selectedOption.dataset.grandTotal));
        document.getElementById('bom-info').style.display = 'block';
        
        const dimensions = size.replace(/mm/g, '').replace(/ /g, '').split('x');
        P = parseInt(dimensions[0]) || 0;
        L = parseInt(dimensions[1]) || 0;
        T = parseInt(dimensions[2]) || 0;
        
        document.getElementById('p_value').value = P;
        document.getElementById('l_value').value = L;
        document.getElementById('t_value').value = T;
        document.getElementById('dimensi-section').style.display = 'block';
        
        document.getElementById('components-section').style.display = 'block';
        document.getElementById('komponen-pendukung-section').style.display = 'block';
        
        renderBoxCards();
        
        // ✅ Initialize Penunjang (AUTO-ENABLED)
        initializePenunjangPallet();
        
        console.log('Dimensi:', { P, L, T });
    } else {
        document.getElementById('bom-info').style.display = 'none';
        document.getElementById('dimensi-section').style.display = 'none';
        document.getElementById('components-section').style.display = 'none';
        document.getElementById('komponen-pendukung-section').style.display = 'none';
    }
});
// ============================================
// ✅ SKID BOX REGULER FUNCTIONS
// ============================================

function toggleSkidBoxReguler() {
    const checkbox = document.getElementById('skid-box-reguler-checkbox');
    const detail = document.getElementById('skid-box-reguler-detail');
    
    skidBoxRegulerData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        if (boxRegulerPjg === 0 || boxRegulerLbr === 0) {
            alert('⚠️ Aktifkan dan hitung Box Reguler terlebih dahulu!');
            checkbox.checked = false;
            skidBoxRegulerData.enabled = false;
            return;
        }
        
        detail.style.display = 'block';
        calculateSkidBoxRegulerPjg();
        calculateSkidBoxRegulerLbr();
    } else {
        detail.style.display = 'none';
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        updateGrandTotal();
    }
    
    console.log('✅ SKID Box Reguler toggled:', skidBoxRegulerData.enabled);
}

function calculateSkidBoxRegulerPjg() {
    if (boxRegulerPjg === 0) return;
    
    // PJG = (Dimensi PJG Box Reguler) - 10
    const pjg = boxRegulerPjg - 10;
    const lbr = 120;
    const tbl = 12;
    const m2 = (pjg * lbr) / 1000000;
    const qty = parseFloat(document.getElementById('skid-reguler-pjg-qty').value) || 2;
    const harga = 125000;
    const total = qty * harga * m2;
    
    // Update state
    skidBoxRegulerData.pjg = {
        pjg_dimensi: pjg,
        lbr_dimensi: lbr,
        tbl_dimensi: tbl,
        m2: m2,
        qty: qty,
        harga: harga,
        total: total
    };
    
    // Update display
    document.getElementById('skid-reguler-pjg-pjg').value = pjg;
    document.getElementById('skid-reguler-pjg-m2').value = m2.toFixed(6);
    document.getElementById('skid-reguler-pjg-total').value = Math.round(total).toLocaleString('id-ID');
    
    // Update total SKID
    skidBoxRegulerData.total = skidBoxRegulerData.pjg.total + skidBoxRegulerData.lbr.total;
    
    updateGrandTotal();
    
    console.log('✅ SKID Box Reguler PJG calculated:', skidBoxRegulerData.pjg);
}

function calculateSkidBoxRegulerLbr() {
    if (boxRegulerLbr === 0) return;
    
    // PJG = (Dimensi LBR Box Reguler) - 10
    const pjg = boxRegulerLbr - 10;
    const lbr = 120;
    const tbl = 12;
    const m2 = (pjg * lbr) / 1000000;
    const qty = parseFloat(document.getElementById('skid-reguler-lbr-qty').value) || 6;
    const harga = 125000;
    const total = qty * harga * m2;
    
    // Update state
    skidBoxRegulerData.lbr = {
        pjg_dimensi: pjg,
        lbr_dimensi: lbr,
        tbl_dimensi: tbl,
        m2: m2,
        qty: qty,
        harga: harga,
        total: total
    };
    
    // Update display
    document.getElementById('skid-reguler-lbr-pjg').value = pjg;
    document.getElementById('skid-reguler-lbr-m2').value = m2.toFixed(6);
    document.getElementById('skid-reguler-lbr-total').value = Math.round(total).toLocaleString('id-ID');
    
    // Update total SKID
    skidBoxRegulerData.total = skidBoxRegulerData.pjg.total + skidBoxRegulerData.lbr.total;
    
    updateGrandTotal();
    
    console.log('✅ SKID Box Reguler LBR calculated:', skidBoxRegulerData.lbr);
}

// ============================================
// ✅ SKID BOX TUMBU FUNCTIONS
// ============================================

function toggleSkidBoxTumbu() {
    const checkbox = document.getElementById('skid-box-tumbu-checkbox');
    const detail = document.getElementById('skid-box-tumbu-detail');
    
    skidBoxTumbuData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        if (boxTumbuPjg === 0 || boxTumbuLbr === 0 || boxTumbuTgi === 0) {
            alert('⚠️ Aktifkan dan hitung Box Tumbu terlebih dahulu!');
            checkbox.checked = false;
            skidBoxTumbuData.enabled = false;
            return;
        }
        
        detail.style.display = 'block';
        calculateSkidBoxTumbuPjg();
        calculateSkidBoxTumbuLbr();
    } else {
        detail.style.display = 'none';
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        updateGrandTotal();
    }
    
    console.log('✅ SKID Box Tumbu toggled:', skidBoxTumbuData.enabled);
}

function calculateSkidBoxTumbuPjg() {
    if (boxTumbuPjg === 0 || boxTumbuTgi === 0) return;
    
    // PJG = (Dimensi PJG Box Tumbu) - 10
    // LBR = (Dimensi TGI Box Tumbu) - 10
    const pjg = boxTumbuPjg - 10;
    const lbr = boxTumbuTgi - 10;
    const tbl = 2.4;
    const m2 = (pjg * lbr) / 1000000;
    const qty = parseFloat(document.getElementById('skid-tumbu-pjg-qty').value) || 2;
    const harga = 75000;
    const total = qty * harga * m2;
    
    // Update state
    skidBoxTumbuData.pjg = {
        pjg_dimensi: pjg,
        lbr_dimensi: lbr,
        tbl_dimensi: tbl,
        m2: m2,
        qty: qty,
        harga: harga,
        total: total
    };
    
    // Update display
    document.getElementById('skid-tumbu-pjg-pjg').value = pjg;
    document.getElementById('skid-tumbu-pjg-lbr').value = lbr;
    document.getElementById('skid-tumbu-pjg-m2').value = m2.toFixed(6);
    document.getElementById('skid-tumbu-pjg-total').value = Math.round(total).toLocaleString('id-ID');
    
    // Update total SKID
    skidBoxTumbuData.total = skidBoxTumbuData.pjg.total + skidBoxTumbuData.lbr.total;
    
    updateGrandTotal();
    
    console.log('✅ SKID Box Tumbu PJG calculated:', skidBoxTumbuData.pjg);
}

function calculateSkidBoxTumbuLbr() {
    if (boxTumbuLbr === 0 || boxTumbuTgi === 0) return;
    
    // PJG = (Dimensi LBR Box Tumbu) - 10
    // LBR = (Dimensi TGI Box Tumbu) - 10
    const pjg = boxTumbuLbr - 10;
    const lbr = boxTumbuTgi - 10;
    const tbl = 2.4;
    const m2 = (pjg * lbr) / 1000000;
    const qty = parseFloat(document.getElementById('skid-tumbu-lbr-qty').value) || 2;
    const harga = 75000;
    const total = qty * harga * m2;
    
    // Update state
    skidBoxTumbuData.lbr = {
        pjg_dimensi: pjg,
        lbr_dimensi: lbr,
        tbl_dimensi: tbl,
        m2: m2,
        qty: qty,
        harga: harga,
        total: total
    };
    
    // Update display
    document.getElementById('skid-tumbu-lbr-pjg').value = pjg;
    document.getElementById('skid-tumbu-lbr-lbr').value = lbr;
    document.getElementById('skid-tumbu-lbr-m2').value = m2.toFixed(6);
    document.getElementById('skid-tumbu-lbr-total').value = Math.round(total).toLocaleString('id-ID');
    
    // Update total SKID
    skidBoxTumbuData.total = skidBoxTumbuData.pjg.total + skidBoxTumbuData.lbr.total;
    
    updateGrandTotal();
    
    console.log('✅ SKID Box Tumbu LBR calculated:', skidBoxTumbuData.lbr);
}

// ============================================
// ✅ HELPER: SHOW/HIDE SKID SECTIONS
// ============================================

function showSkidSection(boxType) {
    const skidRegulerSection = document.getElementById('skid-box-reguler-section');
    const skidTumbuSection = document.getElementById('skid-box-tumbu-section');
    
    if (boxType === 'reguler') {
        skidRegulerSection.style.display = 'block';
        skidTumbuSection.style.display = 'none';
        
        // Reset SKID Tumbu
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.total = 0;
        
    } else if (boxType === 'tumbu') {
        skidRegulerSection.style.display = 'none';
        skidTumbuSection.style.display = 'block';
        
        // Reset SKID Reguler
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.total = 0;
    } else {
        skidRegulerSection.style.display = 'none';
        skidTumbuSection.style.display = 'none';
        
        // Reset both
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxTumbuData.enabled = false;
        skidBoxRegulerData.total = 0;
        skidBoxTumbuData.total = 0;
    }
    
    updateGrandTotal();
}

// ============================================
// ✅ HELPER: RECALCULATE SKID WHEN BOX DIMENSIONS CHANGE
// ============================================

function recalculateSkidIfEnabled() {
    // Recalculate SKID Box Reguler if enabled
    if (skidBoxRegulerData.enabled && boxRegulerPjg > 0 && boxRegulerLbr > 0) {
        calculateSkidBoxRegulerPjg();
        calculateSkidBoxRegulerLbr();
    }
    
    // Recalculate SKID Box Tumbu if enabled
    if (skidBoxTumbuData.enabled && boxTumbuPjg > 0 && boxTumbuLbr > 0 && boxTumbuTgi > 0) {
        calculateSkidBoxTumbuPjg();
        calculateSkidBoxTumbuLbr();
    }
}

// ============================================
// ✅ NEW: UPDATE BOX CARDS STATE (DISABLE LOGIC)
// ============================================

function updateBoxCardsState() {
    const hasBoxReguler = componentsData['box-reguler'] !== undefined;
    const hasBoxTumbu = componentsData['box-tumbu'] !== undefined;
    
    console.log('🔄 Updating card states:', { hasBoxReguler, hasBoxTumbu });
    
    // Re-render cards to apply disabled states
    renderBoxCards();
}
// ============================================
// RENDER BOX CARDS - UPDATED WITH DISABLE LOGIC & CANCEL BUTTON
// ============================================

function renderBoxCards() {
    const container = document.getElementById('box-cards-container');
    
    // ✅ CHECK WHAT'S ACTIVE
    const hasBoxReguler = componentsData['box-reguler'] !== undefined;
    const hasBoxTumbu = componentsData['box-tumbu'] !== undefined;
    
    let html = '';
    let renderedComponents = new Set();
    
    Object.keys(componentsData).forEach(key => {
        const data = componentsData[key];
        
        let baseComponentId = key;
        let instanceNum = null;
        
        if (key.includes('-')) {
            const match = key.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
            if (match) {
                baseComponentId = match[1];
                instanceNum = parseInt(match[2]);
            }
        }
        
        const component = boxComponents.find(c => c.id === baseComponentId);
        if (!component) return;
        
        const isLayerHoneycomb = key.startsWith('layer-honeycomb-');
        const isLayerEnabled = data.enabled !== undefined ? data.enabled : true;
        
        let displayName = component.name;
        if (instanceNum && instanceNum > 1) {
            displayName = `${component.name} #${instanceNum}`;
        }
        
        // ✅ CHECK IF THIS IS BOX REGULER/TUMBU/TUTUP (should have cancel button)
        const isMainBox = ['box-reguler', 'box-tumbu', 'box-tutup'].includes(key);
        
        html += `
            <div class="col-md-4">
                <div class="box-component-card active ${isLayerHoneycomb ? 'layer-auto' : ''} ${!isLayerEnabled ? 'layer-disabled' : ''}" 
                     onclick="openComponentModal('${key}')" 
                     style="cursor: pointer;">
                    <div class="card-badge ${!isLayerEnabled ? 'bg-secondary' : ''}">${isLayerHoneycomb ? (isLayerEnabled ? 'AUTO-GENERATED' : 'NONAKTIF') : 'AKTIF'}</div>
                    
                    ${/* ✅ TOMBOL CANCEL/BATAL UNTUK MAIN BOX */ ''}
                    ${isMainBox ? `
                        <button type="button" 
                                class="btn btn-sm btn-danger position-absolute" 
                                style="top: 10px; left: 10px; z-index: 10;"
                                onclick="event.stopPropagation(); cancelBoxComponent('${key}')"
                                title="Batal / Cancel">
                            <i class="fas fa-times me-1"></i>Batal
                        </button>
                    ` : ''}
                    
                    ${/* TOMBOL HAPUS UNTUK FILLER (allowMultiple) */ ''}
                    ${component.allowMultiple && !isLayerHoneycomb && !isMainBox ? `
                        <button type="button" 
                                class="btn btn-sm btn-danger position-absolute" 
                                style="top: 10px; left: 10px; z-index: 10;"
                                onclick="event.stopPropagation(); removeComponent('${key}')"
                                title="Hapus">
                            <i class="fas fa-trash"></i>
                        </button>
                    ` : ''}
                    
                    ${isLayerHoneycomb ? `
                        <div class="position-absolute" style="top: 50px; right: 10px; z-index: 10;">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       id="checkbox-${key}" 
                                       ${isLayerEnabled ? 'checked' : ''}
                                       onchange="toggleLayerHoneycomb('${key}')"
                                       onclick="event.stopPropagation()">
                                <label class="form-check-label small" for="checkbox-${key}">
                                    ${isLayerEnabled ? 'Aktif' : 'Nonaktif'}
                                </label>
                            </div>
                        </div>
                    ` : ''}
                    
                    <div class="card-icon">${component.icon}</div>
                    <div class="card-title">${displayName}</div>
                    <div class="card-formula">${component.formula}</div>
                    <div class="card-total ${!isLayerEnabled ? 'text-muted' : ''}">${formatRupiah(data.harga)}</div>
                    ${isLayerHoneycomb 
                        ? `<small class="text-muted d-block mt-2">
                            <i class="fas fa-${isLayerEnabled ? 'check-circle' : 'times-circle'} me-1"></i>
                            ${isLayerEnabled ? 'Aktif' : 'Nonaktif'} - Klik untuk edit qty
                           </small>` 
                        : `<small class="text-muted d-block mt-2">Klik untuk edit</small>`}
                </div>
            </div>
        `;
        
        renderedComponents.add(baseComponentId);
    });
    
    // ✅ RENDER NON-ACTIVE COMPONENTS WITH DISABLE LOGIC
    boxComponents.forEach(component => {
        if (renderedComponents.has(component.id) || component.allowMultiple || component.id.startsWith('layer-honeycomb-')) {
            return;
        }
        
        // ✅ DISABLE LOGIC
        let isDisabled = false;
        let disabledReason = '';
        
        if (component.id === 'box-reguler' && hasBoxTumbu) {
            isDisabled = true;
            disabledReason = 'Box Tumbu sudah aktif';
        } else if (component.id === 'box-tumbu' && hasBoxReguler) {
            isDisabled = true;
            disabledReason = 'Box Reguler sudah aktif';
        } else if (component.id === 'box-tutup' && hasBoxReguler) {
            isDisabled = true;
            disabledReason = 'Box Tutup hanya bisa dengan Box Tumbu';
        } else if (component.id === 'box-tutup' && !hasBoxTumbu) {
            isDisabled = true;
            disabledReason = 'Aktifkan Box Tumbu terlebih dahulu';
        }
        
        html += `
            <div class="col-md-4">
                <div class="box-component-card ${isDisabled ? 'disabled-card' : ''}" 
                     onclick="${isDisabled ? 'return false;' : 'openComponentModal(\'' + component.id + '\')'}"
                     ${isDisabled ? 'style="cursor: not-allowed !important;"' : ''}>
                    <div class="card-badge">${isDisabled ? 'DISABLED' : 'NONAKTIF'}</div>
                    <div class="card-icon">${component.icon}</div>
                    <div class="card-title">${component.name}</div>
                    <div class="card-formula">${component.formula}</div>
                    <div class="card-total">Rp 0</div>
                    <small class="text-muted d-block mt-2">
                        ${isDisabled 
                            ? `<i class="fas fa-ban me-1 text-danger"></i>${disabledReason}` 
                            : 'Klik untuk aktifkan'}
                    </small>
                </div>
            </div>
        `;
    });
    
    container.innerHTML = html;
}

// ============================================
// ✅ NEW: CANCEL BOX COMPONENT FUNCTION
// ============================================

function cancelBoxComponent(componentId) {
    const component = boxComponents.find(c => c.id === componentId);
    if (!component) return;
    
    const confirmMessage = `⚠️ Yakin ingin MEMBATALKAN ${component.name}?\n\n` +
                          `Data ${component.name} akan dihapus dan Anda bisa memilih box lain.`;
    
    if (!confirm(confirmMessage)) {
        return;
    }
    
    // Delete component dari componentsData
    delete componentsData[componentId];
    
    // ✅ RESET SPECIFIC DATA BASED ON COMPONENT
    if (componentId === 'box-reguler') {
        // Reset Box Reguler dimensions
        boxRegulerPjg = 0;
        boxRegulerLbr = 0;
        boxRegulerTgi = 0;
        
        // Reset SKID Reguler
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        
        // Hide SKID section
        document.getElementById('skid-box-reguler-section').style.display = 'none';
        
        console.log('✅ Box Reguler CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tumbu') {
        // Reset Box Tumbu dimensions
        boxTumbuPjg = 0;
        boxTumbuLbr = 0;
        boxTumbuTgi = 0;
        
        // Reset SKID Tumbu
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        
        // Hide SKID section
        document.getElementById('skid-box-tumbu-section').style.display = 'none';
        
        // ✅ ALSO DELETE BOX TUTUP if exists
        if (componentsData['box-tutup']) {
            delete componentsData['box-tutup'];
            console.log('✅ Box Tutup also removed because Box Tumbu was cancelled');
        }
        
        console.log('✅ Box Tumbu CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tutup') {
        console.log('✅ Box Tutup CANCELLED');
    }
    
    // ✅ UPDATE CARD STATES & RE-RENDER
    updateBoxCardsState();
    renderBoxCards();
    updateGrandTotal();
    
    alert(`✅ ${component.name} berhasil dibatalkan!\n\nAnda sekarang bisa memilih box lain.`);
}
// ============================================
// ✅ NEW: CANCEL BOX COMPONENT FUNCTION
// ============================================

function cancelBoxComponent(componentId) {
    const component = boxComponents.find(c => c.id === componentId);
    if (!component) return;
    
    const confirmMessage = `⚠️ Yakin ingin MEMBATALKAN ${component.name}?\n\n` +
                          `Data ${component.name} akan dihapus dan Anda bisa memilih box lain.`;
    
    if (!confirm(confirmMessage)) {
        return;
    }
    
    // Delete component dari componentsData
    delete componentsData[componentId];
    
    // ✅ RESET SPECIFIC DATA BASED ON COMPONENT
    if (componentId === 'box-reguler') {
        // Reset Box Reguler dimensions
        boxRegulerPjg = 0;
        boxRegulerLbr = 0;
        boxRegulerTgi = 0;
        
        // Reset SKID Reguler
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.pjg.total = 0;
        skidBoxRegulerData.lbr.total = 0;
        skidBoxRegulerData.total = 0;
        
        // Hide SKID section
        document.getElementById('skid-box-reguler-section').style.display = 'none';
        
        console.log('✅ Box Reguler CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tumbu') {
        // Reset Box Tumbu dimensions
        boxTumbuPjg = 0;
        boxTumbuLbr = 0;
        boxTumbuTgi = 0;
        
        // Reset SKID Tumbu
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.pjg.total = 0;
        skidBoxTumbuData.lbr.total = 0;
        skidBoxTumbuData.total = 0;
        
        // Hide SKID section
        document.getElementById('skid-box-tumbu-section').style.display = 'none';
        
        // ✅ ALSO DELETE BOX TUTUP if exists
        if (componentsData['box-tutup']) {
            delete componentsData['box-tutup'];
            console.log('✅ Box Tutup also removed because Box Tumbu was cancelled');
        }
        
        console.log('✅ Box Tumbu CANCELLED - All related data reset');
        
    } else if (componentId === 'box-tutup') {
        console.log('✅ Box Tutup CANCELLED');
    }
    
    // ✅ UPDATE CARD STATES & RE-RENDER
    updateBoxCardsState();
    renderBoxCards();
    updateGrandTotal();
    
    alert(`✅ ${component.name} berhasil dibatalkan!\n\nAnda sekarang bisa memilih box lain.`);
}
// ============================================
// OPEN TAMBAH FILLER MODAL
// ============================================

function openTambahFillerModal() {
    const modal = new bootstrap.Modal(document.getElementById('tambahFillerModal'));
    modal.show();
}

// ============================================
// ADD FILLER BOX (NEW INSTANCE)
// ============================================

function addFillerBox() {
    fillerBoxCounter++;
    const newInstanceId = `filler-box-${fillerBoxCounter}`;
    
    console.log('✅ Adding new Filler Box:', newInstanceId);
    
    bootstrap.Modal.getInstance(document.getElementById('tambahFillerModal')).hide();
    
    openComponentModal(newInstanceId);
}

// ============================================
// ADD FILLER SEGITIGA (NEW INSTANCE)
// ============================================

function addFillerSegitiga() {
    fillerSegitigaCounter++;
    const newInstanceId = `filler-segitiga-${fillerSegitigaCounter}`;
    
    console.log('✅ Adding new Filler Segitiga:', newInstanceId);
    
    bootstrap.Modal.getInstance(document.getElementById('tambahFillerModal')).hide();
    
    openComponentModal(newInstanceId);
}

// ============================================
// REMOVE COMPONENT (Support Multiple)
// ============================================

function removeComponent(componentId) {
    if (!confirm('⚠️ Yakin ingin menghapus komponen ini?')) {
        return;
    }
    
    delete componentsData[componentId];
    
    if (componentId.startsWith('filler-box-')) {
        const instanceNum = componentId.split('-')[2];
        const layerSuffix = `-${instanceNum}`;
        
        delete componentsData[`layer-honeycomb-1${layerSuffix}`];
        delete componentsData[`layer-honeycomb-2${layerSuffix}`];
        delete fillerBoxInstances[componentId];
        
        console.log(`✅ Removed Filler Box ${instanceNum} and its Layer Honeycombs`);
    }
    
    // ✅ CHECK IF BOX REGULER OR BOX TUMBU REMOVED
    if (componentId === 'box-reguler') {
        boxRegulerPjg = 0;
        boxRegulerLbr = 0;
        boxRegulerTgi = 0;
        
        // Reset SKID Reguler
        document.getElementById('skid-box-reguler-checkbox').checked = false;
        skidBoxRegulerData.enabled = false;
        skidBoxRegulerData.total = 0;
        
        console.log('✅ Box Reguler removed - SKID reset');
    } else if (componentId === 'box-tumbu') {
        boxTumbuPjg = 0;
        boxTumbuLbr = 0;
        boxTumbuTgi = 0;
        
        // Reset SKID Tumbu
        document.getElementById('skid-box-tumbu-checkbox').checked = false;
        skidBoxTumbuData.enabled = false;
        skidBoxTumbuData.total = 0;
        
        // ✅ REMOVE BOX TUTUP if exists (Box Tutup depends on Box Tumbu)
        if (componentsData['box-tutup']) {
            delete componentsData['box-tutup'];
            console.log('✅ Box Tutup removed because Box Tumbu was removed');
        }
        
        console.log('✅ Box Tumbu removed - SKID reset');
    }
    
    renderBoxCards();
    updateGrandTotal();
}

// ============================================
// TOGGLE LAYER HONEYCOMB (CHECKBOX)
// ============================================

function toggleLayerHoneycomb(componentId) {
    const checkbox = document.getElementById(`checkbox-${componentId}`);
    const isEnabled = checkbox.checked;
    
    if (componentsData[componentId]) {
        componentsData[componentId].enabled = isEnabled;
        
        console.log(`✅ Layer Honeycomb ${componentId} ${isEnabled ? 'ENABLED' : 'DISABLED'}`);
        
        renderBoxCards();
        updateGrandTotal();
    }
}

// ============================================
// OPEN COMPONENT MODAL - UPDATED
// ============================================

function openComponentModal(componentId) {
    // ✅ VALIDATION: Check if component is disabled
    const hasBoxReguler = componentsData['box-reguler'] !== undefined;
    const hasBoxTumbu = componentsData['box-tumbu'] !== undefined;
    
    if (componentId === 'box-reguler' && hasBoxTumbu) {
        alert('❌ Box Reguler tidak bisa diaktifkan karena Box Tumbu sudah aktif!\n\nHapus Box Tumbu terlebih dahulu jika ingin menggunakan Box Reguler.');
        return;
    }
    
    if (componentId === 'box-tumbu' && hasBoxReguler) {
        alert('❌ Box Tumbu tidak bisa diaktifkan karena Box Reguler sudah aktif!\n\nHapus Box Reguler terlebih dahulu jika ingin menggunakan Box Tumbu.');
        return;
    }
    
    if (componentId === 'box-tutup') {
        if (hasBoxReguler) {
            alert('❌ Box Tutup hanya bisa digunakan dengan Box Tumbu!\n\nBox Reguler sedang aktif. Gunakan Box Tumbu jika ingin menggunakan Box Tutup.');
            return;
        }
        if (!hasBoxTumbu) {
            alert('❌ Aktifkan dan hitung Box Tumbu terlebih dahulu!\n\nBox Tutup membutuhkan Box Tumbu sebagai dasar perhitungan.');
            return;
        }
    }
    
    let baseComponentId = componentId;
    let instanceNum = null;
    
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
            instanceNum = parseInt(match[2]);
        }
    }
    
    const component = boxComponents.find(c => c.id === baseComponentId);
    if (!component) return;
    
    let displayName = component.name;
    if (instanceNum && instanceNum > 1) {
        displayName = `${component.name} #${instanceNum}`;
    }
    
    document.getElementById('modal-component-id').value = componentId;
    document.getElementById('modal-component-name').textContent = displayName;
    
    const existingData = componentsData[componentId];
    
    let modalContent = '';
    
    modalContent += `
        <div class="alert alert-info mb-3">
            <strong>Formula:</strong> ${component.formula}
            ${instanceNum ? `<br><strong>Instance:</strong> #${instanceNum}` : ''}
        </div>
        
        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">Price/M² <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="modal-price-m2" value="${existingData?.price_m2 || component.defaultPrice}" step="0.01">
            </div>
            <div class="col-md-6">
                <label class="form-label">Kebutuhan/Unit <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="modal-kebutuhan" value="${existingData?.kebutuhan_unit || 1}" min="1">
            </div>
        </div>
    `;
    
    if (component.type === 'manual') {
        if (baseComponentId === 'filler-box' || baseComponentId === 'top-pad') {
            modalContent += `
                <div class="alert alert-warning mb-3">
                    <strong>Manual Input Required!</strong>
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">PJG (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-pjg" value="${existingData?.dimensi_box?.pjg || ''}" placeholder="Masukkan PJG">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">LBR (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-lbr" value="${existingData?.dimensi_box?.lbr || ''}" placeholder="Masukkan LBR">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">TGI (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-tgi" value="${existingData?.dimensi_box?.tgi || ''}" placeholder="Masukkan TGI">
                    </div>
                </div>
            `;
        } else if (baseComponentId === 'filler-segitiga') {
            modalContent += `
                <div class="alert alert-warning mb-3">
                    <strong>Manual Input:</strong> TGI otomatis = 6
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">PJG (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-pjg" value="${existingData?.dimensi_box?.pjg || ''}" placeholder="Masukkan PJG">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">LBR (mm) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="modal-lbr" value="${existingData?.dimensi_box?.lbr || ''}" placeholder="Masukkan LBR">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="6" readonly>
                    </div>
                </div>
            `;
        }
    } else if (component.type === 'dependent') {
        if (baseComponentId.includes('layer-honeycomb')) {
            modalContent += `
                <div class="alert alert-info mb-3">
                    <strong>Auto Calculate:</strong> Dimensi dari Filler Box | TGI = 6
                    <br><small class="text-muted">💡 Anda bisa mengubah Qty (Kebutuhan/Unit) dan harga akan otomatis berubah!</small>
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="6" readonly>
                    </div>
                </div>
            `;
        } else if (baseComponentId === 'support-box') {
            modalContent += `
                <div class="alert alert-info mb-3">
                    <strong>Auto Calculate:</strong> Dimensi dari Box Reguler | TGI = 50
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">TGI (Auto)</label>
                        <input type="number" class="form-control" id="modal-tgi" value="50" readonly>
                    </div>
                </div>
            `;
        }
    }
    
    modalContent += `
        <hr>
        <div class="row">
            <div class="col-md-4">
                <label class="form-label">M² (Auto)</label>
                <input type="text" class="form-control" id="modal-m2-display" readonly value="${existingData?.ukuran_karton?.m2 ? existingData.ukuran_karton.m2.toFixed(6) : '0.000000'}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Price Karton (Auto)</label>
                <input type="text" class="form-control" id="modal-price-karton-display" readonly value="${existingData?.price_karton ? formatRupiah(existingData.price_karton) : 'Rp 0'}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Harga Total (Auto)</label>
                <input type="text" class="form-control fw-bold text-success" id="modal-harga-display" readonly value="${existingData?.harga ? formatRupiah(existingData.harga) : 'Rp 0'}">
            </div>
        </div>
    `;
    
    document.getElementById('modal-component-content').innerHTML = modalContent;
    
    const inputs = ['modal-price-m2', 'modal-kebutuhan', 'modal-pjg', 'modal-lbr', 'modal-tgi'];
    inputs.forEach(inputId => {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('input', () => calculateModalComponent(componentId));
        }
    });
    
    calculateModalComponent(componentId);
    
    const modal = new bootstrap.Modal(document.getElementById('editComponentModal'));
    modal.show();
}
// ============================================
// CALCULATE MODAL COMPONENT - UPDATED
// ============================================

function calculateModalComponent(componentId) {
    let result = null;
    
    let baseComponentId = componentId;
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
        }
    }
    
    switch(baseComponentId) {
        case 'box-reguler':
            result = calculateBoxReguler();
            break;
        case 'box-tumbu':
            result = calculateBoxTumbu();
            break;
        case 'box-tutup':
            result = calculateBoxTutup();
            break;
        case 'filler-box':
            result = calculateFillerBoxModal(componentId);
            break;
        case 'layer-honeycomb-1':
            result = calculateLayerHoneycombModal(1, componentId);
            break;
        case 'layer-honeycomb-2':
            result = calculateLayerHoneycombModal(2, componentId);
            break;
        case 'filler-segitiga':
            result = calculateFillerSegitigaModal(componentId);
            break;
        case 'support-box':
            result = calculateSupportBoxModal();
            break;
        case 'top-pad':
            result = calculateTopPadModal();
            break;
    }
    
    if (result) {
        document.getElementById('modal-m2-display').value = result.ukuran_karton.m2.toFixed(6);
        document.getElementById('modal-price-karton-display').value = formatRupiah(result.price_karton);
        document.getElementById('modal-harga-display').value = formatRupiah(result.harga);
    }
}

// ============================================
// BOX CALCULATIONS - UPDATED WITH DISABLE LOGIC
// ============================================

function calculateBoxReguler() {
    const pjg = P + 122;
    const lbr = L + 122;
    const tgi = T + 122 + 24;
    
    boxRegulerPjg = pjg;
    boxRegulerLbr = lbr;
    boxRegulerTgi = tgi;
    
    const pjgKarton = (pjg + lbr + 59) * 2;
    const lbrKarton = (lbr + tgi) + 22;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    // ✅ Show SKID section for Box Reguler
    showSkidSection('reguler');
    
    // ✅ Recalculate SKID if enabled
    recalculateSkidIfEnabled();
    
    return {
        jenis_box: 'BOX REGULER',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateBoxTumbu() {
    const pjg = P + 90;
    const lbr = L + 90;
    const tgi = T + 90;
    
    boxTumbuPjg = pjg;
    boxTumbuLbr = lbr;
    boxTumbuTgi = tgi;
    
    const pjgKarton = pjg + (2 * tgi) + 18;
    const lbrKarton = lbr + (2 * tgi) + 18;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    // ✅ Show SKID section for Box Tumbu
    showSkidSection('tumbu');
    
    // ✅ Recalculate SKID if enabled
    recalculateSkidIfEnabled();
    
    return {
        jenis_box: 'BOX TUMBU',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateBoxTutup() {
    const pjgTumbu = boxTumbuPjg || (P + 90);
    const lbrTumbu = boxTumbuLbr || (L + 90);
    const tgiTumbu = boxTumbuTgi || (T + 90);
    
    const pjg = pjgTumbu + 20;
    const lbr = lbrTumbu + 20;
    const tgi = tgiTumbu + 20;
    
    const pjgKarton = pjg + (2 * tgi) + 18;
    const lbrKarton = lbr + (2 * tgi) + 18;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'BOX TUTUP',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateFillerBoxModal(componentId) {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('modal-tgi').value) || 0;
    
    if (pjg === 0 || lbr === 0 || tgi === 0) {
        return null;
    }
    
    fillerBoxInstances[componentId] = { pjg, lbr, tgi };
    
    const pjgKarton = (pjg + lbr + 59) * 2;
    const lbrKarton = (lbr + tgi) + 22;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const displayName = instanceNum ? `FILLER BOX #${instanceNum}` : 'FILLER BOX';
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga,
        filler_id: componentId
    };
}

function calculateLayerHoneycombModal(number, componentId) {
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    
    const fillerBoxId = instanceNum ? `filler-box-${instanceNum}` : 'filler-box';
    const fillerData = fillerBoxInstances[fillerBoxId];
    
    if (!fillerData) {
        alert('⚠️ Aktifkan dan isi Filler Box terlebih dahulu!');
        return null;
    }
    
    let pjg;
    if (number === 1) {
        pjg = fillerData.pjg - 10;
    } else {
        pjg = fillerData.lbr - 10;
    }
    
    const lbr = fillerData.tgi;
    const tgi = 6;
    
    const pjgKarton = pjg;
    const lbrKarton = lbr + 21;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    
    const kebutuhanInput = document.getElementById('modal-kebutuhan');
    const kebutuhan = kebutuhanInput ? parseFloat(kebutuhanInput.value) || 1 : 1;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const displayName = instanceNum ? `LAYER HONEYCOMB ${number} #${instanceNum}` : `LAYER HONEYCOMB ${number}`;
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga,
        parent_filler: fillerBoxId
    };
}

function autoCreateLayerHoneycombs(fillerId, priceM2, kebutuhan) {
    const fillerData = fillerBoxInstances[fillerId];
    if (!fillerData) {
        console.warn('⚠️ Filler Box data not found for:', fillerId);
        return;
    }
    
    const instanceMatch = fillerId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const layerSuffix = instanceNum ? `-${instanceNum}` : '';
    
    // LAYER HONEYCOMB 1
    const pjg1 = fillerData.pjg - 10;
    const lbr1 = fillerData.tgi;
    const tgi1 = 6;
    
    const pjgKarton1 = pjg1;
    const lbrKarton1 = lbr1 + 21;
    const m2_1 = (pjgKarton1 * lbrKarton1) / 1000000;
    
    const priceKarton1 = priceM2 * m2_1;
    const qty1 = 1;
    const harga1 = qty1 * priceKarton1;
    
    const displayName1 = instanceNum ? `LAYER HONEYCOMB 1 #${instanceNum}` : 'LAYER HONEYCOMB 1';
    const layer1Id = instanceNum ? `layer-honeycomb-1-${instanceNum}` : 'layer-honeycomb-1';
    
    componentsData[layer1Id] = {
        jenis_box: displayName1,
        dimensi_box: { pjg: pjg1, lbr: lbr1, tgi: tgi1 },
        ukuran_karton: { pjg: pjgKarton1, lbr: lbrKarton1, m2: m2_1 },
        price_m2: priceM2,
        price_karton: priceKarton1,
        kebutuhan_unit: qty1,
        harga: harga1,
        parent_filler: fillerId,
        enabled: true
    };
    
    // LAYER HONEYCOMB 2
    const pjg2 = fillerData.lbr - 10;
    const lbr2 = fillerData.tgi;
    const tgi2 = 6;
    
    const pjgKarton2 = pjg2;
    const lbrKarton2 = lbr2 + 21;
    const m2_2 = (pjgKarton2 * lbrKarton2) / 1000000;
    
    const priceKarton2 = priceM2 * m2_2;
    const qty2 = 1;
    const harga2 = qty2 * priceKarton2;
    
    const displayName2 = instanceNum ? `LAYER HONEYCOMB 2 #${instanceNum}` : 'LAYER HONEYCOMB 2';
    const layer2Id = instanceNum ? `layer-honeycomb-2-${instanceNum}` : 'layer-honeycomb-2';
    
    componentsData[layer2Id] = {
        jenis_box: displayName2,
        dimensi_box: { pjg: pjg2, lbr: lbr2, tgi: tgi2 },
        ukuran_karton: { pjg: pjgKarton2, lbr: lbrKarton2, m2: m2_2 },
        price_m2: priceM2,
        price_karton: priceKarton2,
        kebutuhan_unit: qty2,
        harga: harga2,
        parent_filler: fillerId,
        enabled: true
    };
    
    console.log(`✅ Auto-created Layer Honeycombs for ${fillerId}:`, {
        layer1: layer1Id,
        layer2: layer2Id,
        qty1: qty1,
        qty2: qty2
    });
}

function calculateFillerSegitigaModal(componentId) {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = 6;
    
    if (pjg === 0 || lbr === 0) {
        return null;
    }
    
    const pjgKarton = pjg;
    const lbrKarton = lbr + 21;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    const instanceMatch = componentId.match(/-(\d+)$/);
    const instanceNum = instanceMatch ? parseInt(instanceMatch[1]) : null;
    const displayName = instanceNum ? `FILLER SEGITIGA #${instanceNum}` : 'FILLER SEGITIGA';
    
    return {
        jenis_box: displayName,
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateSupportBoxModal() {
    if (boxRegulerPjg === 0 || boxRegulerLbr === 0 || boxRegulerTgi === 0) {
        alert('⚠️ Aktifkan dan hitung Box Reguler terlebih dahulu!');
        return null;
    }
    
    const pjg = boxRegulerPjg - 10;
    const lbr = boxRegulerLbr - 10;
    const tgi = 50;
    
    const pjgKarton = ((2 * pjg) + (2 * tgi)) + 15;
    const lbrKarton = (lbr + (2 * tgi)) + 15;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'SUPPORT BOX',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

function calculateTopPadModal() {
    const pjg = parseFloat(document.getElementById('modal-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('modal-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('modal-tgi').value) || 0;
    
    if (pjg === 0 || lbr === 0 || tgi === 0) {
        return null;
    }
    
    const pjgKarton = (2 * tgi) + pjg + 10;
    const lbrKarton = (2 * lbr) + tgi + 10;
    const m2 = (pjgKarton * lbrKarton) / 1000000;
    
    const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 0;
    const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 0;
    
    const priceKarton = priceM2 * m2;
    const harga = kebutuhan * priceKarton;
    
    return {
        jenis_box: 'TOP PAD',
        dimensi_box: { pjg, lbr, tgi },
        ukuran_karton: { pjg: pjgKarton, lbr: lbrKarton, m2 },
        price_m2: priceM2,
        price_karton: priceKarton,
        kebutuhan_unit: kebutuhan,
        harga: harga
    };
}

// ============================================
// SAVE COMPONENT FROM MODAL - UPDATED
// ============================================

function saveComponentFromModal() {
    const componentId = document.getElementById('modal-component-id').value;
    let result = null;
    
    let baseComponentId = componentId;
    if (componentId.includes('-')) {
        const match = componentId.match(/^(filler-box|filler-segitiga|layer-honeycomb-1|layer-honeycomb-2)-(\d+)$/);
        if (match) {
            baseComponentId = match[1];
        }
    }
    
    switch(baseComponentId) {
        case 'box-reguler':
            result = calculateBoxReguler();
            break;
        case 'box-tumbu':
            result = calculateBoxTumbu();
            break;
        case 'box-tutup':
            result = calculateBoxTutup();
            break;
        case 'filler-box':
            result = calculateFillerBoxModal(componentId);
            break;
        case 'layer-honeycomb-1':
            result = calculateLayerHoneycombModal(1, componentId);
            break;
        case 'layer-honeycomb-2':
            result = calculateLayerHoneycombModal(2, componentId);
            break;
        case 'filler-segitiga':
            result = calculateFillerSegitigaModal(componentId);
            break;
        case 'support-box':
            result = calculateSupportBoxModal();
            break;
        case 'top-pad':
            result = calculateTopPadModal();
            break;
    }
    
    if (result && result.harga > 0) {
        componentsData[componentId] = result;
        
        if (baseComponentId === 'filler-box') {
            const priceM2 = parseFloat(document.getElementById('modal-price-m2').value) || 10600;
            const kebutuhan = parseFloat(document.getElementById('modal-kebutuhan').value) || 1;
            
            autoCreateLayerHoneycombs(componentId, priceM2, kebutuhan);
        }
        
        // ✅ UPDATE CARD STATES (for disable logic)
        updateBoxCardsState();
        
        renderBoxCards();
        updateGrandTotal();
        
        bootstrap.Modal.getInstance(document.getElementById('editComponentModal')).hide();
        
        console.log('✅ Component saved:', componentId, result);
    } else {
        alert('❌ Perhitungan tidak valid! Pastikan semua field terisi dengan benar.');
    }
}
// ============================================
// UPDATE GRAND TOTAL - UPDATED WITH SKID
// ============================================

function updateGrandTotal() {
    const totalBox = Object.entries(componentsData).reduce((sum, [key, component]) => {
        const isLayerHoneycomb = key.startsWith('layer-honeycomb-');
        const isEnabled = component.enabled !== undefined ? component.enabled : true;
        
        if (!isLayerHoneycomb || isEnabled) {
            return sum + component.harga;
        }
        
        return sum;
    }, 0);
    
    const totalKomponenPendukung = komponenPendukungItems.reduce((sum, item) => sum + item.total, 0);
    
    const totalPenunjang = penunjangData.enabled ? penunjangData.total : 0;
    
    const totalPallet = palletData.enabled ? palletData.total : 0;
    
    // ✅ TAMBAH SKID TOTAL
    const totalSkidReguler = skidBoxRegulerData.enabled ? skidBoxRegulerData.total : 0;
    const totalSkidTumbu = skidBoxTumbuData.enabled ? skidBoxTumbuData.total : 0;
    const totalSkid = totalSkidReguler + totalSkidTumbu;
    
    const grandTotal = totalBox + totalKomponenPendukung + totalPenunjang + totalPallet + totalSkid;
    
    document.getElementById('grand-total-display').textContent = formatRupiah(grandTotal);
    document.getElementById('komponen-pendukung-total-display').textContent = formatRupiah(totalKomponenPendukung + totalPenunjang + totalPallet + totalSkid);
    document.getElementById('grand_total').value = grandTotal;
    
    console.log('💰 Grand Total Updated:', {
        totalBox,
        totalKomponenPendukung,
        totalPenunjang,
        totalPallet,
        totalSkidReguler,
        totalSkidTumbu,
        totalSkid,
        grandTotal
    });
}

// ============================================
// ✅ PENUNJANG AUTO-ENABLED FUNCTIONS (NEW)
// ============================================

function initializePenunjangPallet() {
    const invoiceBomSelect = document.getElementById('invoice_bom_id');
    const selectedOption = invoiceBomSelect.options[invoiceBomSelect.selectedIndex];
    
    if (selectedOption && selectedOption.value) {
        const productCategory = selectedOption.dataset.productCategory;
        
        console.log('🔍 Debug Penunjang:', {
            productCategory: productCategory,
            allDatasets: selectedOption.dataset
        });
        
        // ✅ SET PENUNJANG AUTO-ENABLED
        penunjangData.enabled = true;
        penunjangData.category = productCategory;
        penunjangData.harga = PENUNJANG_PRICES[productCategory] || 20000;
        penunjangData.qty = 1;
        penunjangData.total = penunjangData.harga * 1;
        
        // ✅ SHOW PENUNJANG SECTION
        document.getElementById('penunjang-section').style.display = 'block';
        
        // Update display
        document.getElementById('penunjang-category').value = productCategory;
        document.getElementById('penunjang-harga-display').value = penunjangData.harga.toLocaleString('id-ID');
        document.getElementById('penunjang-qty').value = 1;
        
        // Calculate initial total
        calculatePenunjangTotal();
        
        console.log('✅ Penunjang AUTO-ENABLED:', {
            category: productCategory,
            harga: penunjangData.harga,
            qty: 1,
            total: penunjangData.total
        });
    }
}

function calculatePenunjangTotal() {
    const qty = parseFloat(document.getElementById('penunjang-qty').value) || 0;
    
    penunjangData.qty = qty;
    penunjangData.total = penunjangData.harga * qty;
    
    document.getElementById('penunjang-total-display').value = penunjangData.total.toLocaleString('id-ID');
    
    updateGrandTotal();
    
    console.log('✅ Penunjang Total Updated:', penunjangData);
}

// ============================================
// PALLET FUNCTIONS
// ============================================

function togglePallet() {
    const checkbox = document.getElementById('pallet-checkbox');
    const detail = document.getElementById('pallet-detail');
    
    palletData.enabled = checkbox.checked;
    
    if (checkbox.checked) {
        detail.style.display = 'block';
        calculatePalletTotal();
    } else {
        detail.style.display = 'none';
        palletData.total = 0;
        document.getElementById('pallet-total-display').value = '';
        updateGrandTotal();
    }
    
    console.log('✅ Pallet toggled:', palletData.enabled);
}

function calculatePalletTotal() {
    const qty = parseFloat(document.getElementById('pallet-qty').value) || 0;
    
    palletData.qty = qty;
    palletData.total = palletData.harga * qty;
    
    document.getElementById('pallet-total-display').value = palletData.total.toLocaleString('id-ID');
    
    updateGrandTotal();
}
// ============================================
// KOMPONEN PENDUKUNG FUNCTIONS
// ============================================

function openKomponenPendukungModal() {
    document.getElementById('komponen-pendukung-edit-index').value = '';
    document.getElementById('komponen-pendukung-product-select').value = '';
    document.getElementById('komponen-pendukung-kode').value = '';
    document.getElementById('komponen-pendukung-nama').value = '';
    
    document.getElementById('komponen_mode_pilihan').checked = true;
    document.getElementById('komponen_pricing_type_pcs').checked = true;
    
    document.getElementById('komponen-pendukung-harga-asli').value = '';
    document.getElementById('komponen-pendukung-pjg').value = '';
    document.getElementById('komponen-pendukung-lbr').value = '';
    document.getElementById('komponen-pendukung-tgi').value = '';
    document.getElementById('komponen-pendukung-m2').value = '';
    document.getElementById('komponen-pendukung-harga-m2-display').value = '';
    document.getElementById('komponen-pendukung-qty').value = 1;
    document.getElementById('komponen-pendukung-harga-finished-display').value = '';
    document.getElementById('komponen-pendukung-total').value = '';
    
    document.getElementById('komponen-pendukung-mode').value = 'pilihan';
    document.getElementById('komponen-pendukung-harga-m2-master').value = '0';
    document.getElementById('komponen-pendukung-harga-finished-master').value = '0';
    
    toggleKomponenInputMode();
    toggleKomponenPricingFields();
    resetPricingTypeButtons();
    
    const modal = new bootstrap.Modal(document.getElementById('komponenPendukungModal'));
    modal.show();
}

function toggleKomponenInputMode() {
    const mode = document.querySelector('input[name="komponen_input_mode"]:checked').value;
    
    const pilihanSection = document.getElementById('komponen-mode-pilihan-section');
    const manualSection = document.getElementById('komponen-mode-manual-section');
    
    const kodeInput = document.getElementById('komponen-pendukung-kode');
    const namaInput = document.getElementById('komponen-pendukung-nama');
    const hargaAsliInput = document.getElementById('komponen-pendukung-harga-asli');
    const tgiInput = document.getElementById('komponen-pendukung-tgi');
    const tgiLabel = document.getElementById('komponen-tgi-label');
    
    document.getElementById('komponen-pendukung-mode').value = mode;
    
    if (mode === 'pilihan') {
        pilihanSection.style.display = 'block';
        manualSection.style.display = 'none';
        
        kodeInput.readOnly = true;
        namaInput.readOnly = true;
        hargaAsliInput.readOnly = true;
        tgiInput.readOnly = true;
        
        tgiLabel.textContent = '(Auto dari Product)';
        
        document.getElementById('komponen-pendukung-product-select').value = '';
        
        resetPricingTypeButtons();
        
    } else {
        pilihanSection.style.display = 'none';
        manualSection.style.display = 'block';
        
        kodeInput.readOnly = false;
        namaInput.readOnly = false;
        hargaAsliInput.readOnly = false;
        
        const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
        if (pricingType === 'm2') {
            tgiInput.readOnly = false;
            tgiLabel.textContent = '(Optional)';
        }
        
        kodeInput.value = '';
        namaInput.value = '';
        hargaAsliInput.value = '';
        document.getElementById('komponen-pendukung-pjg').value = '';
        document.getElementById('komponen-pendukung-lbr').value = '';
        document.getElementById('komponen-pendukung-tgi').value = '';
        
        document.getElementById('komponen-pendukung-harga-m2-master').value = '0';
        document.getElementById('komponen-pendukung-harga-finished-master').value = '0';
        
        resetPricingTypeButtons();
    }
    
    calculateKomponenPendukung();
}

function resetPricingTypeButtons() {
    const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
    const m2Radio = document.getElementById('komponen_pricing_type_m2');
    const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
    const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
    
    pcsRadio.checked = true;
    m2Radio.checked = false;
    
    pcsRadio.disabled = false;
    m2Radio.disabled = false;
    
    pcsLabel.style.display = 'inline-block';
    m2Label.style.display = 'inline-block';
}

function toggleKomponenPricingFields() {
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const mode = document.getElementById('komponen-pendukung-mode').value;
    
    const pjgInput = document.getElementById('komponen-pendukung-pjg');
    const lbrInput = document.getElementById('komponen-pendukung-lbr');
    const tgiInput = document.getElementById('komponen-pendukung-tgi');
    const m2Input = document.getElementById('komponen-pendukung-m2');
    
    const pjgRequired = document.getElementById('komponen-pjg-required');
    const pjgOptional = document.getElementById('komponen-pjg-optional');
    const lbrRequired = document.getElementById('komponen-lbr-required');
    const lbrOptional = document.getElementById('komponen-lbr-optional');
    const hargaM2Field = document.getElementById('komponen-harga-m2-field');
    const tgiLabel = document.getElementById('komponen-tgi-label');
    
    const hargaM2Info = document.getElementById('komponen-harga-m2-info');
    const hargaFinishedInfo = document.getElementById('komponen-harga-finished-info');
    
    const dimensiRow = document.getElementById('komponen-dimensi-row');
    
    if (pricingType === 'm2') {
        dimensiRow.style.display = 'flex';
        pjgRequired.style.display = 'inline';
        pjgOptional.style.display = 'none';
        lbrRequired.style.display = 'inline';
        lbrOptional.style.display = 'none';
        hargaM2Field.style.display = 'flex';
        
        if (mode === 'pilihan') {
            tgiInput.readOnly = true;
            tgiLabel.textContent = '(Auto dari Product)';
            hargaM2Info.textContent = '(Paten dari Master)';
            hargaFinishedInfo.textContent = '(Paten dari Master)';
        } else {
            tgiInput.readOnly = false;
            tgiLabel.textContent = '(Optional)';
            hargaM2Info.textContent = '(Auto Calculate)';
            hargaFinishedInfo.textContent = '(Auto Calculate)';
        }
        
        pjgInput.readOnly = false;
        lbrInput.readOnly = false;
        
    } else {
        dimensiRow.style.display = 'none';
        hargaM2Field.style.display = 'none';
        
        pjgInput.value = '';
        lbrInput.value = '';
        tgiInput.value = '';
        m2Input.value = '';
        
        hargaFinishedInfo.textContent = mode === 'pilihan' ? '(Paten dari Master)' : '(Auto Calculate)';
    }
    
    calculateKomponenPendukung();
}

function selectProductPendukung() {
    const select = document.getElementById('komponen-pendukung-product-select');
    const selectedOption = select.options[select.selectedIndex];
    
    if (select.value) {
        const pricingType = selectedOption.dataset.pricingType;
        const description = selectedOption.dataset.description;
        
        document.getElementById('komponen-pendukung-kode').value = selectedOption.dataset.materialCode;
        document.getElementById('komponen-pendukung-nama').value = description;
        document.getElementById('komponen-pendukung-harga-asli').value = selectedOption.dataset.hargaAsli || '';
        document.getElementById('komponen-pendukung-pjg').value = selectedOption.dataset.panjang || '';
        document.getElementById('komponen-pendukung-lbr').value = selectedOption.dataset.lebar || '';
        
        const tgiMatch = description.match(/X(\d+)MM/i);
        const tgiValue = tgiMatch ? parseInt(tgiMatch[1]) : 0;
        document.getElementById('komponen-pendukung-tgi').value = tgiValue || '';
        
        const hargaM2Master = parseFloat(selectedOption.dataset.hargaM2) || 0;
        const hargaFinishedMaster = parseFloat(selectedOption.dataset.hargaFinished) || 0;
        
        document.getElementById('komponen-pendukung-harga-m2-master').value = hargaM2Master;
        document.getElementById('komponen-pendukung-harga-finished-master').value = hargaFinishedMaster;
        
        const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
        const m2Radio = document.getElementById('komponen_pricing_type_m2');
        const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
        const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
        
        if (pricingType === 'm2') {
            m2Radio.checked = true;
            pcsRadio.checked = false;
            
            pcsRadio.disabled = true;
            m2Radio.disabled = false;
            
            pcsLabel.style.display = 'none';
            m2Label.style.display = 'inline-block';
            
        } else {
            pcsRadio.checked = true;
            m2Radio.checked = false;
            
            pcsRadio.disabled = false;
            m2Radio.disabled = true;
            
            pcsLabel.style.display = 'inline-block';
            m2Label.style.display = 'none';
        }
        
        toggleKomponenPricingFields();
        calculateKomponenPendukung();
        
        console.log('✅ Product selected:', {
            kode: selectedOption.dataset.materialCode,
            nama: description,
            pricing_type: pricingType,
            harga_asli: selectedOption.dataset.hargaAsli,
            tgi: tgiValue,
            harga_m2_master: hargaM2Master,
            harga_finished_master: hargaFinishedMaster
        });
    } else {
        resetPricingTypeButtons();
    }
}

function calculateKomponenPendukung() {
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const hargaAsli = parseFloat(document.getElementById('komponen-pendukung-harga-asli').value) || 0;
    const pjg = parseFloat(document.getElementById('komponen-pendukung-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('komponen-pendukung-lbr').value) || 0;
    
    let m2 = 0;
    if (pjg > 0 && lbr > 0) {
        m2 = (pjg * lbr) / 1000000;
        document.getElementById('komponen-pendukung-m2').value = m2.toFixed(4);
    } else {
        document.getElementById('komponen-pendukung-m2').value = '';
    }
    
    let hargaM2 = 0;
    let hargaFinished = 0;
    
    if (pricingType === 'm2') {
        if (mode === 'pilihan') {
            const hargaM2Master = parseFloat(document.getElementById('komponen-pendukung-harga-m2-master').value) || 0;
            const hargaFinishedMaster = parseFloat(document.getElementById('komponen-pendukung-harga-finished-master').value) || 0;
            
            hargaM2 = hargaM2Master;
            hargaFinished = hargaFinishedMaster;
            
            document.getElementById('komponen-pendukung-harga-m2-display').value = hargaM2 > 0 ? Math.round(hargaM2).toLocaleString('id-ID') : '';
            document.getElementById('komponen-pendukung-harga-finished-display').value = hargaFinished > 0 ? Math.round(hargaFinished).toLocaleString('id-ID') : '';
            
        } else {
            if (m2 > 0 && hargaAsli > 0) {
                hargaM2 = hargaAsli / m2;
                document.getElementById('komponen-pendukung-harga-m2-display').value = Math.round(hargaM2).toLocaleString('id-ID');
                
                const step1 = hargaM2 / 0.8;
                const step2 = step1 / 1000;
                const step3 = Math.ceil(step2 * 10) / 10;
                hargaFinished = step3 * 1000;
                
                document.getElementById('komponen-pendukung-harga-finished-display').value = Math.round(hargaFinished).toLocaleString('id-ID');
            } else {
                document.getElementById('komponen-pendukung-harga-m2-display').value = '';
                document.getElementById('komponen-pendukung-harga-finished-display').value = '';
            }
        }
    } else {
        if (mode === 'pilihan') {
            const hargaFinishedMaster = parseFloat(document.getElementById('komponen-pendukung-harga-finished-master').value) || 0;
            hargaFinished = hargaFinishedMaster;
            
            document.getElementById('komponen-pendukung-harga-finished-display').value = hargaFinished > 0 ? Math.round(hargaFinished).toLocaleString('id-ID') : '';
            
        } else {
            if (hargaAsli > 0) {
                const step1 = hargaAsli / 0.6;
                const step2 = step1 / 1000;
                const step3 = Math.ceil(step2 * 10) / 10;
                hargaFinished = step3 * 1000;
                
                document.getElementById('komponen-pendukung-harga-finished-display').value = Math.round(hargaFinished).toLocaleString('id-ID');
            } else {
                document.getElementById('komponen-pendukung-harga-finished-display').value = '';
            }
        }
        
        document.getElementById('komponen-pendukung-harga-m2-display').value = '';
    }
    
    calculateKomponenPendukungTotal();
}

function calculateKomponenPendukungTotal() {
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const qty = parseFloat(document.getElementById('komponen-pendukung-qty').value) || 0;
    const hargaFinishedText = document.getElementById('komponen-pendukung-harga-finished-display').value.replace(/\./g, '');
    const hargaFinished = parseFloat(hargaFinishedText) || 0;
    
    let total = 0;
    
    if (pricingType === 'm2' && mode === 'pilihan') {
        const m2 = parseFloat(document.getElementById('komponen-pendukung-m2').value) || 0;
        total = m2 * hargaFinished * qty;
    } else {
        total = qty * hargaFinished;
    }
    
    document.getElementById('komponen-pendukung-total').value = total > 0 ? Math.round(total).toLocaleString('id-ID') : '';
}
function saveKomponenPendukung() {
    const kode = document.getElementById('komponen-pendukung-kode').value.trim();
    const nama = document.getElementById('komponen-pendukung-nama').value.trim();
    const mode = document.getElementById('komponen-pendukung-mode').value;
    const pricingType = document.querySelector('input[name="komponen_pricing_type"]:checked').value;
    const hargaAsli = parseFloat(document.getElementById('komponen-pendukung-harga-asli').value) || 0;
    const pjg = parseFloat(document.getElementById('komponen-pendukung-pjg').value) || 0;
    const lbr = parseFloat(document.getElementById('komponen-pendukung-lbr').value) || 0;
    const tgi = parseFloat(document.getElementById('komponen-pendukung-tgi').value) || 0;
    const m2 = parseFloat(document.getElementById('komponen-pendukung-m2').value) || 0;
    const qty = parseFloat(document.getElementById('komponen-pendukung-qty').value) || 0;
    
    const hargaFinishedText = document.getElementById('komponen-pendukung-harga-finished-display').value.replace(/\./g, '');
    const hargaFinished = parseFloat(hargaFinishedText) || 0;
    
    const totalText = document.getElementById('komponen-pendukung-total').value.replace(/\./g, '');
    const total = parseFloat(totalText) || 0;
    
    console.log('Validasi Data:', { kode, nama, mode, pricingType, hargaAsli, qty, hargaFinished, total });
    
    if (!kode) {
        alert('❌ Kode Barang harus diisi!');
        return;
    }
    
    if (!nama) {
        alert('❌ Nama harus diisi!');
        return;
    }
    
    if (hargaAsli <= 0) {
        alert('❌ Harga Asli harus diisi dan lebih dari 0!');
        return;
    }
    
    if (qty <= 0) {
        alert('❌ Qty harus lebih dari 0!');
        return;
    }
    
    if (pricingType === 'm2') {
        if (pjg <= 0 || lbr <= 0) {
            alert('❌ Untuk tipe M2, PJG dan LBR harus diisi!');
            return;
        }
    }
    
    if (hargaFinished <= 0) {
        alert('❌ Harga Finished tidak valid! Pastikan semua input sudah benar.');
        return;
    }
    
    if (total <= 0) {
        alert('❌ Total harga tidak valid!');
        return;
    }
    
    const editIdx = document.getElementById('komponen-pendukung-edit-index').value;
    
    const itemData = {
        material_code: kode,
        nama: nama,
        pricing_type: pricingType,
        harga_asli: hargaAsli,
        pjg: pjg,
        lbr: lbr,
        tgi: tgi,
        m2: m2,
        qty: qty,
        harga_finished: hargaFinished,
        total: total,
        from_master: mode === 'pilihan'
    };
    
    if (editIdx !== '') {
        const index = parseInt(editIdx);
        komponenPendukungItems[index] = itemData;
    } else {
        komponenPendukungItems.push(itemData);
    }
    
    renderKomponenPendukung();
    updateGrandTotal();
    
    bootstrap.Modal.getInstance(document.getElementById('komponenPendukungModal')).hide();
    
    console.log('✅ Komponen Pendukung saved:', komponenPendukungItems);
}

function renderKomponenPendukung() {
    const container = document.getElementById('komponen-pendukung-container');
    
    if (komponenPendukungItems.length === 0) {
        document.getElementById('no-komponen-pendukung-message').style.display = 'block';
        container.innerHTML = '';
        return;
    }
    
    document.getElementById('no-komponen-pendukung-message').style.display = 'none';
    
    container.innerHTML = komponenPendukungItems.map((item, index) => `
        <div class="komponen-pendukung-card">
            <div class="d-flex align-items-start gap-3">
                <div class="flex-grow-1">
                    <div class="komponen-kode">${item.material_code}</div>
                    <div class="komponen-nama">${item.nama}</div>
                    <div class="mt-2">
                        ${item.pricing_type === 'pcs' 
                            ? '<span class="badge bg-success">Harga PCS</span>' 
                            : '<span class="badge bg-info">Harga M2</span>'}
                        ${item.pricing_type === 'm2' && item.pjg && item.lbr 
                            ? `<span class="komponen-dimensi ms-2">📐 ${item.pjg}×${item.lbr}${item.tgi ? '×' + item.tgi : ''} mm${item.m2 ? ' | ' + item.m2.toFixed(4) + ' m²' : ''}</span>` 
                            : ''}
                    </div>
                </div>
                <div class="text-center" style="min-width: 80px;">
                    <label class="form-label small mb-1">Qty:</label>
                    <div class="fw-bold">${item.qty}</div>
                </div>
                <div class="text-center" style="min-width: 120px;">
                    <label class="form-label small mb-1">Harga Finished:</label>
                    <div class="fw-bold text-success">${formatRupiah(item.harga_finished)}</div>
                </div>
                <div class="text-end" style="min-width: 120px;">
                    <label class="form-label small mb-1">Total:</label>
                    <div class="fw-bold text-success fs-6">${formatRupiah(item.total)}</div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <button type="button" 
                            class="btn btn-sm btn-warning" 
                            onclick="editKomponenPendukung(${index})"
                            title="Edit">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button type="button" 
                            class="btn btn-sm btn-danger" 
                            onclick="removeKomponenPendukung(${index})"
                            title="Hapus">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `).join('');
}

function editKomponenPendukung(index) {
    const item = komponenPendukungItems[index];
    
    document.getElementById('komponen-pendukung-edit-index').value = index;
    document.getElementById('komponen-pendukung-product-select').value = '';
    document.getElementById('komponen-pendukung-kode').value = item.material_code;
    document.getElementById('komponen-pendukung-nama').value = item.nama;
    
    const pcsRadio = document.getElementById('komponen_pricing_type_pcs');
    const m2Radio = document.getElementById('komponen_pricing_type_m2');
    const pcsLabel = document.querySelector('label[for="komponen_pricing_type_pcs"]');
    const m2Label = document.querySelector('label[for="komponen_pricing_type_m2"]');
    
    if (item.pricing_type === 'm2') {
        m2Radio.checked = true;
        pcsRadio.checked = false;
        
        if (item.from_master) {
            pcsRadio.disabled = true;
            m2Radio.disabled = false;
            pcsLabel.style.display = 'none';
            m2Label.style.display = 'inline-block';
        } else {
            resetPricingTypeButtons();
        }
    } else {
        pcsRadio.checked = true;
        m2Radio.checked = false;
        
        if (item.from_master) {
            pcsRadio.disabled = false;
            m2Radio.disabled = true;
            pcsLabel.style.display = 'inline-block';
            m2Label.style.display = 'none';
        } else {
            resetPricingTypeButtons();
        }
    }
    
    document.getElementById('komponen-pendukung-harga-asli').value = item.harga_asli || '';
    document.getElementById('komponen-pendukung-pjg').value = item.pjg || '';
    document.getElementById('komponen-pendukung-lbr').value = item.lbr || '';
    document.getElementById('komponen-pendukung-tgi').value = item.tgi || '';
    document.getElementById('komponen-pendukung-qty').value = item.qty;
    
    toggleKomponenPricingFields();
    calculateKomponenPendukung();
    
    const modal = new bootstrap.Modal(document.getElementById('komponenPendukungModal'));
    modal.show();
}

function removeKomponenPendukung(index) {
    if (!confirm('Yakin ingin menghapus komponen pendukung ini?')) return;
    
    komponenPendukungItems.splice(index, 1);
    renderKomponenPendukung();
    updateGrandTotal();
}

// ============================================
// FORM SUBMIT - UPDATED WITH SKID & PENUNJANG AUTO-ENABLED
// ============================================

document.getElementById('boxForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const invoiceBomId = document.getElementById('invoice_bom_id').value;
    
    if (!invoiceBomId) {
        alert('❌ Pilih Invoice BOM terlebih dahulu!');
        return;
    }
    
    if (Object.keys(componentsData).length === 0 && komponenPendukungItems.length === 0) {
        alert('❌ Minimal harus ada 1 komponen box atau komponen pendukung!');
        return;
    }
    
    for (let i = 0; i < komponenPendukungItems.length; i++) {
        const item = komponenPendukungItems[i];
        
        if (item.harga_finished <= 0 || item.total <= 0) {
            alert(`❌ Komponen Pendukung "${item.nama}" memiliki harga tidak valid! Silakan edit ulang.`);
            return;
        }
        
        if (item.pricing_type === 'm2' && (!item.pjg || !item.lbr || item.m2 <= 0)) {
            alert(`❌ Komponen Pendukung "${item.nama}" dengan tipe M2 harus memiliki dimensi PJG dan LBR!`);
            return;
        }
    }
    
    // ✅ PREPARE SKID DATA FOR SAVE
    const skidDataToSave = [];
    
    // SKID Box Reguler
    if (skidBoxRegulerData.enabled) {
        skidDataToSave.push({
            material_code: 'SKID-REGULER-PJG',
            nama: 'SKID PLYWOOD POPLAR PJG',
            pricing_type: 'm2',
            harga_asli: skidBoxRegulerData.pjg.harga,
            pjg: skidBoxRegulerData.pjg.pjg_dimensi,
            lbr: skidBoxRegulerData.pjg.lbr_dimensi,
            tgi: skidBoxRegulerData.pjg.tbl_dimensi,
            m2: skidBoxRegulerData.pjg.m2,
            qty: skidBoxRegulerData.pjg.qty,
            harga_finished: skidBoxRegulerData.pjg.harga,
            total: skidBoxRegulerData.pjg.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_reguler_pjg'
        });
        
        skidDataToSave.push({
            material_code: 'SKID-REGULER-LBR',
            nama: 'SKID PLYWOOD POPLAR LBR',
            pricing_type: 'm2',
            harga_asli: skidBoxRegulerData.lbr.harga,
            pjg: skidBoxRegulerData.lbr.pjg_dimensi,
            lbr: skidBoxRegulerData.lbr.lbr_dimensi,
            tgi: skidBoxRegulerData.lbr.tbl_dimensi,
            m2: skidBoxRegulerData.lbr.m2,
            qty: skidBoxRegulerData.lbr.qty,
            harga_finished: skidBoxRegulerData.lbr.harga,
            total: skidBoxRegulerData.lbr.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_reguler_lbr'
        });
    }
    
    // SKID Box Tumbu
    if (skidBoxTumbuData.enabled) {
        skidDataToSave.push({
            material_code: 'SKID-TUMBU-PJG',
            nama: 'SKID PLYWOOD POPLAR PJG',
            pricing_type: 'm2',
            harga_asli: skidBoxTumbuData.pjg.harga,
            pjg: skidBoxTumbuData.pjg.pjg_dimensi,
            lbr: skidBoxTumbuData.pjg.lbr_dimensi,
            tgi: skidBoxTumbuData.pjg.tbl_dimensi,
            m2: skidBoxTumbuData.pjg.m2,
            qty: skidBoxTumbuData.pjg.qty,
            harga_finished: skidBoxTumbuData.pjg.harga,
            total: skidBoxTumbuData.pjg.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_tumbu_pjg'
        });
        
        skidDataToSave.push({
            material_code: 'SKID-TUMBU-LBR',
            nama: 'SKID PLYWOOD POPLAR LBR',
            pricing_type: 'm2',
            harga_asli: skidBoxTumbuData.lbr.harga,
            pjg: skidBoxTumbuData.lbr.pjg_dimensi,
            lbr: skidBoxTumbuData.lbr.lbr_dimensi,
            tgi: skidBoxTumbuData.lbr.tbl_dimensi,
            m2: skidBoxTumbuData.lbr.m2,
            qty: skidBoxTumbuData.lbr.qty,
            harga_finished: skidBoxTumbuData.lbr.harga,
            total: skidBoxTumbuData.lbr.total,
            from_master: false,
            is_skid: true,
            skid_type: 'box_tumbu_lbr'
        });
    }
    
    // ✅ MERGE SKID DATA WITH KOMPONEN PENDUKUNG
    const allKomponenPendukung = [...komponenPendukungItems, ...skidDataToSave];
    
    const boxDataToSave = {
        components: Object.values(componentsData),
        komponen_pendukung: allKomponenPendukung,
        penunjang: penunjangData.enabled ? penunjangData : null,
        pallet: palletData.enabled ? palletData : null,
        grand_total: parseFloat(document.getElementById('grand_total').value)
    };
    
    console.log('Submitting Box Data:', boxDataToSave);
    console.log('SKID Data Included:', skidDataToSave);
    console.log('Penunjang Data:', penunjangData);
    
    document.getElementById('loadingOverlay').style.display = 'flex';
    
    fetch('{{ route("invoice.box.store") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            invoice_bom_id: invoiceBomId,
            box_data: JSON.stringify(boxDataToSave),
            grand_total: boxDataToSave.grand_total
        })
    })
    .then(response => response.json())
    .then(data => {
        console.log('Server Response:', data);
        
        if (data.success) {
            localStorage.removeItem(DRAFT_KEY);
            
            alert('✅ Invoice Box berhasil dibuat!');
            window.location.href = '{{ route("invoice.box.index") }}';
        } else {
            throw new Error(data.message || 'Failed to create invoice box');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('❌ Terjadi kesalahan: ' + error.message);
    })
    .finally(() => {
        document.getElementById('loadingOverlay').style.display = 'none';
    });
});

</script>

@endsection