@extends('layouts.app')

@section('title', 'Detail Invoice Fitting - Cost Furniture')

@section('page-title', 'Detail Invoice Fitting')

@section('content')

<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-cog me-2"></i>Invoice Fitting #{{ $invoiceFitting->id }}</h5>
        <div>
            <a href="{{ route('invoice.bom.show', $invoiceFitting->invoiceBom->id) }}" class="btn btn-sm btn-info" title="Lihat Invoice BOM">
                <i class="fas fa-file-invoice me-1"></i>Lihat BOM
            </a>
            <a href="{{ route('invoice.fitting.edit', $invoiceFitting->id) }}" class="btn btn-sm btn-warning">
                <i class="fas fa-edit me-1"></i>Edit
            </a>
            <a href="{{ route('invoice.fitting.index') }}" class="btn btn-sm btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Invoice BOM Info -->
        <div class="info-section mb-4">
            <h6 class="section-title"><i class="fas fa-info-circle me-2"></i>INVOICE BOM INFO</h6>
            <div class="row">
                <div class="col-md-3">
                    <strong>Product Name:</strong>
                    <div>{{ $invoiceFitting->invoiceBom->product_name }}</div>
                </div>
                <div class="col-md-2">
                    <strong>Product Code:</strong>
                    <div>{{ $invoiceFitting->invoiceBom->product_code }}</div>
                </div>
                <div class="col-md-3">
                    <strong>Product Type:</strong>
                    <div>{{ $invoiceFitting->invoiceBom->product_type }}</div>
                </div>
                <div class="col-md-2">
                    <strong>Category:</strong>
                    <div>{{ $invoiceFitting->invoiceBom->product_category }}</div>
                </div>
                <div class="col-md-2">
                    <strong>Tanggal Dibuat:</strong>
                    <div>{{ $invoiceFitting->created_at->format('d M Y') }}</div>
                </div>
            </div>
        </div>

        <!-- Fitting Groups Detail -->
        @php
            $fittingData = json_decode($invoiceFitting->fitting_data, true);
            $groups = $fittingData['groups'] ?? [];
            $manualItems = $fittingData['manual_items'] ?? [];
        @endphp

        @foreach($groups as $groupIndex => $group)
        <div class="fitting-group-card mb-4">
            <div class="group-header-detail">
                <h6 class="group-title-detail">
                    <i class="fas fa-layer-group me-2"></i>
                    Fitting Group #{{ $groupIndex + 1 }} - <span class="badge bg-info">{{ $group['fitting_type'] }}</span>
                </h6>
            </div>
            
            <div class="table-responsive">
                <table class="table table-sm table-bordered table-hover">
                    <thead class="table-light">
                        <tr>
                            <th width="5%">No</th>
                            <th width="12%">Material Code</th>
                            <th>Material Description</th>
                            <th width="8%" class="text-center">Qty</th>
                            <th width="15%" class="text-end">Price/Unit</th>
                            <th width="15%" class="text-end">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($group['materials'] as $matIndex => $material)
                        <tr>
                            <td class="text-center">{{ $matIndex + 1 }}</td>
                            <td>
                                <code class="material-code-badge">{{ $material['material_code'] ?? 'N/A' }}</code>
                                {{-- ✅ Badge MANUAL --}}
                                @if(isset($material['is_manual']) && $material['is_manual'])
                                    <span class="badge bg-info text-white ms-1" style="font-size: 9px;">MANUAL</span>
                                @endif
                            </td>
                            <td class="material-desc-cell">{{ $material['material_description'] }}</td>
                            <td class="text-center"><span class="badge bg-secondary">{{ $material['qty'] }}</span></td>
                            <td class="text-end">{{ \App\Helpers\CasegoodHelper::formatRupiah($material['price']) }}</td>
                            <td class="text-end fw-bold text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($material['total']) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <td colspan="5" class="text-end fw-bold">
                                <i class="fas fa-calculator me-2"></i>Subtotal Group #{{ $groupIndex + 1 }}:
                            </td>
                            <td class="text-end fw-bold fs-5 text-primary">
                                {{ \App\Helpers\CasegoodHelper::formatRupiah($group['subtotal']) }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        @endforeach

        {{-- ✅ NEW: TAMBAHAN MANUAL (Standalone - Tanpa Group) --}}
        @if(!empty($manualItems))
        <div class="manual-items-card mb-4">
            <div class="group-header-detail">
                <h6 class="group-title-detail">
                    <i class="fas fa-edit me-2"></i>
                    TAMBAHAN MANUAL (Tanpa Group) - <span class="badge bg-info text-white">{{ count($manualItems) }} Item(s)</span>
                </h6>
            </div>
            
            <div class="table-responsive">
                <table class="table table-sm table-bordered table-hover">
                    <thead class="table-light">
                        <tr>
                            <th width="5%">No</th>
                            <th width="12%">Material Code</th>
                            <th>Material Description</th>
                            <th width="8%" class="text-center">Qty</th>
                            <th width="15%" class="text-end">Price/Unit</th>
                            <th width="15%" class="text-end">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($manualItems as $itemIndex => $item)
                        <tr class="manual-row">
                            <td class="text-center">{{ $itemIndex + 1 }}</td>
                            <td>
                                <code class="material-code-badge">{{ $item['material_code'] ?? 'N/A' }}</code>
                                <span class="badge bg-info text-white ms-1" style="font-size: 9px;">MANUAL</span>
                            </td>
                            <td class="material-desc-cell">{{ $item['material_description'] }}</td>
                            <td class="text-center"><span class="badge bg-secondary">{{ $item['qty'] }}</span></td>
                            <td class="text-end">{{ \App\Helpers\CasegoodHelper::formatRupiah($item['price']) }}</td>
                            <td class="text-end fw-bold text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($item['total']) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <td colspan="5" class="text-end fw-bold">
                                <i class="fas fa-calculator me-2"></i>Subtotal Tambahan Manual:
                            </td>
                            <td class="text-end fw-bold fs-5 text-primary">
                                @php
                                    $manualSubtotal = collect($manualItems)->sum('total');
                                @endphp
                                {{ \App\Helpers\CasegoodHelper::formatRupiah($manualSubtotal) }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        @endif

        <!-- Grand Total Card -->
        <div class="grand-total-card">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h5 class="mb-0 text-white">
                        <i class="fas fa-calculator me-2"></i>GRAND TOTAL FITTING
                    </h5>
                    <small class="text-white-50">
                        Total dari {{ count($groups) }} Group(s) 
                        @if(!empty($manualItems))
                            + {{ count($manualItems) }} Manual Item(s)
                        @endif
                    </small>
                </div>
                <div class="col-md-6 text-end">
                    <h2 class="mb-0 text-white fw-bold">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoiceFitting->grand_total) }}</h2>
                </div>
            </div>
        </div>

        <!-- Summary Stats -->
        <div class="row mt-4">
            <div class="col-md-3">
                <div class="stat-card stat-blue">
                    <div class="stat-icon">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Total Groups</div>
                        <div class="stat-value">{{ count($groups) }}</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card stat-info-color">
                    <div class="stat-icon">
                        <i class="fas fa-cog"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Total Materials</div>
                        <div class="stat-value">
                            @php
                                $totalMaterials = collect($groups)->sum(function($group) {
                                    return count($group['materials']);
                                });
                            @endphp
                            {{ $totalMaterials }}
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card stat-warning">
                    <div class="stat-icon">
                        <i class="fas fa-edit"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Manual Items</div>
                        <div class="stat-value">{{ count($manualItems) }}</div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card stat-success">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Grand Total</div>
                        <div class="stat-value">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoiceFitting->grand_total) }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-body {
    padding: 30px;
}

.section-title {
    font-weight: 700;
    color: #3498db;
    font-size: 16px;
    margin-bottom: 15px;
}

.info-section {
    background: linear-gradient(135deg, rgba(52, 152, 219, 0.1) 0%, rgba(41, 128, 185, 0.1) 100%);
    border: 2px solid rgba(52, 152, 219, 0.2);
    border-radius: 10px;
    padding: 20px;
}

.info-section strong {
    color: #666;
    font-size: 11px;
    text-transform: uppercase;
    display: block;
    margin-bottom: 5px;
}

.info-section div:not(strong) {
    color: #2c3e50;
    font-size: 15px;
    font-weight: 600;
}

.fitting-group-card {
    background: #fff;
    border: 2px solid #e9ecef;
    border-left: 5px solid #3498db;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

/* ✅ NEW: Manual Items Card */
.manual-items-card {
    background: #fff;
    border: 2px solid #17a2b8;
    border-left: 5px solid #3498db;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(52, 152, 219, 0.15);
}

.manual-row {
    background: rgba(52, 152, 219, 0.03);
}

.group-header-detail {
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 2px solid #f0f0f0;
}

.group-title-detail {
    font-size: 16px;
    font-weight: 700;
    color: #2c3e50;
    margin: 0;
}

.material-code-badge {
    background: #d1ecf1;
    padding: 4px 8px;
    border-radius: 4px;
    color: #0c5460;
    font-size: 11px;
    font-weight: 600;
}

.material-desc-cell {
    font-size: 13px;
    color: #2c3e50;
}

.table-sm {
    font-size: 13px;
}

.table-sm thead th {
    font-weight: 600;
    font-size: 12px;
    background: #f8f9fa;
}

.table-bordered {
    border: 2px solid #dee2e6;
}

.grand-total-card {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    color: white;
    border-radius: 12px;
    padding: 25px 30px;
    box-shadow: 0 4px 15px rgba(52, 152, 219, 0.3);
}

/* Stat Cards */
.stat-card {
    background: white;
    border-radius: 10px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    border-left: 4px solid;
}

.stat-blue {
    border-left-color: #3498db;
}

.stat-info-color {
    border-left-color: #17a2b8;
}

.stat-warning {
    border-left-color: #ffc107;
}

.stat-success {
    border-left-color: #28a745;
}

.stat-icon {
    font-size: 32px;
    color: #3498db;
    width: 60px;
    height: 60px;
    background: rgba(52, 152, 219, 0.1);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.stat-info-color .stat-icon {
    color: #17a2b8;
    background: rgba(23, 162, 184, 0.1);
}

.stat-warning .stat-icon {
    color: #ffc107;
    background: rgba(255, 193, 7, 0.1);
}

.stat-success .stat-icon {
    color: #28a745;
    background: rgba(40, 167, 69, 0.1);
}

.stat-info {
    flex: 1;
}

.stat-label {
    font-size: 12px;
    color: #666;
    text-transform: uppercase;
    font-weight: 600;
    margin-bottom: 5px;
}

.stat-value {
    font-size: 24px;
    font-weight: 700;
    color: #2c3e50;
}
</style>

@endsection