@extends('layouts.app')

@section('title', ($material ? 'Edit' : 'Tambah') . ' Material Solid - Cost Furniture')

@section('page-title', ($material ? 'Edit' : 'Tambah') . ' Material Solid')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card modern-card">
            <div class="card-header">
                <h5>
                    <i class="fas fa-{{ $material ? 'edit' : 'plus-circle' }}"></i> 
                    {{ $material ? 'Edit' : 'Tambah' }} Material Solid
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ $material ? route('material.solid.update', $material->id) : route('material.solid.store') }}" method="POST">
                    @csrf
                    @if($material)
                        @method('PUT')
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Material Name <span class="text-danger">*</span></label>
                        <input type="text" 
                               name="material_name" 
                               class="form-control @error('material_name') is-invalid @enderror" 
                               value="{{ old('material_name', $material->material_name ?? '') }}"
                               placeholder="Contoh: CLEAT"
                               required>
                        @error('material_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price" 
                               class="form-control @error('price') is-invalid @enderror" 
                               value="{{ old('price', $material->price ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 1000"
                               required>
                        @error('price')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga dalam Rupiah</small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ $material ? 'Update' : 'Simpan' }}
                        </button>
                        <a href="{{ route('material.solid.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}
</style>
@endsection