@extends('layouts.app')

@section('title', ($panel ? 'Edit' : 'Tambah') . ' Product Panel - Cost Furniture')

@section('page-title', ($panel ? 'Edit' : 'Tambah') . ' Product Panel')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card modern-card">
            <div class="card-header">
                <h5>
                    <i class="fas fa-{{ $panel ? 'edit' : 'plus-circle' }}"></i> 
                    {{ $panel ? 'Edit' : 'Tambah' }} Product Panel
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ $panel ? route('product.panel.update', $panel->id) : route('product.panel.store') }}" method="POST">
                    @csrf
                    @if($panel)
                        @method('PUT')
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Panel Type <span class="text-danger">*</span></label>
                        <select name="panel_type" class="form-select @error('panel_type') is-invalid @enderror" required>
                            <option value="">-- Pilih Panel Type --</option>
                            <option value="PB" {{ old('panel_type', $panel->panel_type ?? '') == 'PB' ? 'selected' : '' }}>PB</option>
                            <option value="MDF" {{ old('panel_type', $panel->panel_type ?? '') == 'MDF' ? 'selected' : '' }}>MDF</option>
                            <option value="PLYWOOD" {{ old('panel_type', $panel->panel_type ?? '') == 'PLYWOOD' ? 'selected' : '' }}>PLYWOOD</option>
                        </select>
                        @error('panel_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Thickness (mm) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="thickness" 
                               class="form-control @error('thickness') is-invalid @enderror" 
                               value="{{ old('thickness', $panel->thickness ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 15"
                               required>
                        @error('thickness')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price (per M2) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price" 
                               class="form-control @error('price') is-invalid @enderror" 
                               value="{{ old('price', $panel->price ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 88000"
                               required>
                        @error('price')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga dalam Rupiah per meter persegi</small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ $panel ? 'Update' : 'Simpan' }}
                        </button>
                        <a href="{{ route('product.panel.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}
</style>
@endsection