@extends('layouts.app')

@section('title', 'Product Pendukung Box - Cost Furniture')

@section('page-title', 'Product Pendukung Box')

@section('content')

<!-- Success Message -->
@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-boxes me-2"></i>Daftar Product Pendukung Box</h5>
        <a href="{{ route('product.pendukung-box.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Tambah Product
        </a>
    </div>
    <div class="card-body">
        @if($products->isEmpty())
        <div class="text-center py-5">
            <i class="fas fa-box-open fa-4x text-muted mb-3"></i>
            <p class="text-muted">Belum ada product pendukung box.</p>
            <a href="{{ route('product.pendukung-box.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Tambah Product Pertama
            </a>
        </div>
        @else
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-header">
                    <tr>
                        <th width="5%">No</th>
                        <th width="12%">Material Code</th>
                        <th width="25%">Description</th>
                        <th width="8%">Tipe</th>
                        <th width="10%">Harga Asli</th>
                        <th width="8%">Lebar</th>
                        <th width="8%">Panjang</th>
                        <th width="8%">M²</th>
                        <th width="10%">Harga/M²</th>
                        <th width="10%">Harga Finished</th>
                        <th width="10%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $index => $product)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td><span class="badge bg-primary">{{ $product->material_code }}</span></td>
                        <td>{{ $product->description }}</td>
                        <td>
                            @if($product->pricing_type === 'pcs')
                                <span class="badge bg-success">Harga PCS</span>
                            @else
                                <span class="badge bg-info">Harga M2</span>
                            @endif
                        </td>
                        <td>{{ \App\Helpers\CasegoodHelper::formatRupiah($product->harga_asli) }}</td>
                        <td>{{ $product->lebar ? number_format($product->lebar, 0) : '-' }}</td>
                        <td>{{ $product->panjang ? number_format($product->panjang, 0) : '-' }}</td>
                        <td>{{ $product->m2 ? number_format($product->m2, 2) : '-' }}</td>
                        <td>
                            @if($product->pricing_type === 'm2' && $product->harga_m2)
                                {{ \App\Helpers\CasegoodHelper::formatRupiah($product->harga_m2) }}
                            @else
                                -
                            @endif
                        </td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($product->harga_finished) }}</strong></td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('product.pendukung-box.edit', $product->id) }}" class="btn btn-sm btn-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('product.pendukung-box.destroy', $product->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Yakin ingin menghapus?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @endif
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
}

.table-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white;
}

.table-header th {
    color: white;
    font-weight: 600;
    border: none;
}

.table-hover tbody tr:hover {
    background-color: rgba(243, 156, 18, 0.05);
}
</style>

@endsection