<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Product\ProductPanelController;
use App\Http\Controllers\Product\ProductSolidController;
use App\Http\Controllers\Product\ProductVeneerController;
use App\Http\Controllers\Product\ProductDrawerController;
use App\Http\Controllers\Product\MaterialSolidController;
use App\Http\Controllers\Invoice\InvoiceBomController;
use App\Http\Controllers\Invoice\InvoiceHardwareController;
use App\Http\Controllers\Invoice\InvoiceFittingController;
use App\Http\Controllers\Invoice\InvoiceHandleController;
use App\Http\Controllers\Invoice\InvoiceStoneController;
use App\Http\Controllers\Invoice\InvoiceMetalController;
use App\Http\Controllers\Invoice\InvoiceUkirController;
use App\Http\Controllers\Product\ProductPendukungBoxController;
use App\Http\Controllers\Invoice\InvoiceBoxController;

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/
Route::middleware('guest')->group(function () {
    Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
});

/*
|--------------------------------------------------------------------------
| Protected Routes (Requires Authentication)
|--------------------------------------------------------------------------
*/
Route::middleware('auth.check')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
    
    // Product Panel
    Route::prefix('product/panel')->name('product.panel.')->group(function () {
        Route::get('/', [ProductPanelController::class, 'index'])->name('index');
        Route::get('/create', [ProductPanelController::class, 'create'])->name('create');
        Route::post('/store', [ProductPanelController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ProductPanelController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProductPanelController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProductPanelController::class, 'destroy'])->name('destroy');
    });
    
    // Product Solid
    Route::prefix('product/solid')->name('product.solid.')->group(function () {
        Route::get('/', [ProductSolidController::class, 'index'])->name('index');
        Route::get('/create', [ProductSolidController::class, 'create'])->name('create');
        Route::post('/store', [ProductSolidController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ProductSolidController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProductSolidController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProductSolidController::class, 'destroy'])->name('destroy');
    });
    
    // Product Veneer
    Route::prefix('product/veneer')->name('product.veneer.')->group(function () {
        Route::get('/', [ProductVeneerController::class, 'index'])->name('index');
        Route::get('/create', [ProductVeneerController::class, 'create'])->name('create');
        Route::post('/store', [ProductVeneerController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ProductVeneerController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProductVeneerController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProductVeneerController::class, 'destroy'])->name('destroy');
    });
    
    // Product Drawer
    Route::prefix('product/drawer')->name('product.drawer.')->group(function () {
        Route::get('/', [ProductDrawerController::class, 'index'])->name('index');
        Route::get('/create', [ProductDrawerController::class, 'create'])->name('create');
        Route::post('/store', [ProductDrawerController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ProductDrawerController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProductDrawerController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProductDrawerController::class, 'destroy'])->name('destroy');
    });
    
    // Material Solid
    Route::prefix('material/solid')->name('material.solid.')->group(function () {
        Route::get('/', [MaterialSolidController::class, 'index'])->name('index');
        Route::get('/create', [MaterialSolidController::class, 'create'])->name('create');
        Route::post('/store', [MaterialSolidController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [MaterialSolidController::class, 'edit'])->name('edit');
        Route::put('/{id}', [MaterialSolidController::class, 'update'])->name('update');
        Route::delete('/{id}', [MaterialSolidController::class, 'destroy'])->name('destroy');
    });
    // ============================================
    // Product Pendukung Box Routes
    // ============================================
    Route::prefix('product/pendukung-box')->name('product.pendukung-box.')->group(function () {
        Route::get('/', [ProductPendukungBoxController::class, 'index'])->name('index');
        Route::get('/create', [ProductPendukungBoxController::class, 'create'])->name('create');
        Route::post('/store', [ProductPendukungBoxController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ProductPendukungBoxController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ProductPendukungBoxController::class, 'update'])->name('update');
        Route::delete('/{id}', [ProductPendukungBoxController::class, 'destroy'])->name('destroy');
    });
    // ============================================
    // Invoice BOM Routes
    // ============================================
    Route::prefix('invoice/bom')->name('invoice.bom.')->group(function () {
        // ✅ Painting Cost Routes (MUST BE FIRST - BEFORE OTHER ROUTES)
        Route::post('{id}/save-painting', [InvoiceBomController::class, 'savePainting'])->name('save-painting');
        Route::get('{id}/get-painting', [InvoiceBomController::class, 'getPainting'])->name('get-painting');
        
        // Draft System Routes
        Route::post('save-draft', [InvoiceBomController::class, 'saveDraft'])->name('save-draft');
        Route::get('get-draft', [InvoiceBomController::class, 'getDraft'])->name('get-draft');
        Route::post('clear-draft', [InvoiceBomController::class, 'clearDraft'])->name('clear-draft');
        
        // Status Routes (Fix/Unfix)
        Route::post('{id}/fix', [InvoiceBomController::class, 'fix'])->name('fix');
        Route::post('{id}/unfix', [InvoiceBomController::class, 'unfix'])->name('unfix');
        
        // Print Routes
        Route::get('{id}/print', [InvoiceBomController::class, 'print'])->name('print');
        Route::get('{id}/print-hpp', [InvoiceBomController::class, 'printHpp'])->name('print.hpp');
        
        // AJAX Routes
        Route::post('get-product-data', [InvoiceBomController::class, 'getProductData'])->name('getProductData');
        
        // Main CRUD Routes (MUST BE LAST - TO AVOID CONFLICTS)
        Route::get('/', [InvoiceBomController::class, 'index'])->name('index');
        Route::get('create', [InvoiceBomController::class, 'create'])->name('create');
        Route::post('store', [InvoiceBomController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceBomController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceBomController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceBomController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceBomController::class, 'destroy'])->name('destroy');
    });
    
    // ============================================
    // Invoice Hardware Routes
    // ============================================
    Route::prefix('invoice/hardware')->name('invoice.hardware.')->group(function () {
        // AJAX Routes
        Route::post('get-hardware-by-type', [InvoiceHardwareController::class, 'getHardwareByType'])->name('getHardwareByType');
        
        // Main CRUD Routes
        Route::get('/', [InvoiceHardwareController::class, 'index'])->name('index');
        Route::get('create', [InvoiceHardwareController::class, 'create'])->name('create');
        Route::post('store', [InvoiceHardwareController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceHardwareController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceHardwareController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceHardwareController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceHardwareController::class, 'destroy'])->name('destroy');
    });
    
    // ============================================
    // Invoice Fitting Routes
    // ============================================
    Route::prefix('invoice/fitting')->name('invoice.fitting.')->group(function () {
        // AJAX Routes
        Route::post('get-fitting-by-type', [InvoiceFittingController::class, 'getFittingByType'])->name('getFittingByType');
        
        // Main CRUD Routes
        Route::get('/', [InvoiceFittingController::class, 'index'])->name('index');
        Route::get('create', [InvoiceFittingController::class, 'create'])->name('create');
        Route::post('store', [InvoiceFittingController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceFittingController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceFittingController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceFittingController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceFittingController::class, 'destroy'])->name('destroy');
    });
    // ============================================
    // Invoice Handle Routes
    // ============================================
    Route::prefix('invoice/handle')->name('invoice.handle.')->group(function () {
        // Main CRUD Routes
        Route::get('/', [InvoiceHandleController::class, 'index'])->name('index');
        Route::get('create', [InvoiceHandleController::class, 'create'])->name('create');
        Route::post('store', [InvoiceHandleController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceHandleController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceHandleController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceHandleController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceHandleController::class, 'destroy'])->name('destroy');
    });
    
    // ============================================
    // Invoice Stone Routes
    // ============================================
    Route::prefix('invoice/stone')->name('invoice.stone.')->group(function () {
        // Main CRUD Routes
        Route::get('/', [InvoiceStoneController::class, 'index'])->name('index');
        Route::get('create', [InvoiceStoneController::class, 'create'])->name('create');
        Route::post('store', [InvoiceStoneController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceStoneController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceStoneController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceStoneController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceStoneController::class, 'destroy'])->name('destroy');
    });
    
    // ============================================
    // Invoice Metal Routes
    // ============================================
    Route::prefix('invoice/metal')->name('invoice.metal.')->group(function () {
        // Main CRUD Routes
        Route::get('/', [InvoiceMetalController::class, 'index'])->name('index');
        Route::get('create', [InvoiceMetalController::class, 'create'])->name('create');
        Route::post('store', [InvoiceMetalController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceMetalController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceMetalController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceMetalController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceMetalController::class, 'destroy'])->name('destroy');
    });
    
    // ============================================
    // Invoice Ukir/Bubut Routes
    // ============================================
    Route::prefix('invoice/ukir')->name('invoice.ukir.')->group(function () {
        // Main CRUD Routes
        Route::get('/', [InvoiceUkirController::class, 'index'])->name('index');
        Route::get('create', [InvoiceUkirController::class, 'create'])->name('create');
        Route::post('store', [InvoiceUkirController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceUkirController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceUkirController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceUkirController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceUkirController::class, 'destroy'])->name('destroy');
    });
    // ============================================
    // Invoice Box Routes
    // ============================================
    Route::prefix('invoice/box')->name('invoice.box.')->group(function () {
        // Main CRUD Routes
        Route::get('/', [InvoiceBoxController::class, 'index'])->name('index');
        Route::get('create', [InvoiceBoxController::class, 'create'])->name('create');
        Route::post('store', [InvoiceBoxController::class, 'store'])->name('store');
        Route::get('{id}', [InvoiceBoxController::class, 'show'])->name('show');
        Route::get('{id}/edit', [InvoiceBoxController::class, 'edit'])->name('edit');
        Route::put('{id}', [InvoiceBoxController::class, 'update'])->name('update');
        Route::delete('{id}', [InvoiceBoxController::class, 'destroy'])->name('destroy');
        
        // Print Route
        Route::get('{id}/print', [InvoiceBoxController::class, 'print'])->name('print');
    });
});
