<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Color Panel System - Kayu Mebel Indonesia</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #ffffff;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 30px;
        }

        .header {
            text-align: center;
            margin: 50px 0 80px 0;
        }

        .logo {
            width: 150px;
            height: 150px;
            object-fit: contain;
            margin-bottom: 25px;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.1));
        }

        .company-name {
            font-size: 42px;
            font-weight: 700;
            color: #1a1a1a;
            margin-bottom: 12px;
            letter-spacing: 1.5px;
        }

        .system-name {
            font-size: 22px;
            font-weight: 400;
            color: #666;
            letter-spacing: 3px;
            text-transform: uppercase;
        }

        .container {
            display: flex;
            gap: 60px;
            flex-wrap: wrap;
            justify-content: center;
            max-width: 1400px;
            width: 100%;
        }

        .card {
            background: #ffffff;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.12);
            padding: 50px 40px;
            width: 420px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid #f0f0f0;
            text-decoration: none;
            color: inherit;
            display: block;
        }

        .card:hover {
            transform: translateY(-12px);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.18);
            border-color: #007acc;
        }

        .card-image-wrapper {
            margin-bottom: 30px;
            padding: 10px;
        }

        .card-image {
            width: 100%;
            height: 280px;
            object-fit: contain;
            border-radius: 16px;
            background: #f8f8f8;
            padding: 20px;
        }

        .card:hover .card-image {
            transform: scale(1.05);
            transition: transform 0.3s ease;
        }

        .card-title {
            font-size: 36px;
            font-weight: 700;
            color: #1a1a1a;
            margin-bottom: 15px;
            letter-spacing: 0.5px;
        }

        .card-subtitle {
            font-size: 16px;
            color: #888;
            margin-bottom: 30px;
        }

        .card-button {
            background: linear-gradient(135deg, #007acc 0%, #005a9e 100%);
            color: white;
            padding: 16px 48px;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s ease;
        }

        .card:hover .card-button {
            background: linear-gradient(135deg, #005a9e 0%, #004578 100%);
            transform: scale(1.08);
            box-shadow: 0 5px 15px rgba(0, 122, 204, 0.3);
        }

        .footer {
            margin-top: 80px;
            text-align: center;
            color: #999;
            font-size: 15px;
        }

        @media (max-width: 968px) {
            .container {
                gap: 40px;
            }

            .card {
                width: 100%;
                max-width: 420px;
            }
        }

        @media (max-width: 768px) {
            .logo {
                width: 120px;
                height: 120px;
            }

            .company-name {
                font-size: 28px;
            }

            .system-name {
                font-size: 16px;
            }

            .card {
                padding: 40px 30px;
            }

            .card-image {
                height: 220px;
            }

            .card-title {
                font-size: 30px;
            }

            .card-button {
                padding: 14px 40px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Perusahaan" class="logo">
        <div class="company-name">KAYU MEBEL INDONESIA</div>
        <div class="system-name">Color Panel System</div>
    </div>

    <div class="container">
        <a href="https://pawindo.site/Panel_Color_Semarang" class="card">
            <div class="card-image-wrapper">
                <img src="semarang.png" alt="Semarang" class="card-image">
            </div>
            <div class="card-title">Semarang</div>
            <div class="card-subtitle">Cabang Semarang</div>
            <div class="card-button">Login Semarang</div>
        </a>

        <a href="https://pawindo.site/Panel_Color_Surabaya" class="card">
            <div class="card-image-wrapper">
                <img src="surabaya.png" alt="Surabaya" class="card-image">
            </div>
            <div class="card-title">Surabaya</div>
            <div class="card-subtitle">Cabang Surabaya</div>
            <div class="card-button">Login Surabaya</div>
        </a>
    </div>

    <div class="footer">
        &copy; 2025 Kayu Mebel Indonesia. All rights reserved.
    </div>
</body>
</html>