<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not admin
if (!is_logged_in() || !is_user_type('admin')) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Get buyer ID from POST request
$buyer_id = isset($_POST['buyer_id']) ? intval($_POST['buyer_id']) : 0;

if (!$buyer_id) {
    echo json_encode([]);
    exit();
}

// Query to get color codes for the specified buyer
$query = "
    SELECT 
        id, code_color, deskripsi
    FROM 
        master_color_panel_semarang
    WHERE 
        buyer_id = ?
    ORDER BY 
        code_color
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $buyer_id);
$stmt->execute();
$result = $stmt->get_result();

$colors = [];
while ($row = $result->fetch_assoc()) {
    $colors[] = $row;
}

$stmt->close();

// Return colors as JSON
header('Content-Type: application/json');
echo json_encode($colors);
?>