<!-- profile_admin.php -->
<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not admin - using functions from connection.php
if (!is_logged_in() || !is_user_type('admin')) {
    header("Location: ../login.php");
    exit();
}

// Get admin data
$admin_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM admin_users_semarang WHERE id = ?");
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$admin_data = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Check if account is active, redirect to logout if not
if ($admin_data['status'] == 'nonactive') {
    // Log this attempt
    error_log("Nonactive admin attempted to access profile: " . $_SESSION['username']);
    
    // Clear all session variables
    $_SESSION = array();
    
    // Destroy the session
    session_destroy();
    
    // Redirect to login with message
    header("Location: ../login.php?error=inactive");
    exit();
}

// Set page title
$page_title = "Profil Admin";

// Log activity (if log_activity function still exists)
if (function_exists('log_activity')) {
    log_activity($conn, $admin_id, 'admin', 'Profile Access', 'Admin accessed their profile');
}

// Include header
include '../template_admin/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-blue-100 via-teal-100 to-green-100">
    <!-- Welcome Card -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Selamat Datang di Master Color Panel</h2>
        
        <div class="border-t border-gray-200 pt-4">
            <h3 class="text-lg font-semibold text-gray-700 mb-3">Info Anda:</h3>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-3">
                        <i class="fas fa-user text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($admin_data['username']); ?></p>
                    </div>
                </div>
                
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-envelope text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($admin_data['email']); ?></p>
                    </div>
                </div>
                
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-<?php echo $admin_data['status'] == 'active' ? 'green' : 'red'; ?>-100 text-<?php echo $admin_data['status'] == 'active' ? 'green' : 'red'; ?>-500 mr-3">
                        <i class="fas fa-user-check text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <p class="text-lg font-medium text-<?php echo $admin_data['status'] == 'active' ? 'green' : 'red'; ?>-500"><?php echo ucfirst($admin_data['status']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Profile Details -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-6">Detail Profil Admin</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-lg font-medium text-gray-700 mb-4">Informasi Akun</h4>
                
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500">ID Admin</p>
                        <p class="font-medium text-gray-800"><?php echo $admin_data['id']; ?></p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="font-medium text-gray-800"><?php echo htmlspecialchars($admin_data['username']); ?></p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="font-medium text-gray-800"><?php echo htmlspecialchars($admin_data['email']); ?></p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Status Akun</p>
                        <p class="font-medium text-<?php echo $admin_data['status'] == 'active' ? 'green' : 'red'; ?>-500">
                            <?php echo ucfirst($admin_data['status']); ?>
                        </p>
                    </div>
                </div>
            </div>
            
            <div>
                <h4 class="text-lg font-medium text-gray-700 mb-4">Hak Akses</h4>
                
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500">Tipe Pengguna</p>
                        <p class="font-medium text-gray-800">Admin</p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Lokasi</p>
                        <p class="font-medium text-gray-800">Color Room</p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Login Terakhir</p>
                        <p class="font-medium text-gray-800">
                            <?php
                            if ($admin_data['last_login'] && $admin_data['last_login'] != '0000-00-00 00:00:00') {
                                echo date('d M Y, H:i:s', strtotime($admin_data['last_login']));
                            } else {
                                echo "Belum ada login sebelumnya";
                            }
                            ?>
                        </p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Akun Dibuat</p>
                        <p class="font-medium text-gray-800">
                            <?php
                            if ($admin_data['created_at']) {
                                echo date('d M Y, H:i:s', strtotime($admin_data['created_at']));
                            } else {
                                echo "Tidak ada data";
                            }
                            ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../template_admin/footer.php'; ?>