<!-- profile_it.php -->
<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not IT user - using functions from connection.php
if (!is_logged_in() || !is_user_type('it')) {
    header("Location: ../login.php");
    exit();
}

// Get IT user data
$it_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM it_users_semarang WHERE id = ?");
$stmt->bind_param("i", $it_id);
$stmt->execute();
$it_data = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Set page title
$page_title = "Profil IT";

// Log activity using audit_logs_semarang
create_audit_log($conn, 'Profile Access', $it_id, 'it', 'IT user accessed their profile');

// Include header
include '../template_it/header.php';
?>

<!-- Main Content Area -->
<main class="flex-1 p-6 overflow-auto bg-gradient-to-br from-blue-100 via-teal-100 to-green-100">
    <!-- Welcome Card -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Selamat Datang di Master Color Panel</h2>
        
        <div class="border-t border-gray-200 pt-4">
            <h3 class="text-lg font-semibold text-gray-700 mb-3">Info Anda:</h3>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-3">
                        <i class="fas fa-user text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($it_data['username']); ?></p>
                    </div>
                </div>
                
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-envelope text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="text-lg font-medium text-gray-800"><?php echo htmlspecialchars($it_data['email']); ?></p>
                    </div>
                </div>
                
                <div class="flex items-center">
                    <div class="p-3 rounded-full bg-green-100 text-green-500 mr-3">
                        <i class="fas fa-user-check text-xl"></i>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <p class="text-lg font-medium text-green-500">Active</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Profile Details -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-6">Detail Profil IT Support</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-lg font-medium text-gray-700 mb-4">Informasi Akun</h4>
                
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500">ID IT</p>
                        <p class="font-medium text-gray-800"><?php echo $it_data['id']; ?></p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Username</p>
                        <p class="font-medium text-gray-800"><?php echo htmlspecialchars($it_data['username']); ?></p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="font-medium text-gray-800"><?php echo htmlspecialchars($it_data['email']); ?></p>
                    </div>
                </div>
            </div>
            
            <div>
                <h4 class="text-lg font-medium text-gray-700 mb-4">Hak Akses</h4>
                
                <div class="space-y-4">
                    <div>
                        <p class="text-sm text-gray-500">Tipe Pengguna</p>
                        <p class="font-medium text-gray-800">IT Support</p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Lokasi</p>
                        <p class="font-medium text-gray-800">IT Department</p>
                    </div>
                    
                    <div>
                        <p class="text-sm text-gray-500">Login Terakhir</p>
                        <p class="font-medium text-gray-800">
                            <?php
                            // Get last login time from audit_logs_semarang instead of audit_logs_semarang
                            $login_stmt = $conn->prepare("
                                SELECT timestamp 
                                FROM audit_logs_semarang 
                                WHERE user_id = ? AND user_type = 'it' AND action_type = 'Login'
                                ORDER BY timestamp DESC 
                                LIMIT 1
                            ");
                            $login_stmt->bind_param("i", $it_id);
                            $login_stmt->execute();
                            $login_result = $login_stmt->get_result();
                            
                            if ($login_row = $login_result->fetch_assoc()) {
                                echo date('d M Y, H:i:s', strtotime($login_row['timestamp']));
                            } else {
                                echo "Tidak ada data";
                            }
                            
                            $login_stmt->close();
                            ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../template_it/footer.php'; ?>