<?php
// Start session
session_start();

// Include database connection
require_once "../config/connection.php";

// Redirect if not borrower user
if (!is_logged_in() || !is_user_type('borrower')) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Validate input
if (!isset($_GET['collection_semarang_id']) || empty($_GET['collection_semarang_id'])) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'collection_semarang ID is required']);
    exit();
}

$collection_semarang_id = intval($_GET['collection_semarang_id']);

// Fetch color codes for the selected collection_semarang
$stmt = $conn->prepare("
    SELECT id, code_color, deskripsi, status, kode_warna_hex 
    FROM master_color_panel_semarang 
    WHERE collection_semarang_id = ?
    ORDER BY code_color
");
$stmt->bind_param("i", $collection_semarang_id);
$stmt->execute();
$result = $stmt->get_result();

$colors = [];
while ($row = $result->fetch_assoc()) {
    $colors[] = $row;
}

$stmt->close();

// Return colors as JSON
header('Content-Type: application/json');
echo json_encode($colors);
?>