<?php
session_start();
require_once "../config/connection.php";

// Check if user is logged in as IT
if (!is_logged_in() || !is_user_type('it')) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

header('Content-Type: application/json');

try {
    // Get all components
    $query = "SELECT id, component_name, description FROM color_components_surabaya ORDER BY component_name";
    $result = $conn->query($query);
    
    $components = [];
    while ($row = $result->fetch_assoc()) {
        $components[] = $row;
    }
    
    echo json_encode([
        'success' => true,
        'components' => $components
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>