<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('item_requests', function (Blueprint $t) {
      $t->id();
      $t->foreignId('company_id')->constrained()->cascadeOnDelete();
      $t->foreignId('requester_id')->constrained('users')->cascadeOnDelete();
      $t->foreignId('flow_template_id')->constrained('approval_flow_templates');
      $t->timestamp('requested_at')->useCurrent();
      $t->date('posting_date')->nullable();
      $t->string('status')->default('Draft'); // Draft, Submitted, InReview, Approved, Rejected, Cancelled
      $t->unsignedInteger('current_step_no')->nullable();
      $t->text('remarks')->nullable();
      $t->timestamps();
    });
  }
  public function down(): void { Schema::dropIfExists('item_requests'); }
};
