
<?php $__env->startSection('title','Admin — Users Management'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .pill { border-radius: 999px; }
    .card-rounded { border-radius: 1rem; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">

    
    <?php if(session('success')): ?>
        <div class="alert alert-success"><i class="fa fa-check-circle me-1"></i><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i><?php echo e($errors->first()); ?></div>
    <?php endif; ?>

    
    <a id="users"></a>

    
    <div class="card card-rounded mb-3">
        <div class="card-header bg-primary text-white">
            <i class="fa fa-user-plus me-1"></i> Add / Upsert User
        </div>
        <div class="card-body">
            <form class="row g-3" method="POST" action="<?php echo e(route('admin.users.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="col-md-3">
                    <label class="form-label">Name</label>
                    <input name="name" class="form-control" placeholder="Full name" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Email</label>
                    <input name="email" type="email" class="form-control" placeholder="user@yourtenant.onmicrosoft.com" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Notification Email(s) <small class="text-muted">(optional)</small></label>
                    <input name="notify_email" type="text" class="form-control"
                           placeholder="alt@company.com, second@company.com">
                    <div class="form-text">Separate multiple with comma/semicolon/space.</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Role</label>
                    <select name="role_id" class="form-select">
                        <option value="">(none)</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($r->id); ?>"><?php echo e($r->code); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Companies</label>
                    <select name="company_ids[]" class="form-select" multiple>
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($c->id); ?>"><?php echo e($c->code); ?> — <?php echo e($c->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="form-text">Hold Ctrl/Cmd to pick multiple.</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Company Codes (opt)</label>
                    <input name="company_codes" class="form-control" placeholder="e.g. CI, TBI">
                </div>
                <div class="col-12">
                    <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
                </div>
            </form>
            <div class="small text-muted mt-2">
                Users log in via Microsoft; adding them here just pre-creates the row and assigns a role.
            </div>
        </div>
    </div>

    
    <div class="card card-rounded">
        <div class="card-header bg-secondary text-white">
            <i class="fa fa-users me-1"></i> Users
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Notify Email</th>
                            <th>Company</th>
                            <th>Role</th>
                            <th>Change Role</th>
                            <th>Edit</th>
                            <th style="width:70px">Del</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($u->id); ?></td>
                                <td><?php echo e($u->name); ?></td>
                                <td class="small text-muted"><?php echo e($u->email); ?></td>
                                <td class="small text-muted"><?php echo e($u->notify_email ?: '—'); ?></td>
                                <td class="small">
                                    <?php $codes = $u->companies()->pluck('code')->all(); ?>
                                    <?php echo e(empty($codes) ? '—' : implode(', ', $codes)); ?>

                                </td>
                                <td><span class="badge bg-dark"><?php echo e($u->role?->code ?? '—'); ?></span></td>

                                
                                <td>
                                    <form class="d-flex gap-2" method="POST" action="<?php echo e(route('admin.users.updateRole',$u)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <select name="role_id" class="form-select form-select-sm" style="max-width:200px">
                                            <option value="">(none)</option>
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($r->id); ?>" <?php echo e($u->role_id===$r->id?'selected':''); ?>>
                                                    <?php echo e($r->code); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                                    </form>
                                </td>

                                
                                <td>
                                    <form class="d-flex flex-wrap gap-2 align-items-center"
                                          method="POST" action="<?php echo e(route('admin.users.update', $u)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>

                                        <input name="name" class="form-control form-control-sm" style="max-width:180px"
                                               value="<?php echo e(old('name',$u->name)); ?>">

                                        <input name="notify_email" class="form-control form-control-sm" style="max-width:240px"
                                               placeholder="alt1@x.com, alt2@x.com"
                                               value="<?php echo e(old('notify_email',$u->notify_email)); ?>">

                                        <select name="company_ids[]" class="form-select form-select-sm" style="max-width:260px" multiple>
                                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($c->id); ?>" <?php echo e($u->companies->contains('id', $c->id) ? 'selected' : ''); ?>>
                                                    <?php echo e($c->code); ?> — <?php echo e($c->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <input name="company_codes" class="form-control form-control-sm" style="max-width:200px"
                                               placeholder="CI, TBI" value="<?php echo e(old('company_codes', $u->company_codes)); ?>">

                                        <select name="role_id" class="form-select form-select-sm" style="max-width:180px">
                                            <option value="">(none)</option>
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($r->id); ?>" <?php echo e($u->role_id===$r->id?'selected':''); ?>>
                                                    <?php echo e($r->code); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                                    </form>
                                </td>

                                
                                <td>
                                    <form method="POST" action="<?php echo e(route('admin.users.destroy',$u)); ?>"
                                          onsubmit="return confirm('Delete this user?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($users->withQueryString()->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\agusy\OneDrive\Dokumen\Kerjaan\Pastry\resources\views/admin/index.blade.php ENDPATH**/ ?>