<?php
require_once '../config/connection.php';
checkUserType(['admin']);

// Get admin's master organization
$stmt = $pdo->prepare("
    SELECT id, master_organization_id, organization, full_name
    FROM admins 
    WHERE id = ?
");
$stmt->execute([$_SESSION['user_id']]);
$admin_data = $stmt->fetch();

if (!$admin_data) {
    die("Error: Data admin tidak ditemukan. Silakan login ulang.");
}

$admin_master_org_id = $admin_data['master_organization_id'];

// Get essential stats only - FILTERED BY MASTER ORGANIZATION
if ($admin_master_org_id) {
    // Pending count - only from same master organization
    $stmt = $pdo->prepare("
        SELECT COUNT(*) as pending 
        FROM borrow_history bh
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'pending_approval'
        AND b.master_organization_id = ?
    ");
    $stmt->execute([$admin_master_org_id]);
    $pending_count = $stmt->fetch()['pending'];

    // Active count - only from same master organization
    $stmt = $pdo->prepare("
        SELECT COUNT(*) as active 
        FROM borrow_history bh
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'borrowed'
        AND b.master_organization_id = ?
    ");
    $stmt->execute([$admin_master_org_id]);
    $active_count = $stmt->fetch()['active'];
} else {
    // Fallback: show all if no master org
    $stmt = $pdo->prepare("SELECT COUNT(*) as pending FROM borrow_history WHERE status = 'pending_approval'");
    $stmt->execute();
    $pending_count = $stmt->fetch()['pending'];

    $stmt = $pdo->prepare("SELECT COUNT(*) as active FROM borrow_history WHERE status = 'borrowed'");
    $stmt->execute();
    $active_count = $stmt->fetch()['active'];
}

// Total assets and available assets (not filtered by master org)
$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM assets");
$stmt->execute();
$total_assets = $stmt->fetch()['total'];

$stmt = $pdo->prepare("SELECT COUNT(*) as available FROM assets WHERE status_borrower = 'available' AND kondisi != 'hilang'");
$stmt->execute();
$available_assets = $stmt->fetch()['available'];

// Get recent pending requests (last 3) - FILTERED BY MASTER ORGANIZATION
$recent_pending = [];
if ($admin_master_org_id) {
    $stmt = $pdo->prepare("
        SELECT bh.*, a.asset_name, a.asset_number, b.full_name as borrower_name,
               DATEDIFF(CURDATE(), bh.created_at) as days_pending
        FROM borrow_history bh 
        JOIN assets a ON bh.asset_id = a.id 
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'pending_approval'
        AND b.master_organization_id = ?
        ORDER BY bh.created_at DESC 
        LIMIT 3
    ");
    $stmt->execute([$admin_master_org_id]);
    $recent_pending = $stmt->fetchAll();
} else {
    $stmt = $pdo->prepare("
        SELECT bh.*, a.asset_name, a.asset_number, b.full_name as borrower_name,
               DATEDIFF(CURDATE(), bh.created_at) as days_pending
        FROM borrow_history bh 
        JOIN assets a ON bh.asset_id = a.id 
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'pending_approval'
        ORDER BY bh.created_at DESC 
        LIMIT 3
    ");
    $stmt->execute();
    $recent_pending = $stmt->fetchAll();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Tools Room</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'leaf-green': '#90EE90',
                        'dark-leaf': '#32CD32',
                        'soft-gray': '#F5F5F5'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-soft-gray min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm border-b-2 border-leaf-green">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-4">
                    <img src="../images/logo.png" alt="Logo" class="h-10 w-10" onerror="this.style.display='none'">
                    <div>
                        <h1 class="text-xl font-bold text-gray-800">Tools Room Admin</h1>
                        <p class="text-sm text-gray-500">Dashboard</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-600"><?php echo $_SESSION['user_name']; ?></span>
                    <a href="../logout.php" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                        Logout
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Welcome Section -->
        <div class="bg-gradient-to-r from-leaf-green to-dark-leaf rounded-xl p-6 mb-8 text-white">
            <h2 class="text-2xl font-bold mb-2">Selamat Datang, <?php echo $_SESSION['user_name']; ?>!</h2>
            <p class="opacity-90">Kelola peminjaman dan monitoring asset dengan mudah</p>
            <?php if ($admin_master_org_id): ?>
            <p class="text-sm opacity-75 mt-1">📊 Data ditampilkan sesuai master organization Anda</p>
            <?php endif; ?>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-red-400">
                <div class="text-center">
                    <p class="text-2xl font-bold text-red-600"><?php echo $pending_count; ?></p>
                    <p class="text-sm text-gray-600">Perlu Persetujuan</p>
                    <?php if ($admin_master_org_id): ?>
                    <p class="text-xs text-gray-400 mt-1">Master Org Anda</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-blue-400">
                <div class="text-center">
                    <p class="text-2xl font-bold text-blue-600"><?php echo $active_count; ?></p>
                    <p class="text-sm text-gray-600">Sedang Dipinjam</p>
                    <?php if ($admin_master_org_id): ?>
                    <p class="text-xs text-gray-400 mt-1">Master Org Anda</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-green-400">
                <div class="text-center">
                    <p class="text-2xl font-bold text-green-600"><?php echo $available_assets; ?></p>
                    <p class="text-sm text-gray-600">Tersedia</p>
                    <p class="text-xs text-gray-400 mt-1">Semua Asset</p>
                </div>
            </div>
            
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-gray-400">
                <div class="text-center">
                    <p class="text-2xl font-bold text-gray-600"><?php echo $total_assets; ?></p>
                    <p class="text-sm text-gray-600">Total Asset</p>
                    <p class="text-xs text-gray-400 mt-1">Semua Asset</p>
                </div>
            </div>
        </div>

        <!-- Navigation Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6 mb-8">
            <a href="approval.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 text-center">
                <div class="bg-red-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                    <svg class="w-8 h-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Persetujuan</h3>
                <p class="text-sm text-gray-600">Kelola permintaan peminjaman</p>
                <?php if ($pending_count > 0): ?>
                <span class="inline-block bg-red-100 text-red-800 text-xs px-2 py-1 rounded-full mt-2">
                    <?php echo $pending_count; ?> menunggu
                </span>
                <?php endif; ?>
            </a>

            <a href="assets.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 text-center">
                <div class="bg-blue-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Kelola Asset</h3>
                <p class="text-sm text-gray-600">Monitor dan kelola asset</p>
            </a>

            <a href="borrower.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 text-center">
                <div class="bg-green-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Borrower</h3>
                <p class="text-sm text-gray-600">Proses peminjaman</p>
            </a>

            <!-- View Borrower -->
            <a href="view_borrower.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 text-center">
                <div class="bg-orange-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                    <svg class="w-8 h-8 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">View Borrower</h3>
                <p class="text-sm text-gray-600">Lihat borrower aktif</p>
            </a>

            <a href="reports.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition duration-300 text-center">
                <div class="bg-purple-100 p-4 rounded-full w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                    <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Laporan</h3>
                <p class="text-sm text-gray-600">Lihat laporan peminjaman</p>
            </a>
        </div>

        <!-- Recent Requests -->
        <?php if (!empty($recent_pending)): ?>
        <div class="bg-white rounded-xl shadow-lg p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-gray-800">Permintaan Terbaru</h3>
                <a href="approval.php" class="text-dark-leaf hover:text-green-600 text-sm font-medium">Lihat Semua</a>
            </div>
            <div class="space-y-3">
                <?php foreach ($recent_pending as $request): ?>
                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                    <div>
                        <p class="font-medium text-gray-800"><?php echo htmlspecialchars($request['asset_name']); ?></p>
                        <p class="text-sm text-gray-600"><?php echo htmlspecialchars($request['borrower_name']); ?> • <?php echo htmlspecialchars($request['asset_number']); ?></p>
                    </div>
                    <span class="text-xs bg-red-100 text-red-800 px-2 py-1 rounded">
                        <?php echo $request['days_pending'] > 1 ? $request['days_pending'] . ' hari' : 'Baru'; ?>
                    </span>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>