<?php
require_once '../config/connection.php';
checkUserType(['admin']);

// Get admin's master organization
$stmt = $pdo->prepare("
    SELECT id, master_organization_id, organization
    FROM admins 
    WHERE id = ?
");
$stmt->execute([$_SESSION['user_id']]);
$admin_data = $stmt->fetch();

if (!$admin_data) {
    die("Error: Data admin tidak ditemukan. Silakan login ulang.");
}

$admin_master_org_id = $admin_data['master_organization_id'];

// Get return history - FILTERED BY MASTER ORGANIZATION
$returned_items = [];
if ($admin_master_org_id) {
    $stmt = $pdo->prepare("
        SELECT bh.*, 
               a.asset_name, a.asset_number, a.asset_category,
               b.full_name as borrower_name, b.organization, b.nik
        FROM borrow_history bh 
        JOIN assets a ON bh.asset_id = a.id 
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'returned'
        AND b.master_organization_id = ?
        ORDER BY bh.tanggal_kembali DESC
        LIMIT 50
    ");
    $stmt->execute([$admin_master_org_id]);
    $returned_items = $stmt->fetchAll();
} else {
    // Fallback: show all
    $stmt = $pdo->prepare("
        SELECT bh.*, 
               a.asset_name, a.asset_number, a.asset_category,
               b.full_name as borrower_name, b.organization, b.nik
        FROM borrow_history bh 
        JOIN assets a ON bh.asset_id = a.id 
        JOIN borrowers b ON bh.borrower_employee_id = b.employee_id
        WHERE bh.status = 'returned'
        ORDER BY bh.tanggal_kembali DESC
        LIMIT 50
    ");
    $stmt->execute();
    $returned_items = $stmt->fetchAll();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan - Tools Room</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'leaf-green': '#90EE90',
                        'dark-leaf': '#32CD32',
                        'soft-gray': '#F5F5F5'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-soft-gray min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm border-b-2 border-leaf-green">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-4">
                    <a href="dashboard.php" class="text-dark-leaf hover:text-green-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                    </a>
                    <img src="../images/logo.png" alt="Logo" class="h-10 w-10" onerror="this.style.display='none'">
                    <div>
                        <h1 class="text-xl font-bold text-gray-800">Laporan</h1>
                        <p class="text-sm text-gray-500">Riwayat pengembalian dan foto</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-600"><?php echo $_SESSION['user_name']; ?></span>
                    <a href="../logout.php" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                        Logout
                    </a>
                </div>
            </div>
        </div>
    </header>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Info Banner -->
        <?php if ($admin_master_org_id): ?>
        <div class="bg-blue-50 border border-blue-200 text-blue-800 rounded-xl p-4 mb-6">
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm">
                    <strong>Filter Master Organization:</strong> Menampilkan riwayat pengembalian dari master organization Anda
                </p>
            </div>
        </div>
        <?php endif; ?>

        <div class="bg-white rounded-xl shadow-lg p-6">
            <h3 class="text-lg font-semibold text-gray-800 mb-6">Riwayat Pengembalian</h3>
            
            <?php if (empty($returned_items)): ?>
            <div class="text-center py-12">
                <div class="text-gray-400 mb-4">
                    <svg class="w-16 h-16 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-gray-700 mb-2">Belum Ada Pengembalian</h3>
                <p class="text-gray-500">
                    <?php if ($admin_master_org_id): ?>
                        Belum ada riwayat pengembalian dari master organization Anda
                    <?php else: ?>
                        Riwayat pengembalian akan muncul di sini
                    <?php endif; ?>
                </p>
            </div>
            <?php else: ?>
            <div class="space-y-4">
                <?php foreach ($returned_items as $item): ?>
                <div class="border border-gray-200 rounded-lg p-4">
                    <div class="flex justify-between items-start mb-3">
                        <div>
                            <h4 class="font-semibold text-gray-800"><?php echo htmlspecialchars($item['asset_name']); ?></h4>
                            <p class="text-sm text-gray-600"><?php echo htmlspecialchars($item['asset_number']); ?> • <?php echo htmlspecialchars($item['asset_category']); ?></p>
                            <p class="text-sm text-blue-600">
                                Peminjam: <?php echo htmlspecialchars($item['borrower_name']); ?> 
                                (NIK: <?php echo htmlspecialchars($item['nik']); ?>)
                            </p>
                            <p class="text-xs text-gray-500"><?php echo htmlspecialchars($item['organization']); ?></p>
                        </div>
                        <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm">
                            Dikembalikan
                        </span>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                        <div>
                            <span class="text-gray-600">Tanggal Pinjam:</span>
                            <p class="font-medium"><?php echo date('d/m/Y', strtotime($item['borrow_date'])); ?></p>
                        </div>
                        <div>
                            <span class="text-gray-600">Tanggal Kembali:</span>
                            <p class="font-medium"><?php echo $item['tanggal_kembali'] ? date('d/m/Y H:i', strtotime($item['tanggal_kembali'])) : '-'; ?></p>
                        </div>
                        <div>
                            <span class="text-gray-600">Kondisi Kembali:</span>
                            <p class="font-medium <?php echo $item['kondisi_kembali'] == 'baik' ? 'text-green-600' : ($item['kondisi_kembali'] == 'rusak' ? 'text-yellow-600' : 'text-red-600'); ?>">
                                <?php echo ucfirst($item['kondisi_kembali'] ?? 'Tidak diketahui'); ?>
                            </p>
                        </div>
                    </div>
                    
                    <?php if ($item['foto_kembali']): ?>
                    <div class="mt-4">
                        <span class="text-gray-600 text-sm">Foto Pengembalian:</span>
                        <div class="mt-2">
                            <img src="data:image/jpeg;base64,<?php echo base64_encode($item['foto_kembali']); ?>" 
                                 alt="Foto Pengembalian" 
                                 class="w-32 h-32 object-cover rounded-lg border border-gray-300 cursor-pointer hover:opacity-75"
                                 onclick="showImageModal(this.src)">
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50" onclick="closeImageModal()">
        <div class="max-w-4xl max-h-full p-4">
            <img id="modalImage" src="" alt="Foto Pengembalian" class="max-w-full max-h-full rounded-lg">
        </div>
    </div>

    <script>
        function showImageModal(imageSrc) {
            document.getElementById('modalImage').src = imageSrc;
            document.getElementById('imageModal').classList.remove('hidden');
        }

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
        }

        // Close modal with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeImageModal();
            }
        });
    </script>
</body>
</html>