<?php
require_once '../config/connection.php';
checkUserType(['superadmin']);

header('Content-Type: application/json');

$master_id = (int)$_GET['master_id'];
$type = $_GET['type'] ?? '';

$response = [];

try {
    if ($type === 'organizations') {
        // Get organizations assigned to this master
        $stmt = $pdo->prepare("SELECT organization_name FROM organization_master_mapping WHERE master_organization_id = ?");
        $stmt->execute([$master_id]);
        $response['organizations'] = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
    } elseif ($type === 'users') {
        // Get NIKs assigned to this master
        $admin_stmt = $pdo->prepare("SELECT nik FROM admins WHERE master_organization_id = ? AND nik IS NOT NULL");
        $admin_stmt->execute([$master_id]);
        $admin_niks = $admin_stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $borrower_stmt = $pdo->prepare("SELECT nik FROM borrowers WHERE master_organization_id = ? AND nik IS NOT NULL");
        $borrower_stmt->execute([$master_id]);
        $borrower_niks = $borrower_stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $response['niks'] = array_merge($admin_niks, $borrower_niks);
    }
    
    echo json_encode($response);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>