<?php
// File: download.php (diletakkan di root project)
// Script ini berfungsi untuk mengamankan proses download file attachment.

// Konfigurasi direktori upload
define('UPLOAD_DIR', 'uploads/tasks/'); 
define('BASE_PATH', __DIR__ . '/');

$file_name_unique = $_GET['file'] ?? null;

if (empty($file_name_unique)) {
    die("Nama file tidak valid.");
}

// Amankan dari Directory Traversal Attack
$file_name_unique = basename($file_name_unique);
$full_path = BASE_PATH . UPLOAD_DIR . $file_name_unique;

if (!file_exists($full_path)) {
    die("File attachment tidak ditemukan di server.");
}

// Gunakan unique file name sebagai display name
$display_name = $file_name_unique; 
$mime_type = mime_content_type($full_path);

// Header untuk memaksa download
header('Content-Description: File Transfer');
header('Content-Type: ' . $mime_type);
header('Content-Disposition: attachment; filename="' . $display_name . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($full_path));

// Mengeluarkan file
readfile($full_path);
exit;
?>