<?php
// File: forgot_password.php
session_start();
require_once 'db.php';

$message = "";
$error = false;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // Validasi Input
    if (empty($username) || empty($new_password)) {
        $message = "Semua field harus diisi.";
        $error = true;
    } elseif ($new_password !== $confirm_password) {
        $message = "Konfirmasi password tidak cocok.";
        $error = true;
    } elseif (strlen($new_password) < 6) {
        $message = "Password minimal 6 karakter.";
        $error = true;
    } else {
        // Cek Username di Database
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $stmt_check->bind_param("s", $username);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            // Username Ada -> Update Password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt_update = $conn->prepare("UPDATE users SET password = ? WHERE username = ?");
            $stmt_update->bind_param("ss", $hashed_password, $username);
            
            if ($stmt_update->execute()) {
                $message = "✅ Password berhasil direset! Silakan login.";
                $error = false;
            } else {
                $message = "Gagal mereset password.";
                $error = true;
            }
        } else {
            $message = "Username tidak ditemukan di sistem.";
            $error = true;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lupa Password</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        
        body {
            height: 100vh; display: flex; justify-content: center; align-items: center;
            background: #f0f2f5;
        }
        
        .card {
            background: white; padding: 40px; border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05); width: 100%; max-width: 400px;
            text-align: center; border-top: 5px solid #FF9800;
        }
        
        h2 { margin-bottom: 10px; color: #333; }
        p { color: #666; font-size: 13px; margin-bottom: 25px; line-height: 1.5; }
        
        .form-group { margin-bottom: 15px; text-align: left; }
        label { display: block; font-size: 13px; font-weight: 600; margin-bottom: 5px; color: #444; }
        
        /* WRAPPER PASSWORD (Agar Ikon Mata masuk) */
        .password-wrapper { position: relative; width: 100%; }
        
        input { 
            width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 8px; 
            font-size: 14px; transition: 0.3s; padding-right: 40px; /* Space untuk ikon */
        }
        input:focus { border-color: #FF9800; outline: none; box-shadow: 0 0 0 3px rgba(255, 152, 0, 0.1); }

        /* IKON MATA */
        .toggle-password {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #999;
            font-size: 16px;
            user-select: none;
        }
        .toggle-password:hover { color: #FF9800; }

        .btn-reset { 
            width: 100%; padding: 12px; background: #FF9800; color: white; 
            border: none; border-radius: 8px; font-weight: 700; cursor: pointer; margin-top: 10px; 
            text-transform: uppercase; letter-spacing: 0.5px;
        }
        .btn-reset:hover { background: #F57C00; }

        .alert { padding: 12px; border-radius: 6px; font-size: 13px; margin-bottom: 20px; font-weight: 600; }
        .success { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        .error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

        .back-link { display: block; margin-top: 20px; color: #666; text-decoration: none; font-size: 13px; }
        .back-link:hover { color: #000; text-decoration: underline; }
    </style>
</head>
<body>

<div class="card">
    <h2>🔑 Reset Password</h2>
    <p>Masukkan username Anda dan password baru yang diinginkan.</p>

    <?php if ($message): ?>
        <div class="alert <?php echo $error ? 'error' : 'success'; ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label>Username</label>
            <input type="text" name="username" required placeholder="Contoh: superadmin">
        </div>
        
        <div class="form-group">
            <label>Password Baru</label>
            <div class="password-wrapper">
                <input type="password" name="new_password" id="newPass" required placeholder="Minimal 6 karakter">
                <span class="toggle-password" onclick="togglePassword('newPass', this)">👁️</span>
            </div>
        </div>

        <div class="form-group">
            <label>Konfirmasi Password</label>
            <div class="password-wrapper">
                <input type="password" name="confirm_password" id="confirmPass" required placeholder="Ulangi password baru">
                <span class="toggle-password" onclick="togglePassword('confirmPass', this)">👁️</span>
            </div>
        </div>

        <button type="submit" class="btn-reset">RESET PASSWORD</button>
    </form>

    <a href="login.php" class="back-link">← Kembali ke Halaman Login</a>
</div>

<script>
    function togglePassword(inputId, iconElement) {
        var input = document.getElementById(inputId);
        if (input.type === "password") {
            input.type = "text";
            iconElement.textContent = "🙈"; // Ikon mata tertutup
        } else {
            input.type = "password";
            iconElement.textContent = "👁️"; // Ikon mata terbuka
        }
    }
</script>

</body>
</html>