<?php
// === Pengecekan Role ===
include 'auth_check.php';
require_role(['member']); 
// =========================

require_once('../db.php'); 

$member_id = $_SESSION['user_id']; 
$tasks = [];
$message = '';

// --- Query untuk mengambil Tugas Member Beserta Detail Project dan Creator ---
$sql_tasks = "
    SELECT 
        t.id,                 
        t.title, 
        t.description, 
        t.due_date, 
        t.status,
        p.project_name,       
        u.username AS creator_name 
    FROM tasks t
    LEFT JOIN projects p ON t.project_id = p.project_id
    LEFT JOIN users u ON t.creator_id = u.id
    WHERE t.assigned_to = ?
    ORDER BY t.due_date, t.status DESC
";

$stmt = $conn->prepare($sql_tasks);

if ($stmt) {
    $stmt->bind_param("i", $member_id);
    
    if ($stmt->execute()) {
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $tasks[] = $row;
        }
    } else {
        $message = "❌ Gagal mengambil data tugas: " . $stmt->error;
    }
    $stmt->close();
} else {
    $message = "❌ Gagal menyiapkan query: " . $conn->error;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Member - Daftar Tugas Saya</title>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        /* Pastikan CSS untuk status ada dan berfungsi */
        .pending { color: orange; font-weight: bold; }
        .in_progress { color: blue; font-weight: bold; }
        .completed { color: green; }
    </style>
</head>
<body>
    <h1>Dashboard Member</h1>
    <a href="member_dashboard.php">Dashboard</a> | 
    <a href="member_tasks.php">Daftar Tugas</a> |
    <a href="../logout.php">Logout</a>
    
    <hr>
    
    <h2>Daftar Tugas Saya</h2>
    
    <?php if ($message): ?>
        <p style="color:red;"><?php echo $message; ?></p>
    <?php endif; ?>
    
    <?php if (empty($tasks)): ?>
        <p>🎉 Anda tidak memiliki tugas yang ditugaskan saat ini. Selamat!</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Project</th>
                    <th>Judul Tugas</th>
                    <th>Ditugaskan Oleh</th>
                    <th>Batas Waktu</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tasks as $task): ?>
                    <tr>
                        <td>
                            <strong><?php echo htmlspecialchars($task['project_name'] ?? 'Tidak Terikat Project'); ?></strong>
                        </td>
                        <td><?php echo htmlspecialchars($task['title']); ?></td>
                        <td><?php echo htmlspecialchars($task['creator_name']); ?></td>
                        <td><?php echo htmlspecialchars($task['due_date']); ?></td>
                        <td class="<?php echo strtolower($task['status']); ?>">
                            <?php 
                                // Memastikan output status sesuai dengan nilai database (Pending, In Progress, Completed)
                                echo ucfirst($task['status'] ?? 'N/A'); 
                            ?>
                        </td>
                        <td>
                            <a href="member_view_task.php?id=<?php echo htmlspecialchars($task['id']); ?>">Lihat/Update Status</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
    
</body>
</html>