<?php
// File: member/member_view_task.php
include 'auth_check.php'; require_role(['member']); require_once('../db.php'); 
$member_id = $_SESSION['user_id']; $task = null; $attachment = null; $message = ''; $error = false;
if (!isset($_GET['task_id']) || !is_numeric($_GET['task_id'])) { die("ID Tugas tidak valid."); }
$url_task_id = (int)$_GET['task_id'];
function get_task_details($conn, $task_id, $member_id) {
    $sql = "SELECT t.*, p.project_name, c.username AS creator_username FROM tasks t JOIN projects p ON t.project_id = p.project_id JOIN users c ON t.creator_id = c.id WHERE t.id = ? AND t.assigned_to = ?";
    $stmt = $conn->prepare($sql); $stmt->bind_param("ii", $task_id, $member_id); $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}
$task = get_task_details($conn, $url_task_id, $member_id);
if (!$task) { die("Tugas tidak ditemukan."); }
$is_locked = ($task['status'] === 'completed');
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_status'])) {
    if ($is_locked) { $message = "⛔ Tugas sudah selesai."; $error = true; } else {
        $new_status = $_POST['new_status']; $allowed = ['pending', 'in_progress', 'completed'];
        if (in_array($new_status, $allowed)) {
            $stmt = $conn->prepare("UPDATE tasks SET status = ? WHERE id = ? AND assigned_to = ?");
            $stmt->bind_param("sii", $new_status, $url_task_id, $member_id);
            if ($stmt->execute() && $stmt->affected_rows > 0) { $message = "✅ Update Sukses!"; $task['status'] = $new_status; $is_locked = ($new_status === 'completed'); } else { $message = "⚠️ Tidak ada perubahan."; } $stmt->close();
        }
    }
}
$stmt_att = $conn->prepare("SELECT * FROM task_attachments WHERE task_id = ?");
$stmt_att->bind_param("i", $url_task_id); $stmt_att->execute();
$attachment = $stmt_att->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Detail Tugas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root { --bg: #f4f7fe; --primary: #4318FF; --text: #2B3674; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 20px; color: var(--text); padding-bottom: 80px; }
        .container { max-width: 800px; margin: 0 auto; background: white; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.03); overflow: hidden; }
        
        /* Header */
        .top-bar { padding: 15px 20px; border-bottom: 1px solid #f0f0f0; background: #fff; }
        .btn-back { text-decoration: none; color: #707EAE; font-size: 14px; font-weight: 600; display: flex; align-items: center; gap: 5px; }
        
        .content { padding: 20px; }
        .task-header { margin-bottom: 20px; }
        .task-title { font-size: 22px; font-weight: 700; color: #1B2559; margin-bottom: 10px; line-height: 1.3; }
        .badge { padding: 5px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; display: inline-block; }
        .bg-pending { background: #FFF8E1; color: #FFC107; } .bg-in_progress { background: #E3F2FD; color: #2196F3; } .bg-completed { background: #E8F5E9; color: #4CAF50; }

        /* Grid Info */
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; background: #F4F7FE; padding: 15px; border-radius: 15px; margin-bottom: 20px; }
        .info-item h4 { font-size: 10px; color: #707EAE; text-transform: uppercase; margin-bottom: 3px; }
        .info-item p { font-size: 13px; font-weight: 600; color: #1B2559; }

        /* File */
        .file-card { display: flex; align-items: center; gap: 10px; padding: 12px; border: 1px solid #E0E5F2; border-radius: 10px; margin-bottom: 25px; }
        .file-icon { font-size: 20px; } .file-link { text-decoration: none; color: var(--primary); font-weight: 600; font-size: 12px; }

        /* UPDATE FORM (PRESISI) */
        .action-box { border-top: 2px solid #f0f0f0; padding-top: 20px; }
        .section-label { display: block; font-size: 14px; font-weight: 700; margin-bottom: 10px; color: #1B2559; }
        
        .update-form {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        select { flex: 1; padding: 12px; border: 1px solid #E0E5F2; border-radius: 10px; font-family: 'Poppins'; font-size: 14px; background: white; }
        .btn-save { padding: 12px 25px; background: var(--primary); color: white; border: none; border-radius: 10px; font-weight: 600; font-size: 14px; cursor: pointer; }

        /* MOBILE RESPONSIVE FIX */
        @media (max-width: 600px) {
            .update-form { 
                flex-direction: column; /* Tumpuk ke bawah */
                width: 100%; 
            }
            select { 
                width: 100%; /* Lebar Penuh */
                margin-bottom: 10px; /* Jarak dengan tombol */
            }
            .btn-save { 
                width: 100%; /* Lebar Penuh */
                padding: 15px; /* Tombol lebih besar biar enak ditekan */
            }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="top-bar"><a href="member_dashboard.php" class="btn-back">← Kembali</a></div>
    <div class="content">
        <?php if ($message): ?><div style="padding:10px; margin-bottom:15px; border-radius:8px; text-align:center; font-size:13px; font-weight:600; background:<?php echo $error?'#FEE2E2':'#DCFCE7';?>; color:<?php echo $error?'#991B1B':'#166534';?>;"><?php echo $message; ?></div><?php endif; ?>
        
        <div class="task-header">
            <div class="task-title"><?php echo htmlspecialchars($task['title']); ?></div>
            <?php $st = strtolower($task['status'] ?? 'pending'); ?>
            <span class="badge bg-<?php echo $st; ?>"><?php echo strtoupper(str_replace('_',' ',$st)); ?></span>
        </div>

        <div class="info-grid">
            <div class="info-item"><h4>Project</h4><p><?php echo htmlspecialchars($task['project_name']); ?></p></div>
            <div class="info-item"><h4>Creator</h4><p><?php echo htmlspecialchars($task['creator_username']); ?></p></div>
            <div class="info-item"><h4>Deadline</h4><p style="color:#E53E3E"><?php echo $task['due_date']; ?></p></div>
        </div>
        
        <div style="margin-bottom:25px; font-size:13px; line-height:1.6; color:#4a5568;"><?php echo nl2br(htmlspecialchars($task['description'])); ?></div>
        
        <?php if ($attachment): ?><div class="file-card"><div class="file-icon">📎</div><div><div style="font-size:10px; color:#A3AED0;">File</div><a href="../download.php?file=<?php echo urlencode($attachment['unique_file_name']); ?>" class="file-link" target="_blank"><?php echo htmlspecialchars($attachment['original_file_name']); ?></a></div></div><?php endif; ?>
        
        <div class="action-box">
            <span class="section-label">Update Progress</span>
            <?php if ($is_locked): ?><div style="background:#E8F5E9; color:#2E7D32; padding:15px; border-radius:10px; font-weight:600; font-size:13px; text-align:center; border:1px solid #C8E6C9;">🔒 Tugas Selesai (Terkunci)</div><?php else: ?>
            <form method="POST" class="update-form">
                <select name="new_status" required>
                    <option value="pending" <?php if ($st == 'pending') echo 'selected'; ?>>⏳ Pending</option>
                    <option value="in_progress" <?php if ($st == 'in_progress') echo 'selected'; ?>>🚀 In Progress</option>
                    <option value="completed" style="color:green; font-weight:bold;">✅ Completed</option>
                </select>
                <button type="submit" class="btn-save">Simpan</button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>
</body>
</html>