<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\BusinessCentralService;
use App\Services\InventoryBC;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use GuzzleHttp\Promise;
use GuzzleHttp\Promise\Create;
use GuzzleHttp\Promise\Utils;
use GuzzleHttp\Client;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Illuminate\Support\Str;
use GuzzleHttp\Exception\RequestException;
use App\Models\ItemRequest;
use App\Models\Company;
use Illuminate\Support\Facades\Http;

class ApproveController extends Controller
{   

     public function logPurchaseOrderLine()
    {
        // Buat instance service langsung
        $bcService = app(BusinessCentralService::class);

        // Ambil metadata
        $entities = $bcService->getMetadata();

        if (isset($entities['purchaseOrderLine'])) {
            $logData = [];
            foreach ($entities['purchaseOrderLine'] as $field) {
                $logData[] = [
                    'name'     => $field['name'],
                    'type'     => $field['type'],
                    'nullable' => $field['nullable'],
                ];
            }

            Log::info('📦 purchaseOrderLine Metadata', $logData);

            return response()->json([
                'status' => 'success',
                'message' => 'Metadata logged in laravel.log',
                'count' => count($logData)
            ]);
        } else {
            Log::warning('Entity purchaseOrderLine tidak ditemukan di metadata');

            return response()->json([
                'status' => 'warning',
                'message' => 'Entity purchaseOrderLine tidak ditemukan'
            ]);
        }
    }
    

public function getAccessToken()
{
    $client = new Client();
    $response = $client->post("https://login.microsoftonline.com/".env('AZURE_TENANT_ID')."/oauth2/v2.0/token", [
        'form_params' => [
            'grant_type' => 'client_credentials',
            'client_id' => env('AZURE_CLIENT_ID'),
            'client_secret' => env('AZURE_CLIENT_SECRET'),
            'scope' => 'https://api.businesscentral.dynamics.com/.default'
        ]
    ]);
    return json_decode($response->getBody()->getContents(), true)['access_token'];
}

    public function getCompanyId($token)
    {
        $client = new Client();
        $response = $client->get("https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') . "/api/v2.0/companies", [
            'headers' => [
                'Authorization' => "Bearer {$token}",
                'Accept'        => 'application/json'
            ]
        ]);
        $companies = json_decode((string)$response->getBody(), true);
        $role = session('user')['role'] ?? null; 
        $companyId1 = $companies['value'][0]['id'];
        $companyId2 = $companies['value'][1]['id'];

        return [
            'companyId1' => $companyId1,
            'companyId2' => $companyId2
        ];
    }

    public function __construct()
    {
     $this->token = $this->getAccessToken();
     $companyIds = $this->getCompanyId($this->token);
     $this->companyRegent = $companyIds['companyId1'];
     $this->companyHIN    = $companyIds['companyId2'];
     
     $activeCompany = session('current_company_name') ?? session('user')['role'];
    if ($activeCompany === 'Regent' or $activeCompany === 'SUPER') {
        $this->companyId = $this->companyRegent;
    } elseif ($activeCompany === 'HIN') {
        $this->companyId = $this->companyHIN;
    }
     $this->client = new Client();
    }

    
    public function index()
    {
        // Step 1 - approvals
        $approvals = $this->getReqToApprove();
        $mapEntry = [];
        foreach ($approvals as $a) {
            $docNo = $a['DocumentNo'] ?? null;
            if (!$docNo) continue;

            $mapEntry[$docNo] = [
                'EntryNo'     => $a['EntryNo'] ?? null,
                'Salesperson' => $a['Salesperson'] ?? null,
            ];
        }


        $docNos = array_column($approvals, 'DocumentNo');

        // Step 2 - purchase lines
        $lines = $this->getPurchaseLinesX($docNos);

        $headers = $this->getPurchaseHeaders($docNos);


        $merged = [];
        foreach ($lines as $line) {
            $doc = $line['Document_No'];
            $line['EntryNo']     = $mapEntry[$doc]['EntryNo'] ?? null;
            $line['Header']  = $headers[$doc] ?? null;
            $line['Salesperson'] = $mapEntry[$doc]['Salesperson'] ?? null;
            $merged[] = $line;
        }

        $locations = collect($merged)
            ->pluck('Location_Code')
            ->filter()
            ->unique()
            ->values();

        $grouped = collect($merged)->groupBy('Document_No');

        // -------------------------------
        // ⭐ STEP 3 — Fetch attachments for all PO numbers
        // -------------------------------
        // 1. collect all PO numbers
        $attachments = [];

        // 1. collect all PO numbers
        $poNumbers = array_filter(array_keys($grouped->toArray()));

        if (!empty($poNumbers)) {

            // 2. build OR filter
            $filterParts = array_filter(array_map(
                fn ($no) => $no ? "(no eq '$no')" : null,
                $poNumbers
            ));

            if (!empty($filterParts)) {

                $filter = implode(' or ', $filterParts);

                $urlAttach =
                    "https://api.businesscentral.dynamics.com/v2.0/"
                    . env('AZURE_TENANT_ID') . "/"
                    . env('BC_ENVIRONMENT')
                    . "/api/citbi/sku/v1.0/companies(" . rawurlencode($this->companyId) . ")/poAttachments?"
                    . "\$filter=" . urlencode($filter);

                try {
                    $res = $this->client->get($urlAttach, [
                        'headers' => [
                            'Authorization' => "Bearer {$this->token}",
                            'Accept'        => 'application/json'
                        ]
                    ]);

                    $decoded = json_decode($res->getBody(), true);

                    foreach ($decoded['value'] ?? [] as $a) {
                        $po = $a['no'] ?? null;
                        if (!$po) continue;

                        $attachments[$po][] = [
                            'id'       => $a['id'],
                            'fileName' => $a['fileName'],
                            'ext'      => $a['fileExtension']
                        ];
                    }

                } catch (\Throwable $e) {
                    \Log::error('[BC] poAttachments fetch failed', [
                        'error' => $e->getMessage()
                    ]);
                }
            }
        }

        return view('Approve', [
            'groups'      => $grouped,
            'locations'   => $locations,
            'attachments' => $attachments,
        ]);
    }


    // ↓↓↓ KEEP YOUR EXISTING METHODS (they are correct) ↓↓↓

    public function getReqToApprove()
    {
        $url = "https://api.businesscentral.dynamics.com/v2.0/"
        . env('AZURE_TENANT_ID') . "/"
        . env('BC_ENVIRONMENT') .
        "/ODataV4/Company('" . $this->companyId . "')/ApprovalEntryAPI?"
        . "\$filter=Status eq 'Open' and ApproverID eq 'MICHAEL DANIEL' and TableId eq 38";

        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ];

        $response = $this->client->get($url, $headers);
        $decoded  = json_decode($response->getBody(), true);

        return $decoded['value'];  // return approvals array
    }

    public function getPoAttachments($attachmentId)
    {
        $url = "https://api.businesscentral.dynamics.com/v2.0/"
            . env('AZURE_TENANT_ID') . "/"
            . env('BC_ENVIRONMENT')
            . "/api/citbi/sku/v1.0/companies(" . rawurlencode($this->companyId) . ")/poAttachments"
            . "?\$top=50&\$filter=id eq {$attachmentId}";

        $response = $this->client->get($url, [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ]);

        return json_decode($response->getBody(), true)['value'] ?? [];
    }

    public function previewAttachment($attachmentId)
    {

        $urlContent = "https://api.businesscentral.dynamics.com/v2.0/"
        . env('AZURE_TENANT_ID') . "/"
        . env('BC_ENVIRONMENT')
        . "/ODataV4/ReqApprove_GetAttachmentContent?Company=PT.CI%20LIVE";

        $body = new \stdClass(); 
        $body->documentAttachmentID = $attachmentId;

        $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . session('bc_token'),
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
            ])->post($urlContent, $body);
        $json = $response->json();
        $base64 = $json['value']; 

        $filePath = storage_path("app/attachment.pdf");
        file_put_contents($filePath, base64_decode($base64));

        return response(base64_decode($base64))
            ->header("Content-Type", "application/pdf")
            ->header('Content-Disposition', 'inline; filename="attachment.pdf"');
    }

    public function getAttachments()
    {
        // =====================================================
        // STEP 1 — Get Purchase Order by Number
        // =====================================================
        $urlPO = "https://api.businesscentral.dynamics.com/v2.0/"
            . env('AZURE_TENANT_ID') . "/"
            . env('BC_ENVIRONMENT') .
            "/api/v2.0/companies({$this->companyId})/purchaseOrders?\$filter=number eq '36935'";

        $responsePO = $this->client->get($urlPO, [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ]);

        $poDecoded = json_decode($responsePO->getBody(), true);

        if (empty($poDecoded['value'])) {
            return "PO not found";
        }

        $poId = $poDecoded['value'][0]['id'];

        if (empty($attachments['value'])) {
            return "No attachments found.";
        }

        $attachmentId = $attachments['value'][0]['id'];

        $urlContent = "https://api.businesscentral.dynamics.com/v2.0/"
        . env('AZURE_TENANT_ID') . "/"
        . env('BC_ENVIRONMENT')
        . "/ODataV4/ReqApprove_GetAttachmentContent?Company=PT.CI%20LIVE";

        $body = new \stdClass(); 
        $body->documentAttachmentID = $attachmentId;

        $response = Http::withHeaders([
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
            ])->post($urlContent, $body);
        $json = $response->json();
        $base64 = $json['value']; 

        $filePath = storage_path("app/attachment.pdf");
        file_put_contents($filePath, base64_decode($base64));

        return response(base64_decode($base64))
    ->header('Content-Type', 'application/pdf')
    ->header('Content-Disposition', 'inline; filename="attachment.pdf"');
    }



    public function getPurchaseLinesX($documentNos)
    {
        if (empty($documentNos)) {
            return [];
        }

        $docFilter = implode(' or ', array_map(fn($no) =>
            "Document_No eq '$no'", $documentNos));

        $url = "https://api.businesscentral.dynamics.com/v2.0/"
            . env('AZURE_TENANT_ID') . "/"
            . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/Purchase_Lines_Excel?"
            . "\$filter=Status eq 'Pending Approval' "
            . "and ($docFilter)";

        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ];

        $response = $this->client->get($url, $headers);
        $decoded  = json_decode($response->getBody(), true);

        return $decoded['value'];
    }

    public function getPurchaseHeaders(array $documentNos)
    {
        if (empty($documentNos)) {
            return [];
        }

        $docFilter = implode(' or ', array_map(fn($no) =>
            "No eq '$no'", $documentNos));

        $url = "https://api.businesscentral.dynamics.com/v2.0/"
            . env('AZURE_TENANT_ID') . "/"
            . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/Purchase_Order_Excel?"
            . "\$select=No,SystemCreatedBy,SystemCreatedAt,Transaction_Type,Prepayment_Percent,Currency_Code,VAT_Bus_Posting_Group"
            . "&\$filter=Status eq 'Pending Approval' and ($docFilter)";

        $response = $this->client->get($url, [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ]);

        $decoded = json_decode($response->getBody(), true);
        // Index by PO No
        return collect($decoded['value'] ?? [])
            ->keyBy('No')
            ->toArray();
    }

    public function postrequestapprove(Request $request)
    {
        $request->validate([
            'entries' => 'required',
        ]);

        try {
            $entries = is_array($request->entries)
                ? implode(',', $request->entries)
                : $request->entries;

            $result = app(BusinessCentralService::class)->RequestApproved($entries);

            if (!empty($result['success'])) {
                return response()->json([
                    'status' => 'success',
                    'message' => $result['message'] ?? 'Approved',
                    'data' => $result['data'] ?? [],
                ]);
            }

            Log::error('Approve failed', [
                'entries'  => $entries,
                'result'   => $result,
            ]);

            return response()->json([
                'status'  => 'error',
                'message' => $result['message'] ?? 'Approval failed',
            ], 500);

        } catch (\Throwable $e) {

            Log::critical('Approve exception', [
                'entries' => $request->entries,
                'error'   => $e->getMessage(),
                'trace'   => $e->getTraceAsString(),
            ]);

            return response()->json([
                'status'  => 'error',
                'message' => 'Internal server error',
            ], 500);
        }
    }

    public function postrequestreject(Request $request)
    {
        $request->validate([
            'entries' => 'required',
        ]);

        try {
            // ✅ normalize input (array → CSV)
            $entries = $request->entries;
            if (is_array($entries)) {
                $entries = implode(',', $entries);
            }

            $result = app(BusinessCentralService::class)->RequestRejected($entries);

            if (!empty($result['success']) && $result['success'] === true) {
                return response()->json([
                    'status'  => 'success',
                    'message' => $result['message'] ?? 'Request Has Been Rejected successfully.',
                    'data'    => $result['data'] ?? [],
                ]);
            }

            // 🔴 log business failure
            Log::error('Reject failed', [
                'entries' => $entries,
                'result'  => $result,
            ]);

            return response()->json([
                'status'  => 'error',
                'message' => $result['message'] ?? 'Reject failed',
            ], 500);

        } catch (\Throwable $e) {

            // 🔥 log EVERYTHING
            Log::critical('Reject exception', [
                'entries' => $request->entries,
                'error'   => $e->getMessage(),
                'trace'   => $e->getTraceAsString(),
            ]);

            return response()->json([
                'status'  => 'error',
                'message' => 'Internal server error',
            ], 500);
        }
    }


}