@extends('layouts.app')
@section('title', 'Operations Dashboard')

@push('styles')
    <style>
        .kpi-card {
            border-radius: 1rem
        }

        .kpi-icon {
            width: 42px;
            height: 42px;
            display: grid;
            place-items: center;
            border-radius: 999px;
            background: #f3f6ff
        }

        .table-sm td,
        .table-sm th {
            padding: .5rem .6rem
        }
    </style>
@endpush

@section('content')
    <div class="container my-4">
        <div class="row g-3 mb-2">
            <div class="col-md-3">
                <div class="card kpi-card shadow-sm">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted small">Inbox (Approvals)</div>
                            <div class="fs-4 fw-semibold">{{ $kpi_inbox }}</div>
                        </div>
                        <div class="kpi-icon text-primary"><i class="fa fa-envelope-open-text"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card kpi-card shadow-sm">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted small">My Open Requests</div>
                            <div class="fs-4 fw-semibold">{{ $kpi_my_open }}</div>
                        </div>
                        <div class="kpi-icon text-info"><i class="fa fa-clipboard-list"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card kpi-card shadow-sm">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted small">Approved (30 days)</div>
                            <div class="fs-4 fw-semibold text-success">{{ $kpi_approved_30d }}</div>
                        </div>
                        <div class="kpi-icon text-success"><i class="fa fa-thumbs-up"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card kpi-card shadow-sm">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted small">Rejected (30 days)</div>
                            <div class="fs-4 fw-semibold text-danger">{{ $kpi_rejected_30d }}</div>
                        </div>
                        <div class="kpi-icon text-danger"><i class="fa fa-thumbs-down"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card kpi-card shadow-sm">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted small">Average Time (Start → Finish)</div>
                            <div class="fs-4 fw-semibold text-primary">{{ $avgDuration ?? '0 menit' }}</div>
                        </div>
                        <div class="kpi-icon text-primary">
                            <i class="fa fa-hourglass-half"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container py-4">
            <div class="row g-4">

                <!-- This Week Approvals -->
                <div class="col-12">
                    <div class="card border-0 shadow-sm rounded-4">
                        <div class="card-body">
                            <h6 class="text-muted mb-3">This Week Approvals</h6>
                            <div class="row text-center g-3">
                                <div class="col-md-4">
                                    <div class="p-3 rounded-4 bg-light shadow-sm hover-scale">
                                        <h6 class="text-primary mb-1">Submitted</h6>
                                        <h3 class="fw-bold mb-0">{{ $totalRequestsThisWeek['Submitted'] ?? 0 }}</h3>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-3 rounded-4 bg-success bg-opacity-10 text-success shadow-sm hover-scale">
                                        <h6 class="mb-1">Approved</h6>
                                        <h3 class="fw-bold mb-0">{{ $totalRequestsThisWeek['Approved'] ?? 0 }}</h3>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-3 rounded-4 bg-danger bg-opacity-10 text-danger shadow-sm hover-scale">
                                        <h6 class="mb-1">Rejected</h6>
                                        <h3 class="fw-bold mb-0">{{ $totalRequestsThisWeek['Rejected'] ?? 0 }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <style>
            .border-bottom-hover:hover {
                background-color: #f8f9fa;
                transition: 0.2s ease;
            }

            .hover-scale:hover {
                transform: scale(1.03);
                transition: 0.25s ease;
            }
        </style>

        <div class="row mb-4 g-4">
            <!-- Total Requests -->
            <div class="col-md-8">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                        <div><i class="fa fa-users me-2"></i>Total Requests</div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm align-middle">
                                <thead class="table-light">
                                    <tr class="text-center">
                                        <th class="text-start">User</th>
                                        <th>Rejected</th>
                                        <th>Approved</th>
                                        <th>Cancelled</th>
                                        <th>InReview</th>
                                        <th>Draft</th>
                                        <th>Avg Time</th>
                                        <th>Avg Submit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($totalRequestsByStatus as $userName => $statuses)
                                        @php
                                            $avg = $averageTimesIndexed[$userName] ?? null;
                                        @endphp
                                        <tr>
                                            <td class="fw-semibold text-start">{{ $userName }}</td>
                                            <td class="text-center text-danger fw-semibold">{{ $statuses['Rejected'] ?? 0 }}
                                            </td>
                                            <td class="text-center text-success fw-semibold">
                                                {{ $statuses['Approved'] ?? 0 }}</td>
                                            <td class="text-center text-secondary fw-semibold">
                                                {{ $statuses['Cancelled'] ?? 0 }}</td>
                                            <td class="text-center text-warning fw-semibold">
                                                {{ $statuses['InReview'] ?? 0 }}</td>
                                            <td class="text-center text-muted fw-semibold">{{ $statuses['Draft'] ?? 0 }}
                                            </td>
                                            <td class="text-center text-info fw-semibold">
                                                {{ $avg ? $avg->avg_total : '-' }}
                                            </td>
                                            <td class="text-center text-primary fw-semibold">
                                                {{ $avg ? $avg->avg_sourcing : '-' }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Time Spent Per Approver -->
            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                        <div><i class="fa fa-clock me-2"></i>Time Spent Per Approver</div>
                    </div>
                    <div class="card-body">
                        <div class="list-group list-group-flush">
                            @forelse($avgByUser as $user)
                                <div
                                    class="list-group-item d-flex justify-content-between align-items-center border-0 px-0 py-2">
                                    <span class="fw-semibold">{{ $user['actor_name'] ?? $user['actor_user_id'] }}</span>
                                    <span class="text-muted">
                                        {{ $user['avg_duration'] ?? '0 menit' }}
                                        <small class="text-secondary">({{ $user['total_approvals'] }} approvals)</small>
                                    </span>
                                </div>
                            @empty
                                <p class="text-muted mb-0">No data available.</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- PO SUGGESTIONS --}}
        {{-- <div class="row g-4">
 
    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
          <div><i class="fa fa-truck-ramp-box me-2"></i>PO Suggestions</div>
          <div class="d-flex gap-2 small">
            <span class="badge bg-warning text-dark" id="countNeedOrder">
              Need Order: {{ $poCounts['need_order'] }}
            </span>
            <span class="badge bg-dark" id="countNeedOrderTo">
              Need Order for TO: {{ $poCounts['need_order_for_to'] }}
            </span>
            <span class="badge bg-info text-dark" id="countFollowUp">
              Follow Up: {{ $poCounts['follow_up'] }}
            </span>
            <span class="badge bg-success" id="countForStock">
              For Stock: {{ $poCounts['for_stock'] }}
            </span>
            <span class="badge bg-secondary" id="countNoNeed">
              No Need: {{ $poCounts['no_need'] }}
            </span>
          </div>
        </div>

        <div class="card-body">

          <div class="row g-2 align-items-end mb-3">
            <div class="col-md-6">
              <label class="form-label small">Filter by Vendor</label>
              <select id="poVendorFilter" class="form-select form-select-sm">
                <option value="">All vendors</option>
                @foreach ($poVendors as $v)
                  <option value="{{ $v }}">{{ $v }}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label small">Location</label>
              <select id="poLocationFilter" class="form-select form-select-sm">
                <option value="">All locations</option>
                @foreach ($poLocations as $loc)
                  <option value="{{ $loc }}">{{ $loc }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="mb-3">
            <canvas id="poStatusChart" height="140"></canvas>
          </div>

          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th>Item</th>
                  <th>Vendor</th>
                  <th class="text-center">QtyToOrder</th>
                  <th>Status</th>
                  <th>Loc</th>
                </tr>
              </thead>
              <tbody id="poTableBody">
                @forelse($poTop as $r)
                  <tr>
                    <td>
                      <div class="fw-semibold">{{ $r['item_no'] ?? '—' }}</div>
                      <div class="small text-muted">{{ $r['description'] ?? '' }}</div>
                    </td>
                    <td class="small">{{ $r['vendor_name'] ?? '—' }}</td>
                    <td class="text-center">{{ $r['qty_to_order'] ?? '—' }}</td>
                    <td><span class="badge bg-light text-dark">{{ $r['status'] ?? '—' }}</span></td>
                    <td class="small">{{ $r['location_code'] ?? '—' }}</td>
                  </tr>
                @empty
                  <tr><td colspan="5" class="text-muted">No rows.</td></tr>
                @endforelse
              </tbody>
            </table>
          </div>

          <div class="text-end">
            <a href="{{ route('po-suggestions') }}" class="btn btn-outline-primary btn-sm">
              <i class="fa fa-arrow-right me-1"></i> Go to PO Suggestions
            </a>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
          <div><i class="fa fa-layer-group me-2"></i>SKU Mapping</div>
          <div class="d-flex gap-2 small">
            <span class="badge bg-light text-dark">Rows: {{ $skuCounts['rows'] }}</span>
            <span class="badge bg-info text-dark">Modified 30d: {{ $skuCounts['modified_30d'] }}</span>
          </div>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th>Item</th>
                  <th>Location</th>
                  <th class="text-center">Cons(2m)</th>
                  <th>Real Min/Max</th>
                  <th>Suggest Min/Max</th>
                  <th class="text-center">Forecast Min (Avg)</th>
                  <th class="text-center">Forecast Max (Avg)</th>
                </tr>
              </thead>
              <tbody>
                @forelse($skuTop as $r)
                  <tr>
                    <td>
                      <div class="fw-semibold">{{ $r['Item_No'] ?? '—' }}</div>
                      <div class="small text-muted">{{ $r['Description'] ?? '' }}</div>
                    </td>
                    <td class="small">{{ $r['Location'] ?? '—' }}</td>
                    <td class="text-center">{{ $r['Consumption / 2 months'] ?? 0 }}</td>
                    <td class="small">
                      {{ $r['RealMinQty'] ?? 0 }} / {{ $r['RealMaxQty'] ?? 0 }}
                    </td>
                    <td class="small">
                      {{ $r['SuggestMinQty'] ?? 0 }} / {{ $r['SuggestMaxQty'] ?? 0 }}
                    </td>
                    <td class="text-center">
                      {{ $r['ForecMin_Avg'] ?? '—' }}
                      <div class="small text-muted">
                        HIC: {{ $r['ForecMin_HIC'] ?? '—' }},
                        RBC: {{ $r['ForecMin_RBC'] ?? '—' }}
                      </div>
                    </td>
                    <td class="text-center">
                      {{ $r['ForecMax_Avg'] ?? '—' }}
                      <div class="small text-muted">
                        HIC: {{ $r['ForecMax_HIC'] ?? '—' }},
                        RBC: {{ $r['ForecMax_RBC'] ?? '—' }}
                      </div>
                    </td>
                  </tr>
                @empty
                  <tr><td colspan="7" class="text-muted">No rows.</td></tr>
                @endforelse
              </tbody>
            </table>
          </div>
          <div class="text-end">
            <a href="{{ route('sku-mapping') }}" class="btn btn-outline-dark btn-sm">
              <i class="fa fa-arrow-right me-1"></i> Go to SKU Mapping
            </a>
          </div>
        </div>
      </div>
      

    </div>--}}
    
  </div> 
<div class="p-4 space-y-4">
    <!-- Search -->
    <div class="flex justify-between items-center mb-4">
        <input type="text" id="searchInput" placeholder="Search..." 
            class="w-full mr-4 p-2 border rounded-md shadow-sm focus:ring-2 focus:ring-blue-500 focus:outline-none dark:bg-gray-800 dark:border-gray-700 dark:text-gray-100" />

        <button id="resetFilterBtn" 
            class="btn btn-outline-danger px-4 py-2 rounded-md transition">
            Reset Filter
        </button>
    </div>
    <!-- Table wrapper -->
    <div class="card overflow-x-auto rounded-lg w-auto shadow border border-gray-200 dark:border-gray-700">
        <table id="itemRequestTable" class="w-full table-fixed border-collapse">
            <thead class="bg-black text-white">
                <tr>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Request #</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Vendor</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Requester</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">From User</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Requested At</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Start → Finish</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Submit Time</th>
                    <th class="px-4 py-3 text-left text-sm font-semibold ">Status</th>
                </tr>
            </thead>
            <tbody class="w-full bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700">
                <!-- rows inserted by JS -->
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="flex justify-center items-center space-x-2 mt-2">
        <button id="prevBtn" class="px-4 py-2 rounded-md border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700">Prev</button>
        <span id="pageInfo" class="text-sm font-medium text-gray-700 dark:text-gray-200"></span>
        <button id="nextBtn" class="px-4 py-2 rounded-md border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700">Next</button>
    </div>
</div>
    </div>
    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
        <script>
            (function() {
                const PO_ROWS = @json($poRows ?? []);

                const STATUS_KEYS = [
                    'Need Order',
                    'Need Order For TO',
                    'Follow Up PO',
                    'Order For Stock',
                    'No Need Order'
                ];

                const COLORS = ['#3b82f6', '#ef4444', '#f59e0b', '#10b981', '#94a3b8'];

                const selVendor = document.getElementById('poVendorFilter');
                const selLocation = document.getElementById('poLocationFilter');

                const countNeedOrder = document.getElementById('countNeedOrder');
                const countNeedOrderTo = document.getElementById('countNeedOrderTo');
                const countFollowUp = document.getElementById('countFollowUp');
                const countForStock = document.getElementById('countForStock');
                const countNoNeed = document.getElementById('countNoNeed');

                const tableBody = document.getElementById('poTableBody');

                let activeStatuses = new Set(STATUS_KEYS);

                const ctx = document.getElementById('poStatusChart');
                const chart = new Chart(ctx, {
                    type: 'pie',
                    data: {
                        labels: STATUS_KEYS,
                        datasets: [{
                            data: [0, 0, 0, 0, 0],
                            backgroundColor: COLORS,
                            borderColor: '#fff',
                            borderWidth: 1
                        }]
                    },
                    options: {
                        plugins: {
                            legend: {
                                position: 'bottom',
                                onClick: (e, legendItem) => {
                                    const label = legendItem.text;
                                    if (activeStatuses.has(label)) activeStatuses.delete(label);
                                    else activeStatuses.add(label);
                                    updateAll();
                                }
                            },
                            tooltip: {
                                callbacks: {
                                    label: (ctx) => `${ctx.label}: ${ctx.raw}`
                                }
                            }
                        },
                        onClick: (e, elements) => {
                            if (!elements.length) return;
                            const idx = elements[0].index;
                            const clicked = STATUS_KEYS[idx];
                            if (activeStatuses.size === 1 && activeStatuses.has(clicked)) {
                                activeStatuses = new Set(STATUS_KEYS);
                            } else {
                                activeStatuses = new Set([clicked]);
                            }
                            updateAll();
                        }
                    }
                });

                function applyFilters(rows) {
                    const v = selVendor.value.trim();
                    const l = selLocation.value.trim();
                    return rows.filter(r => {
                        const okV = !v || r.vendor_name === v;
                        const okL = !l || r.location_code === l;
                        const okS = activeStatuses.has(r.status || '');
                        return okV && okL && okS;
                    });
                }

                function summarize(rows) {
                    const counts = {
                        'Need Order': 0,
                        'Need Order For TO': 0,
                        'Follow Up PO': 0,
                        'Order For Stock': 0,
                        'No Need Order': 0
                    };
                    rows.forEach(r => {
                        if (counts.hasOwnProperty(r.status)) counts[r.status]++;
                    });
                    return counts;
                }

                function topN(rows, n = 8) {
                    return [...rows].sort((a, b) => (b.qty_to_order || 0) - (a.qty_to_order || 0)).slice(0, n);
                }

                function renderTable(rows) {
                    const top = topN(rows);
                    if (!top.length) {
                        tableBody.innerHTML = `<tr><td colspan="5" class="text-muted">No rows.</td></tr>`;
                        return;
                    }
                    tableBody.innerHTML = top.map(r => `
        <tr>
          <td>
            <div class="fw-semibold">${esc(r.item_no ?? '—')}</div>
            <div class="small text-muted">${esc(r.description ?? '')}</div>
          </td>
          <td class="small">${esc(r.vendor_name ?? '—')}</td>
          <td class="text-center">${r.qty_to_order ?? '—'}</td>
          <td><span class="badge bg-light text-dark">${esc(r.status ?? '—')}</span></td>
          <td class="small">${esc(r.location_code ?? '—')}</td>
        </tr>
      `).join('');
                }

                function updateCounts(counts) {
                    countNeedOrder.textContent = `Need Order: ${counts['Need Order']}`;
                    countNeedOrderTo.textContent = `Need Order for TO: ${counts['Need Order For TO']}`;
                    countFollowUp.textContent = `Follow Up: ${counts['Follow Up PO']}`;
                    countForStock.textContent = `For Stock: ${counts['Order For Stock']}`;
                    countNoNeed.textContent = `No Need: ${counts['No Need Order']}`;
                }

                function updateChart(counts) {
                    chart.data.datasets[0].data = STATUS_KEYS.map(k => counts[k] || 0);
                    // Dim inactive statuses (optional)
                    chart.data.datasets[0].backgroundColor = STATUS_KEYS.map((k, i) =>
                        activeStatuses.has(k) ? COLORS[i] : hexToRgba(COLORS[i], 0.25)
                    );
                    chart.update();
                }

                function esc(x) {
                    return String(x ?? '').replaceAll('&', '&amp;').replaceAll('<', '&lt;').replaceAll('>', '&gt;');
                }

                function hexToRgba(hex, a) {
                    const m = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
                    if (!m) return hex;
                    const r = parseInt(m[1], 16),
                        g = parseInt(m[2], 16),
                        b = parseInt(m[3], 16);
                    return `rgba(${r},${g},${b},${a})`;
                }

                function updateAll() {
                    const filtered = applyFilters(PO_ROWS);
                    const counts = summarize(filtered);
                    updateCounts(counts);
                    updateChart(counts);
                    renderTable(filtered);
                }

                selVendor.addEventListener('change', updateAll);
                selLocation.addEventListener('change', updateAll);

                updateAll();
            })();
        </script>
    @endpush


<script>
const data = @json($itemRequestData);
const perPage = 10;
let currentPage = 1;
let filteredData = [...data];
let sortConfig = { key: null, direction: 'asc' };

const tableBody = document.querySelector("#itemRequestTable tbody");
const pageInfo = document.querySelector("#pageInfo");
const searchInput = document.querySelector("#searchInput");

function formatDuration(seconds) {
    if (!seconds) return '-';
    const h = Math.floor(seconds / 3600);
    const m = Math.floor((seconds % 3600) / 60);
    return `${h} jam ${m} menit`;
}

function sortData() {
    if (!sortConfig.key) return;
    filteredData.sort((a, b) => {
        let valA = a[sortConfig.key];
        let valB = b[sortConfig.key];

        if (sortConfig.key === 'status') {
            valA = a.status?.current_step ?? '';
            valB = b.status?.current_step ?? '';
        }

        if (typeof valA === 'string') valA = valA.toLowerCase();
        if (typeof valB === 'string') valB = valB.toLowerCase();

        if (valA < valB) return sortConfig.direction === 'asc' ? -1 : 1;
        if (valA > valB) return sortConfig.direction === 'asc' ? 1 : -1;
        return 0;
    });
}

function renderTable() {
    sortData();

    tableBody.innerHTML = "";
    const start = (currentPage - 1) * perPage;
    const end = start + perPage;
    const pageData = filteredData.slice(start, end);

    for (const item of pageData) {
        const tr = document.createElement("tr");
        tr.classList.add("hover:bg-gray-50","dark:hover:bg-gray-700");

        tr.innerHTML = `
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-20 max-w-[80px] truncate">${item.request_number}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-36 max-w-[144px] truncate" title="${item.vendor_name}">${item.vendor_name}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-32 max-w-[128px] truncate" title="${item.requester_name}">${item.requester_name}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-32 max-w-[128px] truncate" title="${item.from_user}">${item.from_user}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-40 max-w-[160px] truncate">${item.requested_at ?? '-'}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-36 max-w-[144px] truncate">${item.start_to_finish_hr ?? '-'}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-36 max-w-[144px] truncate">${item.submit_time_hr ?? '-'}</td>
            <td class="px-4 py-3 text-sm text-gray-700 dark:text-gray-200 w-36 max-w-[144px] truncate">${item.status ? `${item.status.current_step}/${item.status.approver_name}` : '-'}</td>
        `;
        tableBody.appendChild(tr);
    }

    const totalPages = Math.ceil(filteredData.length / perPage);
    pageInfo.textContent = `Page ${currentPage} of ${totalPages}`;
    document.getElementById("prevBtn").disabled = currentPage === 1;
    document.getElementById("nextBtn").disabled = currentPage === totalPages;

    // update header arrow
    document.querySelectorAll("#itemRequestTable thead th").forEach((th, index) => {
        th.querySelector('.sort-arrow')?.remove(); // hapus panah lama
        const keys = [
            'request_number',
            'vendor_name',
            'requester_name',
            'from_user',
            'requested_at',
            'start_to_finish_hr',
            'submit_time_hr',
            'status'
        ];
        const key = keys[index];
        if (sortConfig.key === key) {
            const arrow = document.createElement('span');
            arrow.className = 'sort-arrow ml-1';
            arrow.textContent = sortConfig.direction === 'asc' ? '▲' : '▼';
            th.appendChild(arrow);
            th.classList.add('bg-gray-200','dark:bg-gray-700'); // highlight
        } else {
            th.classList.remove('bg-gray-200','dark:bg-gray-700');
        }
    });
}

// tambahkan sorting ke setiap th
document.querySelectorAll("#itemRequestTable thead th").forEach((th, index) => {
    th.style.cursor = "pointer";
    th.addEventListener("click", () => {
        const keys = [
            'request_number',
            'vendor_name',
            'requester_name',
            'from_user',
            'requested_at',
            'start_to_finish_hr',
            'submit_time_hr',
            'status'
        ];
        const key = keys[index];

        if (sortConfig.key === key) {
            sortConfig.direction = sortConfig.direction === 'asc' ? 'desc' : 'asc';
        } else {
            sortConfig.key = key;
            sortConfig.direction = 'asc';
        }

        renderTable();
    });
});

searchInput.addEventListener("input", (e) => {
    const keyword = e.target.value.toLowerCase();
    filteredData = data.filter(item => {
        return (item.request_number+'').includes(keyword)
            || (item.vendor_name || '').toLowerCase().includes(keyword)
            || (item.requester_name || '').toLowerCase().includes(keyword)
            || (item.from_user || '').toLowerCase().includes(keyword);
    });
    currentPage = 1;
    renderTable();
});

document.getElementById("prevBtn").addEventListener("click", () => {
    if (currentPage > 1) {
        currentPage--;
        renderTable();
    }
});

document.getElementById("nextBtn").addEventListener("click", () => {
    if (currentPage < Math.ceil(filteredData.length / perPage)) {
        currentPage++;
        renderTable();
    }
});
document.getElementById("resetFilterBtn").addEventListener("click", () => {
    searchInput.value = "";
    filteredData = [...data];
    currentPage = 1;
    sortConfig = { key: null, direction: 'asc' }; // reset sort
    renderTable();
});
renderTable();
</script>

@endsection
