<?php

use Illuminate\Support\Facades\Route;
use App\Services\BusinessCentralService;
use App\Services\InventoryBC;
use App\Http\Controllers\BusinessCentralController;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\AzureAuthController;
use SocialiteProviders\Manager\SocialiteWasCalled;
use Illuminate\Support\Facades\Event;
use SocialiteProviders\Microsoft\MicrosoftExtendSocialite;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use App\Http\Controllers\OneDriveController;
use App\Http\Controllers\ItemRequestController;
use App\Http\Controllers\ApproveController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ItemRequestCommentController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\UserRequestController;
use App\Http\Controllers\TransferHeaderController;
use App\Services\requestToApproveService;



Event::listen(SocialiteWasCalled::class, function ($event) {
    $event->extendSocialite('microsoft', \SocialiteProviders\Microsoft\Provider::class);
});
Route::get('/', function () {
    return redirect()->route('login');
});
Route::get('/csrf/refresh', fn() => response()->json(['token' => csrf_token()]))->name('csrf.refresh');
Route::get('/login', [AzureAuthController::class, 'redirectToProvider'])->name('login');
Route::get('/auth/callback', [AzureAuthController::class, 'handleProviderCallback'])->name('azure.callback');
// TEMPORARY SUCCESS PAGE (ANTI LOOP)
Route::get('/oauth/success-temp', function () {
    return redirect()->route('approvals.list');
});
Route::get('/logout', [AzureAuthController::class, 'logout'])->name('logout');

Route::middleware(['bc.auth','admin.only'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('/', [AdminController::class, 'index'])->name('index');
        Route::post('/flows',          [AdminController::class, 'storeFlow'])->name('flows.store');
        Route::post('/flows/{flow}/toggle', [AdminController::class, 'toggleFlow'])->name('flows.toggle');
        Route::delete('/flows/{flow}', [AdminController::class, 'destroyFlow'])->name('flows.destroy');

        Route::post('/flows/{flow}/steps', [AdminController::class, 'storeStep'])->name('steps.store');
        Route::delete('/steps/{step}',      [AdminController::class, 'destroyStep'])->name('steps.destroy');

        Route::post('/users/{user}/role', [AdminController::class, 'updateUserRole'])->name('users.updateRole');
        Route::patch('/admin/users/{user}', [AdminController::class,'updateUser'])->name('users.update');
        Route::get('/instances', [AdminController::class, 'instances'])->name('instances');
        Route::get('/requests',  [AdminController::class, 'requests'])->name('requests');
        Route::post('/users', [AdminController::class, 'storeUser'])->name('users.store');
        Route::delete('/users/{user}', [AdminController::class, 'destroyUser'])->name('users.destroy');
        Route::post('/requests/{id}/reset',   [AdminController::class, 'requestResetDraft'])->name('requests.reset');
        Route::post('/requests/{id}/jump',    [AdminController::class, 'requestJumpStep'])->name('requests.jump');
        Route::post('/requests/{id}/approve', [AdminController::class, 'requestForceApprove'])->name('requests.forceApprove');
        Route::post('/requests/{id}/reject',  [AdminController::class, 'requestForceReject'])->name('requests.forceReject');
        Route::delete('/requests/{id}',       [AdminController::class, 'requestDestroy'])->name('requests.destroy');
        Route::post('/roles', [AdminController::class, 'storeRole'])->name('roles.store');
        Route::delete('/roles/{role}', [AdminController::class, 'destroyRole'])->name('roles.destroy');
    });

Route::middleware('bc.auth')->group(function () {
    Route::get('/approve/attachment/{id}', [ApproveController::class, 'previewAttachment'])
     ->name('approve.previewAttachment');
    Route::get('/reqToApprove', [requestToApproveService::class, 'getReqToApprove'])->name('getReqToApprove');
    Route::get('/getPurchaseLines', [requestToApproveService::class, 'getPurchaseLines'])->name('getPurchaseLines');
    Route::get('/getPLine', [requestToApproveService::class, 'getMyApprovalLines'])->name('getMyApprovalLines');
    Route::get('/approvals', [ApproveController::class, 'index'])->name('approvals.list');
    Route::get('/getAttachments', [ApproveController::class, 'getAttachments']);
    Route::post('/approverequest', [ApproveController::class, 'postrequestapprove'])->name('request.approved')->withoutMiddleware(['auth']);
    Route::post('/rejectrequest', [ApproveController::class, 'postrequestreject'])->name('request.rejected');
    Route::get('getaoservice', [BusinessCentralService::class, 'getAssemblyServiceData']);
    Route::post('/bc/reqworksheet/store', [BusinessCentralController::class, 'storeReqWorksheet'])
    ->name('bc.reqworksheet.store');
    Route::post('/bc/transfer/ship', [BusinessCentralController::class, 'shipSelected'])
    ->name('bc.shipSelected');
    Route::post('/bc/post-assembly', [BusinessCentralController::class, 'postAssemblyOrder'])
    ->name('bc.postAssembly');
    Route::get('/sku-mapping/export', [BusinessCentralController::class, 'exportSkuMapping'])
    ->name('sku.mapping.export');
    Route::get('/check-env', function () {
        dd([
            'AZURE_CLIENT_ID' => env('AZURE_CLIENT_ID'),
            'AZURE_CLIENT_SECRET' => env('AZURE_CLIENT_SECRET'),
            'AZURE_TENANT_ID' => env('AZURE_TENANT_ID'),
        ]);
    });
    Route::get('/switch-company/{type}', function ($type) {
        $role = session('user')['role'] ?? null;
        $email = session('user')['email'] ?? null;
    
        if ($role === 'Regent' && $type !== 'Regent') {
            abort(403, 'Unauthorized');
        }
        if ($role === 'HIN' && $type !== 'HIN') {
            abort(403, 'Unauthorized');
        }
    
        session(['current_company_name' => $type]);
    
        if ($email) {
            $cacheKey = 'po_suggestions_' . md5($email);
            Cache::forget($cacheKey);
            
        }
        
        $skuCacheKey = 'sku_mapping_cache';
        if (Cache::has($skuCacheKey)) {
            Cache::forget($skuCacheKey);
        }
        
        Session::forget(['po_items', 'vendor_map']);

        $prev = url()->previous();
        $prevRouteName = null;
        try {
            $prevRouteName = app('router')
                ->getRoutes()
                ->match(Request::create($prev))
                ->getName();
        } catch (\Throwable $e) {

        }

        $msg = "Switched to {$type} environment and cleared caches.";

        if (in_array($prevRouteName, ['approvals.show', 'approvals.edit'], true)) {
            return redirect()->route('approvals.mine')->with('success', $msg);
        }
    
        return redirect()
        ->back()
        ->with('success', "Switched to {$type} environment and cleared caches.");
    })->name('switch-company');
    //getItemInvenLoc
}); 
