<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Approval Portal'); ?></title>

    <!-- Bootstrap & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script defer src="https://unpkg.com/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>

    <!-- Pines UI (for accordion, cards, buttons) -->
    <link rel="stylesheet" href="https://unpkg.com/@pines-ui/core/dist/styles.css">
    <script src="https://unpkg.com/@pines-ui/core"></script>

    <style>
        :root {
            --brand-start: #0d6efd;
            --brand-end: #20c997;
        }

        .navbar-gradient {
            background: linear-gradient(135deg, var(--brand-start), var(--brand-end));
        }

        .navbar {
            padding-top: 0.6rem;
            padding-bottom: 0.6rem;
        }

        .navbar-brand {
            font-weight: 700;
            letter-spacing: 0.3px;
        }

        .navbar-nav .nav-item {
            display: flex;
            align-items: center;
        }

        .nav-link.active {
            background: rgba(255, 255, 255, .22);
            border-radius: 1rem;
        }

        body[data-theme="dark"] {
            background: #1f1f1f !important;
            color: #e5e5e5 !important;
        }

        .card-soft {
            border-radius: 1rem;
            border: 1px solid rgba(0, 0, 0, .08);
            box-shadow: 0 8px 24px rgba(0, 0, 0, .08);
        }

        .company-switcher {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 6px 12px;
            border-radius: 999px;
            background: rgba(255, 255, 255, 0.18);
            backdrop-filter: blur(6px);
            border: 1px solid rgba(255, 255, 255, 0.35);
            transition: all 0.25s ease;
        }

        .company-switcher:hover {
            background: rgba(255, 255, 255, 0.28);
        }

        .company-switcher i {
            color: #fff;
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .company-switcher select {
            border: none;
            background: transparent;
            color: #fff;
            font-weight: 600;
            font-size: 0.85rem;
            padding-right: 1rem;
            cursor: pointer;
            appearance: none;
        }

        .company-switcher select:focus {
            outline: none;
        }

        .company-switcher option {
            color: #000;
        }

        /* Dark mode compatibility */
        body[data-theme="dark"] .company-switcher {
            background: rgba(0, 0, 0, 0.35);
            border-color: rgba(255, 255, 255, 0.15);
        }

        .company-pill {
            background: rgba(255, 255, 255, 0.18);
            border-radius: 999px;
            padding: 6px 14px;
            border: 1px solid rgba(255, 255, 255, 0.35);
            backdrop-filter: blur(6px);
        }

        .dropdown-menu {
            border-radius: 0.75rem;
        }

        .dropdown-item.active {
            background-color: #0d6efd;
            color: #fff;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body x-data="theme()" x-init="init()" :data-theme="mode">

    <!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-gradient shadow-sm sticky-top">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center gap-2" href="#">
                <i class="fa-solid fa-check-double"></i>
                <span>Approval Portal</span>
            </a>

            <button class="navbar-toggler border-0" data-bs-toggle="collapse"
                data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-between" id="navbarNav">

                <!-- Left Nav -->
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('approvals.list') ? 'active' : ''); ?>"
                            href="<?php echo e(route('approvals.list')); ?>">
                            <i class="fa-solid fa-list-check me-1"></i> My Approvals
                        </a>
                    </li>
                </ul>

                <!-- Right Controls -->
                <ul class="navbar-nav align-items-center gap-3">

                    <li class="nav-item dropdown">
                        <button
                            class="btn btn-sm d-flex align-items-center gap-2 text-white company-pill"
                            data-bs-toggle="dropdown"
                            aria-expanded="false">

                            <i class="fa-solid fa-building"></i>
                            <?php echo e(session('current_company_name')); ?>

                            <i class="fa-solid fa-chevron-down small"></i>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-end shadow">
                            <li>
                                <a class="dropdown-item <?php echo e(session('current_company_name') === 'Regent' ? 'active' : ''); ?>"
                                href="<?php echo e(route('switch-company', ['type' => 'Regent'])); ?>">
                                    Regent
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item <?php echo e(session('current_company_name') === 'HIN' ? 'active' : ''); ?>"
                                href="<?php echo e(route('switch-company', ['type' => 'HIN'])); ?>">
                                    HIN
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- THEME TOGGLE -->
                    <li class="nav-item">
                        <button class="btn btn-sm btn-outline-light" @click="toggle()">
                            <i :class="mode === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon'"></i>
                        </button>
                    </li>

                    <?php if(session('user')): ?>
                        <li class="nav-item d-flex align-items-center gap-2">
                            <i class="fa-solid fa-user-circle"></i>
                            <span class="fw-semibold small"><?php echo e(data_get(session('user'), 'email')); ?></span>
                        </li>
                    <?php endif; ?>
                </ul>

            </div>
        </div>
    </nav>

    <!-- Page Content -->
    <main class="py-4">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- FOOTER -->
    <footer class="py-3 border-top mt-5 text-center small">
        &copy; <?php echo e(date('Y')); ?> Approval Portal
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        function theme() {
            return {
                mode: localStorage.getItem('theme') || 'light',
                init() { this.apply() },
                toggle() {
                    this.mode = this.mode === 'light' ? 'dark' : 'light';
                    localStorage.setItem('theme', this.mode);
                    this.apply();
                },
                apply() {
                    document.body.setAttribute('data-theme', this.mode);
                }
            }
        }
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/pawc5944/public_html/approvalpobc/resources/views/layouts/app.blade.php ENDPATH**/ ?>