<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ItemRequestAttachment extends Model
{
    protected $fillable = [
        'item_request_id','uploader_user_id','original_name','path','mime','size',
    ];

    public function request()
    {
        return $this->belongsTo(ItemRequest::class, 'item_request_id');
    }

    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploader_user_id');
    }
}