@extends('layouts.app')
@section('title','Edit Request #'.$req->id)

@push('styles')
<style>.card-rounded{border-radius:1rem}.quote-table td,.quote-table th{padding:.35rem .5rem}</style>
@endpush

@section('content')
<div class="container my-4"
     x-data="editForm(@js($req), @js($flows), @js($companies), @js(old('lines')))">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Edit Request #{{ $req->id }}</h1>
    <div class="d-flex gap-2">
      <a href="{{ route('approvals.show',$req->id) }}" class="btn btn-outline-secondary"><i class="fa fa-eye me-1"></i> View</a>
      <a href="{{ route('approvals.mine') }}" class="btn btn-outline-secondary"><i class="fa fa-inbox me-1"></i> My Forms</a>
    </div>
  </div>

  @if($errors->any())
    <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i>{{ $errors->first() }}</div>
  @endif

  <form method="POST" action="{{ route('approvals.update',$req->id) }}"  enctype="multipart/form-data" novalidate>
    @csrf @method('PUT')

    <div class="card card-rounded shadow-sm mb-3">
      <div class="card-header bg-light fw-semibold"><i class="fa fa-circle-info me-2"></i>Header</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label">Company</label>
            <select name="company_id" class="form-select" x-model="header.company_id" required>
              <template x-for="c in companies" :key="c.id">
                <option :value="c.id" x-text="c.code+' — '+c.name"></option>
              </template>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label">Flow Template</label>
            <select name="flow_template_id" class="form-select" x-model="header.flow_template_id" required>
              <template x-for="f in flows" :key="f.id">
                <option :value="f.id" x-text="f.name+' (v'+f.version+')'"></option>
              </template>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Posting Date</label>
            <input type="date" name="posting_date" class="form-control" x-model="header.posting_date">
          </div>
          <div class="col-md-6">
            <label class="form-label">Vendor (header)</label>
            <input type="text" name="vendor_name" class="form-control" x-model="header.vendor_name">
          </div>
          <div class="col-12">
            <label class="form-label">Remarks</label>
            <textarea name="remarks" rows="2" class="form-control" x-model="header.remarks"></textarea>
          </div>
          <div class="card card-rounded shadow-sm mb-3">
            <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
              <span><i class="fa fa-paperclip me-2"></i>Attachments</span>
              <small class="text-muted">Max 10 MB each</small>
            </div>
            <div class="card-body"
                x-data="{
                  files: [],
                  add(e){ this.files = Array.from(e.target.files || []); },
                  fmt(n){ return (n/1024/1024).toFixed(1) + ' MB'; }
                }">
              @isset($req)
                @if($req->attachments->count())
                  <div class="mb-3">
                    <div class="small text-muted mb-1">Existing files</div>
                    <ul class="list-group">
                      @foreach($req->attachments as $att)
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                          <div class="text-truncate">
                            <i class="fa fa-file me-2"></i>
                            <a href="{{ route('approvals.attachments.download', [$req->id, $att->id]) }}">
                              {{ $att->original_name }}
                            </a>
                            <small class="text-muted ms-2">({{ number_format($att->size/1024/1024,1) }} MB)</small>
                          </div>
                          @if($req->status === 'Draft')
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox"
                                name="delete_attachments[]" value="{{ $att->id }}" id="del_att_{{ $att->id }}">
                              <label class="form-check-label small text-danger" for="del_att_{{ $att->id }}">delete</label>
                            </div>
                          @endif
                        </li>
                      @endforeach
                    </ul>
                  </div>
                @endif
              @endisset

              <div class="mb-2">
                <input class="form-control"
                      type="file"
                      name="attachments[]"
                      multiple
                      accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx,.csv,.txt"
                      @change="add($event)">
                <small class="text-muted">You can select several files at once.</small>
              </div>

              <template x-if="files.length">
                <div class="mt-2">
                  <div class="small text-muted mb-1">To upload</div>
                  <ul class="list-group">
                    <template x-for="(f,i) in files" :key="i">
                      <li class="list-group-item d-flex justify-content-between">
                        <span x-text="f.name"></span>
                        <span class="text-muted" x-text="fmt(f.size)"></span>
                      </li>
                    </template>
                  </ul>
                </div>
              </template>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card card-rounded shadow-sm">
      <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <span class="fw-semibold"><i class="fa fa-list me-2"></i>Lines</span>
        <div class="d-flex gap-2">
          <button type="button" class="btn btn-outline-secondary btn-sm" @click="expandAll()"><i class="fa fa-angle-down me-1"></i>Expand</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" @click="collapseAll()"><i class="fa fa-angle-up me-1"></i>Collapse</button>
          <button type="button" class="btn btn-primary btn-sm" @click="add()"><i class="fa fa-plus me-1"></i>Add line</button>
        </div>
      </div>
      <div class="card-body">
        <div class="accordion" id="linesAcc">
          <template x-for="(ln, idx) in lines" :key="ln._id">
            <div class="accordion-item border rounded-3 mb-2">
              <h2 class="accordion-header d-flex align-items-stretch">
                <button class="accordion-button py-2" :class="{'collapsed': !ln._open}" type="button"
                        @click="ln._open=!ln._open" :aria-expanded="ln._open">
                  <span class="me-2 badge" :class="{'text-bg-primary': ln.type==='Inventory','text-bg-success': ln.type==='Service','text-bg-warning text-dark': ln.type==='NonInventory'}">
                    #<span x-text="idx+1"></span>
                  </span>
                  <span class="ms-2" x-text="ln.article_name || 'Article name…'"></span>
                </button>
                <div class="d-flex align-items-center px-2">
                  <button type="button" class="btn btn-outline-danger btn-sm" @click.stop="remove(idx)">
                    <i class="fa fa-trash"></i>
                  </button>
                </div>
              </h2>
              <div x-show="ln._open" x-collapse.duration.200ms>
                <div class="accordion-body bg-light">
                  <div class="row g-3">
                    <div class="col-md-6">
                      <label class="form-label">Article Name</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][article_name]'" x-model="ln.article_name" required>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Type</label>
                      <select class="form-select" :name="'lines['+idx+'][type]'" x-model="ln.type" required>
                        <option>Inventory</option><option>Service</option><option>NonInventory</option>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Base Unit</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][base_unit_code]'" x-model="ln.base_unit_code" required>
                    </div>

                    <div class="col-md-4">
                      <label class="form-label">GL Account (Service/NonInventory)</label>
                      <input type="text" class="form-control" :disabled="ln.type==='Inventory'"
                             :name="'lines['+idx+'][gl_account_no]'" x-model="ln.gl_account_no">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Inventory Posting Group</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][inventory_posting_group_code]'" x-model="ln.inventory_posting_group_code">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Gen. Prod. Posting Group</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][gen_prod_posting_group_code]'" x-model="ln.gen_prod_posting_group_code">
                    </div>

                    <div class="col-md-3">
                      <label class="form-label">L1</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][l1]'" x-model="ln.l1">
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">L2</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][l2]'" x-model="ln.l2">
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Local Article No</label>
                      <input type="text" class="form-control" :name="'lines['+idx+'][article_no]'" x-model="ln.article_no">
                    </div>
                    <div class="col-12">
                      <label class="form-label">Line Remarks</label>
                      <textarea rows="2" class="form-control" :name="'lines['+idx+'][line_remarks]'" x-model="ln.line_remarks"></textarea>
                    </div>

                    <div class="col-12">
                      <div class="d-flex justify-content-between align-items-center">
                        <label class="form-label mb-0">Vendor Quotes</label>
                        <button type="button" class="btn btn-outline-primary btn-sm" @click="addQuote(idx)"><i class="fa fa-plus me-1"></i>Add quote</button>
                      </div>
                      <div class="table-responsive mt-2">
                        <table class="table table-sm table-bordered quote-table align-middle bg-white">
                          <thead class="table-light">
                            <tr>
                              <th style="width:38px"></th>
                              <th>Vendor</th>
                              <th style="width:160px">Price</th>
                              <th style="width:120px">Currency</th>
                              <th style="width:38px"></th>
                            </tr>
                          </thead>
                          <tbody>
                            <template x-for="(q, qidx) in ln.vendor_quotes" :key="q._id">
                              <tr>
                                <td class="text-center">
                                  <input class="form-check-input" type="radio"
                                         :name="'lines['+idx+'][vendor_selected]'" :value="qidx"
                                         x-model="ln.vendor_selected">
                                </td>
                                <td>
                                  <input type="text" class="form-control form-control-sm"
                                         :name="'lines['+idx+'][vendor_quotes]['+qidx+'][name]'" x-model="q.name">
                                </td>
                                <td>
                                  <input type="number" step="0.0001" min="0" class="form-control form-control-sm"
                                         :name="'lines['+idx+'][vendor_quotes]['+qidx+'][price]'" x-model="q.price">
                                </td>
                                <td>
                                  <input type="text" class="form-control form-control-sm"
                                         :name="'lines['+idx+'][vendor_quotes]['+qidx+'][currency]'" x-model="q.currency">
                                </td>
                                <td class="text-center">
                                  <button type="button" class="btn btn-outline-danger btn-sm" @click="removeQuote(idx,qidx)"><i class="fa fa-trash"></i></button>
                                </td>
                              </tr>
                            </template>
                            <template x-if="!ln.vendor_quotes.length">
                              <tr><td colspan="5" class="text-muted">No quotes yet.</td></tr>
                            </template>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </template>
        </div>
      </div>

      <div class="card-footer d-flex justify-content-end gap-2">
        <a href="{{ route('approvals.show',$req->id) }}" class="btn btn-outline-secondary">Cancel</a>
        <button type="submit" class="btn btn-success"><i class="fa fa-save me-1"></i> Save changes</button>
      </div>
    </div>

  </form>
</div>

@push('scripts')
<script>
document.addEventListener('alpine:init', () => {
  const uid = () => 'id'+Math.random().toString(36).slice(2);
  Alpine.data('editForm', (req, flows, companies, oldLines) => ({
  flows, companies,
      header: {
        company_id:       {{ Js::from(old('company_id', $req->company_id ?? '')) }},
        flow_template_id: {{ Js::from(old('flow_template_id', $req->flow_template_id ?? '')) }},
        posting_date:     {{ Js::from(old('posting_date', ($req->posting_date ?? now())->format('Y-m-d'))) }},
        vendor_name:      {{ Js::from(old('vendor_name', $req->vendor_name ?? '')) }},
        remarks:          {{ Js::from(old('remarks', $req->remarks ?? '')) }},
      },
      lines: [],
      init(){
        const uid = () => 'id'+Math.random().toString(36).slice(2);
    
        const hydrateLine = (l) => {
          const quotes = Array.isArray(l.vendor_quotes)
            ? l.vendor_quotes.map(q => ({
                _id: uid(),
                name: q.name ?? '',
                price: q.price ?? '',
                currency: q.currency ?? 'IDR',
                selected: !!q.selected,
              }))
            : [];
          const selIdx = quotes.findIndex(q => q.selected === true);
          return {
            _id: uid(), _open: true,
            article_name: l.article_name || '',
            type: l.type || 'Inventory',
            base_unit_code: l.base_unit_code || '',
            gl_account_no: l.gl_account_no || '',
            inventory_posting_group_code: l.inventory_posting_group_code || '',
            gen_prod_posting_group_code: l.gen_prod_posting_group_code || '',
            l1: l.l1 || '', l2: l.l2 || '',
            article_no: l.article_no || '',
            line_remarks: l.line_remarks || '',
            vendor_selected: selIdx >= 0 ? selIdx : null,
            vendor_quotes: quotes,
          };
        };
    
        // Prefer old input (after validation error). Fallback to request's existing lines.
        if (Array.isArray(oldLines) && oldLines.length) {
          this.lines = oldLines.map(hydrateLine);
        } else {
          this.lines = Array.isArray(req.lines) ? req.lines.map(hydrateLine) : [];
          if (!this.lines.length) {
            this.add();
          }
        }
      },
      add(){ this.lines.push({_id:'id'+Math.random().toString(36).slice(2),_open:true,article_name:'',type:'Inventory',base_unit_code:'',gl_account_no:'',inventory_posting_group_code:'',gen_prod_posting_group_code:'',l1:'',l2:'',article_no:'',line_remarks:'',vendor_quotes:[],vendor_selected:null}); },
      remove(i){ this.lines.splice(i,1); if(!this.lines.length) this.add(); },
      expandAll(){ this.lines.forEach(l=>l._open=true); },
      collapseAll(){ this.lines.forEach(l=>l._open=false); },
      addQuote(i){ this.lines[i].vendor_quotes.push({_id:'id'+Math.random().toString(36).slice(2),name:'',price:'',currency:'IDR'}); },
      removeQuote(i,qi){
        const ln = this.lines[i];
        if (String(ln.vendor_selected)===String(qi)) ln.vendor_selected = null;
        ln.vendor_quotes.splice(qi,1);
      },
    }));
});
</script>
@endpush
@endsection
