    @extends('layouts.app')

    @section('title', 'PO Suggestions')
    @push('styles')
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
        <link rel="stylesheet" href="https://unpkg.com/vue-select@4.0.0/dist/style.css">
        <style>
            body {
                background-color: #f8f9fa;
                font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            }

            .container {
                max-width: 100%;

            }

            .card {
                border-radius: 1rem;
                box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
                border: none;
            }

            .card-header {
                background-color: #0d6efd;
                color: white;
                font-weight: 500;
                border-top-left-radius: 1rem;
                border-top-right-radius: 1rem;
            }

            .table input[type="checkbox"] {
                transform: scale(1.5); 
                margin: 0.3rem;
                cursor: pointer;
            }

            .table th, .table td {
                vertical-align: middle;
                font-size: 0.9rem;
            }

            .table th {
                background-color: #0d6efd;
                color: white;
            }

            .table tbody tr:hover {
                background-color: #f1f1f1;
            }

            .form-label {
                font-weight: 600;
                color: #333;
            }

            select[multiple] {
                min-height: 140px;
                overflow-y: auto;
            }

            select.form-select option {
                padding: 10px;
                font-weight: 500;
            }
            .btn {
                transition: all 0.2s ease-in-out;
            }
            .btn-success {
                border-radius: 10px;
                padding: 10px 24px;
                font-weight: 600;
                transition: all 0.3s ease;
            }

            .btn-success:hover {
                background-color: #198754;
                box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2);
                transform: translateY(-1px);
            }

            .pagination .page-link {
                color: #0d6efd;
                border-radius: 0.5rem;
                margin: 0 2px;
            }

            .pagination .page-item.active .page-link {
                background-color: #0d6efd;
                border-color: #0d6efd;
            }

            .table-responsive { overflow-x: auto; }

            .overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.6);
                z-index: 9999;
                display: flex;
                align-items: center;
                justify-content: center;
                animation: fadeIn 0.3s ease-in-out;
            }

            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }

            .btn:hover {
                transform: translateY(-1px);
                box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            }

            .spinner-box {
                text-align: center;
            }
            .table-scroll-wrapper {
                overflow-x: auto;
                cursor: grab;
            }

            .dropdown-box {
                position: absolute;
                z-index: 1000;
                width: 100%;
                background: white;
                border: 1px solid #ddd;
                border-radius: 6px;
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
                padding: 10px;
                max-height: 300px;
                overflow-y: auto;
            }

            @media (max-width: 768px) {
                .form-label { font-size: 0.85rem; }
                .form-control, .form-select { font-size: 0.85rem; }
                .table td { padding: 0.75rem 0.5rem; }
                .form-control, .form-select {
                    font-size: 0.9rem;
                }

                .table thead {
                    display: none;
                }

                .table tbody td {
                    display: block;
                    width: 100%;
                }

                .table tbody tr {
                    margin-bottom: 1rem;
                    border-bottom: 2px solid #dee2e6;
                }

                .table tbody td:before {
                    content: attr(data-label);
                    font-weight: bold;
                    display: block;
                    margin-bottom: 5px;
                    color: #495057;
                }
            }
        </style>
    @endpush

    @section('content')
    <div class="modal fade" id="spinnerModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                    <span class="visually-hidden">Loading...</span> 
                </div>
                <h5 class="mb-0">Processing, please wait...</h5>
            </div>
        </div>
    </div>
    <div id="app" class="container mt-4">

        <div class="row align-items-center mb-4">
            <div class="col-md-6 col-sm-12">
                <h2 class="mb-0">PO Suggestions</h2>
            </div>
            <div class="col-md-6 col-sm-12 text-md-end text-start mt-3 mt-md-0">
                <div class="d-flex justify-content-end gap-2 mb-4">
                    <form action="{{ route('refresh.po.suggestions') }}" method="POST">
                        @csrf
                        <button class="btn btn-outline-primary" :disabled="isSubmitting || isExporting">
                        <i class="bi bi-arrow-repeat me-1"></i> Refresh Cache
                        </button>
                    </form>

                    <button type="button" class="btn btn-outline-danger" @click="onExportClick" :disabled="isExporting">
                        <i class="bi bi-file-earmark-excel me-1"></i>
                        <span v-if="isExporting">Exporting...</span>
                        <span v-else>Export Missing Vendor</span>
                    </button>

                    <button type="button" class="btn btn-outline-success"
                            @click="onPOLineExportClick('Follow Up PO')"
                            :disabled="isExporting || isExportingPoLines || isSubmitting">
                    <i class="bi bi-file-earmark-excel me-1"></i>
                    <span v-if="isExporting">Exporting...</span>
                    <span v-else>Export Follow Up PO Lines</span>
                    </button>

                    <button type="button" class="btn btn-outline-secondary"
                            @click="onExportVisibleTable"
                            :disabled="isSubmitting || isExporting || isExportingPoLines || isExportingTable">
                    <i class="bi bi-file-earmark-excel me-1"></i>
                    <span v-if="isExporting">Exporting...</span>
                    <span v-else>Export Visible Table</span>
                    </button>
                </div>
            </div>
        </div>
        <div v-if="successMessage" class="alert alert-success">
                @{{ successMessage }}
                <ul>
                    <li v-for="po in createdPOs" :key="po.po_no">
                        Vendor: @{{ po.vendor }}, PO No: @{{ po.po_no }}, Lines: @{{ po.line_count }}
                    </li>
                </ul>
        </div>
        <div class="row mb-3">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <span><i class="bi bi-funnel me-2"></i>Filters</span>
                <button class="btn btn-outline-light btn-sm" @click="resetFilters">
                    <i class="bi bi-arrow-clockwise me-1"></i> Reset
                </button>
                </div>
                <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-4">
                    <label class="form-label">Search Vendor</label>
                    <input type="text" class="form-control" v-model="vendorSearch" placeholder="e.g., PRATAMA|AMRITHA">

                    <label class="form-label mt-3">Search Item</label>
                    <input type="text" class="form-control" v-model="itemSearch" placeholder="e.g., DRY GOODS|PASTRY">
                    </div>
                    <div class="col-md-4">
                    <label class="form-label">Filter by Transfer Order</label>
                    <div class="position-relative" ref="transferDropdownRef">
                        <div class="form-select d-flex justify-content-between align-items-center" @click="toggleDocumentDropdown" style="cursor: pointer;">
                        <span>@{{ selectedDocumentNo || 'All Document No' }}</span>
                        <i class="bi bi-caret-down-fill ms-auto"></i>
                        </div>
                        <div v-if="showDocumentDropdown" class="dropdown-box">
                        <input type="text" class="form-control form-control-sm mb-2" placeholder="Search..." v-model="documentDropdownSearch">
                        <button class="btn btn-sm btn-outline-secondary w-100 mb-2" @click="clearDocumentFilter">Clear</button>
                        <div class="form-check mb-1" v-for="doc in filteredDocumentOptions" :key="doc">
                            <input class="form-check-input" type="radio" :id="'doc-no-' + doc" :value="doc" v-model="selectedDocumentNo">
                            <label class="form-check-label" :for="'doc-no-' + doc">@{{ doc }}</label>
                        </div>
                        </div>
                    </div>

                    <label class="form-label mt-3">Shipment Date Range</label>
                    <div class="d-flex gap-2">
                        <input type="date" class="form-control" v-model="shipmentDateFrom">
                        <input type="date" class="form-control" v-model="shipmentDateTo">
                    </div>
                    </div>
                    <div class="col-md-4">
                    <label class="form-label">Filter by Location</label>
                    <div class="position-relative" ref="locationDropdownRef">
                        <div class="form-select d-flex justify-content-between align-items-center" @click="toggleLocationDropdown" style="cursor: pointer;">
                        <span>@{{ selectedLocation || 'All Locations' }}</span>
                        <i class="bi bi-caret-down-fill ms-auto"></i>
                        </div>
                        <div v-if="showLocationDropdown" class="dropdown-box">
                        <input type="text" class="form-control form-control-sm mb-2" placeholder="Search..." v-model="locationDropdownSearch">
                        <button class="btn btn-sm btn-outline-secondary w-100 mb-2" @click="clearLocationFilter">Clear</button>
                        <div class="form-check mb-1" v-for="loc in filteredLocationOptions" :key="loc">
                            <input class="form-check-input" type="radio" :id="'loc-' + loc" :value="loc" v-model="selectedLocation">
                            <label class="form-check-label" :for="'loc-' + loc">@{{ loc }}</label>
                        </div>
                        </div>
                    </div>

                    <label class="form-label mt-3">Filter by Active</label>
                    <select class="form-select" v-model="selectedActive">
                        <option :value="null">All</option>
                        <option :value="true">Active</option>
                        <option :value="false">Inactive</option>
                    </select>

                    <label class="form-label mt-3">Filter by Status</label>
                    <div class="d-flex flex-wrap gap-2">
                        <div v-for="status in statuses" :key="status" class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" :id="'status-' + status" :value="status" v-model="selectedStatus">
                        <label class="form-check-label" :for="'status-' + status">@{{ status }}</label>
                        </div>
                    </div>
                    
                    <label class="form-label mt-3">Filter by Need Shipment</label>
                        <select class="form-select" v-model="selectedNeedShipment">
                            <option :value="null">All</option>
                            <option :value="true">Need Shipment</option>
                            <option :value="false">No Shipment</option>
                        </select>
                    </div>
                </div>

                
                </div>
            </div>
            </div>

        <div class="text-end mb-3">
                <button type="button" class="btn btn-success btn-lg rounded-pill" @click="validateAndSubmit">
                    <i class="bi bi-check2-circle me-1"></i> Create PO
                </button>
        </div>
        <form ref="poForm" method="POST" action="{{ route('create-po') }}">
            @csrf
            <div class="table-responsive table-scroll-wrapper" ref="tableScroll" style="overflow-x: auto;">
            <table class="table table-bordered table-striped">
                <thead class="table-primary">
                <tr>
                    <th><input type="checkbox" @change="toggleSelectAll($event)" :checked="areAllFilteredSelected"></th>
                    <th @click="sortBy('item_no')" style="cursor:pointer">Item No <span v-if="sortKey === 'item_no'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th class="position-relative" ref="vendorDropdownRef">
                        <div style="min-width: 350px; max-width: 400px;" class="d-flex justify-content-between align-items-center">
                            <span @click="sortBy('vendor_no')" style="cursor:pointer;">
                                Vendors
                                <span v-if="sortKey === 'vendor_no'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span>
                            </span>
                            <i class="bi bi-filter-circle ms-2 text-dark fs-4" style="cursor:pointer; color: yellow;"  @click.stop="toggleVendorDropdown"></i>
                        </div>
                        <div v-if="showVendorDropdown" class="position-absolute bg-white text-dark border shadow p-2 rounded" style="z-index: 1000; width: 250px; right: 0; max-height: 300px; overflow-y: auto;">
                            <input type="text"
                            class="form-control form-control-sm mb-2"
                            placeholder="Search vendors..."
                            v-model="vendorDropdownSearch">
                            <button class="btn btn-sm btn-outline-secondary w-100 mt-2" @click="clearVendorFilter">Clear</button>
                            <div class="form-check mb-1" v-for="(name, no) in filteredVendorOptions" :key="no">
                                <input type="checkbox" class="form-check-input" :id="'dropdown-vendor-' + no" :value="no" v-model="selectedVendors">
                                <label class="form-check-label text-dark" :for="'dropdown-vendor-' + no">@{{ name }}</label>
                            </div>
                        </div>
                    </th>                
                    <th @click="sortBy('description')" style="cursor:pointer;white-space: nowrap;min-width: 250px;">Description <span v-if="sortKey === 'description'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('min_qty')" style="cursor:pointer">MinQty <span v-if="sortKey === 'min_qty'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('max_qty')" style="cursor:pointer">MaxQty <span v-if="sortKey === 'max_qty'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('stock')" style="cursor:pointer">Stock <span v-if="sortKey === 'stock'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('on_po')" style="cursor:pointer">OnPO <span v-if="sortKey === 'on_po'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('in_transfer')" style="cursor:pointer">InTransfer <span v-if="sortKey === 'in_transfer'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th @click="sortBy('qty_to_order')" style="cursor:pointer; width: 80px; text-align: right;">QtyToOrder <span v-if="sortKey === 'qty_to_order'">@{{ sortDirection === 'asc' ? '▲' : '▼' }}</span> </th>
                    <th style="min-width: 200px; white-space: nowrap;">Transfer Details</th>
                    <th style="white-space: nowrap;">Status</th>
                    <th style="min-width: 160px; white-space: nowrap; position: relative;" ref="statusDropdownRef">
                        <div style="min-width: 160px;">
                            <div class="d-flex justify-content-between align-items-center">
                                <span style="cursor:pointer;" @click="toggleStatusDropdown">
                                    Status Item
                                    <span v-if="selectedStatusItem.length">(@{{ selectedStatusItem.length }})</span>
                                </span>
                                <i class="bi bi-filter-circle ms-2 text-dark fs-5" style="cursor:pointer;" @click.stop="toggleStatusDropdown"></i>
                            </div>

                            <div v-if="showStatusDropdown"
                                class="position-absolute bg-white text-dark border shadow p-2 rounded mt-1"
                                style="z-index: 1000; width: 240px; right: 0; max-height: 300px; overflow-y: auto;">
                                <input type="text"
                                    class="form-control form-control-sm mb-2"
                                    placeholder="Search status..."
                                    v-model="statusDropdownSearch">

                                <div class="form-check mb-1" v-for="status in filteredStatusOptions" :key="status">
                                    <input type="checkbox"
                                        class="form-check-input"
                                        :id="'dropdown-status-' + status"
                                        :value="status"
                                        v-model="selectedStatusItem">
                                    <label class="form-check-label text-dark" :for="'dropdown-status-' + status">@{{ status }}</label>
                                </div>

                                <button class="btn btn-sm btn-outline-secondary w-100 mt-2" @click="clearStatusFilter">Clear</button>
                            </div>
                        </div>
                    </th>
                    <th style="min-width: 200px; white-space: nowrap;">Comment</th>
                    <th style="white-space: nowrap;">Active</th>
                    <th style="min-width: 200px; white-space: nowrap;">PO details</th>
                    <th style="min-width: 200px; white-space: nowrap;">Open PO details</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="item in paginatedItems" :key="item.item_no">                    
                    <td><input type="checkbox" name="selected_items[]" :value="item.item_no" v-model="selectedItems"></td>
                        <td>@{{ item.item_no }}</td>
                        <td>
                            <select class="form-select"
                                :name="'vendor_no[' + item.item_no + ']'"
                                v-model="item.vendor_no">
                            <option 
                                v-for="(vendor, vendorNo) in vendorOptionsByItem[item.item_no] || {}" 
                                :key="vendorNo" 
                                :value="vendorNo"
                            >
                                @{{ vendor.name }} - Rp @{{ Number(vendor.unit_cost).toLocaleString() }}
                            </option>
                            </select>
                        </td>
                        <td>@{{ item.description }}</td>
                        <td>@{{ item.min_qty }}</td>
                        <td>@{{ item.max_qty }}</td>
                        <td>@{{ item.stock }}</td>
                        <td>@{{ item.on_po }}</td>
                        <td>
                            @{{ item.in_transfer }}
                        </td>
                        <td>
                            {{-- <input type="hidden" :name="'qty_to_order[' + item.item_no + ']'" :value="item.qty_to_order"> --}}
                            <input 
                                type="number" 
                                class="form-control form-control-sm"
                                min="0"
                                step="any"
                                v-model.number="item.qty_to_order"
                                :name="'qty_to_order[' + item.item_no + ']'"
                            >
                        </td>
                        <td>
                            <div v-if="item.transfer_lines && item.transfer_lines.length" class="mt-1">
                                <small v-for="(transfer, index) in item.transfer_lines" :key="index" class="d-block text-muted">
                                    @{{ transfer.document_no }} - @{{ transfer.shipment_date }} - Qty: @{{ transfer.quantity }}
                                </small>
                            </div>
                        </td>
                        <td>
                            <span v-if="item.status && item.status.startsWith('Transfer')" class="badge bg-warning text-dark">@{{ item.status }}</span>
                            <span v-else-if="item.status === 'Order For Stock'" class="badge bg-success">@{{ item.status }}</span>
                            <span v-else-if="item.status === 'No Need Order'" class="badge bg-secondary">@{{ item.status }}</span>
                            <span v-else-if="item.status === 'Need Order'" class="badge bg-danger">@{{ item.status }}</span>
                            <span v-else-if="item.status === 'Need Order For TO'" class="badge bg-primary">@{{ item.status }}</span>
                            <span v-else-if="item.status === 'Follow Up PO'" class="badge bg-info">@{{ item.status }}</span>
                        </td>
                        <td>
                            <select class="form-select"
                                :name="'Status[' + item.item_no + ']'"
                                v-model="item.Status" 
                                @change="patchItemField(item.item_no, 'Status', item.Status)">
                            <option v-if="item.Status && !statusOptions.includes(item.Status)" :value="item.Status" selected>
                                @{{ item.Status }}
                            </option>
                            
                            <option disabled value="">-- Select Status --</option>

                            <option v-for="status in statusOptions" :key="status" :value="status">
                                @{{ status }}
                            </option>
                        </select>
                        </td>

                        <td>
                            <input type="text" class="form-control"
                                :name="'Comment[' + item.item_no + ']'"
                                v-model="item.Comment"
                                @blur="patchItemField(item.item_no, 'Comment', item.Comment)"
                            >
                        </td>

                        <td class="text-center">
                            <input type="checkbox"
                                class="form-check-input"
                                :name="'Active[' + item.item_no + ']'"
                                v-model="item.Active"
                                @change="patchItemField(item.item_no, 'Active', item.Active)"
                                true-value="true"
                                false-value="false">
                        </td>
                        <td>
                            <div v-if="item.po_lines && item.po_lines.length" class="mt-1">
                                <small v-for="(po, index) in item.po_lines" :key="index" class="d-block text-muted">
                                    @{{ po.document_no }} - @{{ po.approved_date || 'No Date' }} - @{{ po.status }} - Qty: @{{ po.outstanding_qty }}
                                </small>
                            </div>
                        </td>
                        <td>
                            <div v-if="item.openPo && item.openPo.length" class="mt-1">
                                <small v-for="(po, index) in item.openPo" :key="index" class="d-block text-muted">
                                    @{{ po.document_no }} - @{{ po.approved_date || 'No Date' }} - @{{ po.status }} - Qty: @{{ po.outstanding_qty }}
                                </small>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            </div>
            <nav>
                <ul class="pagination justify-content-center">
                    <li class="page-item" :class="{ disabled: currentPage === 1 }">
                        <a class="page-link" href="#" @click.prevent="currentPage--">Previous</a>
                    </li>
                    <li class="page-item" v-for="page in visiblePages" :key="page" :class="{ active: currentPage === page }">
                        <a class="page-link" href="#" @click.prevent="currentPage = page">@{{ page }}</a>
                    </li>

                    <li class="page-item" :class="{ disabled: currentPage === totalPages }">
                        <a class="page-link" href="#" @click.prevent="currentPage++">Next</a>
                    </li>
                </ul>
            </nav>
            <div class="text-end">
                <button type="button" class="btn btn-success btn-lg rounded-pill" @click="validateAndSubmit">
                    <i class="bi bi-check2-circle me-1"></i> Create PO
                </button>
            </div>
        </form>
        <div class="modal fade" id="columnPickerModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title"><i class="bi bi-columns-gap me-2"></i>Choose Columns to Export</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
    
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Columns</label>
                <div class="border rounded p-2" style="max-height: 380px; overflow-y:auto;">
                  <div class="form-check" v-for="col in availableColumns" :key="col.key">
                    <input class="form-check-input" type="checkbox" :id="'col-'+col.key"
                           :value="col.key" v-model="selectedColumns">
                    <label class="form-check-label" :for="'col-'+col.key">@{{ col.label }}</label>
                  </div>
                </div>
              </div>
    
              <div class="col-md-6">
                <label class="form-label">Order (top = first)</label>
                <ul class="list-group">
                  <li class="list-group-item d-flex align-items-center justify-content-between"
                      v-for="(key, idx) in orderedSelectedColumns" :key="key">
                    <span>@{{ labelFor(key) }}</span>
                    <span class="btn-group">
                      <button class="btn btn-sm btn-outline-secondary" @click="moveColumn(idx, -1)" :disabled="idx===0">
                        ↑
                      </button>
                      <button class="btn btn-sm btn-outline-secondary" @click="moveColumn(idx, 1)" :disabled="idx===orderedSelectedColumns.length-1">
                        ↓
                      </button>
                    </span>
                  </li>
                </ul>
                <small class="text-muted d-block mt-2">Tip: uncheck a column to remove it from the order list.</small>
              </div>
            </div>
    
          </div>
          <div class="modal-footer">
            <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-primary" @click="confirmExportVisibleTable">
              <i class="bi bi-file-earmark-excel me-1"></i> Export
            </button>
          </div>
        </div>
      </div>
    </div>
    </div>
    
    @endsection
    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/vue@3.4.0/dist/vue.global.prod.js"></script>
    <script src="https://unpkg.com/vue-select@4.0.0/dist/vue-select.iife.js"></script>
    <script>
        const { createApp } = Vue;    
        const app = createApp({
            data() {
                return {
                    selectedNeedShipment: null,
                    vendorOptionsByItem: @json($vendorOptionsByItem),
                    isSubmitting: false,
                    items: @json($items),
                    vendors: @json($vendors),
                    locations: @json($locations),
                    statuses: @json($statuses),
                    selectedStatus: [],
                    selectedItems: [],
                    selectedVendors: [],
                    selectedLocation: '',
                    selectedStatusItem: [],      
                    selectedActive: null,
                    statusDropdownSearch: '',
                    showLocationDropdown: false,
                    locationDropdownSearch: '',
                    itemSearch: '',
                    currentPage: 1,
                    perPage: 30,
                    vendorSearch: '',
                    sortKey: '',
                    sortDirection: 'asc',
                    isExporting: false,
                    showVendorDropdown: false,
                    showStatusDropdown: false,
                    vendorDropdownSearch: '',
                    selectedDocumentNo: '',
                    shipmentDateFrom: '',
                    shipmentDateTo: '',
                    showDocumentDropdown: false,
                    documentDropdownSearch: '',
                    successMessage: '',
                    createdPOs: [],
                    statusOptions: [
                    "Reservation", "Delivery", "Sourcing", "Need_PO", "Close_TO", "Change_TO",
                    "Follow_Up", "Butcher", "Parsial", "OS_Payment", "Close_Done",
                    "Wait_app_SBY", "Wait_Payment", "Priority", "__"
                    ],
                    availableColumns: [
                      { key: 'item_no',        label: 'Item No',        default: true },
                      { key: 'description',    label: 'Item Description', default: true },
                      { key: 'location_code',  label: 'Location',       default: true },
                      { key: 'min_qty',        label: 'min_qty',        default: true },
                      { key: 'max_qty',        label: 'max_qty',        default: true },
                      { key: 'stock',          label: 'stock',          default: true },
                      { key: 'on_po',          label: 'on_po',          default: true },
                      { key: 'in_transfer',    label: 'in_transfer',    default: true },
                      { key: 'qty_to_order',   label: 'qty_to_order',   default: true },
                      { key: 'status',         label: 'Item Status',    default: true },
                      { key: 'Status',         label: 'Status (Item)',  default: true },
                      { key: 'Active',         label: 'Active',         default: false },
                      { key: 'vendor_no',      label: 'Vendor No',      default: false },
                      { key: 'vendor_name',    label: 'Vendor Name',    default: false },
                      { key: 'unit_cost',      label: 'Unit Cost',      default: false },
                      { key: 'transfer_details', label: 'Transfer Details', default: false },
                      { key: 'po_details',       label: 'PO details',      default: false },
                      { key: 'open_po_details',  label: 'Open PO details', default: false },
                    ],
                    selectedColumns: [],            
                    columnOrder: [],                
                    isExportingTable: false,
                };
            },
            computed: {
                orderedSelectedColumns() {
                    const pos = k => {
                      const i = this.columnOrder.indexOf(k);
                      return i === -1 ? Number.MAX_SAFE_INTEGER : i; // unseen keys go to the end
                    };
                    return [...this.selectedColumns].sort((a, b) => pos(a) - pos(b));
                  },
            filteredStatusOptions() {
                const search = this.statusDropdownSearch.toLowerCase();
                return this.statusOptions.filter(s => s.toLowerCase().includes(search));
            },
            filteredLocationOptions() {
                return this.locations.filter(loc =>
                    loc.toLowerCase().includes(this.locationDropdownSearch.toLowerCase())
                );
            },
                filteredItems() {
                    let results = this.items.filter(item => {
                        const desc = (item.description ?? '').trim().toUpperCase();
                        if (desc.includes('FRUIT & VEGETABLE') || desc.includes('MEAT -') || desc.includes('SEAFOOD -')) return false;
                        const trimmedVendorNo = item.vendor_no?.trim() ?? '';
                        const matchLocation = !this.selectedLocation || item.location_code === this.selectedLocation;
                        const itemNo = String(item.item_no).trim();
                        const allVendorNames = Object.values(this.vendorOptionsByItem[itemNo] || {}).map(v => v.name);
                        const vendorKeywords = this.vendorSearch.toLowerCase().split('|').map(v => v.trim()).filter(v => v !== '');
                        const itemVendorNos = Object.keys(this.vendorOptionsByItem[item.item_no] || {});
                        const matchVendor = this.selectedVendors.length === 0 ||
                            this.selectedVendors.some(vendor => itemVendorNos.includes(vendor));
                        const matchVendorSearch = vendorKeywords.length === 0 ||
                            vendorKeywords.some(keyword =>
                                allVendorNames.some(name => name.toLowerCase().includes(keyword))
                            );                    
                        const itemKeywords = this.itemSearch.toLowerCase().split('|').map(v => v.trim()).filter(v => v !== '');
                        const matchStatus = this.selectedStatus.length === 0 || this.selectedStatus.includes(item.status);
                        const matchDocumentNo = !this.selectedDocumentNo || (item.transfer_lines || []).some(line =>
                            line.document_no === this.selectedDocumentNo
                        );

                        const matchShipmentDateRange =
                            !(this.shipmentDateFrom && this.shipmentDateTo) ||
                            (item.transfer_lines || []).some(line => {
                                if (!line.shipment_date) return false;
                                return line.shipment_date >= this.shipmentDateFrom && line.shipment_date <= this.shipmentDateTo;
                            });
                        const matchSearch = itemKeywords.length === 0 || itemKeywords.some(v => {
                            const searchText = `${item.item_no ?? ''} ${item.description ?? ''}`.toLowerCase();
                            return searchText.includes(v);
                        });
                        const activeMatch = this.selectedActive === null || item.Active === this.selectedActive;
                        const matchStatusItems =this.selectedStatusItem.length === 0 || this.selectedStatusItem.includes(item.Status);
                        const matchNeedShipment = this.selectedNeedShipment === null || item.need_shipment === this.selectedNeedShipment;
                        return (
                            matchVendor &&
                            matchVendorSearch &&
                            matchSearch &&
                            matchStatus &&
                            matchDocumentNo &&
                            matchShipmentDateRange &&
                            matchLocation && activeMatch && matchStatusItems &&
    matchNeedShipment
                        );

                    });
                    if (this.sortKey) {
                        results.sort((a, b) => {
                            const aVal = a[this.sortKey] ?? '';
                            const bVal = b[this.sortKey] ?? '';
                            if (typeof aVal === 'number' && typeof bVal === 'number') {
                                return this.sortDirection === 'asc' ? aVal - bVal : bVal - aVal;
                            }
                            return this.sortDirection === 'asc'
                                ? String(aVal).localeCompare(String(bVal))
                                : String(bVal).localeCompare(String(aVal));
                        });
                    }

                    return results;
                },
                paginatedItems() {
                    const start = (this.currentPage - 1) * this.perPage;
                    return this.filteredItems.slice(start, start + this.perPage);
                },
                totalPages() {
                    return Math.ceil(this.filteredItems.length / this.perPage);
                },
                pageStart() {
                    return Math.floor((this.currentPage - 1) / 10) * 10 + 1;
                },
                pageEnd() {
                    return Math.min(this.pageStart + 9, this.totalPages);
                },
                visiblePages() {
                    const pages = [];
                    for (let i = this.pageStart; i <= this.pageEnd; i++) {
                    pages.push(i);
                    }
                    return pages;
                },
                areAllFilteredSelected() {
                    return this.filteredItems.every(item => this.selectedItems.includes(item.item_no));
                },
                filteredVendorOptions() {
                    const vendorMap = {};
                    for (const item of this.filteredItems) {
                        const vendors = this.vendorOptionsByItem[item.item_no] || {};
                        for (const [vendorNo, vendor] of Object.entries(vendors)) {
                            if (
                                this.vendorDropdownSearch.trim() === '' ||
                                vendor.name.toLowerCase().includes(this.vendorDropdownSearch.toLowerCase())
                            ) {
                                vendorMap[vendorNo] = vendor.name;
                            }
                        }
                    }
                    return vendorMap;
                },
                filteredDocumentOptions() {
                    return this.uniqueDocumentNos.filter(doc =>
                        doc.toLowerCase().includes(this.documentDropdownSearch.toLowerCase())
                    );
                },
                uniqueDocumentNos() {
                    const docSet = new Set();
                    this.items.forEach(item => {
                        (item.transfer_lines || []).forEach(line => {
                            if (line.document_no) {
                                docSet.add(line.document_no);
                            }
                        });
                    });
                    return Array.from(docSet).sort();
                }
                
            },
            watch: {
                itemSearch() { this.currentPage = 1; },
                vendorSearch() { this.currentPage = 1; },
                selectedVendors() { this.currentPage = 1; },
                selectedStatus() { this.currentPage = 1; },
                currentPage(val) {
                    if (val > this.totalPages) {
                        this.currentPage = this.totalPages || 1;
                    }
                },
                selectedDocumentNo() { this.currentPage = 1; },
                shipmentDateFrom() { this.currentPage = 1; },
                shipmentDateTo() { this.currentPage = 1; },
                selectedColumns(newVal, oldVal) {
                newVal.forEach(k => {
                  if (!this.columnOrder.includes(k)) this.columnOrder.push(k);
                });
              },
            },
            methods: {
                labelFor(key) {
                    const c = this.availableColumns.find(c => c.key === key);
                    return c ? c.label : key;
                  },
                  moveColumn(idx, delta) {
                    const arr = this.columnOrder;
                    const newIdx = idx + delta;
                    if (newIdx < 0 || newIdx >= this.orderedSelectedColumns.length) return;
                
                    // swap within current order representation
                    const current = this.orderedSelectedColumns;
                    const a = current[idx], b = current[newIdx];
                
                    // reflect the swap in columnOrder (which may contain unselected keys)
                    const ia = this.columnOrder.indexOf(a);
                    const ib = this.columnOrder.indexOf(b);
                    [this.columnOrder[ia], this.columnOrder[ib]] = [this.columnOrder[ib], this.columnOrder[ia]];
                  },
                  onExportVisibleTable() {
                    const modal = new bootstrap.Modal(document.getElementById('columnPickerModal'));
                    modal.show();
                  },
                  confirmExportVisibleTable() {
                    this.isExportingTable = true;
                
                    const params = new URLSearchParams();
                
                    if (this.selectedLocation) params.append('location_code', this.selectedLocation);
                    (this.selectedVendors || []).forEach(v => params.append('selected_vendors[]', v));
                    if (this.vendorSearch) params.append('vendor_keywords', this.vendorSearch);
                    if (this.itemSearch) params.append('item_keywords', this.itemSearch);
                    (this.selectedStatus || []).forEach(s => params.append('selected_status[]', s));
                    (this.selectedStatusItem || []).forEach(s => params.append('selected_status_item[]', s));
                    if (this.selectedDocumentNo) params.append('document_no', this.selectedDocumentNo);
                    if (this.shipmentDateFrom)  params.append('ship_from', this.shipmentDateFrom);
                    if (this.shipmentDateTo)    params.append('ship_to', this.shipmentDateTo);
                    if (this.selectedActive !== null && this.selectedActive !== undefined)
                      params.append('active', String(this.selectedActive));
                    if (this.selectedNeedShipment !== null && this.selectedNeedShipment !== undefined) {
                      params.append('need_shipment', String(this.selectedNeedShipment));
                    }
                    // columns in chosen order
                    this.orderedSelectedColumns.forEach(col => params.append('columns[]', col));
                
                    window.open(`/bc/export-po-lines-visible?${params.toString()}`, '_blank');
                
                    // close modal and reset flag
                    bootstrap.Modal.getInstance(document.getElementById('columnPickerModal'))?.hide();
                    this.isExportingTable = false;
                  },
                toggleStatusDropdown() {
                    this.showStatusDropdown = !this.showStatusDropdown;
                    if (!this.showStatusDropdown) {
                        this.statusDropdownSearch = '';
                    }
                },
                clearStatusFilter() {
                    this.selectedStatusItem = [];
                    this.statusDropdownSearch = '';
                },
                toggleActive(value) {
                    this.selectedActive = this.selectedActive === value ? '' : value;
                },
                async patchItemField(item_no, field, value) {
                    const item = this.items.find(i => i.item_no === item_no);
                    if (!item) return;

                    const payload = {
                        item_no: item.item_no,
                        variant_code: item.variant_code || '',
                        location_code: item.location_code || '',
                        [field]: value
                    };
                    try {
                        await fetch(`/bc/bc-update-item`, {
                            method: 'PATCH',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                            },
                            body: JSON.stringify(payload)
                        });
                       console.log(`✅ ${field} updated for ${item_no}`);
                    } catch (err) {
                        console.error(`❌ Failed to update ${field} for ${item_no}`, err);
                    }
                },
                toggleLocationDropdown() {
                    this.showLocationDropdown = !this.showLocationDropdown;
                    if (!this.showLocationDropdown) {
                        this.locationDropdownSearch = '';
                    }
                },
                clearLocationFilter() {
                    this.selectedLocation = '';
                    this.locationDropdownSearch = '';
                    this.showLocationDropdown = false;
                },
                toggleVendorDropdown() {
                    this.showVendorDropdown = !this.showVendorDropdown;
                    if (!this.showVendorDropdown) {
                        this.vendorDropdownSearch = '';
                    }
                },
                clearVendorFilter() {
                    this.selectedVendors = [];
                    this.showVendorDropdown = false;
                },
                toggleDocumentDropdown() {
                    this.showDocumentDropdown = !this.showDocumentDropdown;
                    if (!this.showDocumentDropdown) {
                        this.documentDropdownSearch = '';
                    }
                },
                clearDocumentFilter() {
                    this.selectedDocumentNo = '';
                    this.documentDropdownSearch = '';
                    this.showDocumentDropdown = false;
                },
                resetFilters() {
                    this.itemSearch = '';
                    this.vendorSearch = '';
                    this.selectedVendors = [];
                    this.selectedStatus = [];
                    this.selectedDocumentNo = '';
                    this.shipmentDateFrom = '';
                    this.shipmentDateTo = '';
                    this.selectedStatusItem = [];
                    this.showDocumentDropdown = false;
                    this.showLocationDropdown = false;
                    this.showStatusDropdown = false;
                    this.showVendorDropdown = false;
                    this.currentPage = 1;
                },
                toggleSelectAll(event) {
                    const isChecked = event.target.checked;
                    const filteredIds = this.filteredItems.map(item => item.item_no);

                    if (isChecked) {
                        this.selectedItems = Array.from(new Set([...this.selectedItems, ...filteredIds]));
                    } else {
                        this.selectedItems = this.selectedItems.filter(id => !filteredIds.includes(id));
                    }
                },
                sortBy(key) {
                    if (this.sortKey === key) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    } else {
                        this.sortKey = key;
                        this.sortDirection = 'asc';
                    }
                },
                //  onExportVisibleTable() {
    //             this.isExporting = true;
    //             const params = new URLSearchParams();

    //             if (this.selectedLocation) params.append('location_code', this.selectedLocation);

    //             (this.selectedVendors || []).forEach(v => params.append('selected_vendors[]', v));
    //             if (this.vendorSearch) params.append('vendor_keywords', this.vendorSearch); 

    //             if (this.itemSearch) params.append('item_keywords', this.itemSearch);       
    //             (this.selectedStatus || []).forEach(s => params.append('selected_status[]', s));      
    //             (this.selectedStatusItem || []).forEach(s => params.append('selected_status_item[]', s)); 

    //             if (this.selectedDocumentNo) params.append('document_no', this.selectedDocumentNo);
    //             if (this.shipmentDateFrom)  params.append('ship_from', this.shipmentDateFrom); 
    //             if (this.shipmentDateTo)    params.append('ship_to', this.shipmentDateTo);

    //             if (this.selectedActive !== null && this.selectedActive !== undefined)
    //                 params.append('active', String(this.selectedActive));
    //             window.open(`/bc/export-po-lines-visible?${params.toString()}`, '_blank');
    //             this.isExporting = false;
    //             },
                onExportClick() {
                    this.isExporting = true;
                    this.baseExportUrl = '/bc/export-missing-vendor';
                    const locationCode = this.selectedLocation || '';

                    const exportUrl = `${this.baseExportUrl}?location_code=${locationCode}`;
                    window.open(exportUrl, '_blank');
                    this.isExporting = false;
                },
                onPOLineExportClick() {
                    this.isExporting = true;
                    const locationCode = this.selectedLocation || '';
                    const status = 'Follow Up PO';
                    const url = `/bc/export-po-lines?location_code=${encodeURIComponent(this.selectedLocation || '')}&status=${encodeURIComponent(status)}`;
                    window.open(url, '_blank');
                    this.isExporting = false
                },
                validateAndSubmit() {
                    const spinner = new bootstrap.Modal(document.getElementById('spinnerModal'));
                    spinner.show();

                    if (this.selectedItems.length === 0) {
                        alert("Please select at least one item to create a PO.");
                        return;
                    }
                    if (this.isSubmitting) return;

                    const itemsWithNoVendor = this.selectedItems.filter(itemNo => {
                        const item = this.items.find(i => i.item_no === itemNo);
                        return !item?.vendor_no;
                    });

                    if (itemsWithNoVendor.length > 0) {
                        alert(`The following items have no vendor selected:\n${itemsWithNoVendor.join(', ')}`);
                        return;
                    }

                    this.isSubmitting = true;

                    const postData = {
                        selected_items: this.selectedItems,
                        vendor_no: {},
                        qty_to_order: {},
                        unit_cost: {},
                        location_code: {}
                    };

                    this.selectedItems.forEach(itemNo => {
                        const item = this.items.find(i => i.item_no === itemNo);
                        if (!item) return;
                        postData.vendor_no[itemNo] = item.vendor_no ?? '';
                        postData.qty_to_order[itemNo] = item.qty_to_order ?? 0;
                        postData.location_code[itemNo] = item.location_code ?? '';
                        const selectedVendor = this.vendorOptionsByItem[itemNo]?.[item.vendor_no];
                        if (selectedVendor) {
                            postData.unit_cost[itemNo] = selectedVendor.unit_cost ?? 0;
                        }
                    });

                    axios.post('{{ route('create-po') }}', postData)
                    .then(response => {
                        this.items = this.items.filter(item => !this.selectedItems.includes(item.item_no));
                        this.selectedItems = [];
                        this.successMessage = response.data.success;
                        this.createdPOs = response.data.createdPOs;
                    })
                    .catch(error => {
                        if (error.response) {
                            // Server responded with a status other than 2xx
                            console.error("Response error:", error.response.data);
                            console.error("Status:", error.response.status);
                            console.error("Headers:", error.response.headers);
                            alert(`Error: ${error.response.data.message || 'Server returned an error'}`);
                        } else if (error.request) {
                            // Request made but no response
                            console.error("No response received:", error.request);
                            alert("No response received from server.");
                        } else {
                            // Something else happened
                            console.error("Error message:", error.message);
                            alert(`Error: ${error.message}`);
                        }
                    })
                    .finally(() => {
                        this.isSubmitting = false;
                        spinner.hide(); 
                    });
                }
            },
            mounted() {
                document.addEventListener('click', (e) => {
                    if (!this.$refs.vendorDropdownRef?.contains(e.target)) {
                        this.showVendorDropdown = false;
                    }
                    if (!this.$refs.transferDropdownRef?.contains(e.target)) {
                        this.showDocumentDropdown = false;
                    }
                    if (!this.$refs.locationDropdownRef?.contains(e.target)) {
                        this.showLocationDropdown = false;
                    }
                    if (!this.$refs.statusDropdownRef?.contains(e.target)) {
                        this.showStatusDropdown = false;
                    }
                });

                const el = this.$refs.tableScroll;
                let isDragging = false;
                let startX, scrollLeft;
                this.selectedColumns = this.availableColumns.filter(c => c.default).map(c => c.key);
                this.columnOrder = [...this.selectedColumns];

                el.addEventListener('contextmenu', e => e.preventDefault()); // disable right-click menu

                el.addEventListener('mousedown', (e) => {
                if (e.button === 2) {
                    isDragging = true;
                    el.style.cursor = 'grabbing';
                    startX = e.pageX - el.offsetLeft;
                    scrollLeft = el.scrollLeft;
                    e.preventDefault();
                }
                });

                el.addEventListener('mouseleave', () => {
                isDragging = false;
                el.style.cursor = 'grab';
                });

                el.addEventListener('mouseup', () => {
                isDragging = false;
                el.style.cursor = 'grab';
                });

                el.addEventListener('mousemove', (e) => {
                if (!isDragging) return;
                const x = e.pageX - el.offsetLeft;
                const walk = (x - startX) * 1;
                el.scrollLeft = scrollLeft - walk;
                });
            }
        })
        app.component('v-select', window['vue-select']);
        app.mount('#app');
    </script>
    @endpush