<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('line_vendors', function (Blueprint $t) {
      $t->id();
      $t->foreignId('item_request_line_id')->constrained()->cascadeOnDelete();
      $t->string('vendor_no');
      $t->unsignedInteger('rank_no');        // 1..n
      $t->boolean('is_chosen')->default(false);
      $t->string('notes',255)->nullable();
      $t->timestamps();
      $t->unique(['item_request_line_id','rank_no']);
    });
  }
  public function down(): void { Schema::dropIfExists('line_vendors'); }
};