<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('item_requests', function (Blueprint $table) {
            if (!Schema::hasColumn('item_requests', 'vendor_name')) {
                $table->string('vendor_name')->after('remarks');
            }
        });
    }

    public function down(): void
    {
        Schema::table('item_requests', function (Blueprint $table) {
            if (Schema::hasColumn('item_requests', 'vendor_name')) {
                $table->dropColumn('vendor_name');
            }
        });
    }
};