<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('item_request_lines', function (Blueprint $t) {
            if (!Schema::hasColumn('item_request_lines', 'vendor_quotes')) {
                $t->json('vendor_quotes')->nullable()->after('line_remarks'); 
            }
        });
    }

    public function down(): void {
        Schema::table('item_request_lines', function (Blueprint $t) {
            if (Schema::hasColumn('item_request_lines', 'vendor_quotes')) {
                $t->dropColumn('vendor_quotes');
            }
        });
    }
};
