<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();

            // Basic fields from API
            $table->string('item_no')->index();
            $table->string('description')->nullable();

            // Vendor info
            $table->string('vendor_name')->nullable();
            $table->string('vendor_no')->nullable();

            // Cost
            $table->decimal('unit_cost', 18, 4)->nullable();

            // UOM
            $table->string('uom')->nullable();           // default/base UOM
            $table->json('item_uom')->nullable();        // array dari API

            // Validity dates
            $table->string('starting_date')->nullable();
            $table->string('ending_date')->nullable();

            // Status
            $table->string('status_price')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
