<?php $__env->startSection('title', 'Outlet Order - Transfers'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container py-4">
        <div class="d-flex align-items-center mb-3 flex-wrap gap-2">
            <h3 class="fw-bold text-brown mb-0">Outlet Order</h3>
            <div class="ms-auto d-flex align-items-center gap-2 w-100 w-md-auto">
                <input id="soSearch" class="form-control form-control-sm flex-grow-1"
                    placeholder="Cari no / description / to-code ...">
                <select id="sortSelect" class="form-select form-select-sm w-auto">
                    <option value="default">Urutkan</option>
                    <option value="no-asc">No ↑</option>
                    <option value="no-desc">No ↓</option>
                    <option value="date-asc">Tanggal ↑</option>
                    <option value="date-desc">Tanggal ↓</option>
                    <option value="lines-desc">Jumlah Lines ↓</option>
                </select>
                <button id="refreshBtn" class="btn btn-sm btn-outline-brown">Refresh</button>
            </div>
        </div>

        <div id="soCount" class="text-muted small mb-3"></div>
        <div id="soList" class="row g-3"></div>
        <nav id="paginationWrap" aria-label="SO pagination" class="mt-3"></nav>

        <!-- Expand / Collapse Controls -->
        <div class="d-flex position-fixed gap-2" style="bottom: 80px; right:20px; z-index:9999;">
            <button id="expandAllBtn" class="btn btn-soft btn-sm px-2 py-1">
                ⬇️ Expand All
            </button>

            <button id="collapseAllBtn" class="btn btn-soft btn-sm px-2 py-1">
                ⬆️ Collapse All
            </button>
        </div>

        <!-- Ship Selected -->
        <button id="shipSelectedBtn" class="btn btn-brown position-fixed" style="bottom:20px; right:20px; z-index:9999;">
            🚚 Ship Selected ▸
        </button>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const soListEl = document.getElementById('soList');
            const soCount = document.getElementById('soCount');
            const soSearch = document.getElementById('soSearch');
            const refreshBtn = document.getElementById('refreshBtn');
            const sortSelect = document.getElementById('sortSelect');
            const paginationWrap = document.getElementById('paginationWrap');
            const shipSelectedBtn = document.getElementById('shipSelectedBtn');

            const API_URL = `<?php echo e(route('bc.transfer.with-lines')); ?>`;
            let dataStore = [];
            let filtered = [];
            let pageSize = 8;
            let currentPage = 1;

            async function fetchData() {
                showLoadingCards();
                try {
                    const res = await fetch(API_URL);
                    const json = await res.json();
                    if (res.ok && json.status === 'success') {
                        dataStore = json.data || [];
                        dataStore.sort((a, b) => new Date(a.shipmentDate) - new Date(b.shipmentDate));
                        filtered = dataStore;
                        renderList();
                    } else {
                        soListEl.innerHTML = `<div class='text-danger p-3'>Failed to fetch data.</div>`;
                    }
                } catch (e) {
                    soListEl.innerHTML =
                        `<div class='text-danger p-3'>Network error while fetching data.</div>`;
                }
            }

            function showLoadingCards() {
                soListEl.innerHTML = '';
                for (let i = 0; i < 4; i++) {
                    soListEl.innerHTML +=
                        `<div class='col-12'><div class='so-card p-4 fade-slide show'><div class='placeholder-glow'><span class='placeholder col-7'></span><br><span class='placeholder col-5'></span></div></div></div>`;
                }
            }

            function renderList() {
                const total = filtered.length;
                soCount.textContent = `${total} transfers`;
                const totalPages = Math.max(1, Math.ceil(total / pageSize));
                if (currentPage > totalPages) currentPage = totalPages;
                const start = (currentPage - 1) * pageSize;
                const pageData = filtered.slice(start, start + pageSize);

                soListEl.innerHTML = '';
                pageData.forEach((h, idx) => {
                    const collapseId = `collapse-${idx}`;
                    const card = document.createElement('div');
                    card.className = 'col-12 fade-slide show';
                    card.innerHTML = `
<div class='so-card p-0'>
  <div class='card-head'>
    <div class='d-flex align-items-center gap-2'>
      <input type='checkbox' class='form-check-input so-header-check' data-no='${escapeHtml(h.no)}'>
      <div>
        <div class='fw-semibold' style='font-size:1.02rem'>NO: ${escapeHtml(h.no ?? '-')}</div>
        <div class='small text-muted'>Due: ${escapeHtml(h.shipmentDate ?? '')}</div>
      </div>
    </div>
    <div class='d-flex flex-wrap align-items-center gap-2'>
      <div class='kv'>${escapeHtml(h.transferFromCode ?? '')} → <strong>${escapeHtml(h.transfertoCode ?? h.transferToCode ?? '')}</strong></div>
      <button class='btn btn-sm btn-outline-brown toggle-detail' data-bs-toggle='collapse' data-bs-target='#${collapseId}'>Detail ▾</button>
    </div>
  </div>
  <div id='${collapseId}' class='collapse'>
    <div class='p-3'>
      <div class='table-responsive'>
        <table class='table table-sm align-middle small'>
          <thead>
            <tr>
              <th></th>
              <th>No</th>
              <th>Item No</th>
              <th>Description</th>
              <th class='text-end'>Qty to Ship</th>
            </tr>
          </thead>
          <tbody>
            ${(h.Lines||[]).map((l, i) => `
                                                                  <tr>
                                                                    <td><input type='checkbox' class='form-check-input so-line-check' data-header='${escapeHtml(h.no)}' data-index='${i}'></td>
                                                                    <td>${i+1}</td>
                                                                    <td>${escapeHtml(l.itemNo ?? '-')}</td>
                                                                    <td>${escapeHtml(l.desc ?? '-')}</td>
                                                                    <td class='text-end'>
                                                                      <div class='d-flex justify-content-end align-items-center gap-1'>
                                                                        <input type='number' class='form-control form-control-sm text-end qty-input'
                                                                            style='width:70px' 
                                                                            min='0' 
                                                                            max='${l.quantity ?? 0}' 
                                                                            step='0.01'
                                                                            value=''
                                                                            placeholder='0'
                                                                            data-item='${escapeHtml(l.itemNo ?? '')}'
                                                                            data-header='${escapeHtml(h.no)}'
                                                                            data-index='${i}'>
                                                                        <span class='text-muted small'>/ 
                                          ${formatNumber(Math.max((l.quantity ?? 0) - (l.qtyShip ?? 0), 0))} 
                                          ${escapeHtml(l.uomCode ?? '')}
                                        </span>
                                                                      </div>
                                                                    </td>
                                                                  </tr>`).join('')}
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>`;
                    soListEl.appendChild(card);
                });

                renderPagination(totalPages);
                attachCheckboxLogic();
            }

            function renderPagination(totalPages) {
                if (totalPages <= 1) {
                    paginationWrap.innerHTML = '';
                    return;
                }
                let html = `<ul class='pagination justify-content-center flex-wrap'>`;
                html +=
                    `<li class='page-item ${currentPage===1?'disabled':''}'><a href='#' class='page-link' data-page='${currentPage-1}'>←</a></li>`;
                for (let i = 1; i <= totalPages; i++) {
                    html +=
                        `<li class='page-item ${i===currentPage?'active':''}'><a href='#' class='page-link' data-page='${i}'>${i}</a></li>`;
                }
                html +=
                    `<li class='page-item ${currentPage===totalPages?'disabled':''}'><a href='#' class='page-link' data-page='${currentPage+1}'>→</a></li>`;
                html += `</ul>`;
                paginationWrap.innerHTML = html;
                paginationWrap.querySelectorAll('.page-link').forEach(a => {
                    a.addEventListener('click', ev => {
                        ev.preventDefault();
                        const p = parseInt(a.dataset.page);
                        if (p >= 1 && p <= totalPages && p !== currentPage) {
                            currentPage = p;
                            renderList();
                            window.scrollTo({
                                top: 0,
                                behavior: 'smooth'
                            });
                        }
                    });
                });
            }

            function attachCheckboxLogic() {
                document.querySelectorAll('.so-header-check').forEach(headerCb => {
                    headerCb.addEventListener('change', () => {
                        const headerNo = headerCb.dataset.no;
                        const lineChecks = document.querySelectorAll(
                            `.so-line-check[data-header='${headerNo}']`);
                        lineChecks.forEach(cb => cb.checked = headerCb.checked);
                    });
                });

                document.querySelectorAll('.so-line-check').forEach(lineCb => {
                    lineCb.addEventListener('change', () => {
                        const headerNo = lineCb.dataset.header;
                        const allLines = document.querySelectorAll(
                            `.so-line-check[data-header='${headerNo}']`);
                        const allChecked = Array.from(allLines).every(cb => cb.checked);
                        const headerCb = document.querySelector(
                            `.so-header-check[data-no='${headerNo}']`);
                        if (headerCb) headerCb.checked = allChecked;
                    });
                });
            }

            function escapeHtml(s) {
                return String(s || '').replace(/[&<>]/g, c => ({
                    '&': '&amp;',
                    '<': '&lt;',
                    '>': '&gt;'
                } [c]));
            }

            function formatNumber(n) {
                return Number(n || 0).toLocaleString();
            }

            function applySearch() {
                const q = soSearch.value.trim().toLowerCase();
                filtered = !q ? dataStore : dataStore.filter(h =>
                    (h.no || '').toLowerCase().includes(q) ||
                    (h.transferFromCode || '').toLowerCase().includes(q) ||
                    (h.transfertoCode || h.transferToCode || '').toLowerCase().includes(q) ||
                    (h.postingDate || '').toLowerCase().includes(q) ||
                    (h.description || '').toLowerCase().includes(q)
                );
                currentPage = 1;
                applySort();
            }

            function applySort() {
                const sortBy = sortSelect.value;
                if (sortBy === 'no-asc') filtered.sort((a, b) => a.no.localeCompare(b.no));
                else if (sortBy === 'no-desc') filtered.sort((a, b) => b.no.localeCompare(a.no));
                else if (sortBy === 'date-asc') filtered.sort((a, b) => new Date(a.postingDate) - new Date(b
                    .postingDate));
                else if (sortBy === 'date-desc') filtered.sort((a, b) => new Date(b.postingDate) - new Date(a
                    .postingDate));
                else if (sortBy === 'lines-desc') filtered.sort((a, b) => (b.Lines?.length || 0) - (a.Lines
                    ?.length || 0));
                renderList();
            }

            soSearch.addEventListener('input', applySearch);
            sortSelect.addEventListener('change', applySort);
            refreshBtn.addEventListener('click', fetchData);

            // 🟢 Validasi qty input dan SweetAlert loading
            shipSelectedBtn.addEventListener('click', async () => {
                const checked = document.querySelectorAll('.so-line-check:checked');
                if (checked.length === 0 && document.querySelectorAll('.so-header-check:checked')
                    .length ===
                    0) {
                    Swal.fire('Tidak ada item dipilih', 'Pilih minimal satu item sebelum melanjutkan.',
                        'warning');
                    return;
                }

                for (const cb of checked) {
                    const headerNo = cb.dataset.header;
                    const index = cb.dataset.index;
                    const input = document.querySelector(
                        `.qty-input[data-header='${headerNo}'][data-index='${index}']`);
                    if (!input || input.value.trim() === '' || Number(input.value) <= 0) {
                        const itemNo = input?.dataset.item || '(Unknown)';
                        Swal.fire({
                            icon: 'warning',
                            title: 'Qty to Ship kosong',
                            text: `Item ${itemNo} pada transfer ${headerNo} harus diisi Qty to Ship.`
                        });
                        return;
                    }
                }

                const confirm = await Swal.fire({
                    title: 'Kirim barang sekarang?',
                    text: 'Pastikan semua data sudah benar sebelum melanjutkan.',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Ya, kirim sekarang',
                    cancelButtonText: 'Batal',
                    reverseButtons: true,
                    confirmButtonColor: '#a47148',
                    cancelButtonColor: '#ccc'
                });

                if (!confirm.isConfirmed) return;
                const payload = buildShipmentPayload();

                // 🔹 SweetAlert loading
                Swal.fire({
                    title: 'Processing shipment...',
                    html: 'Mohon tunggu sementara data sedang diproses.',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                $.ajax({
                    url: "<?php echo e(route('bc.shipSelected')); ?>",
                    method: "POST",
                    data: {
                        headers: payload.headers,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(res) {
                        Swal.close();
                        if (res.status === 'success') {
                            Swal.fire('Success', res.message, 'success');
                            setTimeout(() => {
                                location.reload();
                            }, 800);
                        } else {
                            Swal.fire('Partial / Error', res.message, 'warning');
                        }
                    },
                    error: function(xhr) {
                        Swal.close();
                        const msg = xhr.responseJSON?.message || 'Something went wrong';
                        Swal.fire('Error', msg, 'error');
                    }
                });
            });

            function buildShipmentPayload() {
                const selected = [];

                document.querySelectorAll('.so-header-check:checked').forEach(hcb => {
                    const headerNo = hcb.dataset.no;
                    const header = dataStore.find(x => x.no === headerNo);
                    if (!header) return;
                    selected.push({
                        etag: header['@odata.etag'] ?? null,
                        no: header.no,
                        Lines: header.Lines.map(l => ({
                            ...l,
                            quantityShip: Number(document.querySelector(
                                `.qty-input[data-header='${headerNo}'][data-item='${l.itemNo}']`
                            )?.value || 0)
                        }))
                    });
                });

                document.querySelectorAll('.so-line-check:checked').forEach(lcb => {
                    const headerNo = lcb.dataset.header;
                    const lineIdx = parseInt(lcb.dataset.index);
                    const existing = selected.find(x => x.no === headerNo);
                    const header = dataStore.find(x => x.no === headerNo);
                    const qtyInput = document.querySelector(
                        `.qty-input[data-header='${headerNo}'][data-index='${lineIdx}']`);
                    const qtyVal = Number(qtyInput?.value || 0);

                    if (!existing && header) {
                        selected.push({
                            etag: header['@odata.etag'] ?? null,
                            no: header.no,
                            Lines: [{
                                ...header.Lines[lineIdx],
                                quantityShip: qtyVal
                            }]
                        });
                    } else if (existing && header) {
                        if (!existing.Lines.some(l => l.itemNo === header.Lines[lineIdx].itemNo)) {
                            existing.Lines.push({
                                ...header.Lines[lineIdx],
                                quantityShip: qtyVal
                            });
                        }
                    }
                });

                return {
                    headers: selected
                };
            }

            fetchData();
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", () => {

            // Expand All
            document.getElementById("expandAllBtn").addEventListener("click", () => {
                document.querySelectorAll(".collapse").forEach(el => {
                    let bs = bootstrap.Collapse.getOrCreateInstance(el, {
                        toggle: false
                    });
                    bs.show();
                });
            });

            // Collapse All
            document.getElementById("collapseAllBtn").addEventListener("click", () => {
                document.querySelectorAll(".collapse").forEach(el => {
                    let bs = bootstrap.Collapse.getOrCreateInstance(el, {
                        toggle: false
                    });
                    bs.hide();
                });
            });

        });
    </script>


    <?php $__env->startPush('styles'); ?>
        <style>
            :root {
                --brown-soft: #A67856;
                --brown-soft-2: #D8B79A;
                --cream-bg: #fff9f4;
                --muted: #7a6a62;
            }

            body {
                background: var(--cream-bg);
            }

            /* dark theme adaptation */
            [data-bs-theme="dark"] body {
                background-color: #1e1c1a !important;
            }

            [data-bs-theme="dark"] .so-card {
                background: #2a2623 !important;
                border-color: rgba(255, 255, 255, 0.05) !important;
            }

            [data-bs-theme="dark"] .text-brown,
            [data-bs-theme="dark"] .kv,
            [data-bs-theme="dark"] .fw-semibold {
                color: #f5ede8 !important;
            }

            /* card */
            .so-card {
                background: linear-gradient(180deg, rgba(255, 255, 255, 0.98), rgba(255, 250, 245, 0.98));
                border-radius: 14px;
                box-shadow: 0 8px 24px rgba(103, 76, 62, 0.08);
                border: 1px solid rgba(166, 136, 116, 0.10);
                overflow: hidden;
                transition: transform .28s cubic-bezier(.2, .9, .2, 1), box-shadow .28s ease;
            }

            .so-card:hover {
                transform: translateY(-6px) scale(1.002);
                box-shadow: 0 18px 40px rgba(103, 76, 62, 0.12);
            }

            /* header strip */
            .so-card .card-head {
                padding: .9rem 1rem;
                display: flex;
                align-items: center;
                justify-content: space-between;
                flex-wrap: wrap;
                gap: 12px;
                border-bottom: 1px solid rgba(166, 136, 116, 0.06);
                background: linear-gradient(90deg, rgba(166, 136, 116, 0.04), rgba(216, 183, 154, 0.02));
            }

            /* small details */
            .so-meta {
                font-size: .86rem;
                color: var(--muted);
            }

            .badge-brown {
                background: rgba(166, 136, 116, 0.12);
                color: var(--brown-soft);
                border-radius: 999px;
                padding: .25rem .6rem;
                font-weight: 600;
            }

            /* animated caret */
            .caret-anim {
                transition: transform .32s cubic-bezier(.2, .9, .2, 1);
            }

            /* subtle progressive reveal */
            .fade-slide {
                opacity: 0;
                transform: translateY(8px);
                transition: opacity .36s ease, transform .36s cubic-bezier(.2, .9, .2, 1);
            }

            .fade-slide.show {
                opacity: 1;
                transform: translateY(0);
            }

            /* table */
            .table.small {
                font-size: .86rem;
            }

            /* page controls */
            .btn-outline-brown {
                color: var(--brown-soft);
                border-color: rgba(166, 136, 116, 0.18);
            }

            .btn-outline-brown:hover {
                background: rgba(166, 136, 116, 0.06);
            }

            /* small utilities */
            .kv {
                color: var(--muted);
                font-size: .9rem;
            }

            /* modal theme */
            .modal-theme {
                background: linear-gradient(90deg, rgba(150, 100, 60, 0.06), rgba(255, 240, 230, 0.03));
            }

            /* tablet friendly layout */
            @media (max-width: 992px) {
                .so-card .card-head {
                    flex-direction: column;
                    align-items: flex-start;
                }

                .so-card .p-3 {
                    font-size: 0.9rem;
                }

                #soSearch {
                    width: 100%;
                }
            }
        </style>
        <style>
            /* Tombol Ship Selected - floating style */
            #shipSelectedBtn {
                position: fixed;
                bottom: 25px;
                right: 35px;
                background-color: #a47148;
                /* warm brown */
                color: #fff;
                border: none;
                border-radius: 50px;
                padding: 12px 24px;
                font-weight: 600;
                box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
                transition: all 0.3s ease;
                z-index: 999;
            }

            #shipSelectedBtn:hover {
                background-color: #8c5e3c;
                transform: translateY(-2px);
                box-shadow: 0 6px 14px rgba(0, 0, 0, 0.25);
            }

            #shipSelectedBtn:disabled {
                opacity: 0.6;
                cursor: not-allowed;
            }

            /* Base Soft Button */
            .btn-soft {
                background-color: #f3e8dc !important;
                color: #5a4633 !important;
                border: 1px solid #d2bca3 !important;
                font-size: 0.8rem;
                padding: 4px 8px;
                border-radius: 8px;

                position: relative;
                overflow: hidden;

                /* Transitions lebih lembut */
                transition:
                    background-color 0.25s ease,
                    box-shadow 0.25s ease,
                    transform 0.22s cubic-bezier(0.22, 1, 0.36, 1);
            }

            /* Hover — floating effect sangat halus */
            .btn-soft:hover {
                background-color: #f8eee4 !important;
                transform: translateY(-1.2px);
                /* lebih halus dari -2px */
                box-shadow: 0 3px 8px rgba(0, 0, 0, 0.10);
                /* lebih soft */
            }

            /* Pressed — smooth shrink */
            .btn-soft:active {
                transform: scale(0.97);
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12);
            }

            /* Ripple Effect — lebih halus & lebih lembut */
            .btn-soft::after {
                content: "";
                position: absolute;
                width: 10px;
                height: 10px;
                background: rgba(255, 170, 80, 0.25);
                border-radius: 50%;
                transform: scale(0);
                opacity: 0;
                top: 50%;
                left: 50%;
                translate: -50% -50%;

                transition:
                    transform 0.55s cubic-bezier(0.22, 1, 0.36, 1),
                    opacity 0.55s ease-out;
            }

            .btn-soft:active::after {
                transform: scale(22);
                /* lebih halus daripada 25 */
                opacity: 0.35;
            }

            /* Icon Subtle Float */
            .btn-soft span {
                display: inline-block;
                transition: transform 0.25s ease;
            }

            .btn-soft:hover span {
                transform: translateY(1px);
                /* lebih halus dari 2px */
            }
        </style>
    <?php $__env->stopPush(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/butcher/resources/views/so/index.blade.php ENDPATH**/ ?>