

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold" style="color:#3B3B3B;">Assembly Order Approvals</h4>

        <div class="d-flex gap-2 align-items-center">

            
            <input type="text" id="searchBox" class="form-control form-control-sm" placeholder="Search recipe...">

            
            <select id="viewModeSelect" class="form-select form-select-sm">
                <option value="grid">🔳 Grid View</option>
                <option value="kitchen">🧾 Kitchen Ticket</option>
            </select>

            
            <select id="sortSelect" class="form-select form-select-sm">
                <option value="due_date">Sort by Due Date</option>
                <option value="posting_date">Sort by Posting Date</option>
                <option value="recipe_name">Sort by Recipe Name</option>
                <option value="status">Sort by Status</option>
            </select>
        </div>
    </div>

    
    <div id="aoListContainer" class="row g-3"></div>

</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('styles'); ?>
<script>
document.addEventListener('DOMContentLoaded', async () => {

    const container = document.getElementById('aoListContainer');
    const searchBox = document.getElementById('searchBox');
    const sortSelect = document.getElementById('sortSelect');
    const viewSelect = document.getElementById('viewModeSelect');

    let aoData = [];
    let currentView = viewSelect.value;

    /* ======================================================
       SKELETON LOADING
    ====================================================== */
    function showSkeleton(count = (currentView === 'grid' ? 6 : 4)) {
        container.innerHTML = '';
        for (let i = 0; i < count; i++) {
            const skeleton = document.createElement('div');
            skeleton.className = currentView === 'grid'
                ? 'col-md-4 col-lg-3'
                : 'col-md-4 col-lg-3';

            skeleton.innerHTML = `
                <div class="card shadow-sm border-0 h-100 p-3 skeleton shimmer"></div>
            `;
            container.appendChild(skeleton);
        }
    }

    function hideSkeleton() {
        container.innerHTML = '';
    }

    /* ======================================================
       FETCH AO DATA
    ====================================================== */
    async function fetchAOData() {
        showSkeleton();
        try {
            const res = await fetch('<?php echo e(route('getassemblyorder')); ?>');
            if (!res.ok) throw new Error(`HTTP ${res.status}`);

            const result = await res.json();
            const data = result.data ?? [];

            aoData = data.map(item => {
                let rawItems = item.lines || item.items || item.components || item.ItemLines || null;

                let items = [];
                if (Array.isArray(rawItems) && rawItems.length > 0) {
                    items = rawItems.map(line => {
                        const name = line.description || line.itemName || line.name || line.ItemDescription || line.ProductName || '';
                        const qty = line.quantity ?? line.Qty ?? line.qty ?? line.Quantity ?? 0;
                        const uom = line.uom || line.UnitOfMeasure || line.UoM || '';
                        return { name: name || item.description, qty: qty, uom };
                    });
                } else {
                    items = [{
                        name: item.description || 'Item',
                        qty: item.Quantity ?? item.qty ?? 1,
                        uom: item.uom || ''
                    }];
                }

                return {
                    docType: item.docType ?? item.DocType ?? '',
                    docNo: item.docNo || item.DocumentNo || item.No || (item.id ?? ''),
                    description: item.description ?? '',
                    recipe_name: item.description || item.recipe_name || item.name || '',
                    creationDate: item.creationDate ?? '',
                    itemNo: item.itemNo ?? '',
                    invPostGroup: item.invPostGroup ?? '',
                    genProd: item.genProd ?? '',
                    businessUnit: item.businessUnit ?? '',
                    quantity: item.Quantity ?? item.qty ?? 0,
                    QuantitytoAssemble: item.QuantitytoAssemble ?? 0,
                    postingDate: item.postingDate || item.posting_date || item.PostingDate || '',
                    dueDate: item.dueDate || item.due_date || item.DueDate || '',
                    noSeries: item.noSeries ?? '',
                    postingNoSeries: item.postingNoSeries ?? '',
                    status: item.status || item.Status || 'Open',
                    variantCode: item.variantCode ?? '',
                    locCode: item.locCode ?? '',
                    cost: item.CostAmount ?? item.cost ?? 0,
                    items
                };
            });

            hideSkeleton();
            filterAndSort();
        } catch (err) {
            console.error(err);
            container.innerHTML =
                `<div class="text-center text-danger py-3">Failed to load Assembly Orders</div>`;
        }
    }

    /* ======================================================
       REPLACED: RENDER GRID VIEW → renderCards()
    ====================================================== */
function renderCards(data) {
        container.innerHTML = '';
        data.forEach((ao, index) => {

            const statusClass =
                ao.status.toLowerCase() === 'released'
                    ? 'bg-success'
                    : 'bg-warning text-dark';

            const card = document.createElement('div');
            card.className = 'col-md-4 col-lg-3';

            card.innerHTML = `
                <div class="card shadow-sm border-0 ao-card h-100" data-status="${ao.status.toLowerCase()}" data-doc="${ao.docNo}" data-qty="${ao.quantity}">
                    <div class="card-body">

                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="badge ${statusClass}">${ao.status}</span>
                            <small class="text-muted">${ao.docNo}</small>
                        </div>

                        <h6 class="fw-semibold mb-1">${ao.recipe_name}</h6>

                        <div class="text-muted small mb-2">
                            Qty: <strong>${ao.quantity}</strong>
                        </div>

                        <div class="d-flex justify-content-between small text-muted">
                            <div><i class="bi bi-calendar-event me-1"></i> ${ao.postingDate}</div>
                            <div><i class="bi bi-hourglass-split me-1"></i> Due: ${ao.dueDate}</div>
                        </div>

                    </div>

                    <div class="card-footer bg-transparent border-0 d-flex justify-content-between">
                        <button class="btn btn-sm btn-outline-primary w-50 me-1 approve-btn">
                            <i class="bi bi-check2-circle"></i> Approve
                        </button>

                        <button class="btn btn-sm btn-outline-danger w-50 reject-btn">
                            <i class="bi bi-x-circle"></i> Reject
                        </button>
                    </div>

                </div>
            `;

            container.appendChild(card);
        });
    }

    /* ======================================================
        KITCHEN VIEW (TETAP)
    ====================================================== */
    function renderKitchenView(data) {
        container.innerHTML = '';

        data.forEach(ao => {

            const statusClass =
                ao.status.toLowerCase() === 'released'
                ? 'released-ticket'
                : 'pending-ticket';

            const ticket = document.createElement('div');
            ticket.className = 'col-md-4 col-lg-3 fadeIn';

            const itemsHtml = ao.items.map(it => {
                const displayName = (it.name || '').replace(/\s+/g, ' ').trim();
                const displayQty = it.qty ?? 0;
                const uom = it.uom ? ` ${it.uom}` : '';
                return `
                    <div class="kt-item-row">
                        <div class="kt-item-name">${escapeHtml(displayName)}</div>
                        <div class="kt-item-qty">${escapeHtml(String(displayQty))}${escapeHtml(uom)}</div>
                    </div>
                `;
            }).join('');

            ticket.innerHTML = `
                <div class="kitchen-ticket ${statusClass}" data-doc="${ao.docNo}" data-status="${ao.status.toLowerCase()}">

                    <div class="kt-header">
                        <div class="kt-title">ASSEMBLY ORDER</div>
                        <div class="kt-sub">
                            <div>#${ao.docNo}</div>
                            <div class="kt-status">${ao.status}</div>
                        </div>
                    </div>

                    <div class="kt-meta">
                        <div class="kt-meta-row"><span class="meta-label">Item:</span> <span class="meta-val">${ao.itemNo}</span></div>
                        <div class="kt-meta-row"><span class="meta-label">Loc:</span> <span class="meta-val">${ao.locCode}</span></div>
                        <div class="kt-meta-row"><span class="meta-label">Post:</span> <span class="meta-val">${ao.postingDate}</span></div>
                        <div class="kt-meta-row"><span class="meta-label">Due:</span> <span class="meta-val">${ao.dueDate}</span></div>
                        <div class="kt-meta-row"><span class="meta-label">InvGroup:</span> <span class="meta-val">${ao.invPostGroup}</span></div>
                        <div class="kt-meta-row"><span class="meta-label">GenProd:</span> <span class="meta-val">${ao.genProd}</span></div>
                    </div>

                    <div class="kt-divider"></div>

                    <div class="kt-items">
                        ${itemsHtml}
                    </div>

                    <div class="kt-divider"></div>

                    <div class="kt-footer">
                        <div class="kt-total">Total Items: <strong>${ao.items.length}</strong></div>
                        <div class="kt-cost">Est. Cost: <strong>${ao.cost}</strong></div>
                    </div>

                </div>
            `;

            container.appendChild(ticket);
        });
    }

    /* Escape Helper */
    function escapeHtml(unsafe) {
        return unsafe
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    /* ======================================================
       RENDER VIEW
    ====================================================== */
    function renderView(data) {
        if (currentView === 'grid') return renderCards(data);
        if (currentView === 'kitchen') return renderKitchenView(data);
    }

    /* ======================================================
       FILTER & SORT
    ====================================================== */
    function filterAndSort() {
        const query = (searchBox.value || '').toLowerCase();

        let filtered = aoData.filter(ao =>
            (ao.recipe_name || '').toLowerCase().includes(query)
        );

        filtered.sort((a, b) => {
            const postA = new Date(a.postingDate || 0);
            const postB = new Date(b.postingDate || 0);
            if (postA < postB) return 1;
            if (postA > postB) return -1;

            const dueA = new Date(a.dueDate || 0);
            const dueB = new Date(b.dueDate || 0);
            return dueA - dueB;
        });

        renderView(filtered);
    }

    searchBox.addEventListener('input', filterAndSort);
    sortSelect.addEventListener('change', filterAndSort);
    viewSelect.addEventListener('change', (e) => {
        currentView = e.target.value;
        filterAndSort();
    });

    /* ======================================================
       APPROVE / REJECT
    ====================================================== */
    container.addEventListener('click', async (e) => {
    const approveBtn = e.target.closest('.approve-btn');
    const rejectBtn = e.target.closest('.reject-btn');

    if (approveBtn) {
        const card = approveBtn.closest('.ao-card') || approveBtn.closest('.kitchen-ticket');
        const AssemblyNo = card?.dataset?.doc;
        const qtyBase = card?.dataset?.qty;
        if (!AssemblyNo) {
            console.warn('No AssemblyNo found for approve action.');
            return;
        }

        // === SWAL DENGAN INPUT SELECT ===
        const confirm = await Swal.fire({
            title: `Post Assembly Order ${AssemblyNo}?`,
            focusConfirm: false,
            showCancelButton: true,
            confirmButtonText: 'Ya, Post Sekarang',
            cancelButtonText: 'Batal',
            confirmButtonColor: '#a47148',
            cancelButtonColor: '#d3d3d3',
        });

        if (!confirm.isConfirmed) return;

        // Ubah tampilan tombol
        approveBtn.disabled = true;
        approveBtn.innerHTML =
            `<span class="spinner-border spinner-border-sm me-1"></span>Posting...`;

        try {
            // === KIRIM DATA KE SERVER ===
            const res = await fetch(`<?php echo e(route('bc.postAssembly')); ?>`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({
                    AssemblyNo,
                    qtyBase,
                })
            });

            const result = await res.json();
            console.log(result);
            if (res.ok && result.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Assembly Posted!',
                    text: `Assembly Order ${AssemblyNo} berhasil diposting.`,
                    showConfirmButton: false,
                    timer: 1000
                });

                setTimeout(() => location.reload(), 1000);
            } else {
                let errorMsg = result.message || 'Gagal memproses request.';

                if (result.response) {
                    try {
                        const parsed = JSON.parse(result.response);
                        if (parsed?.error?.message) {
                            errorMsg = parsed.error.message;
                        }
                    } catch (e) {}
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Gagal Posting Assembly!',
                    html: `<pre style="text-align:left;white-space:pre-wrap;">${errorMsg}</pre>`,
                    confirmButtonColor: '#a47148'
                });

                approveBtn.innerHTML = `<i class="bi bi-check2-circle"></i> Approve`;
                approveBtn.disabled = false;
            }
        } catch (error) {
            console.error(error);
            Swal.fire({
                icon: 'error',
                title: 'Server Error',
                text: error.message || 'Terjadi kesalahan tak terduga.'
            });

            approveBtn.innerHTML = `<i class="bi bi-check2-circle"></i> Approve`;
            approveBtn.disabled = false;
        }
    }

    if (rejectBtn) {
        const card = rejectBtn.closest('.ao-card') || rejectBtn.closest('.kitchen-ticket');
        if (card) {
            card.dataset.status = 'open';
        }

        Swal.fire({
            icon: 'info',
            title: 'Assembly Order dibuka kembali',
            timer: 1000,
            showConfirmButton: false
        });
    }
});

    /* ======================================================
       AUTO RELOAD
    ====================================================== */
    // setInterval(() => {
    //     fetchAOData();
    // }, 60000);

    /* ======================================================
       INITIAL LOAD
    ====================================================== */
    await fetchAOData();
});
</script>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('styles'); ?>
<style>
:root {
    --cream: #F7EFE5;
    --peach: #E6B7A9;
    --blue:  #6FA7CE;
    --dark:  #3B3B3B;
}

.ao-desc {
    white-space: normal !important;
    word-break: break-word;
}

.ao-card.ao-vertical {
    min-height: 320px;
    height: 100%;
    border-radius: 12px;
    background: #fff;
    padding: 10px;
    display: flex;
    flex-direction: column;
}

.kitchen-ticket {
    height: 100%;
}

.skeleton {
    background-color: #e2e2e2;
    position: relative;
    overflow: hidden;
    border-radius: 8px;
    height: 140px;
}
.skeleton.shimmer::before,
.shimmer::before {
    content: '';
    position: absolute;
    top: 0; left: -150px;
    height: 100%;
    width: 150px;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
    animation: shimmer 1.5s infinite;
}
@keyframes shimmer {
    0% { left: -150px; }
    100% { left: 100%; }
}

.kitchen-ticket {
    background: var(--cream);
    border: 2px solid var(--peach);
    border-radius: 10px;
    padding: 14px 16px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.06);
    transition: all .25s ease;
    margin-bottom: 12px;
}

.kitchen-ticket:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 18px rgba(0,0,0,0.09);
}

.kt-header {
    display: flex;
    flex-direction: column;
    gap: 6px;
    border-bottom: 2px dashed rgba(0,0,0,0.06);
    padding-bottom: 8px;
    margin-bottom: 10px;
}

.kt-title {
    font-size: 16px;
    font-weight: 800;
    color: var(--dark);
    letter-spacing: 1px;
}

.kt-sub {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 8px;
    color: var(--dark);
    font-size: 13px;
}

.kt-status {
    background: var(--peach);
    padding: 4px 8px;
    border-radius: 6px;
    font-weight: 700;
    font-size: 12px;
    color: #3b3b3b;
}

.kt-meta {
    display: flex;
    flex-direction: column;
    gap: 4px;
    font-size: 13px;
    color: #555;
}

.kt-meta-row {
    display: flex;
    gap: 6px;
}
.meta-label {
    color: #333;
    min-width: 70px;
    font-weight: 600;
}
.meta-val { color: #666; }

.kt-divider {
    height: 1px;
    background: linear-gradient(90deg, rgba(0,0,0,0.03), rgba(0,0,0,0.06), rgba(0,0,0,0.03));
    margin: 10px 0;
}

.kt-items {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.kt-item-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: rgba(111,167,206,0.05);
    padding: 8px 10px;
    border-radius: 8px;
    border: 1px solid rgba(111,167,206,0.06);
}

.kt-item-name {
    flex: 1 1 auto;
    font-weight: 600;
    color: var(--dark);
    white-space: normal;
    word-break: break-word;
    padding-right: 12px;
}

.kt-item-qty {
    flex: 0 0 auto;
    min-width: 60px;
    text-align: right;
    font-weight: 700;
    color: var(--dark);
}

.kt-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 8px;
    font-size: 13px;
    color: #444;
}

.released-ticket .kt-status {
    background: #4CAF50 !important;
    color: #fff;
}

.fadeIn {
    animation: fadeInUp .35s cubic-bezier(.22,.9,.32,1) both;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(8px); }
    to   { opacity: 1; transform: translateY(0); }
}
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/butcher/resources/views/aoApproval.blade.php ENDPATH**/ ?>