<?php $__env->startSection('content'); ?>
    <div class="container py-4">

        <!-- =========================
                                                                                                                                                     HEADER
                                                                                                                                                ========================== -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="fw-bold text-dark">
                <i class="fa-solid fa-chart-line text-primary me-2"></i>
                Butcher Operations Dashboard
            </h2>

            <button class="btn btn-sm btn-primary" id="refreshDash">
                <i class="fa-solid fa-rotate-right"></i> Refresh
            </button>
        </div>


        <!-- =========================
                                                                                                                                                     TOP SUMMARY CARDS — UPDATED STYLING
                                                                                                                                                ========================== -->
        <div class="row g-3 mb-4">

            <!-- Assembly Order -->
            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-blue">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Total Assembly Orders</div>
                            <h4 id="cardAO" class="fw-bold text-dark"><?php echo e($assemblyCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-blue">
                            <i class="fa-solid fa-screwdriver-wrench text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>



            <!-- Transfer Order to Warehouse -->
            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-orange">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Total Transfer Orders</div>
                            <h4 id="cardWarehouseTO" class="fw-bold text-dark"><?php echo e($warehouseCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-orange">
                            <i class="fa-solid fa-truck-ramp-box text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Outlet Orders -->
            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-green">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Total Outlet Orders</div>
                            <h4 id="cardOutlet" class="fw-bold text-dark"><?php echo e($outletCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-green">
                            <i class="fa-solid fa-store text-success"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Expiring Items -->
            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-red">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Total Expired Item (H-3)</div>
                            <h4 id="cardExpiring" class="fw-bold text-dark"><?php echo e($expiringCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-red">
                            <i class="fa-solid fa-triangle-exclamation text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-blue">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Outstanding Assembly Orders</div>
                            <h4 id="cardAO" class="fw-bold text-dark"><?php echo e($overdueAOCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-blue">
                            <i class="fa-solid fa-triangle-exclamation text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-orange">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Outstanding Transfer Orders</div>
                            <h4 id="cardWarehouseTO" class="fw-bold text-dark"><?php echo e($overdueTOCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-orange">
                            <i class="fa-solid fa-triangle-exclamation text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="dash-card p-3 shadow-sm rounded bg-white pastel-border-green">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="text-muted small">Outstanding Outlet Orders</div>
                            <h4 id="cardOutlet" class="fw-bold text-dark"><?php echo e($overdueOutletCount); ?></h4>
                        </div>

                        <div class="icon-bubble pastel-bg-green">
                            <i class="fa-solid fa-triangle-exclamation text-success"></i>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <!-- =========================
                                                                                                                                                     CHARTS AREA — PASTEL COLORS APPLIED
                                                                                                                                                ========================== -->
        <div class="row g-4 mb-4">

            <div class="col-lg-8">
                <div class="shadow-sm rounded bg-white p-3 chart-container">
                    <h6 class="fw-bold mb-2">
                        <i class="fa-solid fa-chart-area text-primary me-2"></i>
                        Transfer Order
                    </h6>
                    <canvas id="aoChart" height="120"></canvas>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="shadow-sm rounded bg-white p-3 chart-container">
                    <h6 class="fw-bold mb-2">
                        <i class="fa-solid fa-diagram-project text-success me-2"></i>
                        Outlet Order
                    </h6>
                    <canvas id="stockPie" height="120"></canvas>
                </div>
            </div>

        </div>


        <!-- =============================================================
                                                                                     NAVIGATION TABS
                                                                                ============================================================== -->
        <ul class="nav nav-tabs mb-4" id="dashboardTabs">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#tabExpired">
                    <i class="fa-solid fa-triangle-exclamation text-danger me-1"></i> Expired Items
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabAO">
                    <i class="fa-solid fa-list-check text-primary me-1"></i> Assembly Orders
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabOutlet">
                    <i class="fa-solid fa-shop text-success me-1"></i> Outlet Orders
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabTO">
                    <i class="fa-solid fa-truck-ramp-box text-warning me-1"></i> Transfer Orders
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabexpAO">
                    <i class="fa-solid fa-triangle-exclamation text-primary me-1"></i> Outstanding Assembly Orders
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabexpOutlet">
                    <i class="fa-solid fa-triangle-exclamation text-success me-1"></i> Outstanding Outlet Orders
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tabExpiredTO">
                    <i class="fa-solid fa-triangle-exclamation text-warning me-1"></i>Outstanding Transfer Orders
                </a>
            </li>
        </ul>

        <!-- =============================================================
                                                                                     TAB CONTENT
                                                                                ============================================================== -->
        <div class="tab-content">

            <!-- =======================
                                                                                         TAB: EXPIRED
                                                                                    =========================== -->
            <div class="tab-pane fade show active" id="tabExpired">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Expired Items Soon
                    </h6>

                    <table class="table table-sm align-middle" id="expiredTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('expired','LotNo')">Lot No <span id="expired-LotNo-icon"
                                        class="expired-sort-icon"></span></th>
                                <th onclick="sortTable('expired','itemNo')">Item <span id="expired-itemNo-icon"
                                        class="expired-sort-icon"></span></th>
                                <th onclick="sortTable('expired','desc')">Deskripsi <span id="expired-desc-icon"
                                        class="expired-sort-icon"></span></th>
                                <th onclick="sortTable('expired','Quantity')">Qty <span id="expired-Quantity-icon"
                                        class="expired-sort-icon"></span></th>
                                <th onclick="sortTable('expired','expDate')">ExpDate <span id="expired-expDate-icon"
                                        class="expired-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableExpired"></tbody>
                    </table>
                </div>
            </div>

            <!-- =======================
                                                                                         TAB: AO
                                                                                    =========================== -->
            <div class="tab-pane fade" id="tabAO">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Latest Assembly Orders
                    </h6>

                    <table class="table table-sm align-middle" id="aoTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('ao','docNo')">Doc No <span id="ao-docNo-icon"
                                        class="ao-sort-icon"></span></th>
                                <th onclick="sortTable('ao','itemNo')">Item <span id="ao-itemNo-icon"
                                        class="ao-sort-icon"></span></th>
                                <th onclick="sortTable('ao','Quantity')">Qty <span id="ao-Quantity-icon"
                                        class="ao-sort-icon"></span></th>
                                <th onclick="sortTable('ao','duedate')">Due Date <span id="ao-duedate-icon"
                                        class="ao-sort-icon"></span></th>
                                <th onclick="sortTable('ao','status')">Status <span id="ao-status-icon"
                                        class="ao-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableAO"></tbody>
                    </table>
                </div>
            </div>

            <!-- =======================
                                                                                         TAB: OUTLET
                                                                                    =========================== -->
            <div class="tab-pane fade" id="tabOutlet">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Latest Outlet Orders
                    </h6>

                    <table class="table table-sm align-middle" id="outletTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('outlet','docNo')">Doc No <span id="outlet-docNo-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','outlet')">Outlet <span id="outlet-outlet-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','itemNo')">Item <span id="outlet-itemNo-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','desc')">Deskripsi <span id="outlet-desc-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','qty')">Qty <span id="outlet-qty-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','qty_remain')">Qty Remain <span
                                        id="outlet-qty_remain-icon" class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','shipdate')">Shipment Date <span id="outlet-shipdate-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('outlet','status')">Status <span id="outlet-status-icon"
                                        class="outlet-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableOutlet"></tbody>
                    </table>
                </div>
            </div>

            <!-- =======================
                                                                                         TAB: TO
                                                                                    =========================== -->
            <div class="tab-pane fade" id="tabTO">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Latest Transfer Order (Material)
                    </h6>

                    <table class="table table-sm align-middle" id="aoTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('to','documentNo')">Doc No <span id="to-documentNo-icon"
                                        class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','itemNo')">Item <span id="to-itemNo-icon"
                                        class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','desc')">Deskripsi <span id="to-desc-icon"
                                        class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','Quantity')">Qty <span id="to-Quantity-icon"
                                        class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','Quantity_remain')">Qty Remain <span
                                        id="to-Quantity_remain-icon" class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','ShipDate')">Shipment Date <span id="to-ShipDate-icon"
                                        class="to-sort-icon"></span></th>
                                <th onclick="sortTable('to','status')">Status <span id="to-status-icon"
                                        class="to-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableTO"></tbody>
                    </table>
                </div>
            </div>


            <div class="tab-pane fade" id="tabexpAO">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Outstanding Assembly Orders
                    </h6>

                    <table class="table table-sm align-middle" id="aoTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('expao','docNo')">Doc No <span id="expao-docNo-icon"
                                        class="expao-sort-icon"></span></th>
                                <th onclick="sortTable('expao','itemNo')">Item <span id="expao-itemNo-icon"
                                        class="expao-sort-icon"></span></th>
                                <th onclick="sortTable('expao','Quantity')">Qty <span id="expao-Quantity-icon"
                                        class="expao-sort-icon"></span></th>
                                <th onclick="sortTable('expao','duedate')">Due Date <span id="expao-duedate-icon"
                                        class="expao-sort-icon"></span></th>
                                <th onclick="sortTable('expao','status')">Status <span id="expao-status-icon"
                                        class="expao-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableexpAO"></tbody>
                    </table>
                </div>
            </div>

            <div class="tab-pane fade" id="tabexpOutlet">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Outstanding Outlet Orders
                    </h6>

                    <table class="table table-sm align-middle" id="outletTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('expoutlet','docNo')">Doc No <span id="expoutlet-docNo-icon"
                                        class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','outlet')">Outlet <span id="expoutlet-outlet-icon"
                                        class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','itemNo')">Item <span id="expoutlet-itemNo-icon"
                                        class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','desc')">Deskripsi <span id="expoutlet-desc-icon"
                                        class="outlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','qty')">Qty <span id="expoutlet-qty-icon"
                                        class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','qty_remain')">Qty Remain <span
                                        id="expoutlet-qty_remain-icon" class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','shipdate')">Shipment Date <span id="expoutlet-shipdate-icon"
                                        class="expoutlet-sort-icon"></span></th>
                                <th onclick="sortTable('expoutlet','status')">Status <span id="expoutlet-status-icon"
                                        class="expoutlet-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="tableexpOutlet"></tbody>
                    </table>
                </div>
            </div>

            <div class="tab-pane fade" id="tabExpiredTO">
                <div class="shadow-sm rounded bg-white p-3">
                    <h6 class="fw-bold mb-3">
                        Outstanding Transfer Order (Material)
                    </h6>

                    <table class="table table-sm align-middle" id="expaoTableWrap">
                        <thead class="table-light">
                            <tr>
                                <th class="sortable">#</th>
                                <th onclick="sortTable('expto','documentNo')">Doc No <span id="expto-documentNo-icon"
                                        class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','itemNo')">Item <span id="expto-itemNo-icon"
                                        class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','desc')">Deskripsi <span id="expto-desc-icon"
                                        class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','Quantity')">Qty <span id="expto-Quantity-icon"
                                        class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','Quantity_remain')">Qty Remain <span
                                        id="expto-Quantity_remain-icon" class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','ShipDate')">Shipment Date <span id="expto-ShipDate-icon"
                                        class="expto-sort-icon"></span></th>
                                <th onclick="sortTable('expto','status')">Status <span id="expto-status-icon"
                                        class="expto-sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody id="ExpiredTO"></tbody>
                    </table>
                </div>
            </div>

        </div>



    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('scripts'); ?>
    <script>
        /* ======================================================
                                                                                                                       DUMMY DATA — SAME AS ORIGINAL
                                                                                                                    ======================================================*/
        const aoList = <?php echo json_encode($aolist, 15, 512) ?>;
        const outletlist = <?php echo json_encode($outletlist, 15, 512) ?>;
        const toList = <?php echo json_encode($tolist, 15, 512) ?>;
        const expiredList = <?php echo json_encode($expiringItems, 15, 512) ?>;
        const aoLabels = [...Array(14).keys()].map(i => "Day " + (i + 1));
        const inout = {
            inbound: [5, 7, 4, 6, 10, 9, 12, 11, 13, 10, 9, 8, 6, 7],
            outbound: [3, 4, 6, 5, 7, 8, 10, 9, 12, 11, 13, 9, 8, 7]
        };

        const expiryDist = [3, 5, 12, 20, 10];
        const expiryLabel = ["H-0/H-3", "H-7", "H-14", "H-21", "H-30+"];
        const today = new Date();
        today.setHours(0, 0, 0, 0);

        /* ======================================================
           TABLE AO DATA
        ======================================================*/
        let aoData = aoList.map((row, i) => ({
            no: i + 1,
            docNo: row.docNo,
            itemNo: row.itemNo,
            Quantity: row.Quantity,
            duedate: row.dueDate,
            status: row.status
        }));

        let expiredAoData = aoList
            .map((row, i) => ({
                no: i + 1,
                docNo: row.docNo,
                itemNo: row.itemNo,
                Quantity: row.Quantity,
                duedate: row.dueDate,
                status: row.status
            }))
            .filter(row => {
                if (!row.duedate) return false; // proteksi jika kosong/null

                const due = new Date(row.duedate);
                return due < today; // hanya ambil yang lewat
            });

        /* ======================================================
           OUTLET FLATTEN
        ======================================================*/
        let outletData = [];
        outletlist.forEach(doc => {
            if (!doc.Lines || !Array.isArray(doc.Lines)) return;

            doc.Lines.forEach(line => {
                const qty = Number(line.quantity) || 0;
                const shipped = Number(line.qtyShip) || 0;

                // Hitung dan perbaiki floating error
                const rawRemain = qty - shipped;
                const remain = Number(rawRemain.toFixed(2));
                outletData.push({
                    docNo: doc.no,
                    outlet: doc.transfertoCode,
                    itemNo: line.itemNo,
                    desc: line.desc,
                    qty: line.quantity,
                    qty_remain: remain,
                    shipdate: line.shipmentDate,
                    status: line.status,
                    Uom: line.uomCode,
                });
            });
        });

        let epxoutletData = [];
        outletlist.forEach(doc => {
            if (!doc.Lines || !Array.isArray(doc.Lines)) return;

            doc.Lines.forEach(line => {
                const qty = Number(line.quantity) || 0;
                const shipped = Number(line.qtyShip) || 0;

                // Hitung dan perbaiki floating error
                const rawRemain = qty - shipped;
                const remain = Number(rawRemain.toFixed(2));

                // Convert shipdate ke Date object
                const shipDateObj = new Date(line.shipmentDate);

                // Hanya masukkan jika shipdate sudah lewat hari ini
                if (shipDateObj < today) {
                    epxoutletData.push({
                        docNo: doc.no,
                        outlet: doc.transfertoCode,
                        itemNo: line.itemNo,
                        desc: line.desc,
                        qty: qty,
                        qty_remain: remain,
                        shipdate: line.shipmentDate,
                        status: line.status,
                        Uom: line.uomCode,
                    });
                }
            });
        });


        /* ======================================================
           TO FLATTEN
        ======================================================*/
        let toData = toList.map((row, i) => {
            const qty = Number(row.quantity) || 0;
            const shipped = Number(row.qtyShip) || 0;

            // Hitung dan perbaiki floating error
            const rawRemain = qty - shipped;
            const remain = Number(rawRemain.toFixed(2)); // hasil: 0.2, bukan 0.1999999999

            return {
                no: i + 1,
                documentNo: row.documentNo,
                itemNo: row.itemNo,
                desc: row.desc,
                Quantity: qty,
                Quantity_remain: remain,
                ShipDate: row.shipmentDate,
                Uom: row.uomCode,
                status: row.status
            };
        });

        // Siapkan tanggal hari ini tanpa jam (00:00)


        // Transformasi + filter ShipDate < hari ini
        let expiredToData = toList
            .map((row, i) => {
                const qty = Number(row.quantity) || 0;
                const shipped = Number(row.qtyShip) || 0;

                // Perbaikan floating
                const rawRemain = qty - shipped;
                const remain = Number(rawRemain.toFixed(2));

                return {
                    no: i + 1,
                    documentNo: row.documentNo,
                    itemNo: row.itemNo,
                    desc: row.desc,
                    Quantity: qty,
                    Quantity_remain: remain,
                    ShipDate: row.shipmentDate,
                    Uom: row.uomCode,
                    status: row.status
                };
            })
            .filter(row => {
                // Parse tanggal ShipDate
                const shipDate = new Date(row.ShipDate);

                // Filter ShipDate < hari ini
                return shipDate < today;
            });



        /* ======================================================
           TO FLATTEN
        ======================================================*/
        let expiredData = Object.values(expiredList).map((row, i) => ({
            no: i + 1,
            LotNo: row.Lot_No,
            itemNo: row.ItemNo,
            desc: row.Description,
            Quantity: row.Qty,
            expDate: row.ExpiredAt
        }));



        /* ======================================================
           PIE CHART — TOTAL TO GROUPED BY OUTLET
        ======================================================*/

        // Group per outlet
        const outletGrouped = {};
        outletData.forEach(row => {
            const outlet = row.outlet;
            if (!outletGrouped[outlet]) {
                outletGrouped[outlet] = {
                    count: 0, // jumlah TO per outlet
                    items: [] // daftar TO detail
                };
            }

            // Hitung jumlah TO
            outletGrouped[outlet].count += 1;

            // Masukkan detail TO
            outletGrouped[outlet].items.push({
                toNo: row.docNo ?? "-",
                item: row.desc ?? "-",
                qty: Number(row.qty),
            });
        });

        // Labels (outlet names)
        const pieLabels = Object.keys(outletGrouped);

        // Values = jumlah TO per outlet
        const pieValues = pieLabels.map(o => outletGrouped[o].count);

        // Warna pastel
        const pastelColors = [
            "#A7C7E7", "#F7D1BA", "#F2A8A8", "#B8E0D2",
            "#C8F3B0", "#E0BBE4", "#FFDFD3"
        ];

        // Create PIE chart
        const pieChart = new Chart(document.getElementById("stockPie"), {
            type: 'pie',
            data: {
                labels: pieLabels,
                datasets: [{
                    data: pieValues,
                    backgroundColor: pastelColors,
                }]
            },
            options: {
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const outletName = context.label;
                                const dataset = outletGrouped[outletName];

                                let lines = [`${outletName}: ${dataset.count} TO`];

                                dataset.items.forEach(it => {
                                    lines.push(`• ${it.toNo} — ${it.item}`);
                                });

                                return lines;
                            }
                        }
                    }
                }
            }
        });



        // ================================
        // 1. GROUPING TO PER TANGGAL
        // ================================
        const toGrouped = {};
        toList.forEach(row => {
            const date = row.shipmentDate;
            if (!toGrouped[date]) {
                toGrouped[date] = {
                    count: 0, // jumlah TO per tanggal
                    items: [] // daftar TO detail
                };
            }

            // Tambah jumlah TO
            toGrouped[date].count += 1;

            // Tambahkan detail TO
            toGrouped[date].items.push({
                toNo: row.documentNo ?? "-", // nomor TO (buat tooltip)
                item: row.desc ?? "-", // nama item
                qty: Number(row.quantity), // quantity, jika perlu ditampilkan
            });
        });

        // ================================
        // 2. SORTING BY DATE
        // ================================
        const toDates = Object.keys(toGrouped).sort((a, b) => new Date(a) - new Date(b));

        // ================================
        // 3. Ambil hanya LAST 14 days
        // ================================
        const lastDates = toDates.slice(-14);

        // Chart data: jumlah TO per tanggal
        const lastCounts = lastDates.map(d => toGrouped[d].count);


        // ================================
        // 4. CHART.JS CONFIG
        // ================================
        const aoChart = new Chart(document.getElementById("aoChart"), {
            type: 'line',
            data: {
                labels: lastDates,
                datasets: [{
                    label: "Total TO per Date",
                    data: lastCounts,
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4,
                    borderColor: "rgba(54, 162, 235, .6)",
                    backgroundColor: "rgba(54, 162, 235, .15)",
                }]
            },
            options: {
                maintainAspectRatio: true,
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const date = context.label;
                                const dataset = toGrouped[date];

                                let lines = [`${date}: ${dataset.count} TO`];

                                dataset.items.forEach(it => {
                                    lines.push(`• ${it.toNo} — ${it.item}`);
                                });

                                return lines;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            maxRotation: 0
                        }
                    }
                }
            }
        });



        /* ======================================================
           SORT TABLE
        ======================================================*/
        let sortState = {
            ao: {
                column: null,
                direction: 'asc'
            },
            expao: {
                column: null,
                direction: 'asc'
            },
            outlet: {
                column: null,
                direction: 'asc'
            },
            expoutlet: {
                column: null,
                direction: 'asc'
            },
            to: {
                column: null,
                direction: 'asc'
            },
            expto: {
                column: null,
                direction: 'asc'
            },
            expired: {
                column: null,
                direction: 'asc'
            },
        };

        function sortTable(type, column) {
            const state = sortState[type];

            const map = {
                ao: aoData,
                expao: expiredAoData,
                outlet: outletData,
                expoutlet: epxoutletData,
                to: toData,
                expto: expiredToData,
                expired: expiredData,
            };

            const tableData = map[type]; // jauh lebih aman & bersih

            if (state.column === column) state.direction = state.direction === 'asc' ? 'desc' : 'asc';
            else {
                state.column = column;
                state.direction = 'asc';
            }

            tableData.sort((a, b) => {
                let x = a[column],
                    y = b[column];
                if (!isNaN(x) && !isNaN(y)) {
                    x = Number(x);
                    y = Number(y);
                }

                if (x < y) return state.direction === 'asc' ? -1 : 1;
                if (x > y) return state.direction === 'asc' ? 1 : -1;
                return 0;
            });

            renderAO();
            renderexpAO();
            renderOutlet();
            renderexpOutlet();
            renderTO();
            renderExp();
            renderExpiredTO();
            updateSortIcons(type, column);
        }

        function updateSortIcons(type, column) {
            document.querySelectorAll(`.${type}-sort-icon`).forEach(i => i.innerHTML = "");
            document.getElementById(`${type}-${column}-icon`).innerHTML =
                sortState[type].direction === 'asc' ?
                `<i class="fa-solid fa-arrow-up-wide-short"></i>` :
                `<i class="fa-solid fa-arrow-down-wide-short"></i>`;
        }

        /* ======================================================
           RENDER TABLES
        ======================================================*/
        function renderAO() {
            const aoTable = document.getElementById("tableAO");
            aoTable.innerHTML = "";
            aoData.forEach((r, i) => {
                aoTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.docNo}</td>
                <td>${r.itemNo}</td>
                <td>${r.Quantity}</td>
                <td>${r.duedate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderexpAO() {
            const expaoTable = document.getElementById("tableexpAO");
            expaoTable.innerHTML = "";
            expiredAoData.forEach((r, i) => {
                expaoTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.docNo}</td>
                <td>${r.itemNo}</td>
                <td>${r.Quantity}</td>
                <td>${r.duedate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderOutlet() {
            const outletTable = document.getElementById("tableOutlet");
            outletTable.innerHTML = "";
            outletData.forEach((r, i) => {
                outletTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.docNo}</td>
                <td>${r.outlet}</td>
                <td>${r.itemNo}</td>
                <td>${r.desc}</td>
                <td>${r.qty} ${r.Uom}</td>
                <td>${r.qty_remain} ${r.Uom}</td>
                <td>${r.shipdate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderexpOutlet() {
            const expoutletTable = document.getElementById("tableexpOutlet");
            expoutletTable.innerHTML = "";
            epxoutletData.forEach((r, i) => {
                expoutletTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.docNo}</td>
                <td>${r.outlet}</td>
                <td>${r.itemNo}</td>
                <td>${r.desc}</td>
                <td>${r.qty} ${r.Uom}</td>
                <td>${r.qty_remain} ${r.Uom}</td>
                <td>${r.shipdate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderExpiredTO() {
            const exptoTable = document.getElementById("ExpiredTO");
            exptoTable.innerHTML = "";
            expiredToData.forEach((r, i) => {
                exptoTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.documentNo}</td>
                <td>${r.itemNo}</td>
                <td>${r.desc}</td>
                <td>${r.Quantity} ${r.Uom}</td>
                <td>${r.Quantity_remain} ${r.Uom}</td>
                <td>${r.ShipDate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderTO() {
            const toTable = document.getElementById("tableTO");
            toTable.innerHTML = "";
            toData.forEach((r, i) => {
                toTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.documentNo}</td>
                <td>${r.itemNo}</td>
                <td>${r.desc}</td>
                <td>${r.Quantity} ${r.Uom}</td>
                <td>${r.Quantity_remain} ${r.Uom}</td>
                <td>${r.ShipDate}</td>
                <td>${r.status}</td>
            </tr>`;
            });
        }

        function renderExp() {
            const expTable = document.getElementById("tableExpired");
            expTable.innerHTML = "";
            expiredData.forEach((r, i) => {
                expTable.innerHTML += `
            <tr>
                <td>${i+1}</td>
                <td>${r.LotNo}</td>
                <td>${r.itemNo}</td>
                <td>${r.desc}</td>
                <td>${r.Quantity}</td>
                <td>${r.expDate}</td>
            </tr>`;
            });
        }

        renderAO();
        renderexpAO();
        renderOutlet();
        renderexpOutlet();
        renderTO();
        renderExp();
        renderExpiredTO();
        document.getElementById("refreshDash").onclick = () => location.reload();
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {

            // ==============================
            // SIDEBAR CHECKBOX HANDLER
            // ==============================
            document.querySelectorAll('.table-check').forEach(cb => {
                cb.addEventListener('change', () => {
                    const id = cb.value;
                    const section = document.getElementById(id);

                    if (cb.checked) {
                        section.classList.remove('collapse-hidden');
                        section.classList.add('collapse-show');
                    } else {
                        section.classList.remove('collapse-show');
                        section.classList.add('collapse-hidden');
                    }
                });
            });

        });
    </script>


    <style>
        /* Soft hover */
        .dash-card {
            transition: .25s;
            border-radius: 14px;
        }

        .dash-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, .12) !important;
        }

        /* Icon bubble pastel (improved) */
        .icon-bubble {
            width: 48px;
            height: 48px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        /* Pastel backgrounds (softer) */
        .pastel-bg-blue {
            background: #ecf4ff;
        }

        .pastel-bg-orange {
            background: #ffeede;
        }

        .pastel-bg-green {
            background: #ebf9ee;
        }

        .pastel-bg-red {
            background: #ffe9ec;
        }

        /* Pastel borders (smooth) */
        .pastel-border-blue {
            border-left: 8px solid #a9ccef;
        }

        .pastel-border-orange {
            border-left: 8px solid #f7d6c1;
        }

        .pastel-border-green {
            border-left: 8px solid #cbf4ba;
        }

        .pastel-border-red {
            border-left: 8px solid #f3b7c1;
        }

        .table tbody tr:hover {
            background: #f8f9fa;
        }

        .chart-container {
            width: 100%;
            height: 460px;
            /* tinggi fix agar kedua chart konsisten */
        }
    </style>
    <style>
        /* Tab aktif: text hitam, bold */
        .nav-tabs .nav-link.active {
            color: #000 !important;
            font-weight: 600;
        }

        /* Tab normal */
        .nav-tabs .nav-link {
            color: #6c757d;
        }

        /* Hover */
        .nav-tabs .nav-link:hover {
            color: #000;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/butcher/resources/views/dashboard/index.blade.php ENDPATH**/ ?>